/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.math.BigDecimal;
/*      */ import java.math.BigInteger;
/*      */ import java.net.URL;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.NClob;
/*      */ import java.sql.Ref;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLXML;
/*      */ import java.sql.Struct;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Calendar;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleArray;
/*      */ import oracle.jdbc.OracleBfile;
/*      */ import oracle.jdbc.OracleBlob;
/*      */ import oracle.jdbc.OracleClob;
/*      */ import oracle.jdbc.OracleData;
/*      */ import oracle.jdbc.OracleDataFactory;
/*      */ import oracle.jdbc.OracleOpaque;
/*      */ import oracle.jdbc.OracleRef;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BINARY_DOUBLE;
/*      */ import oracle.sql.BINARY_FLOAT;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CHAR;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.CustomDatum;
/*      */ import oracle.sql.CustomDatumFactory;
/*      */ import oracle.sql.DATE;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.INTERVALDS;
/*      */ import oracle.sql.INTERVALYM;
/*      */ import oracle.sql.NUMBER;
/*      */ import oracle.sql.OPAQUE;
/*      */ import oracle.sql.ORAData;
/*      */ import oracle.sql.ORADataFactory;
/*      */ import oracle.sql.RAW;
/*      */ import oracle.sql.REF;
/*      */ import oracle.sql.ROWID;
/*      */ import oracle.sql.STRUCT;
/*      */ import oracle.sql.TIMESTAMP;
/*      */ import oracle.sql.TIMESTAMPLTZ;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ 
/*      */ abstract class GeneratedAccessor
/*      */ {
/*      */   OracleStatement statement;
/* 1807 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   abstract boolean isNull(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   Array getArray(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  121 */     if (isNull(paramInt)) return null;
/*      */ 
/*  123 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getArray not implemented for class " + getClass().getName());
/*  124 */     localSQLException.fillInStackTrace();
/*  125 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   BigDecimal getBigDecimal(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  145 */     if (isNull(paramInt)) return null;
/*      */ 
/*  147 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBigDecimal not implemented for class " + getClass().getName());
/*  148 */     localSQLException.fillInStackTrace();
/*  149 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  169 */     if (isNull(paramInt1)) return null;
/*      */ 
/*  171 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBigDecimal not implemented for class " + getClass().getName());
/*  172 */     localSQLException.fillInStackTrace();
/*  173 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Blob getBlob(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  193 */     if (isNull(paramInt)) return null;
/*      */ 
/*  195 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBlob not implemented for class " + getClass().getName());
/*  196 */     localSQLException.fillInStackTrace();
/*  197 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   boolean getBoolean(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  217 */     if (isNull(paramInt)) return false;
/*      */ 
/*  219 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBoolean not implemented for class " + getClass().getName());
/*  220 */     localSQLException.fillInStackTrace();
/*  221 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   byte getByte(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  241 */     if (isNull(paramInt)) return 0;
/*      */ 
/*  243 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getByte not implemented for class " + getClass().getName());
/*  244 */     localSQLException.fillInStackTrace();
/*  245 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   byte[] getBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  265 */     if (isNull(paramInt)) return null;
/*      */ 
/*  267 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBytes not implemented for class " + getClass().getName());
/*  268 */     localSQLException.fillInStackTrace();
/*  269 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Clob getClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  289 */     if (isNull(paramInt)) return null;
/*      */ 
/*  291 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getClob not implemented for class " + getClass().getName());
/*  292 */     localSQLException.fillInStackTrace();
/*  293 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   java.sql.Date getDate(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  313 */     if (isNull(paramInt)) return null;
/*      */ 
/*  315 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getDate not implemented for class " + getClass().getName());
/*  316 */     localSQLException.fillInStackTrace();
/*  317 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   java.sql.Date getDate(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  337 */     if (isNull(paramInt)) return null;
/*      */ 
/*  339 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getDate not implemented for class " + getClass().getName());
/*  340 */     localSQLException.fillInStackTrace();
/*  341 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   double getDouble(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  361 */     if (isNull(paramInt)) return 0.0D;
/*      */ 
/*  363 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getDouble not implemented for class " + getClass().getName());
/*  364 */     localSQLException.fillInStackTrace();
/*  365 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   float getFloat(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  385 */     if (isNull(paramInt)) return 0.0F;
/*      */ 
/*  387 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getFloat not implemented for class " + getClass().getName());
/*  388 */     localSQLException.fillInStackTrace();
/*  389 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   int getInt(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  409 */     if (isNull(paramInt)) return 0;
/*      */ 
/*  411 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getInt not implemented for class " + getClass().getName());
/*  412 */     localSQLException.fillInStackTrace();
/*  413 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   long getLong(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  433 */     if (isNull(paramInt)) return 0L;
/*      */ 
/*  435 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getLong not implemented for class " + getClass().getName());
/*  436 */     localSQLException.fillInStackTrace();
/*  437 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   NClob getNClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  457 */     if (isNull(paramInt)) return null;
/*      */ 
/*  459 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getNClob not implemented for class " + getClass().getName());
/*  460 */     localSQLException.fillInStackTrace();
/*  461 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   String getNString(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  481 */     if (isNull(paramInt)) return null;
/*      */ 
/*  483 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getNString not implemented for class " + getClass().getName());
/*  484 */     localSQLException.fillInStackTrace();
/*  485 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Object getObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  505 */     if (isNull(paramInt)) return null;
/*      */ 
/*  507 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getObject not implemented for class " + getClass().getName());
/*  508 */     localSQLException.fillInStackTrace();
/*  509 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Object getObject(int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  529 */     if (isNull(paramInt)) return null;
/*      */ 
/*  531 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getObject not implemented for class " + getClass().getName());
/*  532 */     localSQLException.fillInStackTrace();
/*  533 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Ref getRef(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  553 */     if (isNull(paramInt)) return null;
/*      */ 
/*  555 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getRef not implemented for class " + getClass().getName());
/*  556 */     localSQLException.fillInStackTrace();
/*  557 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   RowId getRowId(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  577 */     if (isNull(paramInt)) return null;
/*      */ 
/*  579 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getRowId not implemented for class " + getClass().getName());
/*  580 */     localSQLException.fillInStackTrace();
/*  581 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   short getShort(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  601 */     if (isNull(paramInt)) return 0;
/*      */ 
/*  603 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getShort not implemented for class " + getClass().getName());
/*  604 */     localSQLException.fillInStackTrace();
/*  605 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   SQLXML getSQLXML(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  625 */     if (isNull(paramInt)) return null;
/*      */ 
/*  627 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getSQLXML not implemented for class " + getClass().getName());
/*  628 */     localSQLException.fillInStackTrace();
/*  629 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   String getString(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  649 */     if (isNull(paramInt)) return null;
/*      */ 
/*  651 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getString not implemented for class " + getClass().getName());
/*  652 */     localSQLException.fillInStackTrace();
/*  653 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Struct getStruct(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  673 */     if (isNull(paramInt)) return null;
/*      */ 
/*  675 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getStruct not implemented for class " + getClass().getName());
/*  676 */     localSQLException.fillInStackTrace();
/*  677 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Time getTime(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  697 */     if (isNull(paramInt)) return null;
/*      */ 
/*  699 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTime not implemented for class " + getClass().getName());
/*  700 */     localSQLException.fillInStackTrace();
/*  701 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Time getTime(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  721 */     if (isNull(paramInt)) return null;
/*      */ 
/*  723 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTime not implemented for class " + getClass().getName());
/*  724 */     localSQLException.fillInStackTrace();
/*  725 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Timestamp getTimestamp(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  745 */     if (isNull(paramInt)) return null;
/*      */ 
/*  747 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTimestamp not implemented for class " + getClass().getName());
/*  748 */     localSQLException.fillInStackTrace();
/*  749 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  769 */     if (isNull(paramInt)) return null;
/*      */ 
/*  771 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTimestamp not implemented for class " + getClass().getName());
/*  772 */     localSQLException.fillInStackTrace();
/*  773 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   URL getURL(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  793 */     if (isNull(paramInt)) return null;
/*      */ 
/*  795 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getURL not implemented for class " + getClass().getName());
/*  796 */     localSQLException.fillInStackTrace();
/*  797 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   BigInteger getBigInteger(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  817 */     if (isNull(paramInt)) return null;
/*      */ 
/*  819 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBigInteger not implemented for class " + getClass().getName());
/*  820 */     localSQLException.fillInStackTrace();
/*  821 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   java.util.Date getJavaUtilDate(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  841 */     if (isNull(paramInt)) return null;
/*      */ 
/*  843 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getJavaUtilDate not implemented for class " + getClass().getName());
/*  844 */     localSQLException.fillInStackTrace();
/*  845 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Calendar getCalendar(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  865 */     if (isNull(paramInt)) return null;
/*      */ 
/*  867 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCalendar not implemented for class " + getClass().getName());
/*  868 */     localSQLException.fillInStackTrace();
/*  869 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   ARRAY getARRAY(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  889 */     if (isNull(paramInt)) return null;
/*      */ 
/*  891 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getARRAY not implemented for class " + getClass().getName());
/*  892 */     localSQLException.fillInStackTrace();
/*  893 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   BFILE getBFILE(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  913 */     if (isNull(paramInt)) return null;
/*      */ 
/*  915 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBFILE not implemented for class " + getClass().getName());
/*  916 */     localSQLException.fillInStackTrace();
/*  917 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   BFILE getBfile(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  937 */     if (isNull(paramInt)) return null;
/*      */ 
/*  939 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBfile not implemented for class " + getClass().getName());
/*  940 */     localSQLException.fillInStackTrace();
/*  941 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   BINARY_FLOAT getBINARY_FLOAT(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  961 */     if (isNull(paramInt)) return null;
/*      */ 
/*  963 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBINARY_FLOAT not implemented for class " + getClass().getName());
/*  964 */     localSQLException.fillInStackTrace();
/*  965 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   BINARY_DOUBLE getBINARY_DOUBLE(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  985 */     if (isNull(paramInt)) return null;
/*      */ 
/*  987 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBINARY_DOUBLE not implemented for class " + getClass().getName());
/*  988 */     localSQLException.fillInStackTrace();
/*  989 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   BLOB getBLOB(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1009 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1011 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBLOB not implemented for class " + getClass().getName());
/* 1012 */     localSQLException.fillInStackTrace();
/* 1013 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   CHAR getCHAR(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1033 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1035 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCHAR not implemented for class " + getClass().getName());
/* 1036 */     localSQLException.fillInStackTrace();
/* 1037 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   CLOB getCLOB(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1057 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1059 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCLOB not implemented for class " + getClass().getName());
/* 1060 */     localSQLException.fillInStackTrace();
/* 1061 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   ResultSet getCursor(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1081 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1083 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCursor not implemented for class " + getClass().getName());
/* 1084 */     localSQLException.fillInStackTrace();
/* 1085 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   DATE getDATE(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1105 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1107 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getDATE not implemented for class " + getClass().getName());
/* 1108 */     localSQLException.fillInStackTrace();
/* 1109 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   INTERVALDS getINTERVALDS(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1129 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1131 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getINTERVALDS not implemented for class " + getClass().getName());
/* 1132 */     localSQLException.fillInStackTrace();
/* 1133 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   INTERVALYM getINTERVALYM(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1153 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1155 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getINTERVALYM not implemented for class " + getClass().getName());
/* 1156 */     localSQLException.fillInStackTrace();
/* 1157 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   NUMBER getNUMBER(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1177 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1179 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getNUMBER not implemented for class " + getClass().getName());
/* 1180 */     localSQLException.fillInStackTrace();
/* 1181 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   OPAQUE getOPAQUE(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1201 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1203 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOPAQUE not implemented for class " + getClass().getName());
/* 1204 */     localSQLException.fillInStackTrace();
/* 1205 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Datum getOracleObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1225 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1227 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOracleObject not implemented for class " + getClass().getName());
/* 1228 */     localSQLException.fillInStackTrace();
/* 1229 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   ORAData getORAData(int paramInt, ORADataFactory paramORADataFactory)
/*      */     throws SQLException
/*      */   {
/* 1249 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1251 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getORAData not implemented for class " + getClass().getName());
/* 1252 */     localSQLException.fillInStackTrace();
/* 1253 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   ORAData getORAData(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1273 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1275 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getORAData not implemented for class " + getClass().getName());
/* 1276 */     localSQLException.fillInStackTrace();
/* 1277 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   OracleData getOracleData(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1297 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1299 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOracleData not implemented for class " + getClass().getName());
/* 1300 */     localSQLException.fillInStackTrace();
/* 1301 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Object getObject(int paramInt, OracleDataFactory paramOracleDataFactory)
/*      */     throws SQLException
/*      */   {
/* 1321 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1323 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getObject not implemented for class " + getClass().getName());
/* 1324 */     localSQLException.fillInStackTrace();
/* 1325 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   RAW getRAW(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1345 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1347 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getRAW not implemented for class " + getClass().getName());
/* 1348 */     localSQLException.fillInStackTrace();
/* 1349 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   REF getREF(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1369 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1371 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getREF not implemented for class " + getClass().getName());
/* 1372 */     localSQLException.fillInStackTrace();
/* 1373 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   ROWID getROWID(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1393 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1395 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getROWID not implemented for class " + getClass().getName());
/* 1396 */     localSQLException.fillInStackTrace();
/* 1397 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   STRUCT getSTRUCT(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1417 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1419 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getSTRUCT not implemented for class " + getClass().getName());
/* 1420 */     localSQLException.fillInStackTrace();
/* 1421 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   TIMESTAMPLTZ getTIMESTAMPLTZ(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1441 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1443 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ not implemented for class " + getClass().getName());
/* 1444 */     localSQLException.fillInStackTrace();
/* 1445 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1465 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1467 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ not implemented for class " + getClass().getName());
/* 1468 */     localSQLException.fillInStackTrace();
/* 1469 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   TIMESTAMP getTIMESTAMP(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1489 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1491 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP not implemented for class " + getClass().getName());
/* 1492 */     localSQLException.fillInStackTrace();
/* 1493 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   CustomDatum getCustomDatum(int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */     throws SQLException
/*      */   {
/* 1513 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1515 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCustomDatum not implemented for class " + getClass().getName());
/* 1516 */     localSQLException.fillInStackTrace();
/* 1517 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   OracleArray getOracleArray(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1537 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1539 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOracleArray not implemented for class " + getClass().getName());
/* 1540 */     localSQLException.fillInStackTrace();
/* 1541 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   OracleBlob getOracleBlob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1561 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1563 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOracleBlob not implemented for class " + getClass().getName());
/* 1564 */     localSQLException.fillInStackTrace();
/* 1565 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   OracleClob getOracleClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1585 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1587 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOracleClob not implemented for class " + getClass().getName());
/* 1588 */     localSQLException.fillInStackTrace();
/* 1589 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   OracleBfile getOracleBfile(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1609 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1611 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOracleBfile not implemented for class " + getClass().getName());
/* 1612 */     localSQLException.fillInStackTrace();
/* 1613 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   OracleRef getOracleRef(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1633 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1635 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOracleRef not implemented for class " + getClass().getName());
/* 1636 */     localSQLException.fillInStackTrace();
/* 1637 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   OracleOpaque getOracleOpaque(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1657 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1659 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOracleOpaque not implemented for class " + getClass().getName());
/* 1660 */     localSQLException.fillInStackTrace();
/* 1661 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   InputStream getAsciiStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1681 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1683 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getAsciiStream not implemented for class " + getClass().getName());
/* 1684 */     localSQLException.fillInStackTrace();
/* 1685 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   InputStream getBinaryStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1705 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1707 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBinaryStream not implemented for class " + getClass().getName());
/* 1708 */     localSQLException.fillInStackTrace();
/* 1709 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Reader getCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1729 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1731 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCharacterStream not implemented for class " + getClass().getName());
/* 1732 */     localSQLException.fillInStackTrace();
/* 1733 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   Reader getNCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1753 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1755 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getNCharacterStream not implemented for class " + getClass().getName());
/* 1756 */     localSQLException.fillInStackTrace();
/* 1757 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   InputStream getUnicodeStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1777 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1779 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getUnicodeStream not implemented for class " + getClass().getName());
/* 1780 */     localSQLException.fillInStackTrace();
/* 1781 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1802 */     return this.statement.getConnectionDuringExceptionHandling();
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.GeneratedAccessor
 * JD-Core Version:    0.6.2
 */