/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ import java.sql.SQLException;
/*       */ import oracle.core.lmx.CoreException;
/*       */ 
/*       */ class FloatBinder extends VarnumBinder
/*       */ {
/* 18656 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   long bind(OraclePreparedStatement paramOraclePreparedStatement, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte, char[] paramArrayOfChar, short[] paramArrayOfShort, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, int paramInt9, boolean paramBoolean, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 18434 */     byte[] arrayOfByte = paramArrayOfByte;
/* 18435 */     int i = paramInt6 + 1;
/* 18436 */     double d = paramOraclePreparedStatement.parameterDouble[paramInt3][paramInt1];
/* 18437 */     int j = 0;
/*       */ 
/* 18441 */     if (d == 0.0D)
/*       */     {
/* 18443 */       arrayOfByte[i] = -128;
/* 18444 */       j = 1;
/*       */     }
/* 18446 */     else if (d == (1.0D / 0.0D))
/*       */     {
/* 18448 */       arrayOfByte[i] = -1;
/* 18449 */       arrayOfByte[(i + 1)] = 101;
/* 18450 */       j = 2;
/*       */     }
/* 18452 */     else if (d == (-1.0D / 0.0D))
/*       */     {
/* 18454 */       arrayOfByte[i] = 0;
/* 18455 */       j = 1;
/*       */     }
/*       */     else
/*       */     {
/* 18460 */       boolean bool = d < 0.0D;
/*       */ 
/* 18462 */       if (bool) {
/* 18463 */         d = -d;
/*       */       }
/* 18465 */       long l = Double.doubleToLongBits(d);
/* 18466 */       int k = (int)(l >> 52 & 0x7FF);
/* 18467 */       int m = (k > 1023 ? 126 : 127) - (int)((k - 1023) / 6.643856189774725D);
/*       */       SQLException localSQLException;
/* 18470 */       if (m < 0)
/*       */       {
/* 18473 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + d);
/*       */ 
/* 18475 */         localSQLException.fillInStackTrace();
/* 18476 */         throw localSQLException;
/*       */       }
/*       */ 
/* 18480 */       if (m > 192)
/*       */       {
/* 18483 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + d);
/*       */ 
/* 18485 */         localSQLException.fillInStackTrace();
/* 18486 */         throw localSQLException;
/*       */       }
/*       */ 
/* 18490 */       if (d > factorTable[m]) {
/* 18491 */         while ((m > 0) && (d > factorTable[(--m)]));
/*       */       }
/* 18493 */       while ((m < 193) && (d <= factorTable[(m + 1)])) {
/* 18494 */         m++;
/*       */       }
/* 18496 */       if (d == factorTable[m])
/*       */       {
/* 18498 */         if (m < 65)
/*       */         {
/* 18501 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + d);
/*       */ 
/* 18503 */           localSQLException.fillInStackTrace();
/* 18504 */           throw localSQLException;
/*       */         }
/*       */ 
/* 18508 */         if (m > 192)
/*       */         {
/* 18511 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + d);
/*       */ 
/* 18513 */           localSQLException.fillInStackTrace();
/* 18514 */           throw localSQLException;
/*       */         }
/*       */ 
/* 18518 */         if (bool)
/*       */         {
/* 18520 */           arrayOfByte[i] = ((byte)(62 - (127 - m)));
/* 18521 */           arrayOfByte[(i + 1)] = 100;
/* 18522 */           arrayOfByte[(i + 2)] = 102;
/* 18523 */           j = 3;
/*       */         }
/*       */         else
/*       */         {
/* 18527 */           arrayOfByte[i] = ((byte)(192 + (128 - m)));
/* 18528 */           arrayOfByte[(i + 1)] = 2;
/* 18529 */           j = 2;
/*       */         }
/*       */ 
/*       */       }
/*       */       else
/*       */       {
/* 18535 */         if (m < 64)
/*       */         {
/* 18538 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + d);
/*       */ 
/* 18540 */           localSQLException.fillInStackTrace();
/* 18541 */           throw localSQLException;
/*       */         }
/*       */ 
/* 18545 */         if (m > 191)
/*       */         {
/* 18548 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + d);
/*       */ 
/* 18550 */           localSQLException.fillInStackTrace();
/* 18551 */           throw localSQLException;
/*       */         }
/*       */ 
/* 18557 */         int n = Float.floatToIntBits((float)d);
/* 18558 */         int i1 = n & 0x7FFFFF;
/* 18559 */         int i2 = n >> 23 & 0xFF;
/*       */ 
/* 18561 */         char[] arrayOfChar = paramOraclePreparedStatement.digits;
/*       */         int i3;
/* 18566 */         if (i2 == 0)
/*       */         {
/* 18568 */           while ((i1 & 0x800000) == 0L)
/*       */           {
/* 18570 */             i1 <<= 1;
/* 18571 */             i2--;
/*       */           }
/*       */ 
/* 18574 */           i3 = 24 + i2;
/* 18575 */           i2++;
/*       */         }
/*       */         else
/*       */         {
/* 18579 */           i1 |= 8388608;
/* 18580 */           i3 = 24;
/*       */         }
/*       */ 
/* 18583 */         i2 -= 127;
/*       */ 
/* 18586 */         j = dtoa(arrayOfByte, i, d, bool, true, arrayOfChar, i2, i1 << 29, i3);
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/* 18648 */     arrayOfByte[paramInt6] = ((byte)j);
/* 18649 */     paramArrayOfShort[paramInt9] = 0;
/* 18650 */     paramArrayOfShort[paramInt8] = ((short)(j + 1));
/* 18651 */     return paramLong;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.FloatBinder
 * JD-Core Version:    0.6.2
 */