/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ class FDBigInt
/*       */ {
/*       */   int nWords;
/*       */   int[] data;
/* 19448 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   FDBigInt(int paramInt)
/*       */   {
/* 18960 */     this.nWords = 1;
/* 18961 */     this.data = new int[1];
/* 18962 */     this.data[0] = paramInt;
/*       */   }
/*       */ 
/*       */   FDBigInt(long paramLong)
/*       */   {
/* 18969 */     this.data = new int[2];
/* 18970 */     this.data[0] = ((int)paramLong);
/* 18971 */     this.data[1] = ((int)(paramLong >>> 32));
/* 18972 */     this.nWords = (this.data[1] == 0 ? 1 : 2);
/*       */   }
/*       */ 
/*       */   FDBigInt(FDBigInt paramFDBigInt)
/*       */   {
/* 18979 */     this.data = new int[this.nWords = paramFDBigInt.nWords];
/*       */ 
/* 18981 */     System.arraycopy(paramFDBigInt.data, 0, this.data, 0, this.nWords);
/*       */   }
/*       */ 
/*       */   FDBigInt(int[] paramArrayOfInt, int paramInt)
/*       */   {
/* 18988 */     this.data = paramArrayOfInt;
/* 18989 */     this.nWords = paramInt;
/*       */   }
/*       */ 
/*       */   void lshiftMe(int paramInt)
/*       */     throws IllegalArgumentException
/*       */   {
/* 19000 */     if (paramInt <= 0)
/*       */     {
/* 19002 */       if (paramInt == 0) {
/* 19003 */         return;
/*       */       }
/* 19005 */       throw new IllegalArgumentException("negative shift count");
/*       */     }
/*       */ 
/* 19008 */     int i = paramInt >> 5;
/* 19009 */     int j = paramInt & 0x1F;
/* 19010 */     int k = 32 - j;
/* 19011 */     int[] arrayOfInt1 = this.data;
/* 19012 */     int[] arrayOfInt2 = this.data;
/*       */ 
/* 19014 */     if (this.nWords + i + 1 > arrayOfInt1.length)
/*       */     {
/* 19018 */       arrayOfInt1 = new int[this.nWords + i + 1];
/*       */     }
/*       */ 
/* 19021 */     int m = this.nWords + i;
/* 19022 */     int n = this.nWords - 1;
/*       */ 
/* 19024 */     if (j == 0)
/*       */     {
/* 19028 */       System.arraycopy(arrayOfInt2, 0, arrayOfInt1, i, this.nWords);
/*       */ 
/* 19030 */       m = i - 1;
/*       */     }
/*       */     else
/*       */     {
/* 19034 */       arrayOfInt1[(m--)] = (arrayOfInt2[n] >>> k);
/*       */ 
/* 19036 */       while (n >= 1)
/*       */       {
/* 19038 */         arrayOfInt1[(m--)] = (arrayOfInt2[n] << j | arrayOfInt2[(--n)] >>> k);
/*       */       }
/*       */ 
/* 19041 */       arrayOfInt1[(m--)] = (arrayOfInt2[n] << j);
/*       */     }
/*       */ 
/* 19044 */     while (m >= 0)
/*       */     {
/* 19046 */       arrayOfInt1[(m--)] = 0;
/*       */     }
/*       */ 
/* 19049 */     this.data = arrayOfInt1;
/* 19050 */     this.nWords += i + 1;
/*       */ 
/* 19054 */     while ((this.nWords > 1) && (this.data[(this.nWords - 1)] == 0))
/* 19055 */       this.nWords -= 1;
/*       */   }
/*       */ 
/*       */   int normalizeMe()
/*       */     throws IllegalArgumentException
/*       */   {
/* 19074 */     int j = 0;
/* 19075 */     int k = 0;
/* 19076 */     int m = 0;
/*       */ 
/* 19078 */     for (int i = this.nWords - 1; (i >= 0) && ((m = this.data[i]) == 0); i--)
/*       */     {
/* 19080 */       j++;
/*       */     }
/*       */ 
/* 19083 */     if (i < 0)
/*       */     {
/* 19087 */       throw new IllegalArgumentException("zero value");
/*       */     }
/*       */ 
/* 19096 */     this.nWords -= j;
/*       */ 
/* 19103 */     if ((m & 0xF0000000) != 0)
/*       */     {
/* 19108 */       for (k = 32; (m & 0xF0000000) != 0; k--) {
/* 19109 */         m >>>= 1;
/*       */       }
/*       */     }
/*       */ 
/* 19113 */     while (m <= 1048575)
/*       */     {
/* 19117 */       m <<= 8;
/* 19118 */       k += 8;
/*       */     }
/*       */ 
/* 19121 */     while (m <= 134217727)
/*       */     {
/* 19123 */       m <<= 1;
/* 19124 */       k++;
/*       */     }
/*       */ 
/* 19128 */     if (k != 0) {
/* 19129 */       lshiftMe(k);
/*       */     }
/* 19131 */     return k;
/*       */   }
/*       */ 
/*       */   FDBigInt mult(int paramInt)
/*       */   {
/* 19142 */     long l1 = paramInt;
/*       */ 
/* 19147 */     int[] arrayOfInt = new int[l1 * (this.data[(this.nWords - 1)] & 0xFFFFFFFF) > 268435455L ? this.nWords + 1 : this.nWords];
/*       */ 
/* 19151 */     long l2 = 0L;
/*       */ 
/* 19153 */     for (int i = 0; i < this.nWords; i++)
/*       */     {
/* 19155 */       l2 += l1 * (this.data[i] & 0xFFFFFFFF);
/* 19156 */       arrayOfInt[i] = ((int)l2);
/* 19157 */       l2 >>>= 32;
/*       */     }
/*       */ 
/* 19160 */     if (l2 == 0L)
/*       */     {
/* 19162 */       return new FDBigInt(arrayOfInt, this.nWords);
/*       */     }
/*       */ 
/* 19166 */     arrayOfInt[this.nWords] = ((int)l2);
/*       */ 
/* 19168 */     return new FDBigInt(arrayOfInt, this.nWords + 1);
/*       */   }
/*       */ 
/*       */   FDBigInt mult(FDBigInt paramFDBigInt)
/*       */   {
/* 19182 */     int[] arrayOfInt = new int[this.nWords + paramFDBigInt.nWords];
/*       */ 
/* 19187 */     for (int i = 0; i < this.nWords; i++)
/*       */     {
/* 19189 */       long l1 = this.data[i] & 0xFFFFFFFF;
/* 19190 */       long l2 = 0L;
/*       */ 
/* 19193 */       for (int j = 0; j < paramFDBigInt.nWords; j++)
/*       */       {
/* 19195 */         l2 += (arrayOfInt[(i + j)] & 0xFFFFFFFF) + l1 * (paramFDBigInt.data[j] & 0xFFFFFFFF);
/*       */ 
/* 19199 */         arrayOfInt[(i + j)] = ((int)l2);
/* 19200 */         l2 >>>= 32;
/*       */       }
/*       */ 
/* 19203 */       arrayOfInt[(i + j)] = ((int)l2);
/*       */     }
/*       */ 
/* 19207 */     for (i = arrayOfInt.length - 1; (i > 0) && 
/* 19208 */       (arrayOfInt[i] == 0); i--);
/* 19211 */     return new FDBigInt(arrayOfInt, i + 1);
/*       */   }
/*       */ 
/*       */   FDBigInt add(FDBigInt paramFDBigInt)
/*       */   {
/* 19224 */     long l = 0L;
/*       */     int[] arrayOfInt1;
/*       */     int j;
/*       */     int[] arrayOfInt2;
/*       */     int k;
/* 19228 */     if (this.nWords >= paramFDBigInt.nWords)
/*       */     {
/* 19230 */       arrayOfInt1 = this.data;
/* 19231 */       j = this.nWords;
/* 19232 */       arrayOfInt2 = paramFDBigInt.data;
/* 19233 */       k = paramFDBigInt.nWords;
/*       */     }
/*       */     else
/*       */     {
/* 19237 */       arrayOfInt1 = paramFDBigInt.data;
/* 19238 */       j = paramFDBigInt.nWords;
/* 19239 */       arrayOfInt2 = this.data;
/* 19240 */       k = this.nWords;
/*       */     }
/*       */ 
/* 19243 */     int[] arrayOfInt3 = new int[j];
/*       */ 
/* 19245 */     for (int i = 0; i < j; i++)
/*       */     {
/* 19247 */       l += (arrayOfInt1[i] & 0xFFFFFFFF);
/*       */ 
/* 19249 */       if (i < k)
/*       */       {
/* 19251 */         l += (arrayOfInt2[i] & 0xFFFFFFFF);
/*       */       }
/*       */ 
/* 19254 */       arrayOfInt3[i] = ((int)l);
/* 19255 */       l >>= 32;
/*       */     }
/*       */ 
/* 19258 */     if (l != 0L)
/*       */     {
/* 19262 */       int[] arrayOfInt4 = new int[arrayOfInt3.length + 1];
/*       */ 
/* 19264 */       System.arraycopy(arrayOfInt3, 0, arrayOfInt4, 0, arrayOfInt3.length);
/*       */ 
/* 19266 */       arrayOfInt4[(i++)] = ((int)l);
/*       */ 
/* 19268 */       return new FDBigInt(arrayOfInt4, i);
/*       */     }
/*       */ 
/* 19271 */     return new FDBigInt(arrayOfInt3, i);
/*       */   }
/*       */ 
/*       */   int cmp(FDBigInt paramFDBigInt)
/*       */   {
/*       */     int i;
/* 19286 */     if (this.nWords > paramFDBigInt.nWords)
/*       */     {
/* 19291 */       j = paramFDBigInt.nWords - 1;
/*       */ 
/* 19293 */       for (i = this.nWords - 1; i > j; i--)
/* 19294 */         if (this.data[i] != 0)
/* 19295 */           return 1;
/*       */     }
/* 19297 */     else if (this.nWords < paramFDBigInt.nWords)
/*       */     {
/* 19302 */       j = this.nWords - 1;
/*       */ 
/* 19304 */       for (i = paramFDBigInt.nWords - 1; i > j; i--)
/* 19305 */         if (paramFDBigInt.data[i] != 0)
/* 19306 */           return -1;
/*       */     }
/*       */     else
/*       */     {
/* 19310 */       i = this.nWords - 1;
/*       */     }
/*       */ 
/* 19313 */     while ((i > 0) && 
/* 19314 */       (this.data[i] == paramFDBigInt.data[i])) {
/* 19313 */       i--;
/*       */     }
/*       */ 
/* 19320 */     int j = this.data[i];
/* 19321 */     int k = paramFDBigInt.data[i];
/*       */ 
/* 19323 */     if (j < 0)
/*       */     {
/* 19327 */       if (k < 0)
/*       */       {
/* 19329 */         return j - k;
/*       */       }
/*       */ 
/* 19333 */       return 1;
/*       */     }
/*       */ 
/* 19340 */     if (k < 0)
/*       */     {
/* 19344 */       return -1;
/*       */     }
/*       */ 
/* 19348 */     return j - k;
/*       */   }
/*       */ 
/*       */   int quoRemIteration(FDBigInt paramFDBigInt)
/*       */     throws IllegalArgumentException
/*       */   {
/* 19372 */     if (this.nWords != paramFDBigInt.nWords)
/*       */     {
/* 19374 */       throw new IllegalArgumentException("disparate values");
/*       */     }
/*       */ 
/* 19380 */     int i = this.nWords - 1;
/* 19381 */     long l1 = (this.data[i] & 0xFFFFFFFF) / paramFDBigInt.data[i];
/* 19382 */     long l2 = 0L;
/*       */ 
/* 19384 */     for (int j = 0; j <= i; j++)
/*       */     {
/* 19386 */       l2 += (this.data[j] & 0xFFFFFFFF) - l1 * (paramFDBigInt.data[j] & 0xFFFFFFFF);
/*       */ 
/* 19388 */       this.data[j] = ((int)l2);
/* 19389 */       l2 >>= 32;
/*       */     }
/*       */ 
/* 19392 */     if (l2 != 0L)
/*       */     {
/* 19398 */       l3 = 0L;
/*       */ 
/* 19400 */       while (l3 == 0L)
/*       */       {
/* 19402 */         l3 = 0L;
/*       */ 
/* 19404 */         for (k = 0; k <= i; k++)
/*       */         {
/* 19406 */           l3 += (this.data[k] & 0xFFFFFFFF) + (paramFDBigInt.data[k] & 0xFFFFFFFF);
/*       */ 
/* 19408 */           this.data[k] = ((int)l3);
/* 19409 */           l3 >>= 32;
/*       */         }
/*       */ 
/* 19421 */         if ((l3 != 0L) && (l3 != 1L)) {
/* 19422 */           throw new RuntimeException("Assertion botch: " + l3 + " carry out of division correction");
/*       */         }
/* 19424 */         l1 -= 1L;
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/* 19431 */     long l3 = 0L;
/*       */ 
/* 19433 */     for (int k = 0; k <= i; k++)
/*       */     {
/* 19435 */       l3 += 10L * (this.data[k] & 0xFFFFFFFF);
/* 19436 */       this.data[k] = ((int)l3);
/* 19437 */       l3 >>= 32;
/*       */     }
/*       */ 
/* 19440 */     if (l3 != 0L) {
/* 19441 */       throw new RuntimeException("Assertion botch: carry out of *10");
/*       */     }
/* 19443 */     return (int)l1;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.FDBigInt
 * JD-Core Version:    0.6.2
 */