/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.sql.SQLException;
/*      */ import oracle.sql.CharacterSet;
/*      */ import oracle.sql.converter.CharacterConverter1Byte;
/*      */ import oracle.sql.converter.CharacterConverterJDBC;
/*      */ import oracle.sql.converter.JdbcCharacterConverters;
/*      */ 
/*      */ final class DynamicByteArray extends ByteArray
/*      */ {
/*      */   static final int INITIAL_BLOCKS = 16;
/*      */   static final int GROWTH_FACTOR = 8;
/*      */   private final BlockSource source;
/*      */   private final long blockSize;
/*   66 */   private byte[][] blocks = new byte[16][];
/*      */ 
/*   74 */   protected long length = 0L;
/*      */ 
/*  136 */   private final int[] out_bytesRead = new int[1];
/*      */ 
/*  551 */   private static final char[] ISO_LATIN_1_TO_JAVA = arrayOfChar[0];
/*  552 */   private static final char[] WE8DEC_TO_JAVA = arrayOfChar[1];
/*  553 */   private static final char[] WE8MSWIN1252_TO_JAVA = arrayOfChar[2];
/*      */ 
/*  594 */   private int globalBlockIndex = -1;
/*  595 */   private int globalByteIndex = -1;
/*  596 */   private int globalRemaining = -1;
/*  597 */   private int globalBlockSize = -1;
/*  598 */   private byte[] globalBytes = null;
/*      */   private static final char UTF16_REPLACEMENT_CHAR = '�';
/* 1202 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   long length()
/*      */   {
/*   79 */     return this.length;
/*      */   }
/*      */ 
/*      */   static DynamicByteArray createDynamicByteArray(BlockSource paramBlockSource)
/*      */   {
/*   91 */     return new DynamicByteArray(paramBlockSource);
/*      */   }
/*      */ 
/*      */   private DynamicByteArray(BlockSource paramBlockSource)
/*      */   {
/*  101 */     assert (paramBlockSource != null) : "source is null";
/*  102 */     this.source = paramBlockSource;
/*  103 */     this.blockSize = paramBlockSource.getBlockSize();
/*      */   }
/*      */ 
/*      */   private void grow()
/*      */   {
/*  112 */     byte[][] arrayOfByte = new byte[this.blocks.length * 8][];
/*  113 */     System.arraycopy(this.blocks, 0, arrayOfByte, 0, this.blocks.length);
/*  114 */     this.blocks = arrayOfByte;
/*      */   }
/*      */ 
/*      */   final int unmarshalCLR(T4CMAREngine paramT4CMAREngine)
/*      */     throws SQLException, IOException
/*      */   {
/*  131 */     return unmarshalCLR(paramT4CMAREngine, 2147483647);
/*      */   }
/*      */ 
/*      */   final int unmarshalCLR(T4CMAREngine paramT4CMAREngine, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/*  149 */     paramT4CMAREngine.unmarshalCLR(this, this.position, this.out_bytesRead, paramInt, 0);
/*  150 */     this.position += this.out_bytesRead[0];
/*  151 */     this.length = Math.max(this.length, this.position + 1L);
/*  152 */     return this.out_bytesRead[0];
/*      */   }
/*      */ 
/*      */   final long unmarshalBuffer(T4CMAREngine paramT4CMAREngine, long paramLong, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/*  159 */     assert (paramLong >= 0L) : new StringBuilder().append("offset: ").append(paramLong).toString();
/*  160 */     int i = (int)(paramLong / this.blockSize);
/*  161 */     int j = (int)(paramLong % this.blockSize);
/*  162 */     paramLong += paramInt;
/*  163 */     while (paramInt > 0) {
/*  164 */       while (i >= this.blocks.length) grow();
/*  165 */       if (this.blocks[i] == null) this.blocks[i] = this.source.get();
/*  166 */       int k = Math.min(paramInt, (int)this.blockSize - j);
/*  167 */       paramT4CMAREngine.unmarshalNBytes(this.blocks[i], j, k);
/*  168 */       j = 0;
/*  169 */       i++;
/*  170 */       paramInt -= k;
/*      */     }
/*  172 */     return paramLong;
/*      */   }
/*      */ 
/*      */   final int unmarshalCLRforREFS(T4CMAREngine paramT4CMAREngine)
/*      */     throws SQLException, IOException
/*      */   {
/*  187 */     byte[] arrayOfByte = paramT4CMAREngine.unmarshalCLRforREFS();
/*  188 */     if (arrayOfByte == null) return 0;
/*      */ 
/*  190 */     put(arrayOfByte);
/*  191 */     return arrayOfByte.length;
/*      */   }
/*      */ 
/*      */   void copyLeft(long paramLong, int paramInt)
/*      */   {
/*  209 */     assert ((paramLong >= this.position) && (paramInt >= 0) && (this.length >= this.position + paramInt)) : new StringBuilder().append("this.position: ").append(this.position).append(" this.length: ").append(this.length).append(" srcOffset: ").append(paramLong).append(" length: ").append(paramInt).toString();
/*      */ 
/*  211 */     if ((paramLong == this.position) || (paramInt == 0)) {
/*  212 */       this.position += paramInt;
/*      */ 
/*  214 */       return;
/*      */     }
/*  216 */     assert ((paramLong > this.position) && (paramInt > 0));
/*      */ 
/*  218 */     int i = (int)(this.position / this.blockSize);
/*  219 */     int j = (int)(this.position % this.blockSize);
/*  220 */     int k = (int)(paramLong / this.blockSize);
/*  221 */     int m = (int)(paramLong % this.blockSize);
/*  222 */     int n = (int)this.blockSize;
/*  223 */     int i1 = paramInt;
/*  224 */     while (i1 > 0) {
/*  225 */       int i2 = Math.min(i1, Math.min(n - m, n - j));
/*  226 */       System.arraycopy(this.blocks[k], m, this.blocks[i], j, i2);
/*  227 */       m += i2;
/*  228 */       if (m == n) {
/*  229 */         k++;
/*  230 */         m = 0;
/*      */       }
/*  232 */       j += i2;
/*  233 */       if (j == n) {
/*  234 */         i++;
/*  235 */         j = 0;
/*      */       }
/*  237 */       i1 -= i2;
/*      */     }
/*  239 */     this.position += paramInt;
/*      */   }
/*      */ 
/*      */   void put(long paramLong, byte paramByte)
/*      */   {
/*  255 */     assert (paramLong >= 0L) : new StringBuilder().append("index: ").append(paramLong).toString();
/*  256 */     int i = (int)(paramLong / this.blockSize);
/*  257 */     int j = (int)(paramLong % this.blockSize);
/*  258 */     while (i >= this.blocks.length) grow();
/*  259 */     if (this.blocks[i] == null) this.blocks[i] = this.source.get();
/*  260 */     this.blocks[i][j] = paramByte;
/*  261 */     this.length = Math.max(this.length, paramLong + 1L);
/*      */   }
/*      */ 
/*      */   byte get(long paramLong)
/*      */   {
/*  277 */     assert ((paramLong >= 0L) && (paramLong < this.length));
/*  278 */     int i = (int)(paramLong / this.blockSize);
/*  279 */     int j = (int)(paramLong % this.blockSize);
/*      */ 
/*  281 */     if ((!$assertionsDisabled) && ((this.blocks.length < i) || (this.blocks[i] == null))) throw new AssertionError(new StringBuilder().append("invalid read--blocks.length: ").append(this.blocks.length).append(" blockIndex: ").append(i).append(i < this.blocks.length ? new StringBuilder().append(" blocks[").append(i).append("]: ").append(this.blocks[i]).toString() : "").toString());
/*      */ 
/*  283 */     return this.blocks[i][j];
/*      */   }
/*      */ 
/*      */   void put(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */   {
/*  303 */     assert (paramArrayOfByte != null) : "src is null";
/*      */ 
/*  305 */     assert ((paramLong >= 0L) && (paramInt1 + paramInt2 <= paramArrayOfByte.length)) : new StringBuilder().append("offset: ").append(paramLong).append(" src.length: ").append(paramArrayOfByte.length).append(" srcOffset: ").append(paramInt1).append(" length: ").append(paramInt2).toString();
/*  306 */     int i = (int)(paramLong / this.blockSize);
/*  307 */     int j = (int)(paramLong % this.blockSize);
/*  308 */     int k = (int)this.blockSize;
/*  309 */     int m = paramInt2;
/*      */     do {
/*  311 */       while (i >= this.blocks.length) grow();
/*  312 */       if (this.blocks[i] == null) this.blocks[i] = this.source.get();
/*  313 */       System.arraycopy(paramArrayOfByte, paramInt1 + paramInt2 - m, this.blocks[i], j, Math.min(k - j, m));
/*      */ 
/*  318 */       i++;
/*  319 */       m -= k - j;
/*  320 */       j = 0;
/*  321 */     }while (m > 0);
/*  322 */     this.length = Math.max(this.length, paramLong + paramInt2 + 1L);
/*      */   }
/*      */ 
/*      */   void get(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */   {
/*  344 */     assert ((paramLong >= 0L) && (paramLong + paramInt2 <= this.length) && (paramInt1 >= 0) && (paramInt1 + paramInt2 <= paramArrayOfByte.length)) : new StringBuilder().append(" offset: ").append(paramLong).append(" this.length: ").append(this.length).append(" destOffset: ").append(paramInt1).append(" length: ").append(paramInt2).toString();
/*  345 */     int i = (int)(paramLong / this.blockSize);
/*  346 */     int j = (int)(paramLong % this.blockSize);
/*  347 */     int k = (int)this.blockSize;
/*  348 */     int m = paramInt2;
/*      */     do {
/*  350 */       System.arraycopy(this.blocks[i], j, paramArrayOfByte, paramInt1 + paramInt2 - m, Math.min(k - j, m));
/*      */ 
/*  355 */       i++;
/*  356 */       m -= k - j;
/*  357 */       j = 0;
/*  358 */     }while (m > 0);
/*      */   }
/*      */ 
/*      */   void free()
/*      */   {
/*  366 */     for (int i = 0; i < this.blocks.length; i++) {
/*  367 */       if (this.blocks[i] != null) {
/*  368 */         this.source.put(this.blocks[i]);
/*  369 */         this.blocks[i] = null;
/*      */       }
/*      */     }
/*      */ 
/*  373 */     this.position = 0L;
/*      */ 
/*  375 */     this.length = 0L;
/*      */   }
/*      */ 
/*      */   long updateChecksum(long paramLong1, int paramInt, CRC64 paramCRC64, long paramLong2)
/*      */   {
/*  381 */     int i = (int)(paramLong1 / this.blockSize);
/*  382 */     int j = (int)(paramLong1 % this.blockSize);
/*  383 */     int k = paramInt;
/*  384 */     long l = paramLong2;
/*  385 */     while (k > 0) {
/*  386 */       int m = Math.min(k, (int)this.blockSize - j);
/*  387 */       l = CRC64.updateChecksum(l, this.blocks[i], j, m);
/*  388 */       k -= m;
/*  389 */       i++;
/*  390 */       j = 0;
/*      */     }
/*  392 */     return l;
/*      */   }
/*      */ 
/*      */   final char[] getChars(long paramLong, int paramInt, CharacterSet paramCharacterSet, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/*  416 */     String str = getString(paramLong, paramInt, paramCharacterSet);
/*  417 */     char[] arrayOfChar = str.toCharArray();
/*  418 */     paramArrayOfInt[0] = arrayOfChar.length;
/*  419 */     return arrayOfChar;
/*      */   }
/*      */ 
/*      */   final String getString(long paramLong, int paramInt, CharacterSet paramCharacterSet)
/*      */     throws SQLException
/*      */   {
/*  439 */     switch (paramCharacterSet.getOracleId()) {
/*      */     case 1:
/*  441 */       return getStringFromUS7ASCII(paramLong, paramInt);
/*      */     case 2:
/*  443 */       return getStringFrom1Byte(paramLong, paramInt, WE8DEC_TO_JAVA);
/*      */     case 31:
/*  445 */       return getStringFrom1Byte(paramLong, paramInt, ISO_LATIN_1_TO_JAVA);
/*      */     case 178:
/*  447 */       return getStringFrom1Byte(paramLong, paramInt, WE8MSWIN1252_TO_JAVA);
/*      */     case 2000:
/*  449 */       return getStringFromAL16UTF16(paramLong, paramInt);
/*      */     case 2002:
/*  451 */       return getStringFromAL16UTF16LE(paramLong, paramInt);
/*      */     case 871:
/*  453 */       return getStringFromUTF8(paramLong, paramInt);
/*      */     case 873:
/*  455 */       return getStringFromAL32UTF8(paramLong, paramInt);
/*      */     }
/*      */ 
/*  459 */     if (!$assertionsDisabled) throw new AssertionError(new StringBuilder().append("charSet: ").append(paramCharacterSet.toString()).toString());
/*      */ 
/*  461 */     int i = (int)(paramLong / this.blockSize);
/*  462 */     int j = (int)(paramLong % this.blockSize);
/*  463 */     if (paramInt <= (int)this.blockSize - j) {
/*  464 */       return paramCharacterSet.toString(this.blocks[i], j, paramInt);
/*      */     }
/*      */ 
/*  468 */     byte[] arrayOfByte = get(paramLong, paramInt);
/*  469 */     return paramCharacterSet.toString(arrayOfByte, 0, arrayOfByte.length);
/*      */   }
/*      */ 
/*      */   private final String getStringFromUS7ASCII(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  493 */     assert ((paramLong >= 0L) && (paramInt >= 0) && (this.length >= paramLong + paramInt)) : new StringBuilder().append("this.length: ").append(this.length).append(" offset: ").append(paramLong).append(" lengthInBytes: ").append(paramInt).toString();
/*      */ 
/*  495 */     int i = (int)(paramLong / this.blockSize);
/*  496 */     int j = (int)(paramLong % this.blockSize);
/*  497 */     byte[] arrayOfByte = null;
/*  498 */     int k = paramInt;
/*  499 */     char[] arrayOfChar = new char[paramInt];
/*  500 */     int m = 0;
/*      */ 
/*  503 */     while (k > 0) {
/*  504 */       arrayOfByte = this.blocks[(i++)];
/*  505 */       int n = Math.min(j + k, arrayOfByte.length);
/*  506 */       k = k - n + j;
/*      */ 
/*  508 */       while (j < n) arrayOfChar[(m++)] = ((char)arrayOfByte[(j++)]);
/*  509 */       j = 0;
/*      */     }
/*      */ 
/*  512 */     assert (m == arrayOfChar.length) : new StringBuilder().append("charIndex: ").append(m).append("\tchars.length: ").append(arrayOfChar.length).toString();
/*  513 */     return new String(arrayOfChar);
/*      */   }
/*      */ 
/*      */   private static final char[] intToChar(int[] paramArrayOfInt)
/*      */   {
/*  528 */     char[] arrayOfChar = new char[paramArrayOfInt.length];
/*  529 */     for (int i = 0; i < paramArrayOfInt.length; i++) arrayOfChar[i] = ((char)paramArrayOfInt[i]);
/*  530 */     return arrayOfChar;
/*      */   }
/*      */ 
/*      */   private final String getStringFrom1Byte(long paramLong, int paramInt, char[] paramArrayOfChar)
/*      */     throws SQLException
/*      */   {
/*  569 */     assert ((paramLong >= 0L) && (paramInt >= 0) && (this.length >= paramLong + paramInt)) : new StringBuilder().append("this.length: ").append(this.length).append(" offset: ").append(paramLong).append(" lengthInBytes: ").append(paramInt).toString();
/*      */ 
/*  571 */     int i = (int)(paramLong / this.blockSize);
/*  572 */     int j = (int)(paramLong % this.blockSize);
/*  573 */     byte[] arrayOfByte = null;
/*  574 */     int k = paramInt;
/*  575 */     char[] arrayOfChar = new char[paramInt];
/*  576 */     int m = 0;
/*      */ 
/*  579 */     while (k > 0) {
/*  580 */       arrayOfByte = this.blocks[(i++)];
/*  581 */       int n = Math.min(j + k, arrayOfByte.length);
/*  582 */       k = k - n + j;
/*      */ 
/*  584 */       while (j < n) arrayOfChar[(m++)] = paramArrayOfChar[(arrayOfByte[(j++)] & 0xFF)];
/*  585 */       j = 0;
/*      */     }
/*      */ 
/*  588 */     assert (m == arrayOfChar.length) : new StringBuilder().append("charIndex: ").append(m).append("\tchars.length: ").append(arrayOfChar.length).toString();
/*  589 */     return new String(arrayOfChar);
/*      */   }
/*      */ 
/*      */   private final void setGlobals(long paramLong, int paramInt)
/*      */   {
/*  602 */     this.globalBlockIndex = ((int)(paramLong / this.blockSize));
/*  603 */     this.globalByteIndex = ((int)(paramLong % this.blockSize));
/*  604 */     this.globalRemaining = paramInt;
/*  605 */     this.globalBlockSize = ((int)this.blockSize);
/*  606 */     this.globalBytes = (this.globalBlockIndex < this.blocks.length ? this.blocks[(this.globalBlockIndex++)] : null);
/*      */   }
/*      */   private final byte next() {
/*  609 */     assert (this.globalRemaining > 0) : "next overrun in DBA";
/*  610 */     byte b = this.globalBytes[(this.globalByteIndex++)];
/*  611 */     this.globalRemaining -= 1;
/*  612 */     if (this.globalByteIndex >= this.globalBlockSize) {
/*  613 */       this.globalBytes = (this.globalBlockIndex < this.blocks.length ? this.blocks[(this.globalBlockIndex++)] : null);
/*  614 */       this.globalByteIndex = 0;
/*      */     }
/*      */ 
/*  617 */     return b;
/*      */   }
/*      */   private final byte peek() {
/*  620 */     assert (this.globalRemaining > 0) : "peek overrun in DBA";
/*  621 */     return this.globalBytes[this.globalByteIndex];
/*      */   }
/*      */   private final void back() {
/*  624 */     if (this.globalByteIndex == 0) {
/*  625 */       this.globalByteIndex = this.globalBlockSize;
/*  626 */       this.globalBlockIndex -= 1;
/*  627 */       this.globalBytes = this.blocks[this.globalBlockIndex];
/*      */     }
/*  629 */     this.globalByteIndex -= 1;
/*  630 */     this.globalRemaining += 1;
/*      */   }
/*      */ 
/*      */   private final String getStringFromAL16UTF16(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  642 */     assert ((paramLong >= 0L) && (paramInt >= 0) && (this.length >= paramLong + paramInt)) : new StringBuilder().append("this.length: ").append(this.length).append(" offset: ").append(paramLong).append(" lengthInBytes: ").append(paramInt).toString();
/*  643 */     assert (paramInt % 2 == 0) : new StringBuilder().append("lengthInBytes: ").append(paramInt).toString();
/*      */ 
/*  645 */     setGlobals(paramLong, paramInt);
/*  646 */     char[] arrayOfChar = new char[paramInt / 2];
/*  647 */     int i = 0;
/*      */ 
/*  649 */     while (this.globalRemaining > 0) {
/*  650 */       int j = next() << 8;
/*  651 */       arrayOfChar[(i++)] = ((char)(j | next() & 0xFF));
/*      */     }
/*      */ 
/*  654 */     assert (i == arrayOfChar.length) : new StringBuilder().append("charIndex: ").append(i).append("\tchars.length: ").append(arrayOfChar.length).toString();
/*  655 */     return new String(arrayOfChar);
/*      */   }
/*      */ 
/*      */   private final String getStringFromAL16UTF16LE(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  666 */     assert ((paramLong >= 0L) && (paramInt >= 0) && (this.length >= paramLong + paramInt)) : new StringBuilder().append("this.length: ").append(this.length).append(" offset: ").append(paramLong).append(" lengthInBytes: ").append(paramInt).toString();
/*  667 */     assert (paramInt % 2 == 0) : new StringBuilder().append("lengthInBytes: ").append(paramInt).toString();
/*      */ 
/*  669 */     setGlobals(paramLong, paramInt);
/*  670 */     char[] arrayOfChar = new char[paramInt / 2];
/*  671 */     int i = 0;
/*      */ 
/*  673 */     while (this.globalRemaining > 0) {
/*  674 */       int j = next();
/*  675 */       char c1 = (char)(next() << 8 | j & 0xFF);
/*  676 */       if (!isHiSurrogate(c1)) {
/*  677 */         arrayOfChar[(i++)] = c1;
/*      */       }
/*      */       else
/*      */       {
/*  681 */         if (this.globalRemaining == 0) {
/*  682 */           arrayOfChar[(i++)] = 65533;
/*  683 */           break;
/*      */         }
/*      */ 
/*  686 */         j = next();
/*  687 */         char c2 = (char)(next() << 8 | j & 0xFF);
/*  688 */         if (isLoSurrogate(c2)) arrayOfChar[(i++)] = c1; else
/*  689 */           arrayOfChar[(i++)] = 65533;
/*  690 */         arrayOfChar[(i++)] = c2;
/*      */       }
/*      */     }
/*  693 */     assert (i == arrayOfChar.length) : new StringBuilder().append("charIndex: ").append(i).append("\tchars.length: ").append(arrayOfChar.length).toString();
/*  694 */     return new String(arrayOfChar);
/*      */   }
/*      */ 
/*      */   private final String getStringFromUTF8(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  705 */     assert ((paramLong >= 0L) && (paramInt >= 0) && (this.length >= paramLong + paramInt)) : new StringBuilder().append("this.length: ").append(this.length).append(" offset: ").append(paramLong).append(" lengthInBytes: ").append(paramInt).toString();
/*      */ 
/*  707 */     setGlobals(paramLong, paramInt);
/*  708 */     int i = (int)((paramLong + paramInt - 1L) / this.blockSize) + 1;
/*  709 */     int j = (int)((paramLong + paramInt - 1L) % this.blockSize) + 1;
/*  710 */     char[] arrayOfChar = new char[paramInt];
/*  711 */     int k = 0;
/*      */ 
/*  720 */     while (this.globalRemaining > 0) {
/*  721 */       int m = next();
/*      */       int i4;
/*  723 */       if (m >= 0)
/*      */       {
/*  726 */         arrayOfChar[(k++)] = ((char)m);
/*      */ 
/*  729 */         i4 = this.globalBlockIndex < i ? (int)this.blockSize : this.globalBlockIndex == i ? j : 0;
/*      */ 
/*  733 */         int i5 = this.globalByteIndex;
/*  734 */         while (i5 < i4) {
/*  735 */           m = this.globalBytes[i5];
/*  736 */           if (m < 0)
/*      */             break;
/*  738 */           arrayOfChar[(k++)] = ((char)m);
/*  739 */           i5++;
/*      */         }
/*  741 */         this.globalRemaining -= i5 - this.globalByteIndex;
/*  742 */         this.globalByteIndex = i5;
/*  743 */         if (this.globalByteIndex >= this.globalBlockSize) {
/*  744 */           this.globalByteIndex = 0;
/*  745 */           this.globalBytes = (this.globalBlockIndex < this.blocks.length ? this.blocks[(this.globalBlockIndex++)] : null);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  750 */         int i1 = m & 0xF0;
/*  751 */         int i2 = m;
/*  752 */         int i3 = (byte)(i2 << 2);
/*      */         char c1;
/*  753 */         if (i3 >= 0)
/*      */         {
/*  755 */           if (this.globalRemaining < 1)
/*      */           {
/*  758 */             arrayOfChar[(k++)] = 65533;
/*      */           }
/*      */           else
/*      */           {
/*  763 */             c1 = conv2ByteUTFtoUTF16(m, next());
/*  764 */             arrayOfChar[(k++)] = c1;
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/*  769 */           i3 = (byte)(i3 << 1);
/*  770 */           if (i3 >= 0)
/*      */           {
/*  772 */             if (this.globalRemaining < 2)
/*      */             {
/*  775 */               arrayOfChar[(k++)] = 65533;
/*      */             }
/*      */             else
/*      */             {
/*  780 */               i4 = next();
/*  781 */               byte b = next();
/*  782 */               char c2 = conv3ByteUTFtoUTF16(m, i4, b);
/*      */ 
/*  785 */               if ((isHiSurrogate(c2)) && (this.globalRemaining > 0)) {
/*  786 */                 int n = peek();
/*  787 */                 if ((byte)(n & 0xF0) != -32)
/*      */                 {
/*  791 */                   arrayOfChar[(k++)] = 65533;
/*      */                 }
/*      */                 else {
/*  794 */                   next();
/*      */ 
/*  796 */                   if (this.globalRemaining < 2)
/*      */                   {
/*  799 */                     arrayOfChar[(k++)] = 65533;
/*      */                   }
/*      */                   else
/*      */                   {
/*  804 */                     i4 = next();
/*  805 */                     b = next();
/*  806 */                     c1 = conv3ByteUTFtoUTF16(n, i4, b);
/*      */ 
/*  808 */                     if (isLoSurrogate(c1))
/*      */                     {
/*  810 */                       arrayOfChar[(k++)] = c2;
/*      */                     }
/*      */                     else
/*      */                     {
/*  815 */                       arrayOfChar[(k++)] = 65533;
/*      */                     }
/*      */ 
/*  818 */                     arrayOfChar[(k++)] = c1;
/*      */                   }
/*      */                 }
/*      */               } else {
/*  822 */                 arrayOfChar[(k++)] = c2;
/*      */               }
/*      */             }
/*      */ 
/*      */           }
/*      */           else
/*      */           {
/*  829 */             arrayOfChar[(k++)] = 65533;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  833 */     return new String(arrayOfChar, 0, k);
/*      */   }
/*      */ 
/*      */   private final String getStringFromAL32UTF8(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  844 */     assert ((paramLong >= 0L) && (paramInt >= 0) && (this.length >= paramLong + paramInt)) : new StringBuilder().append("this.length: ").append(this.length).append(" offset: ").append(paramLong).append(" lengthInBytes: ").append(paramInt).toString();
/*      */ 
/*  846 */     setGlobals(paramLong, paramInt);
/*  847 */     int i = (int)((paramLong + paramInt - 1L) / this.blockSize) + 1;
/*  848 */     int j = (int)((paramLong + paramInt - 1L) % this.blockSize) + 1;
/*  849 */     char[] arrayOfChar = new char[paramInt];
/*  850 */     int k = 0;
/*      */ 
/*  856 */     while (this.globalRemaining > 0) {
/*  857 */       byte b1 = next();
/*      */ 
/*  859 */       if (b1 >= 0)
/*      */       {
/*  861 */         arrayOfChar[(k++)] = ((char)b1);
/*      */ 
/*  864 */         int m = this.globalBlockIndex < i ? (int)this.blockSize : this.globalBlockIndex == i ? j : 0;
/*      */ 
/*  868 */         int n = this.globalByteIndex;
/*  869 */         while (n < m) {
/*  870 */           b1 = this.globalBytes[n];
/*  871 */           if (b1 < 0)
/*      */             break;
/*  873 */           arrayOfChar[(k++)] = ((char)b1);
/*  874 */           n++;
/*      */         }
/*  876 */         this.globalRemaining -= n - this.globalByteIndex;
/*  877 */         this.globalByteIndex = n;
/*  878 */         if (this.globalByteIndex >= this.globalBlockSize) {
/*  879 */           this.globalByteIndex = 0;
/*  880 */           this.globalBytes = (this.globalBlockIndex < this.blocks.length ? this.blocks[(this.globalBlockIndex++)] : null);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  885 */         byte b2 = b1;
/*  886 */         b2 = (byte)(b2 << 2);
/*  887 */         if (b2 >= 0)
/*      */         {
/*  889 */           if (this.globalRemaining < 1)
/*      */           {
/*  892 */             arrayOfChar[(k++)] = 65533;
/*      */           }
/*      */           else
/*      */           {
/*  897 */             arrayOfChar[(k++)] = conv2ByteUTFtoUTF16(b1, next());
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/*  902 */           b2 = (byte)(b2 << 1);
/*  903 */           if (b2 >= 0)
/*      */           {
/*  905 */             if (this.globalRemaining < 2)
/*      */             {
/*  908 */               arrayOfChar[(k++)] = 65533;
/*      */             }
/*      */             else
/*      */             {
/*  913 */               arrayOfChar[(k++)] = conv3ByteAL32UTF8toUTF16(b1, next(), next());
/*      */             }
/*      */           }
/*      */           else {
/*  917 */             b2 = (byte)(b2 << 1);
/*  918 */             if (b2 >= 0)
/*      */             {
/*  920 */               if (this.globalRemaining < 3)
/*      */               {
/*  923 */                 arrayOfChar[(k++)] = 65533;
/*      */               }
/*      */               else
/*      */               {
/*  927 */                 k = conv4ByteAL32UTF8toUTF16(b1, next(), next(), next(), arrayOfChar, k);
/*      */               }
/*      */             }
/*      */             else {
/*  931 */               arrayOfChar[(k++)] = 65533;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  937 */     return new String(arrayOfChar, 0, k);
/*      */   }
/*      */ 
/*      */   private final boolean isHiSurrogate(char paramChar)
/*      */   {
/*  953 */     return (char)(paramChar & 0xFC00) == 55296;
/*      */   }
/*      */ 
/*      */   private final boolean isLoSurrogate(char paramChar)
/*      */   {
/*  968 */     return (char)(paramChar & 0xFC00) == 56320;
/*      */   }
/*      */ 
/*      */   private final boolean check80toBF(byte paramByte)
/*      */   {
/*  982 */     return (paramByte & 0xFFFFFFC0) == -128;
/*      */   }
/*      */ 
/*      */   private final boolean check80to8F(byte paramByte)
/*      */   {
/*  995 */     return (paramByte & 0xFFFFFFF0) == -128;
/*      */   }
/*      */ 
/*      */   private final boolean check80to9F(byte paramByte)
/*      */   {
/* 1008 */     return (paramByte & 0xFFFFFFE0) == -128;
/*      */   }
/*      */ 
/*      */   private final boolean checkA0toBF(byte paramByte)
/*      */   {
/* 1021 */     return (paramByte & 0xFFFFFFE0) == -96;
/*      */   }
/*      */ 
/*      */   private final boolean check90toBF(byte paramByte)
/*      */   {
/* 1034 */     return ((paramByte & 0xFFFFFFC0) == -128) && ((paramByte & 0x30) != 0);
/*      */   }
/*      */ 
/*      */   private final char conv2ByteUTFtoUTF16(byte paramByte1, byte paramByte2)
/*      */   {
/* 1050 */     if ((paramByte1 < -62) || (paramByte1 > -33) || (!check80toBF(paramByte2)))
/*      */     {
/* 1052 */       back();
/* 1053 */       return 65533;
/*      */     }
/*      */ 
/* 1056 */     return (char)((paramByte1 & 0x1F) << 6 | paramByte2 & 0x3F);
/*      */   }
/*      */ 
/*      */   private final char conv3ByteUTFtoUTF16(byte paramByte1, byte paramByte2, byte paramByte3)
/*      */   {
/* 1076 */     if (((paramByte1 != -32) || (!checkA0toBF(paramByte2)) || (!check80toBF(paramByte3))) && ((paramByte1 < -31) || (paramByte1 > -17) || (!check80toBF(paramByte2)) || (!check80toBF(paramByte3))))
/*      */     {
/* 1080 */       back();
/* 1081 */       back();
/* 1082 */       return 65533;
/*      */     }
/*      */ 
/* 1085 */     return (char)((paramByte1 & 0xF) << 12 | (paramByte2 & 0x3F) << 6 | paramByte3 & 0x3F);
/*      */   }
/*      */ 
/*      */   private final char conv3ByteAL32UTF8toUTF16(byte paramByte1, byte paramByte2, byte paramByte3)
/*      */   {
/* 1109 */     if (((paramByte1 != -32) || (!checkA0toBF(paramByte2)) || (!check80toBF(paramByte3))) && ((paramByte1 < -31) || (paramByte1 > -20) || (!check80toBF(paramByte2)) || (!check80toBF(paramByte3))) && ((paramByte1 != -19) || (!check80to9F(paramByte2)) || (!check80toBF(paramByte3))) && ((paramByte1 < -18) || (paramByte1 > -17) || (!check80toBF(paramByte2)) || (!check80toBF(paramByte3))))
/*      */     {
/* 1116 */       back();
/* 1117 */       back();
/* 1118 */       return 65533;
/*      */     }
/*      */ 
/* 1122 */     return (char)((paramByte1 & 0xF) << 12 | (paramByte2 & 0x3F) << 6 | paramByte3 & 0x3F);
/*      */   }
/*      */ 
/*      */   private final int conv4ByteAL32UTF8toUTF16(byte paramByte1, byte paramByte2, byte paramByte3, byte paramByte4, char[] paramArrayOfChar, int paramInt)
/*      */   {
/* 1141 */     int i = 0;
/*      */ 
/* 1143 */     if (((paramByte1 != -16) || (!check90toBF(paramByte2)) || (!check80toBF(paramByte3)) || (!check80toBF(paramByte4))) && ((paramByte1 < -15) || (paramByte1 > -13) || (!check80toBF(paramByte2)) || (!check80toBF(paramByte3)) || (!check80toBF(paramByte4))) && ((paramByte1 != -12) || (!check80to8F(paramByte2)) || (!check80toBF(paramByte3)) || (!check80toBF(paramByte4))))
/*      */     {
/* 1148 */       back();
/* 1149 */       back();
/* 1150 */       back();
/* 1151 */       paramArrayOfChar[(paramInt++)] = 65533;
/*      */     }
/*      */     else
/*      */     {
/* 1155 */       paramArrayOfChar[(paramInt++)] = ((char)((((paramByte1 & 0x7) << 2 | paramByte2 >>> 4 & 0x3) - 1 & 0xF) << 6 | (paramByte2 & 0xF) << 2 | paramByte3 >>> 4 & 0x3 | 0xD800));
/*      */ 
/* 1161 */       paramArrayOfChar[(paramInt++)] = ((char)((paramByte3 & 0xF) << 6 | paramByte4 & 0x3F | 0xDC00));
/*      */     }
/* 1163 */     return paramInt;
/*      */   }
/*      */ 
/*      */   byte[] getBlockBasic(long paramLong, int[] paramArrayOfInt)
/*      */   {
/* 1179 */     int i = (int)(paramLong / this.blockSize);
/* 1180 */     paramArrayOfInt[0] = ((int)(paramLong % this.blockSize));
/* 1181 */     if (i >= this.blocks.length) return null;
/* 1182 */     return this.blocks[i];
/*      */   }
/*      */ 
/*      */   private static String escape(String paramString)
/*      */   {
/* 1189 */     StringBuilder localStringBuilder = new StringBuilder(paramString.length() * 6);
/* 1190 */     for (int k : paramString.toCharArray()) {
/* 1191 */       localStringBuilder.append("\\u");
/* 1192 */       int m = (byte)(k >> 8);
/* 1193 */       String str = new StringBuilder().append("00").append(Integer.toHexString(m & 0xFF)).toString();
/* 1194 */       localStringBuilder.append(str, str.length() - 2, str.length());
/* 1195 */       str = new StringBuilder().append("00").append(Integer.toHexString((byte)k & 0xFF)).toString();
/* 1196 */       localStringBuilder.append(str, str.length() - 2, str.length());
/*      */     }
/* 1198 */     return localStringBuilder.toString();
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  534 */     char[][] arrayOfChar = new char[3][];
/*  535 */     AccessController.doPrivileged(new PrivilegedAction()
/*      */     {
/*      */       public Object run()
/*      */       {
/*  539 */         JdbcCharacterConverters localJdbcCharacterConverters = CharacterConverterJDBC.getInstance(31);
/*  540 */         this.val$tmp[0] = DynamicByteArray.intToChar(((CharacterConverter1Byte)localJdbcCharacterConverters).m_ucsChar);
/*      */ 
/*  542 */         localJdbcCharacterConverters = CharacterConverterJDBC.getInstance(2);
/*  543 */         this.val$tmp[1] = DynamicByteArray.intToChar(((CharacterConverter1Byte)localJdbcCharacterConverters).m_ucsChar);
/*      */ 
/*  545 */         localJdbcCharacterConverters = CharacterConverterJDBC.getInstance(178);
/*  546 */         this.val$tmp[2] = DynamicByteArray.intToChar(((CharacterConverter1Byte)localJdbcCharacterConverters).m_ucsChar);
/*      */ 
/*  548 */         return null;
/*      */       }
/*      */     });
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.DynamicByteArray
 * JD-Core Version:    0.6.2
 */