/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ import java.util.TimeZone;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ 
/*     */ abstract class DateTimeCommonAccessor extends Accessor
/*     */ {
/*     */   static final int GREGORIAN_CUTOVER_YEAR = 1582;
/*     */   static final long GREGORIAN_CUTOVER = -12219292800000L;
/*     */   static final int JAN_1_1_JULIAN_DAY = 1721426;
/*     */   static final int EPOCH_JULIAN_DAY = 2440588;
/*     */   static final int ONE_SECOND = 1000;
/*     */   static final int ONE_MINUTE = 60000;
/*     */   static final int ONE_HOUR = 3600000;
/*     */   static final long ONE_DAY = 86400000L;
/*  39 */   static final int[] NUM_DAYS = { 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334 };
/*     */ 
/*  44 */   static final int[] LEAP_NUM_DAYS = { 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335 };
/*     */   static final int ORACLE_CENTURY = 0;
/*     */   static final int ORACLE_YEAR = 1;
/*     */   static final int ORACLE_MONTH = 2;
/*     */   static final int ORACLE_DAY = 3;
/*     */   static final int ORACLE_HOUR = 4;
/*     */   static final int ORACLE_MIN = 5;
/*     */   static final int ORACLE_SEC = 6;
/*     */   static final int ORACLE_NANO1 = 7;
/*     */   static final int ORACLE_NANO2 = 8;
/*     */   static final int ORACLE_NANO3 = 9;
/*     */   static final int ORACLE_NANO4 = 10;
/*     */   static final int ORACLE_TZ1 = 11;
/*     */   static final int ORACLE_TZ2 = 12;
/*     */   static final int SIZE_DATE = 7;
/*     */   static final int MAX_TIMESTAMP_LENGTH = 11;
/*     */   protected final byte[] tmpBytes;
/*     */   static TimeZone epochTimeZone;
/*     */   static long epochTimeZoneOffset;
/* 574 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   DateTimeCommonAccessor(Representation paramRepresentation, OracleStatement paramOracleStatement, int paramInt, boolean paramBoolean)
/*     */   {
/*  73 */     super(paramRepresentation, paramOracleStatement, paramInt, paramBoolean);
/*  74 */     this.tmpBytes = new byte[this.representationMaxLength];
/*     */   }
/*     */ 
/*     */   java.sql.Date getDate(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  84 */     return getDate(paramInt, (Calendar)null);
/*     */   }
/*     */ 
/*     */   java.sql.Date getDate(int paramInt, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/*  94 */     if (isNull(paramInt)) return null;
/*     */ 
/*  96 */     java.sql.Date localDate = null;
/*     */     Calendar localCalendar;
/*  99 */     if (paramCalendar == null) {
/* 100 */       localCalendar = this.statement.getDefaultCalendar();
/*     */     }
/*     */     else {
/* 103 */       localCalendar = (Calendar)paramCalendar.clone();
/*     */     }
/*     */ 
/* 106 */     getBytesInternal(paramInt, this.tmpBytes);
/*     */ 
/* 108 */     int i = oracleYear(this.tmpBytes);
/*     */ 
/* 110 */     localCalendar.set(1, i);
/* 111 */     localCalendar.set(2, oracleMonth(this.tmpBytes));
/* 112 */     localCalendar.set(5, oracleDay(this.tmpBytes));
/* 113 */     localCalendar.set(11, oracleHour(this.tmpBytes));
/* 114 */     localCalendar.set(12, oracleMin(this.tmpBytes));
/* 115 */     localCalendar.set(13, oracleSec(this.tmpBytes));
/* 116 */     localCalendar.set(14, 0);
/*     */ 
/* 118 */     if ((i > 0) && (localCalendar.isSet(0))) {
/* 119 */       localCalendar.set(0, 1);
/*     */     }
/*     */ 
/* 122 */     localDate = new java.sql.Date(localCalendar.getTimeInMillis());
/* 123 */     return localDate;
/*     */   }
/*     */ 
/*     */   Time getTime(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 132 */     Time localTime = null;
/*     */ 
/* 134 */     if (isNull(paramInt)) {
/* 135 */       return null;
/*     */     }
/*     */ 
/* 138 */     TimeZone localTimeZone = this.statement.getDefaultTimeZone();
/*     */ 
/* 140 */     if (localTimeZone != epochTimeZone) {
/* 141 */       epochTimeZoneOffset = calculateEpochOffset(localTimeZone);
/* 142 */       epochTimeZone = localTimeZone;
/*     */     }
/* 144 */     getBytesInternal(paramInt, this.tmpBytes);
/* 145 */     localTime = new Time(oracleTime(this.tmpBytes) - epochTimeZoneOffset);
/*     */ 
/* 148 */     return localTime;
/*     */   }
/*     */ 
/*     */   Time getTime(int paramInt, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 155 */     if (isNull(paramInt)) return null;
/*     */ 
/* 157 */     if (paramCalendar == null) {
/* 158 */       return getTime(paramInt);
/*     */     }
/*     */ 
/* 161 */     getBytesInternal(paramInt, this.tmpBytes);
/*     */ 
/* 163 */     int i = oracleYear(this.tmpBytes);
/*     */ 
/* 165 */     Calendar localCalendar = (Calendar)paramCalendar.clone();
/*     */ 
/* 167 */     localCalendar.set(1, 1970);
/* 168 */     localCalendar.set(2, 0);
/* 169 */     localCalendar.set(5, 1);
/* 170 */     localCalendar.set(11, oracleHour(this.tmpBytes));
/* 171 */     localCalendar.set(12, oracleMin(this.tmpBytes));
/* 172 */     localCalendar.set(13, oracleSec(this.tmpBytes));
/* 173 */     localCalendar.set(14, 0);
/*     */ 
/* 175 */     if ((i > 0) && (localCalendar.isSet(0))) {
/* 176 */       localCalendar.set(0, 1);
/*     */     }
/*     */ 
/* 179 */     return new Time(localCalendar.getTimeInMillis());
/*     */   }
/*     */ 
/*     */   Timestamp getTimestamp(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 189 */     return getTimestamp(paramInt, (Calendar)null);
/*     */   }
/*     */ 
/*     */   Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 196 */     if (isNull(paramInt)) return null;
/*     */     Calendar localCalendar;
/* 199 */     if (paramCalendar == null) {
/* 200 */       localCalendar = this.statement.getDefaultCalendar();
/*     */     }
/*     */     else {
/* 203 */       localCalendar = (Calendar)paramCalendar.clone();
/*     */     }
/*     */ 
/* 206 */     getBytesInternal(paramInt, this.tmpBytes);
/*     */ 
/* 208 */     int i = oracleYear(this.tmpBytes);
/*     */ 
/* 210 */     localCalendar.set(1, i);
/* 211 */     localCalendar.set(2, oracleMonth(this.tmpBytes));
/* 212 */     localCalendar.set(5, oracleDay(this.tmpBytes));
/* 213 */     localCalendar.set(11, oracleHour(this.tmpBytes));
/* 214 */     localCalendar.set(12, oracleMin(this.tmpBytes));
/* 215 */     localCalendar.set(13, oracleSec(this.tmpBytes));
/* 216 */     localCalendar.set(14, 0);
/*     */ 
/* 218 */     if ((i > 0) && (localCalendar.isSet(0))) {
/* 219 */       localCalendar.set(0, 1);
/*     */     }
/*     */ 
/* 222 */     Timestamp localTimestamp = new Timestamp(localCalendar.getTimeInMillis());
/*     */ 
/* 224 */     if (getLength(paramInt) >= 11)
/*     */     {
/* 226 */       localTimestamp.setNanos(oracleNanos(this.tmpBytes));
/*     */     }
/* 228 */     return localTimestamp;
/*     */   }
/*     */ 
/*     */   DATE getDATE(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 237 */     if (isNull(paramInt)) {
/* 238 */       return null;
/*     */     }
/*     */ 
/* 241 */     byte[] arrayOfByte = new byte[7];
/* 242 */     this.rowData.get(getOffset(paramInt), arrayOfByte, 0, 7);
/* 243 */     return new DATE(arrayOfByte);
/*     */   }
/*     */ 
/*     */   TIMESTAMP getTIMESTAMP(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 252 */     if (isNull(paramInt)) {
/* 253 */       return null;
/*     */     }
/*     */ 
/* 256 */     return new TIMESTAMP(getBytesInternal(paramInt));
/*     */   }
/*     */ 
/*     */   java.util.Date getJavaUtilDate(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 266 */     if (isNull(paramInt)) return null;
/*     */ 
/* 268 */     java.util.Date localDate = null;
/*     */ 
/* 270 */     getBytesInternal(paramInt, this.tmpBytes);
/*     */ 
/* 272 */     int i = oracleYear(this.tmpBytes);
/*     */ 
/* 274 */     Calendar localCalendar = this.statement.getDefaultCalendar();
/*     */ 
/* 276 */     localCalendar.set(1, i);
/* 277 */     localCalendar.set(2, oracleMonth(this.tmpBytes));
/* 278 */     localCalendar.set(5, oracleDay(this.tmpBytes));
/* 279 */     localCalendar.set(11, oracleHour(this.tmpBytes));
/* 280 */     localCalendar.set(12, oracleMin(this.tmpBytes));
/* 281 */     localCalendar.set(13, oracleSec(this.tmpBytes));
/* 282 */     localCalendar.set(14, 0);
/*     */ 
/* 284 */     if ((i > 0) && (localCalendar.isSet(0))) {
/* 285 */       localCalendar.set(0, 1);
/*     */     }
/*     */ 
/* 288 */     localDate = localCalendar.getTime();
/* 289 */     return localDate;
/*     */   }
/*     */ 
/*     */   Calendar getCalendar(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 296 */     if (isNull(paramInt)) return null;
/*     */ 
/* 298 */     getBytesInternal(paramInt, this.tmpBytes);
/*     */ 
/* 300 */     int i = oracleYear(this.tmpBytes);
/*     */ 
/* 302 */     Calendar localCalendar = (Calendar)this.statement.getDefaultCalendar().clone();
/*     */ 
/* 304 */     localCalendar.set(1, i);
/* 305 */     localCalendar.set(2, oracleMonth(this.tmpBytes));
/* 306 */     localCalendar.set(5, oracleDay(this.tmpBytes));
/* 307 */     localCalendar.set(11, oracleHour(this.tmpBytes));
/* 308 */     localCalendar.set(12, oracleMin(this.tmpBytes));
/* 309 */     localCalendar.set(13, oracleSec(this.tmpBytes));
/*     */ 
/* 311 */     if (getLength(paramInt) >= 11) {
/* 312 */       localCalendar.set(14, oracleNanos(this.tmpBytes) / 1000);
/*     */     }
/*     */     else {
/* 315 */       localCalendar.set(14, 0);
/*     */     }
/*     */ 
/* 318 */     if ((i > 0) && (localCalendar.isSet(0))) {
/* 319 */       localCalendar.set(0, 1);
/*     */     }
/*     */ 
/* 322 */     return localCalendar;
/*     */   }
/*     */ 
/*     */   final int oracleYear(byte[] paramArrayOfByte)
/*     */   {
/* 330 */     int i = ((paramArrayOfByte[0] & 0xFF) - 100) * 100 + (paramArrayOfByte[1] & 0xFF) - 100;
/*     */ 
/* 334 */     return i <= 0 ? i + 1 : i;
/*     */   }
/*     */ 
/*     */   final int oracleMonth(byte[] paramArrayOfByte)
/*     */   {
/* 342 */     return paramArrayOfByte[2] - 1;
/*     */   }
/*     */ 
/*     */   final int oracleDay(byte[] paramArrayOfByte)
/*     */   {
/* 350 */     return paramArrayOfByte[3];
/*     */   }
/*     */ 
/*     */   final int oracleHour(byte[] paramArrayOfByte)
/*     */   {
/* 358 */     return paramArrayOfByte[4] - 1;
/*     */   }
/*     */ 
/*     */   final int oracleMin(byte[] paramArrayOfByte)
/*     */   {
/* 366 */     return paramArrayOfByte[5] - 1;
/*     */   }
/*     */ 
/*     */   final int oracleSec(byte[] paramArrayOfByte)
/*     */   {
/* 374 */     return paramArrayOfByte[6] - 1;
/*     */   }
/*     */ 
/*     */   final int oracleTZ1(byte[] paramArrayOfByte)
/*     */   {
/* 382 */     return paramArrayOfByte[11];
/*     */   }
/*     */ 
/*     */   final int oracleTZ2(byte[] paramArrayOfByte)
/*     */   {
/* 390 */     return paramArrayOfByte[12];
/*     */   }
/*     */ 
/*     */   final int oracleTime(byte[] paramArrayOfByte)
/*     */   {
/* 397 */     int i = oracleHour(paramArrayOfByte);
/*     */ 
/* 399 */     i *= 60;
/* 400 */     i += oracleMin(paramArrayOfByte);
/* 401 */     i *= 60;
/* 402 */     i += oracleSec(paramArrayOfByte);
/* 403 */     i *= 1000;
/*     */ 
/* 405 */     return i;
/*     */   }
/*     */ 
/*     */   final int oracleNanos(byte[] paramArrayOfByte)
/*     */   {
/* 412 */     int i = (paramArrayOfByte[7] & 0xFF) << 24;
/*     */ 
/* 414 */     i |= (paramArrayOfByte[8] & 0xFF) << 16;
/* 415 */     i |= (paramArrayOfByte[9] & 0xFF) << 8;
/* 416 */     i |= paramArrayOfByte[10] & 0xFF & 0xFF;
/*     */ 
/* 418 */     return i;
/*     */   }
/*     */ 
/*     */   static final long computeJulianDay(boolean paramBoolean, int paramInt1, int paramInt2, int paramInt3)
/*     */   {
/* 426 */     int i = paramInt1 % 4 == 0 ? 1 : 0;
/* 427 */     int j = paramInt1 - 1;
/* 428 */     long l = 365L * j + floorDivide(j, 4L) + 1721423L;
/*     */ 
/* 430 */     if (paramBoolean)
/*     */     {
/* 432 */       i = (i != 0) && ((paramInt1 % 100 != 0) || (paramInt1 % 400 == 0)) ? 1 : 0;
/*     */ 
/* 435 */       l += floorDivide(j, 400L) - floorDivide(j, 100L) + 2L;
/*     */     }
/*     */ 
/* 442 */     return l + paramInt3 + (i != 0 ? LEAP_NUM_DAYS[paramInt2] : NUM_DAYS[paramInt2]);
/*     */   }
/*     */ 
/*     */   static final long floorDivide(long paramLong1, long paramLong2)
/*     */   {
/* 449 */     return paramLong1 >= 0L ? paramLong1 / paramLong2 : (paramLong1 + 1L) / paramLong2 - 1L;
/*     */   }
/*     */ 
/*     */   static final long julianDayToMillis(long paramLong)
/*     */   {
/* 457 */     return (paramLong - 2440588L) * 86400000L;
/*     */   }
/*     */ 
/*     */   static final long zoneOffset(TimeZone paramTimeZone, int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5)
/*     */   {
/* 467 */     return paramTimeZone.getOffset(paramInt1 < 0 ? 0 : 1, paramInt1, paramInt2, paramInt3, paramInt4, paramInt5);
/*     */   }
/*     */ 
/*     */   static long getMillis(int paramInt1, int paramInt2, int paramInt3, int paramInt4, TimeZone paramTimeZone)
/*     */   {
/* 488 */     boolean bool = paramInt1 >= 1582;
/* 489 */     long l1 = computeJulianDay(bool, paramInt1, paramInt2, paramInt3);
/* 490 */     long l2 = (l1 - 2440588L) * 86400000L;
/*     */ 
/* 494 */     if (bool != l2 >= -12219292800000L)
/*     */     {
/* 496 */       l1 = computeJulianDay(!bool, paramInt1, paramInt2, paramInt3);
/* 497 */       l2 = (l1 - 2440588L) * 86400000L;
/*     */     }
/*     */ 
/* 502 */     l2 += paramInt4;
/*     */ 
/* 507 */     return l2 - zoneOffset(paramTimeZone, paramInt1, paramInt2, paramInt3, julianDayToDayOfWeek(l1), paramInt4);
/*     */   }
/*     */ 
/*     */   static final int julianDayToDayOfWeek(long paramLong)
/*     */   {
/* 525 */     int i = (int)((paramLong + 1L) % 7L);
/*     */ 
/* 527 */     return i + (i < 0 ? 8 : 1);
/*     */   }
/*     */ 
/*     */   static long calculateEpochOffset(TimeZone paramTimeZone)
/*     */   {
/* 546 */     return zoneOffset(paramTimeZone, 1970, 0, 1, 5, 0);
/*     */   }
/*     */ 
/*     */   String toText(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, boolean paramBoolean, String paramString)
/*     */     throws SQLException
/*     */   {
/* 561 */     return TIMESTAMPTZ.toString(paramInt1, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramString);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.DateTimeCommonAccessor
 * JD-Core Version:    0.6.2
 */