/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ import java.sql.SQLException;
/*       */ import java.util.Calendar;
/*       */ import java.util.TimeZone;
/*       */ 
/*       */ abstract class DateCommonBinder extends Binder
/*       */ {
/*       */   static final int GREGORIAN_CUTOVER_YEAR = 1582;
/*       */   static final long GREGORIAN_CUTOVER = -12219292800000L;
/*       */   static final int JAN_1_1_JULIAN_DAY = 1721426;
/*       */   static final int EPOCH_JULIAN_DAY = 2440588;
/*       */   static final int ONE_SECOND = 1000;
/*       */   static final int ONE_MINUTE = 60000;
/*       */   static final int ONE_HOUR = 3600000;
/*       */   static final long ONE_DAY = 86400000L;
/* 20613 */   static final int[] NUM_DAYS = { 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334 };
/*       */ 
/* 20617 */   static final int[] LEAP_NUM_DAYS = { 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335 };
/*       */ 
/* 20621 */   static final int[] MONTH_LENGTH = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
/*       */ 
/* 20625 */   static final int[] LEAP_MONTH_LENGTH = { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
/*       */   static final int ORACLE_DATE_CENTURY = 0;
/*       */   static final int ORACLE_DATE_YEAR = 1;
/*       */   static final int ORACLE_DATE_MONTH = 2;
/*       */   static final int ORACLE_DATE_DAY = 3;
/*       */   static final int ORACLE_DATE_HOUR = 4;
/*       */   static final int ORACLE_DATE_MIN = 5;
/*       */   static final int ORACLE_DATE_SEC = 6;
/*       */   static final int ORACLE_DATE_NANO1 = 7;
/*       */   static final int ORACLE_DATE_NANO2 = 8;
/*       */   static final int ORACLE_DATE_NANO3 = 9;
/*       */   static final int ORACLE_DATE_NANO4 = 10;
/* 20742 */   private static int HOUR_MILLISECOND = 3600000;
/* 20743 */   private static int MINUTE_MILLISECOND = 60000;
/* 20744 */   private static int SECOND_MILLISECOND = 1000;
/*       */ 
/* 20935 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   static final long floorDivide(long paramLong1, long paramLong2)
/*       */   {
/* 20645 */     return paramLong1 >= 0L ? paramLong1 / paramLong2 : (paramLong1 + 1L) / paramLong2 - 1L;
/*       */   }
/*       */ 
/*       */   static final int floorDivide(int paramInt1, int paramInt2)
/*       */   {
/* 20653 */     return paramInt1 >= 0 ? paramInt1 / paramInt2 : (paramInt1 + 1) / paramInt2 - 1;
/*       */   }
/*       */ 
/*       */   static final int floorDivide(int paramInt1, int paramInt2, int[] paramArrayOfInt)
/*       */   {
/* 20661 */     if (paramInt1 >= 0)
/*       */     {
/* 20663 */       paramArrayOfInt[0] = (paramInt1 % paramInt2);
/*       */ 
/* 20665 */       return paramInt1 / paramInt2;
/*       */     }
/*       */ 
/* 20668 */     int i = (paramInt1 + 1) / paramInt2 - 1;
/*       */ 
/* 20670 */     paramArrayOfInt[0] = (paramInt1 - i * paramInt2);
/*       */ 
/* 20672 */     return i;
/*       */   }
/*       */ 
/*       */   static final int floorDivide(long paramLong, int paramInt, int[] paramArrayOfInt)
/*       */   {
/* 20681 */     if (paramLong >= 0L)
/*       */     {
/* 20683 */       paramArrayOfInt[0] = ((int)(paramLong % paramInt));
/*       */ 
/* 20685 */       return (int)(paramLong / paramInt);
/*       */     }
/*       */ 
/* 20688 */     int i = (int)((paramLong + 1L) / paramInt - 1L);
/*       */ 
/* 20690 */     paramArrayOfInt[0] = ((int)(paramLong - i * paramInt));
/*       */ 
/* 20692 */     return i;
/*       */   }
/*       */ 
/*       */   static final long zoneOffset(TimeZone paramTimeZone, int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5)
/*       */   {
/* 20703 */     return paramTimeZone.getOffset(paramInt1 < 0 ? 0 : 1, paramInt1, paramInt2, paramInt3, paramInt4, paramInt5);
/*       */   }
/*       */ 
/*       */   static void setOracleNanos(long paramLong, byte[] paramArrayOfByte, int paramInt)
/*       */   {
/* 20716 */     paramArrayOfByte[(10 + paramInt)] = ((byte)(int)(paramLong & 0xFF));
/* 20717 */     paramArrayOfByte[(9 + paramInt)] = ((byte)(int)(paramLong >> 8 & 0xFF));
/* 20718 */     paramArrayOfByte[(8 + paramInt)] = ((byte)(int)(paramLong >> 16 & 0xFF));
/* 20719 */     paramArrayOfByte[(7 + paramInt)] = ((byte)(int)(paramLong >> 24 & 0xFF));
/*       */   }
/*       */ 
/*       */   static void setOracleHMS(int paramInt1, byte[] paramArrayOfByte, int paramInt2)
/*       */   {
/* 20730 */     if (paramInt1 < 0) {
/* 20731 */       throw new RuntimeException("Assertion botch: negative time");
/*       */     }
/* 20733 */     paramInt1 /= 1000;
/* 20734 */     paramArrayOfByte[(6 + paramInt2)] = ((byte)(paramInt1 % 60 + 1));
/* 20735 */     paramInt1 /= 60;
/* 20736 */     paramArrayOfByte[(5 + paramInt2)] = ((byte)(paramInt1 % 60 + 1));
/* 20737 */     paramInt1 /= 60;
/* 20738 */     paramArrayOfByte[(4 + paramInt2)] = ((byte)(paramInt1 + 1));
/*       */   }
/*       */ 
/*       */   static final int setOracleCYMD(long paramLong, byte[] paramArrayOfByte, int paramInt, OraclePreparedStatement paramOraclePreparedStatement)
/*       */     throws SQLException
/*       */   {
/* 20763 */     TimeZone localTimeZone = paramOraclePreparedStatement.getDefaultTimeZone(true);
/*       */ 
/* 20770 */     Calendar localCalendar1 = paramOraclePreparedStatement.cachedUTCUSCalendar;
/*       */ 
/* 20772 */     localCalendar1.setTimeInMillis(paramLong);
/*       */ 
/* 20774 */     Calendar localCalendar2 = paramOraclePreparedStatement.getDefaultCalendar();
/* 20775 */     localCalendar2.setTimeInMillis(paramLong);
/* 20776 */     int i2 = localCalendar2.get(15);
/*       */ 
/* 20779 */     long l1 = paramLong + i2;
/*       */     long l2;
/*       */     int n;
/*       */     int i;
/*       */     int i1;
/*       */     int m;
/* 20782 */     if (l1 >= -12219292800000L)
/*       */     {
/* 20785 */       l2 = 2440588L + floorDivide(l1, 86400000L) - 1721426L;
/*       */       int i5;
/*       */       int i6;
/*       */       int i8;
/* 20795 */       if (l2 > 0L)
/*       */       {
/* 20797 */         i5 = (int)(l2 / 146097L);
/* 20798 */         n = (int)(l2 % 146097L);
/* 20799 */         i6 = n / 36524;
/* 20800 */         n %= 36524;
/* 20801 */         i7 = n / 1461;
/* 20802 */         n %= 1461;
/* 20803 */         i8 = n / 365;
/* 20804 */         n %= 365;
/*       */       }
/*       */       else
/*       */       {
/* 20808 */         int[] arrayOfInt = new int[1];
/*       */ 
/* 20811 */         i5 = floorDivide(l2, 146097, arrayOfInt);
/* 20812 */         i6 = floorDivide(arrayOfInt[0], 36524, arrayOfInt);
/* 20813 */         i7 = floorDivide(arrayOfInt[0], 1461, arrayOfInt);
/* 20814 */         i8 = floorDivide(arrayOfInt[0], 365, arrayOfInt);
/* 20815 */         n = arrayOfInt[0];
/*       */       }
/*       */ 
/* 20818 */       i = 400 * i5 + 100 * i6 + 4 * i7 + i8;
/*       */ 
/* 20820 */       if ((i6 == 4) || (i8 == 4))
/*       */       {
/* 20822 */         n = 365;
/*       */       }
/*       */       else
/*       */       {
/* 20826 */         i++;
/*       */       }
/*       */ 
/* 20829 */       i1 = ((i & 0x3) == 0) && ((i % 100 != 0) || (i % 400 == 0)) ? 1 : 0;
/*       */ 
/* 20832 */       m = (int)((l2 + 1L) % 7L);
/*       */     }
/*       */     else
/*       */     {
/* 20839 */       l2 = 2440588L + floorDivide(l1, 86400000L) - 1721424L;
/*       */ 
/* 20843 */       i = (int)floorDivide(4L * l2 + 1464L, 1461L);
/*       */ 
/* 20846 */       l3 = 365 * (i - 1) + floorDivide(i - 1, 4);
/*       */ 
/* 20848 */       n = (int)(l2 - l3);
/* 20849 */       i1 = (i & 0x3) == 0 ? 1 : 0;
/*       */ 
/* 20852 */       m = (int)((l2 - 1L) % 7L);
/*       */     }
/*       */ 
/* 20856 */     int i3 = 0;
/* 20857 */     int i4 = i1 != 0 ? 60 : 59;
/*       */ 
/* 20859 */     if (n >= i4)
/*       */     {
/* 20861 */       i3 = i1 != 0 ? 1 : 2;
/*       */     }
/*       */ 
/* 20864 */     int j = (12 * (n + i3) + 6) / 367;
/*       */ 
/* 20866 */     int k = n - (i1 != 0 ? LEAP_NUM_DAYS[j] : NUM_DAYS[j]) + 1;
/*       */ 
/* 20871 */     m += (m < 0 ? 8 : 1);
/*       */ 
/* 20873 */     long l3 = l1 / 86400000L;
/* 20874 */     int i7 = (int)(l1 - l3 * 86400000L);
/*       */ 
/* 20876 */     if (i7 < 0)
/*       */     {
/* 20878 */       i7 = (int)(i7 + 86400000L);
/*       */     }
/*       */ 
/* 20884 */     long l4 = zoneOffset(localTimeZone, i, j, k, m, i7);
/*       */ 
/* 20888 */     l4 -= i2;
/*       */ 
/* 20891 */     i7 = (int)(i7 + l4);
/*       */ 
/* 20895 */     if (i7 >= 86400000L)
/*       */     {
/* 20897 */       i7 = (int)(i7 - 86400000L);
/*       */ 
/* 20899 */       k++; if (k > (i1 != 0 ? LEAP_MONTH_LENGTH[j] : MONTH_LENGTH[j]))
/*       */       {
/* 20901 */         k = 1;
/*       */ 
/* 20903 */         j++; if (j == 12)
/*       */         {
/* 20905 */           j = 0;
/* 20906 */           i++;
/*       */         }
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/* 20912 */     if (i <= 0) {
/* 20913 */       i--;
/*       */     }
/* 20915 */     if ((i > 9999) || (i < -4712))
/*       */     {
/* 20919 */       SQLException localSQLException = DatabaseError.createSqlException(null, 268);
/* 20920 */       localSQLException.fillInStackTrace();
/* 20921 */       throw localSQLException;
/*       */     }
/*       */ 
/* 20925 */     paramArrayOfByte[(0 + paramInt)] = ((byte)(i / 100 + 100));
/* 20926 */     paramArrayOfByte[(1 + paramInt)] = ((byte)(i % 100 + 100));
/* 20927 */     paramArrayOfByte[(2 + paramInt)] = ((byte)(j + 1));
/* 20928 */     paramArrayOfByte[(3 + paramInt)] = ((byte)k);
/*       */ 
/* 20930 */     return i7;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.DateCommonBinder
 * JD-Core Version:    0.6.2
 */