/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ import java.sql.Date;
/*       */ import java.sql.SQLException;
/*       */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*       */ 
/*       */ class DateBinder extends DateCommonBinder
/*       */ {
/* 20943 */   Binder theDateCopyingBinder = OraclePreparedStatementReadOnly.theStaticDateCopyingBinder;
/*       */ 
/* 21014 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   static void init(Binder paramBinder)
/*       */   {
/* 20949 */     paramBinder.type = 12;
/* 20950 */     paramBinder.bytelen = 7;
/*       */   }
/*       */ 
/*       */   DateBinder()
/*       */   {
/* 20957 */     init(this);
/*       */   }
/*       */ 
/*       */   Binder copyingBinder()
/*       */   {
/* 20964 */     return this.theDateCopyingBinder;
/*       */   }
/*       */ 
/*       */   long bind(OraclePreparedStatement paramOraclePreparedStatement, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte, char[] paramArrayOfChar, short[] paramArrayOfShort, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, int paramInt9, boolean paramBoolean, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 20976 */     Date[] arrayOfDate = paramOraclePreparedStatement.parameterDate[paramInt3];
/* 20977 */     Date localDate = arrayOfDate[paramInt1];
/*       */ 
/* 20979 */     if (paramBoolean) {
/* 20980 */       arrayOfDate[paramInt1] = null;
/*       */     }
/* 20982 */     if (localDate == null)
/*       */     {
/* 20984 */       paramArrayOfShort[paramInt9] = -1;
/*       */     }
/*       */     else
/*       */     {
/* 20988 */       paramArrayOfShort[paramInt9] = 0;
/*       */ 
/* 20990 */       long l = setOracleCYMD(localDate.getTime(), paramArrayOfByte, paramInt6, paramOraclePreparedStatement);
/*       */ 
/* 20993 */       paramArrayOfByte[(6 + paramInt6)] = 1;
/* 20994 */       paramArrayOfByte[(5 + paramInt6)] = 1;
/* 20995 */       paramArrayOfByte[(4 + paramInt6)] = 1;
/*       */ 
/* 20997 */       paramArrayOfShort[paramInt8] = ((short)paramInt4);
/*       */     }
/* 20999 */     if (paramOraclePreparedStatement.connection.checksumMode.needToCalculateBindChecksum()) {
/* 21000 */       if (paramArrayOfShort[paramInt9] == -1) {
/* 21001 */         paramLong = CRC64.updateChecksum(paramLong, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
/*       */       }
/*       */       else
/*       */       {
/* 21005 */         paramLong = CRC64.updateChecksum(paramLong, localDate.getTime());
/*       */       }
/*       */     }
/*       */ 
/* 21009 */     return paramLong;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.DateBinder
 * JD-Core Version:    0.6.2
 */