/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.Date;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Map;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ class DateAccessor extends DateTimeCommonAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 7;
/* 142 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   DateAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  28 */     super(Representation.DATE, paramOracleStatement, 7, paramBoolean);
/*     */ 
/*  30 */     init(paramOracleStatement, 12, 12, paramShort, paramBoolean);
/*  31 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   DateAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  39 */     super(Representation.DATE, paramOracleStatement, 7, false);
/*     */ 
/*  41 */     init(paramOracleStatement, 12, 12, paramShort, false);
/*  42 */     initForDescribe(12, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  44 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  52 */     String str = null;
/*  53 */     if (isNull(paramInt)) return null;
/*     */ 
/*  55 */     if (this.externalType == 0)
/*     */     {
/*  58 */       if (this.statement.connection.mapDateToTimestamp)
/*     */       {
/*  60 */         str = getTimestamp(paramInt).toString();
/*     */       }
/*     */       else
/*     */       {
/*  64 */         str = getDate(paramInt).toString();
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  69 */       getBytesInternal(paramInt, this.tmpBytes);
/*     */ 
/*  71 */       int i = oracleYear(this.tmpBytes);
/*  72 */       int j = 0;
/*  73 */       str = toText(i, this.tmpBytes[2], this.tmpBytes[3], j = this.tmpBytes[4] - 1, this.tmpBytes[5] - 1, this.tmpBytes[6] - 1, -1, j < 12, null);
/*     */     }
/*     */ 
/*  84 */     return str;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  92 */     if (isNull(paramInt)) return null;
/*     */ 
/*  94 */     if (this.externalType == 0)
/*     */     {
/*  97 */       if (this.statement.connection.mapDateToTimestamp) {
/*  98 */         return getTimestamp(paramInt);
/*     */       }
/* 100 */       return getDate(paramInt);
/*     */     }
/*     */ 
/* 104 */     switch (this.externalType)
/*     */     {
/*     */     case 91:
/* 107 */       return getDate(paramInt);
/*     */     case 92:
/* 109 */       return getTime(paramInt);
/*     */     case 93:
/* 111 */       return getTimestamp(paramInt);
/*     */     }
/*     */ 
/* 114 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/*     */ 
/* 116 */     localSQLException.fillInStackTrace();
/* 117 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 129 */     return getDATE(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 137 */     return getObject(paramInt);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.DateAccessor
 * JD-Core Version:    0.6.2
 */