/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.sql.BatchUpdateException;
/*      */ import java.sql.ClientInfoStatus;
/*      */ import java.sql.SQLClientInfoException;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLWarning;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ 
/*      */ public class DatabaseError
/*      */ {
/*      */   private static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
/*      */   private static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
/*      */   private static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
/*      */   private static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
/*      */   private static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
/*      */   private static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
/*      */   private static final int ORAERROR_NET_IO_EXCEPTION = 17002;
/*      */   private static final int ORAERROR_NO_MORE_DATA_TO_READ = 17410;
/*      */   private static final int ORAERROR_OALL8_INCONSISTENT_STATE = 17447;
/*      */   private static final int ORAERROR_PROTOCOL_VOILATION = 17401;
/*  771 */   private static boolean loadedMessages = false;
/*  772 */   private static Message message = null;
/*  773 */   private static String msgClassName = "oracle.jdbc.driver.Message11";
/*      */ 
/*  990 */   static final SQLStateMapping DEFAULT_SQLSTATE = new SQLStateMapping(-2147483648, 2147483647, "99999", 0);
/*      */ 
/*  993 */   static final SQLStateMapping[] mappings = SQLStateMapping.getMappings();
/*      */   public static final int JDBC_ERROR_BASE = 17000;
/*      */   public static final int JDBC_MAX_ERRORS = 500;
/*      */   public static final int EOJ_SUCCESS = 0;
/*      */   public static final int EOJ_ERROR = 1;
/*      */   public static final int EOJ_IOEXCEPTION = 2;
/*      */   public static final int EOJ_INVALID_COLUMN_INDEX = 3;
/*      */   public static final int EOJ_INVALID_COLUMN_TYPE = 4;
/*      */   public static final int EOJ_UNSUPPORTED_COLUMN_TYPE = 5;
/*      */   public static final int EOJ_INVALID_COLUMN_NAME = 6;
/*      */   public static final int EOJ_INVALID_DYNAMIC_COLUMN = 7;
/*      */   public static final int EOJ_CLOSED_CONNECTION = 8;
/*      */   public static final int EOJ_CLOSED_STATEMENT = 9;
/*      */   public static final int EOJ_CLOSED_RESULTSET = 10;
/*      */   public static final int EOJ_EXHAUSTED_RESULTSET = 11;
/*      */   public static final int EOJ_TYPE_CONFLICT = 12;
/*      */   public static final int EOJ_WAS_NULL = 13;
/*      */   public static final int EOJ_RESULTSET_BEFORE_FIRST_ROW = 14;
/*      */   public static final int EOJ_STATEMENT_WAS_CANCELLED = 15;
/*      */   public static final int EOJ_STATEMENT_TIMED_OUT = 16;
/*      */   public static final int EOJ_CURSOR_ALREADY_INITIALIZED = 17;
/*      */   public static final int EOJ_INVALID_CURSOR = 18;
/*      */   public static final int EOJ_CAN_ONLY_DESCRIBE_A_QUERY = 19;
/*      */   public static final int EOJ_INVALID_ROW_PREFETCH = 20;
/*      */   public static final int EOJ_MISSING_DEFINES = 21;
/*      */   public static final int EOJ_MISSING_DEFINES_AT_INDEX = 22;
/*      */   public static final int EOJ_UNSUPPORTED_FEATURE = 23;
/*      */   public static final int EOJ_NO_DATA_READ = 24;
/*      */   public static final int EOJ_IS_DEFINES_NULL_ERROR = 25;
/*      */   public static final int EOJ_NUMERIC_OVERFLOW = 26;
/*      */   public static final int EOJ_STREAM_CLOSED = 27;
/*      */   public static final int EOJ_NO_NEW_DEFINE_IF_RESULT_SET_NOT_CLOSED = 28;
/*      */   public static final int EOJ_READ_ONLY = 29;
/*      */   public static final int EOJ_INVALID_TRANSLEVEL = 30;
/*      */   public static final int EOJ_AUTO_CLOSE_ONLY = 31;
/*      */   public static final int EOJ_ROW_PREFETCH_NOT_ZERO = 32;
/*      */   public static final int EOJ_MALFORMED_SQL92 = 33;
/*      */   public static final int EOJ_NON_SUPPORTED_SQL92_TOKEN = 34;
/*      */   public static final int EOJ_NON_SUPPORTED_CHAR_SET = 35;
/*      */   public static final int EOJ_ORACLE_NUMBER_EXCEPTION = 36;
/*      */   public static final int EOJ_FAIL_CONVERSION_UTF8_TO_UCS2 = 37;
/*      */   public static final int EOJ_CONVERSION_BYTE_ARRAY_ERROR = 38;
/*      */   public static final int EOJ_CONVERSION_CHAR_ARRAY_ERROR = 39;
/*      */   public static final int EOJ_SUB_SUB_PROTOCOL_ERROR = 40;
/*      */   public static final int EOJ_INVALID_IN_OUT_BINDS = 41;
/*      */   public static final int EOJ_INVALID_BATCH_VALUE = 42;
/*      */   public static final int EOJ_INVALID_STREAM_SIZE = 43;
/*      */   public static final int EOJ_DATASET_ITEMS_NOT_ALLOCATED = 44;
/*      */   public static final int EOJ_BEYOND_BINDS_BATCH = 45;
/*      */   public static final int EOJ_INVALID_RANK = 46;
/*      */   public static final int EOJ_TDS_FORMAT_ERROR = 47;
/*      */   public static final int EOJ_UNDEFINED_TYPE = 48;
/*      */   public static final int EOJ_INCONSISTENT_ADT = 49;
/*      */   public static final int EOJ_NOSUCHELEMENT = 50;
/*      */   public static final int EOJ_NOT_AN_OBJECT_TYPE = 51;
/*      */   public static final int EOJ_INVALID_REF = 52;
/*      */   public static final int EOJ_INVALID_SIZE = 53;
/*      */   public static final int EOJ_INVALID_LOB_LOCATOR = 54;
/*      */   public static final int EOJ_FAIL_CONVERSION_CHARACTER = 55;
/*      */   public static final int EOJ_UNSUPPORTED_CHARSET = 56;
/*      */   public static final int EOJ_CLOSED_LOB = 57;
/*      */   public static final int EOJ_INVALID_NLS_RATIO = 58;
/*      */   public static final int EOJ_CONVERSION_JAVA_ERROR = 59;
/*      */   public static final int EOJ_FAIL_CREATE_DESC = 60;
/*      */   public static final int EOJ_NO_DESCRIPTOR = 61;
/*      */   public static final int EOJ_INVALID_REF_CURSOR = 62;
/*      */   public static final int EOJ_NOT_IN_A_TRANSACTION = 63;
/*      */   public static final int EOJ_DATABASE_IS_NULL = 64;
/*      */   public static final int EOJ_CONV_WAS_NULL = 65;
/*      */   public static final int EOJ_ACCESS_SPECIFIC_IMPL = 66;
/*      */   public static final int EOJ_INVALID_URL = 67;
/*      */   public static final int EOJ_INVALID_ARGUMENTS = 68;
/*      */   public static final int EOJ_USE_XA_EXPLICIT = 69;
/*      */   public static final int EOJ_INVALID_DATASIZE_LENGTH = 70;
/*      */   public static final int EOJ_EXCEEDED_VARRAY_LENGTH = 71;
/*      */   public static final int EOJ_VALUE_TOO_BIG = 72;
/*      */   public static final int EOJ_INVALID_NAME_PATTERN = 74;
/*      */   public static final int EOJ_INVALID_FORWARD_RSET_OP = 75;
/*      */   public static final int EOJ_INVALID_READONLY_RSET_OP = 76;
/*      */   public static final int EOJ_FAIL_REF_SETVALUE = 77;
/*      */   public static final int EOJ_CONNECTIONS_ALREADY_EXIST = 78;
/*      */   public static final int EOJ_USER_CREDENTIALS_FAIL = 79;
/*      */   public static final int EOJ_INVALID_BATCH_COMMAND = 80;
/*      */   public static final int EOJ_BATCH_ERROR = 81;
/*      */   public static final int EOJ_NO_CURRENT_ROW = 82;
/*      */   public static final int EOJ_NOT_ON_INSERT_ROW = 83;
/*      */   public static final int EOJ_ON_INSERT_ROW = 84;
/*      */   public static final int EOJ_UPDATE_CONFLICTS = 85;
/*      */   public static final int EOJ_NULL_INSERT_ROW_VALUE = 86;
/*      */   public static final int WARN_IGNORE_FETCH_DIRECTION = 87;
/*      */   public static final int EOJ_UNSUPPORTED_SYNTAX = 88;
/*      */   public static final int EOJ_INTERNAL_ERROR = 89;
/*      */   public static final int EOJ_OPER_NOT_ALLOWED = 90;
/*      */   public static final int WARN_ALTERNATE_RSET_TYPE = 91;
/*      */   public static final int EOJ_NO_JDBC_AT_END_OF_CALL = 92;
/*      */   public static final int EOJ_WARN_SUCCESS_WITH_INFO = 93;
/*      */   public static final int EOJ_VERSION_MISMATCH = 94;
/*      */   public static final int EOJ_NO_STMT_CACHE_SIZE = 95;
/*      */   public static final int EOJ_INVALID_ELEMENT_TYPE = 97;
/*      */   public static final int EOJ_INVALID_EMPTYLOB_OP = 98;
/*      */   public static final int EOJ_INVALID_INDEXTABLE_ARRAY_LENGTH = 99;
/*      */   public static final int EOJ_INVALID_JAVA_OBJECT = 100;
/*      */   public static final int EOJ_CONNECTIONPOOL_INVALID_PROPERTIES = 101;
/*      */   public static final int EOJ_BFILE_IS_READONLY = 102;
/*      */   public static final int EOJ_WRONG_CONNECTION_TYPE_FOR_METHOD = 103;
/*      */   public static final int EOJ_NULL_SQL_STRING = 104;
/*      */   public static final int EOJ_SESSION_TZ_NOT_SET = 105;
/*      */   public static final int EOJ_CONNECTIONPOOL_INVALID_CONFIG = 106;
/*      */   public static final int EOJ_CONNECTIONPOOL_INVALID_PROXY_TYPE = 107;
/*      */   public static final int WARN_DEFINE_COLUMN_TYPE = 108;
/*      */   public static final int EOJ_STANDARD_ENCODING_NOT_FOUND = 109;
/*      */   public static final int EOJ_THIN_WARNING = 110;
/*      */   public static final int EOJ_WARN_CONN_CACHE_TIMEOUT = 111;
/*      */   public static final int EOJ_WARN_THREAD_TIMEOUT_INTERVAL = 112;
/*      */   public static final int EOJ_WARN_THREAD_INTERVAL_TOO_BIG = 113;
/*      */   public static final int EOJ_LOCAL_COMMIT_IN_GLOBAL_TXN = 114;
/*      */   public static final int EOJ_LOCAL_ROLLBACK_IN_GLOBAL_TXN = 115;
/*      */   public static final int EOJ_AUTOCOMMIT_IN_GLOBAL_TXN = 116;
/*      */   public static final int EOJ_SETSVPT_IN_GLOBAL_TXN = 117;
/*      */   public static final int EOJ_GETID_FOR_NAMED_SVPT = 118;
/*      */   public static final int EOJ_GETNAME_FOR_UNNAMED_SVPT = 119;
/*      */   public static final int EOJ_SETSVPT_WITH_AUTOCOMMIT = 120;
/*      */   public static final int EOJ_ROLLBACK_WITH_AUTOCOMMIT = 121;
/*      */   public static final int EOJ_ROLLBACK_TO_SVPT_IN_GLOBAL_TXN = 122;
/*      */   public static final int EOJ_INVALID_STMT_CACHE_SIZE = 123;
/*      */   public static final int EOJ_WARN_CACHE_INACTIVITY_TIMEOUT = 124;
/*      */   public static final int EOJ_IMPROPER_STATEMENT_TYPE = 125;
/*      */   public static final int EOJ_FIXED_WAIT_TIMEOUT = 126;
/*      */   public static final int EOJ_WARN_CACHE_FIXEDWAIT_TIMEOUT = 127;
/*      */   public static final int EOJ_INVALID_QUERY_STRING = 128;
/*      */   public static final int EOJ_INVALID_DML_STRING = 129;
/*      */   public static final int EOJ_QUERY_TIMEOUT_CLASS_NOT_FOUND = 130;
/*      */   public static final int EOJ_QUERY_TIMEOUT_INVALID_STATE = 131;
/*      */   public static final int EOJ_INVALID_OBJECT_TO_CONVERT = 132;
/*      */   public static final int EOJ_PARAMETER_NAME_TOO_LONG = 134;
/*      */   public static final int EOJ_PARAMETER_NAME_APPEARS_MORE_THAN_ONCE = 135;
/*      */   public static final int EOJ_MALFORMED_DLNK_URL = 136;
/*      */   public static final int EOJ_INVALID_CACHE_ENABLED_DATASOURCE = 137;
/*      */   public static final int EOJ_INVALID_CONNECTION_CACHE_NAME = 138;
/*      */   public static final int EOJ_INVALID_CONNECTION_CACHE_PROPERTIES = 139;
/*      */   public static final int EOJ_CONNECTION_CACHE_ALREADY_EXISTS = 140;
/*      */   public static final int EOJ_CONNECTION_CACHE_DOESNOT_EXIST = 141;
/*      */   public static final int EOJ_CONNECTION_CACHE_DISABLED = 142;
/*      */   public static final int EOJ_INVALID_CACHED_CONNECTION = 143;
/*      */   public static final int EOJ_STMT_NOT_EXECUTED = 144;
/*      */   public static final int EOJ_INVALID_ONS_EVENT = 145;
/*      */   public static final int EOJ_INVALID_ONS_EVENT_VERSION = 146;
/*      */   public static final int EOJ_UNKNOWN_PARAMETER_NAME = 147;
/*      */   public static final int EOJ_T4C_ONLY = 148;
/*      */   public static final int EOJ_ALREADY_PROXY = 149;
/*      */   public static final int EOJ_PROXY_WRONG_ARG = 150;
/*      */   public static final int EOJ_CLOB_TOO_LARGE = 151;
/*      */   public static final int EOJ_METHOD_FOR_LOGICAL_CONNECTION_ONLY = 152;
/*      */   public static final int EOJ_METHOD_FOR_PHYSICAL_CONNECTION_ONLY = 153;
/*      */   public static final int EOJ_EX_MAP_ORACLE_TO_UCS = 154;
/*      */   public static final int EOJ_EX_MAP_UCS_TO_ORACLE = 155;
/*      */   public static final int EOJ_E2E_METRIC_ARRAY_SIZE = 156;
/*      */   public static final int EOJ_SETSTRING_LIMIT = 157;
/*      */   public static final int EOJ_INVALID_DURATION = 158;
/*      */   public static final int EOJ_E2E_METRIC_TOO_LONG = 159;
/*      */   public static final int EOJ_E2E_SEQUENCE_NUMBER_OUT_OF_RANGE = 160;
/*      */   public static final int EOJ_INVALID_TXN_MODE = 161;
/*      */   public static final int EOJ_UNSUPPORTED_HOLDABILITY = 162;
/*      */   public static final int EOJ_GETXACONN_WHEN_CACHE_ENABLED = 163;
/*      */   public static final int EOJ_GETXARESOURCE_FROM_PHYSICAL_CONN = 164;
/*      */   public static final int EOJ_PRIVATE_JDBC_NOT_PRESENT = 165;
/*      */   public static final int EOJ_NO_FETCH_ON_PLSQL = 166;
/*      */   public static final int EOJ_ORACLEPKI_JAR_NOT_FOUND = 167;
/*      */   public static final int EOJ_PKI_WALLET_ERROR = 168;
/*      */   public static final int EOJ_NO_STREAM_BIND_ALLOWED = 169;
/*      */   public static final int EOJ_APP_CTXT_NULL_NAMESPACE = 170;
/*      */   public static final int EOJ_APP_CTXT_ATTR_TOO_LONG = 171;
/*      */   public static final int EOJ_APP_CTXT_VAL_TOO_LONG = 172;
/*      */   public static final int EOJ_DML_RETURNING_PARAM_NOT_REGISTERED = 173;
/*      */   public static final int EOJ_APP_CTXT_INVALID_NAMESPACE = 174;
/*      */   public static final int EOJ_REMOTE_ONS_CONFIG_ERROR = 175;
/*      */   public static final int EOJ_UNKNOWN_LOCALE = 176;
/*      */   public static final int EOJ_DOES_NOT_WRAP_INTERFACE = 177;
/*      */   public static final int EOJ_ANYTYPE_PICKLER = 178;
/*      */   public static final int EOJ_KOTAD_MAGIC_NUMBER_ERROR = 179;
/*      */   public static final int EOJ_KOTAD_FORMAT_ERROR = 180;
/*      */   public static final int EOJ_CHARACTER_CONVERTER_GENERAL_ERROR = 181;
/*      */   public static final int EOJ_CHARACTER_CONVERTER_OVERRUN_ERROR = 182;
/*      */   public static final int EOJ_CHARACTER_CONVERTER_IMPOSSIBLE_ERROR = 183;
/*      */   public static final int EOJ_INCORRECT_FORM_OF_USE = 184;
/*      */   public static final int EOJ_CONNECTION_PROPERTIES_DEFAULT_MISSING = 185;
/*      */   public static final int EOJ_CONNECTION_PROPERTIES_ACCESSMODE_MISSING = 186;
/*      */   public static final int EOJ_CONNECTION_PROPERTIES_INVALID_TYPE = 187;
/*      */   public static final int EOJ_CONNECTION_PROPERTIES_REFLECTION_ILLEGAL_ACCESS = 188;
/*      */   public static final int EOJ_CONNECTION_PROPERTIES_MISSING_INSTANCE_VARIABLE = 189;
/*      */   public static final int EOJ_CONNECTION_PROPERTIES_FORMAT_ERROR = 190;
/*      */   public static final int EOJ_INVALID_COMMIT_OPTIONS = 191;
/*      */   public static final int EOJ_FREED_LOB = 192;
/*      */   public static final int EOJ_INVALID_AQ_MESSAGE_FORMAT = 193;
/*      */   public static final int EOJ_MARK_RESET_NOT_SUPPORTED = 194;
/*      */   public static final int EOJ_INVALID_MARK = 195;
/*      */   public static final int EOJ_READAHEAD_LIMIT_EXCEEDED = 196;
/*      */   public static final int EOJ_INCORRECT_PARAMETER_USAGE = 197;
/*      */   public static final int EOJ_SESSION_TIME_ZONE_NOT_SET = 198;
/*      */   public static final int EOJ_SESSION_TIME_ZONE_NOT_SUPPORTED = 199;
/*      */   public static final int EOJ_HETEROXA_GET_UTF_OPENSTR = 200;
/*      */   public static final int EOJ_HETEROXA_GET_UTF_CLOSESTR = 201;
/*      */   public static final int EOJ_HETEROXA_GET_UTF_RMNAME = 202;
/*      */   public static final int EOJ_HETEROXA_JHANDLE_SIZE = 203;
/*      */   public static final int EOJ_HETEROXA_ARRAY_TOO_SHORT = 204;
/*      */   public static final int EOJ_HETEROXA_SVCCTX_HANDLE = 205;
/*      */   public static final int EOJ_HETEROXA_ENV_HANDLE = 206;
/*      */   public static final int EOJ_HETEROXA_NULL_TNSENTRY = 207;
/*      */   public static final int EOJ_HETEROXA_OPEN_RMERR = 213;
/*      */   public static final int EOJ_HETEROXA_OPEN_INVAL = 215;
/*      */   public static final int EOJ_HETEROXA_OPEN_PROTO = 216;
/*      */   public static final int EOJ_HETEROXA_CLOSE_RMERR = 233;
/*      */   public static final int EOJ_HETEROXA_CLOSE_INVAL = 235;
/*      */   public static final int EOJ_HETEROXA_CLOSE_PROTO = 236;
/*      */   static final int NEXT_ERROR = 240;
/*      */   public static final int EOJ_NTF_UNKNOWN_LOCALHOST = 240;
/*      */   public static final int EOJ_NTF_SECURITY_MANAGER = 241;
/*      */   public static final int EOJ_NTF_TCP_OPTION = 242;
/*      */   public static final int EOJ_NTF_TIMEOUT_OPTION = 243;
/*      */   public static final int EOJ_DCN_CHANGELAG_OPTION = 244;
/*      */   public static final int EOJ_NTF_DELETE_REG_WRONG_INSTANCE = 245;
/*      */   public static final int EOJ_NTF_NULL_LISTENER = 246;
/*      */   public static final int EOJ_NTF_PLSQL_LISTENER = 247;
/*      */   public static final int EOJ_NTF_DUP_LISTENER = 248;
/*      */   public static final int EOJ_NTF_RM_MISSING_LISTENER = 249;
/*      */   public static final int EOJ_NTF_TCPPORT_ALREADY_USED = 250;
/*      */   public static final int EOJ_NTF_CLOSED_REGISTRATION = 251;
/*      */   public static final int EOJ_AQ_UNDEFINED_PAYLOAD_TYPE = 252;
/*      */   public static final int EOJ_INVALID_NAME_FOR_CLIENTINFO = 253;
/*      */   public static final int EOJ_OUT_OF_MEMORY_ERROR = 254;
/*      */   public static final int EOJ_CANNOT_DISABLE_FCF = 255;
/*      */   public static final int EOJ_INSTANCE_PROP_NOT_AVAILABLE = 256;
/*      */   public static final int EOJ_INVALID_DRIVER_NAME_ATTR = 257;
/*      */   public static final int EOJ_SYNONYM_LOOP_DETECTED = 258;
/*      */   public static final int EOJ_MISSING_JAR_FOR_XML = 259;
/*      */   public static final int EOJ_READ_EMPTY_SQLXML = 260;
/*      */   public static final int EOJ_NOT_READABLE_SQLXML = 261;
/*      */   public static final int EOJ_NOT_WRITEABLE_SQLXML = 262;
/*      */   public static final int EOJ_UNSUPPORTED_SQLXML_RESULT_TYPE = 263;
/*      */   public static final int EOJ_UNSUPPORTED_SQLXML_SOURCE_TYPE = 264;
/*      */   public static final int EOJ_INVALID_TIMEZONE_NAME = 265;
/*      */   public static final int EOJ_USER_STREAM_BIND_EXCEPTION = 266;
/*      */   public static final int EOJ_INVALID_LOB_PREFETCH_SIZE = 267;
/*      */   public static final int EOJ_INVALID_DATE_YEAR = 268;
/*      */   public static final int EOJ_OCI_FATAL_ERROR = 269;
/*      */   public static final int EOJ_DUPLICATE_STREAM_PARAMETER = 270;
/*      */   public static final int EOJ_SETPLSQLINDEXTABLE_NULL_ARRAY = 271;
/*      */   public static final int EOJ_SETPLSQLINDEXTABLE_ZERO_ARRAY = 272;
/*      */   public static final int EOJ_CALLCOMMIT_WITH_AUTOCOMMIT = 273;
/*      */   public static final int EOJ_CALLROLLBACK_WITH_AUTOCOMMIT = 274;
/*      */   public static final int EOJ_RESULTSET_MAXROWS_LIMIT_REACHED = 275;
/*      */   public static final int EOJ_ATTEMPT_TO_USE_RESERVED_NAMESPACE = 276;
/*      */   public static final int EOJ_CANNOT_OPEN_TRANSLATION_FILE = 277;
/*      */   public static final int EOJ_TRANSLATION_FILE_PARSING_ERROR = 278;
/*      */   public static final int EOJ_TRANSLATE_QUERY_IN_LOCAL_MODE = 279;
/*      */   public static final int EOJ_SERVER_TRANSLATION_ERROR = 280;
/*      */   public static final int EOJ_NULL_FACTORY = 281;
/*      */   public static final int EOJ_NULL_CLASS = 282;
/*      */   public static final int EOJ_NO_RESULTSET = 283;
/*      */   public static final int EOJ_NULL_EXECUTOR = 284;
/*      */   public static final int EOJ_NEGATIVE_TIMEOUT = 285;
/*      */   public static final int EOJ_RECURSIVE_EXECUTION = 286;
/*      */   public static final int EOJ_NTF_REGISTRATION_FAILED = 287;
/*      */   public static final int EOJ_SERVER_QUERY_TRANSLATION_NULL = 288;
/*      */   public static final int EOJ_RESULTSET_AFTER_LAST_ROW = 289;
/*      */   public static final int EOJ_BIND_CHECKSUM_MISMATCH = 290;
/*      */   private static final int EOJ_ROWSET_ERROR_BASE = 300;
/*      */   public static final int EOJ_JRS_UNABLE_CONNECT_VIA_DS = 300;
/*      */   public static final int EOJ_JRS_AUTH_PROPS_NOT_SET = 301;
/*      */   public static final int EOJ_JRS_CONN_NOT_OPEN = 302;
/*      */   public static final int EOJ_JRS_DEL_ROWS_INVISIBLE = 303;
/*      */   public static final int EOJ_JRS_SYNC_PROVIDER = 304;
/*      */   public static final int EOJ_JRS_RESULTSET_NOT_OPEN = 305;
/*      */   public static final int EOJ_JRS_FETCH_DIR_FOR_SCROLL = 306;
/*      */   public static final int EOJ_JRS_FETCH_REV_FOR_FWD_TYPE = 307;
/*      */   public static final int EOJ_JRS_INVALID_FETCH_DIR = 308;
/*      */   public static final int EOJ_JRS_ROWSET_NOT_WRITABLE = 309;
/*      */   public static final int EOJ_JRS_INVALID_PARAM_INDEX = 310;
/*      */   public static final int EOJ_JRS_CNVT_COL_TO_STREAM = 311;
/*      */   public static final int EOJ_JRS_CANT_COVT_COL_TO_STRM = 312;
/*      */   public static final int EOJ_JRS_CALL_NEXT_PREV_FIRST = 313;
/*      */   public static final int EOJ_JRS_INVALID_OP_FWD_TYPE = 314;
/*      */   public static final int EOJ_JRS_NO_ROWS_CHANGED = 315;
/*      */   public static final int EOJ_JRS_MAP_IN_TOCOLLECTION = 316;
/*      */   public static final int EOJ_JRS_ROW_NOT_INSERTED = 317;
/*      */   public static final int EOJ_JRS_ROW_NOT_DELETED = 318;
/*      */   public static final int EOJ_JRS_ROW_NOT_UPDATED = 319;
/*      */   public static final int EOJ_JRS_NOT_ALL_COLS_SET = 320;
/*      */   public static final int EOJ_JRS_CONV_READER_TO_STR = 321;
/*      */   public static final int EOJ_JRS_STREAM_READ = 322;
/*      */   public static final int EOJ_JRS_INVALID_PARAM_TYPE = 323;
/*      */   public static final int EOJ_JRS_INVALID_NUM_KEY_COLS = 324;
/*      */   public static final int EOJ_JRS_INVALID_PAGE_SIZE = 325;
/*      */   public static final int EOJ_JRS_MARK_INS_ROW_ORIG = 326;
/*      */   public static final int EOJ_JRS_INVALID_OP_BEFORE_INS = 327;
/*      */   public static final int EOJ_JRS_INVALID_OP_ON_RESULTSET = 328;
/*      */   public static final int EOJ_JRS_INVALID_OP_BEFORE_PAGING = 329;
/*      */   public static final int EOJ_JRS_INVALID_ROW_NUM_PARAM = 330;
/*      */   public static final int EOJ_JRS_NEGATIVE_START_POS = 331;
/*      */   public static final int EOJ_JRS_NULL_RESULTSET_TO_POPULATE = 332;
/*      */   public static final int EOJ_JRS_FEW_ROWS_START_POPULATE = 333;
/*      */   public static final int EOJ_JRS_NO_MATCH_COL_INDEXES_SET = 334;
/*      */   public static final int EOJ_JRS_NO_MATCH_COL_NAMES_SET = 335;
/*      */   public static final int EOJ_JRS_INVALID_MATCH_COL_INDEX = 336;
/*      */   public static final int EOJ_JRS_INVALID_MATCH_COL_NAME = 337;
/*      */   public static final int EOJ_JRS_CANT_SET_MATCH_COL_INDEX = 338;
/*      */   public static final int EOJ_JRS_CANT_SET_MATCH_COL_NAME = 339;
/*      */   public static final int EOJ_JRS_COL_INDEX_NOT_BEEN_SET = 340;
/*      */   public static final int EOJ_JRS_COL_NAME_NOT_BEEN_SET = 341;
/*      */   public static final int EOJ_JRS_CANT_OBTAIN_CONNECTION = 342;
/*      */   public static final int EOJ_JRS_TABLE_NAME_IN_SQL = 343;
/*      */   public static final int EOJ_JRS_WRONG_ROWSET_SCROLL_TYPE = 344;
/*      */   public static final int EOJ_JRS_OBJ_NOT_SATISFY_FILTER = 345;
/*      */   public static final int EOJ_JRS_SERIAL_BLOB_CONSTRUCTOR = 346;
/*      */   public static final int EOJ_JRS_SERIAL_CLOB_CONSTRUCTOR = 347;
/*      */   public static final int EOJ_JRS_CANT_CREATE_OBJ_COPY = 348;
/*      */   public static final int EOJ_JRS_ERROR_CREATE_OBJ_COPY = 349;
/*      */   public static final int EOJ_JRS_EMPTY_ROWSET_PARAM = 350;
/*      */   public static final int EOJ_JRS_PARAM_NOT_A_ROWSET = 351;
/*      */   public static final int EOJ_JRS_UNSUPPORTED_JOIN_TYPE = 352;
/*      */   public static final int EOJ_JRS_ROWSET_MATCH_COL_NUM_DIFF = 353;
/*      */   public static final int EOJ_JRS_UNSUPPORTED_3RD_PARTY = 354;
/*      */   public static final int EOJ_JRS_INVALID_XMLREADER = 355;
/*      */   public static final int EOJ_JRS_INVALID_XMLWRITER = 356;
/*      */   public static final int EOJ_JRS_NON_NULLABLE_PROPERTY = 357;
/*      */   public static final int EOJ_JRS_NON_NULLABLE_METADATA = 358;
/*      */   public static final int EOJ_JRS_INVALID_WEBROWSET_ARG = 359;
/*      */   public static final int EOJ_NO_REPLAY = 370;
/*      */   public static final int NO_REPLAY_ACTIVE_TXN = 371;
/*      */   public static final int NO_REPLAY_NONREPLAYABLE_CALL = 372;
/*      */   public static final int NO_REPLAY_LAST_CALL_PLSQL = 373;
/*      */   public static final int NO_REPLAY_TXN_MONITORING_FAILED = 374;
/*      */   public static final int NO_REPLAY_BEGIN_REPLAY_FAILED = 375;
/*      */   public static final int NO_REPLAY_END_REPLAY_FAILED = 376;
/*      */   public static final int NO_REPLAY_INITIATION_TIMEOUT_EXCEEDED = 377;
/*      */   public static final int NO_REPLAY_RETRIES_EXCEEDED = 378;
/*      */   public static final int NO_REPLAY_INIT_CALLBACK_FAILURE = 379;
/*      */   public static final int NO_REPLAY_ACTIVE_TXN_IN_INIT_CALLBACK = 380;
/*      */   public static final int NO_REPLAY_AFTER_ENDREQUEST = 381;
/*      */   public static final int NO_REPLAY_RECONNECT_RETRIES_EXCEEDED = 382;
/*      */   public static final int NO_REPLAY_GET_REPLAY_CONTEXT_FAILED = 383;
/*      */   public static final int NO_REPLAY_SERVER_CM_DISABLED = 384;
/*      */   public static final int NO_REPLAY_PREPARE_REPLAY_FAILED = 385;
/*      */   public static final int NO_REPLAY_EMBEDDED_COMMIT = 386;
/*      */   public static final int EOJ_REPLAY_ERROR = 387;
/*      */   public static final int REPLAY_ERROR_CHECKSUM_MISMATCH = 388;
/*      */   public static final int REPLAY_ERROR_ERRCODES_MESG_MISMATCH = 389;
/*      */   public static final int REPLAY_ERROR_ACTIVE_TXN = 390;
/*      */   public static final int BEGIN_REQUEST_CALLED_DURING_REQUEST = 391;
/*      */   public static final int BEGIN_REQUEST_CALLED_WITH_OPEN_TXN = 392;
/*      */   public static final int END_REQUEST_CALLED_WITH_OPEN_TXN = 393;
/*      */   public static final int SVR_TOO_OLD_TO_SUPPORT_REPLAY = 394;
/*      */   public static final int REPLAY_SUPPORT_UNAVAILABLE_IN_SVR = 395;
/*      */   public static final int SVR_FAILOVER_TYPE_NOT_TRANSACTION = 396;
/*      */   public static final int TTC_ERR_BASE = 400;
/*      */   public static final int TTC0000 = 401;
/*      */   public static final int TTC0001 = 402;
/*      */   public static final int TTC0002 = 403;
/*      */   public static final int TTC0003 = 404;
/*      */   public static final int TTC0004 = 405;
/*      */   public static final int TTC0005 = 406;
/*      */   public static final int TTC0100 = 407;
/*      */   public static final int TTC0101 = 408;
/*      */   public static final int TTC0102 = 409;
/*      */   public static final int TTC0103 = 410;
/*      */   public static final int TTC0104 = 411;
/*      */   public static final int TTC0105 = 412;
/*      */   public static final int TTC0106 = 413;
/*      */   public static final int TTC0107 = 414;
/*      */   public static final int TTC0108 = 415;
/*      */   public static final int TTC0109 = 416;
/*      */   public static final int TTC0110 = 417;
/*      */   public static final int TTC0111 = 418;
/*      */   public static final int TTC0112 = 419;
/*      */   public static final int TTC0113 = 420;
/*      */   public static final int TTC0114 = 421;
/*      */   public static final int TTC0115 = 422;
/*      */   public static final int TTC0116 = 423;
/*      */   public static final int TTC0117 = 424;
/*      */   public static final int TTC0118 = 425;
/*      */   public static final int TTC0119 = 426;
/*      */   public static final int TTC0120 = 427;
/*      */   public static final int TTC0200 = 428;
/*      */   public static final int TTC0201 = 429;
/*      */   public static final int TTC0202 = 430;
/*      */   public static final int TTC0203 = 431;
/*      */   public static final int TTC0204 = 432;
/*      */   public static final int TTC0205 = 433;
/*      */   public static final int TTC0206 = 434;
/*      */   public static final int TTC0207 = 435;
/*      */   public static final int TTC0208 = 436;
/*      */   public static final int TTC0209 = 437;
/*      */   public static final int TTC0210 = 438;
/*      */   public static final int TTC0211 = 439;
/*      */   public static final int TTC0212 = 440;
/*      */   public static final int TTC0213 = 441;
/*      */   public static final int TTC0214 = 442;
/*      */   public static final int TTC0217 = 444;
/*      */   public static final int TTC0218 = 445;
/*      */   public static final int TTC0219 = 446;
/*      */   public static final int TTC0220 = 447;
/*      */   public static final int TTC0222 = 449;
/*      */   public static final int TTC0223 = 450;
/*      */   public static final int TTC0224 = 451;
/*      */   public static final int TTC0225 = 452;
/*      */   public static final int TTC0226 = 453;
/* 1609 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public static SQLException newSQLException(OracleConnection paramOracleConnection, String paramString, int paramInt)
/*      */   {
/*   82 */     return newSQLException(paramOracleConnection, paramString, paramInt, null);
/*      */   }
/*      */ 
/*      */   public static SQLException newSQLException(OracleConnection paramOracleConnection, String paramString, int paramInt, Throwable paramThrowable)
/*      */   {
/*   92 */     SQLStateMapping localSQLStateMapping = findSQLStateMapping(paramInt);
/*      */ 
/*   95 */     if (paramOracleConnection != null)
/*      */     {
/*      */       try
/*      */       {
/*  101 */         switch (paramInt)
/*      */         {
/*      */         case 1033:
/*      */         case 1034:
/*      */         case 1089:
/*      */         case 1090:
/*      */         case 3113:
/*      */         case 3114:
/*      */         case 17002:
/*      */         case 17401:
/*      */         case 17410:
/*      */         case 17447:
/*  115 */           paramOracleConnection.setUsable(false);
/*  116 */           break;
/*      */         default:
/*  119 */           if (paramOracleConnection.isClosed()) {
/*  120 */             paramOracleConnection.setUsable(false);
/*      */           }
/*      */           break;
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (SQLException localSQLException1)
/*      */       {
/*  128 */         paramOracleConnection.setUsable(false);
/*      */       }
/*      */ 
/*  131 */       if ((paramInt >= 401) && (paramInt <= 452))
/*      */         try {
/*  133 */           ((PhysicalConnection)paramOracleConnection).internalClose();
/*      */         }
/*      */         catch (SQLException localSQLException2) {
/*      */         }
/*      */     }
/*  138 */     SQLException localSQLException3 = localSQLStateMapping.newSQLException(paramString, paramInt);
/*  139 */     if (paramThrowable != null) {
/*  140 */       localSQLException3.initCause(paramThrowable);
/*      */     }
/*  142 */     return localSQLException3;
/*      */   }
/*      */ 
/*      */   public static SQLException newSQLException(OracleConnection paramOracleConnection, int paramInt)
/*      */   {
/*  160 */     int i = getVendorCode(paramInt);
/*  161 */     String str = findMessage(paramInt, null);
/*  162 */     return newSQLException(paramOracleConnection, str, i);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(OracleConnection paramOracleConnection, String paramString, int paramInt, Throwable paramThrowable)
/*      */   {
/*  185 */     return newSQLException(paramOracleConnection, paramString, paramInt, paramThrowable);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(OracleConnection paramOracleConnection, String paramString, int paramInt)
/*      */   {
/*  194 */     return newSQLException(paramOracleConnection, paramString, paramInt, null);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(int paramInt, Object paramObject)
/*      */   {
/*  218 */     return createSqlException(null, paramInt, paramObject);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(OracleConnection paramOracleConnection, int paramInt, Object paramObject, Throwable paramThrowable)
/*      */   {
/*  244 */     if ((paramInt == 0) || (paramInt == 13))
/*      */     {
/*  246 */       return null;
/*      */     }
/*      */ 
/*  249 */     String str = findMessage(paramInt, paramObject);
/*  250 */     int i = getVendorCode(paramInt);
/*      */ 
/*  252 */     return createSqlException(paramOracleConnection, str, i, paramThrowable);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(OracleConnection paramOracleConnection, int paramInt, Object paramObject)
/*      */   {
/*  260 */     return createSqlException(paramOracleConnection, paramInt, paramObject, null);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(OracleSQLException paramOracleSQLException)
/*      */   {
/*  285 */     return createSqlException(null, paramOracleSQLException);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(OracleConnection paramOracleConnection, OracleSQLException paramOracleSQLException)
/*      */   {
/*  314 */     int i = paramOracleSQLException.getErrorCode();
/*  315 */     if ((i == 0) || (i == 13))
/*      */     {
/*  317 */       return null;
/*      */     }
/*  319 */     String str = paramOracleSQLException.getMessage();
/*      */ 
/*  324 */     SQLException localSQLException = newSQLException(paramOracleConnection, str, i);
/*  325 */     localSQLException.initCause(paramOracleSQLException);
/*  326 */     return localSQLException;
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(OracleConnection paramOracleConnection, SQLException paramSQLException, int paramInt, Object paramObject)
/*      */   {
/*  353 */     if ((paramInt == 0) || (paramInt == 13))
/*      */     {
/*  355 */       return null;
/*      */     }
/*      */ 
/*  358 */     String str = findMessage(paramInt, paramObject);
/*  359 */     int i = getVendorCode(paramInt);
/*      */ 
/*  361 */     SQLException localSQLException = newSQLException(paramOracleConnection, str, i);
/*      */ 
/*  363 */     localSQLException.setNextException(paramSQLException);
/*  364 */     return localSQLException;
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(int paramInt)
/*      */   {
/*  382 */     return createSqlException(null, paramInt);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(OracleConnection paramOracleConnection, int paramInt)
/*      */   {
/*  402 */     return createSqlException(paramOracleConnection, paramInt, null);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(IOException paramIOException)
/*      */   {
/*  417 */     return createSqlException(null, paramIOException);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(OracleConnection paramOracleConnection, IOException paramIOException)
/*      */   {
/*  436 */     String str = paramIOException.getMessage();
/*      */ 
/*  438 */     int j = 0;
/*      */     int i;
/*  443 */     if ((str != null) && ((i = str.indexOf("ORA-")) != -1))
/*      */     {
/*  446 */       i += 4;
/*      */ 
/*  448 */       int k = str.length() - 1;
/*  449 */       int m = str.indexOf(":", i);
/*  450 */       int n = str.indexOf(",", i);
/*      */ 
/*  452 */       if (m != -1) {
/*  453 */         k = m;
/*      */       }
/*  455 */       if (n != -1) {
/*  456 */         k = Math.min(n, k);
/*      */       }
/*      */       try
/*      */       {
/*  460 */         j = Integer.parseInt(str.substring(i, k));
/*      */       }
/*      */       catch (StringIndexOutOfBoundsException localStringIndexOutOfBoundsException) {
/*  463 */         return createSqlException(paramOracleConnection, 2, str, paramIOException);
/*      */       }
/*      */       catch (NumberFormatException localNumberFormatException) {
/*  466 */         return createSqlException(paramOracleConnection, 2, str, paramIOException);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  471 */       return createSqlException(paramOracleConnection, 2, str, paramIOException);
/*      */     }
/*  473 */     return createSqlException(paramOracleConnection, str, j, paramIOException);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(Exception paramException)
/*      */   {
/*  490 */     return createSqlException(null, paramException);
/*      */   }
/*      */ 
/*      */   public static SQLException createSqlException(OracleConnection paramOracleConnection, Exception paramException)
/*      */   {
/*  509 */     return createSqlException(paramOracleConnection, paramException.getMessage(), 1, paramException);
/*      */   }
/*      */ 
/*      */   public static void addSqlException(SQLException paramSQLException, String paramString, int paramInt)
/*      */   {
/*  526 */     SQLException localSQLException = newSQLException(null, paramString, paramInt);
/*  527 */     paramSQLException.setNextException(localSQLException);
/*      */   }
/*      */ 
/*      */   public static BatchUpdateException createBatchUpdateException(SQLException paramSQLException, int paramInt, int[] paramArrayOfInt)
/*      */   {
/*  553 */     int i = 0;
/*  554 */     int[] arrayOfInt = null;
/*      */ 
/*  556 */     if (paramInt < 0)
/*      */     {
/*  558 */       paramInt = 0;
/*      */     }
/*      */ 
/*  561 */     if (paramArrayOfInt == null)
/*      */     {
/*  563 */       arrayOfInt = new int[0];
/*      */     }
/*  565 */     else if (paramInt >= paramArrayOfInt.length)
/*      */     {
/*  567 */       arrayOfInt = paramArrayOfInt;
/*      */     }
/*      */     else
/*      */     {
/*  571 */       arrayOfInt = new int[paramInt];
/*      */ 
/*  573 */       for (i = 0; i < paramInt; i++)
/*      */       {
/*  575 */         arrayOfInt[i] = paramArrayOfInt[i];
/*      */       }
/*      */     }
/*  578 */     BatchUpdateException localBatchUpdateException = new BatchUpdateException(paramSQLException.getMessage(), paramSQLException.getSQLState(), paramSQLException.getErrorCode(), arrayOfInt);
/*      */ 
/*  580 */     localBatchUpdateException.setNextException(paramSQLException);
/*  581 */     return localBatchUpdateException;
/*      */   }
/*      */ 
/*      */   public static BatchUpdateException createBatchUpdateException(String paramString1, String paramString2, int paramInt1, int paramInt2, int[] paramArrayOfInt)
/*      */   {
/*  610 */     int i = 0;
/*  611 */     int[] arrayOfInt = null;
/*      */ 
/*  613 */     if (paramInt2 < 0)
/*      */     {
/*  615 */       paramInt2 = 0;
/*      */     }
/*      */ 
/*  618 */     if (paramArrayOfInt == null)
/*      */     {
/*  620 */       arrayOfInt = new int[0];
/*      */     }
/*  622 */     else if (paramInt2 >= paramArrayOfInt.length)
/*      */     {
/*  624 */       arrayOfInt = paramArrayOfInt;
/*      */     }
/*      */     else
/*      */     {
/*  628 */       arrayOfInt = new int[paramInt2];
/*      */ 
/*  630 */       for (i = 0; i < paramInt2; i++)
/*      */       {
/*  632 */         arrayOfInt[i] = paramArrayOfInt[i];
/*      */       }
/*      */     }
/*  635 */     return new BatchUpdateException(paramString1, paramString2, paramInt1, arrayOfInt);
/*      */   }
/*      */ 
/*      */   public static BatchUpdateException createBatchUpdateException(int paramInt1, Object paramObject, int paramInt2, int[] paramArrayOfInt)
/*      */   {
/*  664 */     if (paramInt1 == 0)
/*      */     {
/*  666 */       return null;
/*      */     }
/*      */ 
/*  669 */     String str = findMessage(paramInt1, paramObject);
/*  670 */     int i = getVendorCode(paramInt1);
/*      */ 
/*  672 */     return createBatchUpdateException(str, null, i, paramInt2, paramArrayOfInt);
/*      */   }
/*      */ 
/*      */   public static BatchUpdateException createBatchUpdateException(int paramInt1, int paramInt2, int[] paramArrayOfInt)
/*      */   {
/*  697 */     return createBatchUpdateException(paramInt1, null, paramInt2, paramArrayOfInt);
/*      */   }
/*      */ 
/*      */   public static SQLException createUnsupportedFeatureSqlException()
/*      */   {
/*  710 */     return createSqlException(null, 23);
/*      */   }
/*      */ 
/*      */   public static SQLException createUnsupportedFeatureSqlException(String paramString)
/*      */   {
/*  723 */     return createSqlException(null, 23, paramString);
/*      */   }
/*      */ 
/*      */   public static SQLClientInfoException createSQLClientInfoException(int paramInt, Map<String, ClientInfoStatus> paramMap, Throwable paramThrowable)
/*      */   {
/*  741 */     if ((paramInt == 0) || (paramInt == 13))
/*      */     {
/*  743 */       return null;
/*      */     }
/*  745 */     int i = getVendorCode(paramInt);
/*  746 */     String str1 = findMessage(paramInt, null);
/*  747 */     SQLStateMapping localSQLStateMapping = findSQLStateMapping(i);
/*  748 */     String str2 = localSQLStateMapping.sqlState;
/*  749 */     return new SQLClientInfoException(str1, str2, i, paramMap, paramThrowable);
/*      */   }
/*      */ 
/*      */   public static IOException createIOException(SQLException paramSQLException)
/*      */   {
/*  766 */     return new IOException(paramSQLException.getMessage(), paramSQLException);
/*      */   }
/*      */ 
/*      */   static String findMessage(int paramInt, Object paramObject)
/*      */   {
/*  787 */     String str = getMsgKey(paramInt);
/*  788 */     return findMessage(str, paramObject);
/*      */   }
/*      */ 
/*      */   static String findMessage(String paramString, Object paramObject)
/*      */   {
/*  805 */     String str = null;
/*  806 */     if (!loadedMessages)
/*      */     {
/*      */       try
/*      */       {
/*  810 */         message = (Message)Class.forName(msgClassName).newInstance();
/*  811 */         loadedMessages = true;
/*      */       }
/*      */       catch (ClassNotFoundException localClassNotFoundException)
/*      */       {
/*      */       }
/*      */       catch (IllegalAccessException localIllegalAccessException)
/*      */       {
/*      */       }
/*      */       catch (InstantiationException localInstantiationException)
/*      */       {
/*      */       }
/*      */       finally {
/*  818 */         if (loadedMessages);
/*      */       }
/*      */     }
/*  826 */     if (message == null)
/*      */     {
/*  828 */       if (paramObject == null)
/*      */       {
/*  830 */         str = paramString + ": (no message for error)";
/*      */       }
/*      */       else
/*      */       {
/*  834 */         str = paramString + ": (no message for error) " + paramObject;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  839 */       str = message.msg(paramString, paramObject);
/*      */     }
/*  841 */     return str;
/*      */   }
/*      */ 
/*      */   public static SQLWarning newSqlWarning(String paramString, int paramInt)
/*      */   {
/*  867 */     return addSqlWarning(null, paramString, paramInt);
/*      */   }
/*      */ 
/*      */   public static SQLWarning newSqlWarning(int paramInt, Object paramObject)
/*      */   {
/*  887 */     return addSqlWarning(null, paramInt, paramObject);
/*      */   }
/*      */ 
/*      */   public static SQLWarning newSqlWarning(int paramInt)
/*      */   {
/*  901 */     return addSqlWarning(null, paramInt);
/*      */   }
/*      */ 
/*      */   public static SQLWarning addSqlWarning(SQLWarning paramSQLWarning, String paramString, int paramInt)
/*      */   {
/*  922 */     String str = ErrorToSQLState(paramInt);
/*  923 */     SQLWarning localSQLWarning = new SQLWarning(paramString, str, paramInt);
/*      */ 
/*  928 */     return addSqlWarning(paramSQLWarning, localSQLWarning);
/*      */   }
/*      */ 
/*      */   public static SQLWarning addSqlWarning(SQLWarning paramSQLWarning1, SQLWarning paramSQLWarning2)
/*      */   {
/*  939 */     if (paramSQLWarning1 == null)
/*  940 */       return paramSQLWarning2;
/*  941 */     paramSQLWarning1.setNextWarning(paramSQLWarning2);
/*      */ 
/*  943 */     return paramSQLWarning1;
/*      */   }
/*      */ 
/*      */   public static SQLWarning addSqlWarning(SQLWarning paramSQLWarning, int paramInt, Object paramObject)
/*      */   {
/*  963 */     if ((paramInt == 0) || (paramInt == 13))
/*      */     {
/*  965 */       return paramSQLWarning;
/*      */     }
/*      */ 
/*  968 */     String str = findMessage(paramInt, paramObject);
/*  969 */     int i = getVendorCode(paramInt);
/*      */ 
/*  971 */     return addSqlWarning(paramSQLWarning, "Warning: " + str, i);
/*      */   }
/*      */ 
/*      */   public static SQLWarning addSqlWarning(SQLWarning paramSQLWarning, int paramInt)
/*      */   {
/*  986 */     return addSqlWarning(paramSQLWarning, paramInt, null);
/*      */   }
/*      */ 
/*      */   public static String ErrorToSQLState(int paramInt)
/*      */   {
/* 1002 */     return findSQLStateMapping(paramInt).sqlState;
/*      */   }
/*      */ 
/*      */   static SQLStateMapping findSQLStateMapping(int paramInt)
/*      */   {
/* 1008 */     for (int i = 0; i < mappings.length; i++)
/* 1009 */       if (mappings[i].isIncluded(paramInt))
/* 1010 */         return mappings[i];
/* 1011 */     return DEFAULT_SQLSTATE;
/*      */   }
/*      */ 
/*      */   public static int getVendorCode(int paramInt)
/*      */   {
/* 1033 */     if (paramInt >= 500);
/* 1037 */     return 17000 + paramInt;
/*      */   }
/*      */ 
/*      */   static String getMsgKey(int paramInt)
/*      */   {
/* 1052 */     int i = getVendorCode(paramInt);
/* 1053 */     String str = "ORA-" + Integer.toString(i);
/* 1054 */     return str;
/*      */   }
/*      */ 
/*      */   public static void test()
/*      */   {
/*      */     try
/*      */     {
/* 1535 */       throw createSqlException(null, "exception_message_1", 25);
/*      */     }
/*      */     catch (SQLException localSQLException1)
/*      */     {
/* 1539 */       printSqlException(localSQLException1);
/*      */       try
/*      */       {
/* 1544 */         throw createSqlException(null, 412, "object_string");
/*      */       }
/*      */       catch (SQLException localSQLException2)
/*      */       {
/* 1548 */         printSqlException(localSQLException2);
/*      */         try
/*      */         {
/* 1553 */           throw createSqlException(null, 6);
/*      */         }
/*      */         catch (SQLException localSQLException3)
/*      */         {
/* 1557 */           printSqlException(localSQLException3);
/*      */           try
/*      */           {
/* 1562 */             throw createSqlException(null, 999);
/*      */           }
/*      */           catch (SQLException localSQLException4)
/*      */           {
/* 1566 */             printSqlException(localSQLException4);
/*      */             try
/*      */             {
/* 1571 */               throw createSqlException(null, 13);
/*      */             }
/*      */             catch (SQLException localSQLException5)
/*      */             {
/* 1575 */               printSqlException(localSQLException5);
/*      */               try
/*      */               {
/* 1580 */                 IOException localIOException1 = new IOException("ORA-00601: cleanup lock conflict");
/*      */ 
/* 1582 */                 throw createSqlException(null, localIOException1);
/*      */               }
/*      */               catch (SQLException localSQLException6)
/*      */               {
/* 1586 */                 printSqlException(localSQLException6);
/*      */                 try
/*      */                 {
/* 1591 */                   IOException localIOException2 = new IOException("some unknown io exception");
/*      */ 
/* 1593 */                   throw createSqlException(null, localIOException2);
/*      */                 }
/*      */                 catch (SQLException localSQLException7)
/*      */                 {
/* 1597 */                   printSqlException(localSQLException7);
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public static void printSqlException(SQLException paramSQLException)
/*      */   {
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.DatabaseError
 * JD-Core Version:    0.6.2
 */