/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.sql.SQLException;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.util.RepConversion;
/*      */ import oracle.sql.CharacterSet;
/*      */ import oracle.sql.converter.CharacterSetMetaData;
/*      */ 
/*      */ public class DBConversion
/*      */ {
/*      */   public static final boolean DO_CONVERSION_WITH_REPLACEMENT = true;
/*      */   public static final short ORACLE8_PROD_VERSION = 8030;
/*      */   protected short serverNCharSetId;
/*      */   protected short serverCharSetId;
/*      */   protected short clientCharSetId;
/*      */   protected CharacterSet serverCharSet;
/*      */   protected CharacterSet serverNCharSet;
/*      */   protected CharacterSet clientCharSet;
/*      */   protected CharacterSet asciiCharSet;
/*      */   protected boolean isServerCharSetFixedWidth;
/*      */   protected boolean isServerNCharSetFixedWidth;
/*      */   protected int c2sNlsRatio;
/*      */   protected int s2cNlsRatio;
/*      */   protected int sMaxCharSize;
/*      */   protected int cMaxCharSize;
/*      */   protected int maxNCharSize;
/*      */   protected boolean isServerCSMultiByte;
/*      */   private boolean isStrictASCIIConversion;
/*      */   public static final short DBCS_CHARSET = -1;
/*      */   public static final short UCS2_CHARSET = -5;
/*      */   public static final short ASCII_CHARSET = 1;
/*      */   public static final short ISO_LATIN_1_CHARSET = 31;
/*      */   public static final short AL24UTFFSS_CHARSET = 870;
/*      */   public static final short UTF8_CHARSET = 871;
/*      */   public static final short AL32UTF8_CHARSET = 873;
/*      */   public static final short AL16UTF16_CHARSET = 2000;
/* 2249 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public DBConversion(short paramShort1, short paramShort2, short paramShort3, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  115 */     this.isStrictASCIIConversion = paramBoolean;
/*  116 */     if (paramShort2 != -1)
/*      */     {
/*  118 */       init(paramShort1, paramShort2, paramShort3);
/*      */     }
/*      */   }
/*      */ 
/*      */   public DBConversion(short paramShort1, short paramShort2, short paramShort3)
/*      */     throws SQLException
/*      */   {
/*  127 */     this(paramShort1, paramShort2, paramShort3, false);
/*      */   }
/*      */ 
/*      */   void init(short paramShort1, short paramShort2, short paramShort3)
/*      */     throws SQLException
/*      */   {
/*  138 */     switch (paramShort2)
/*      */     {
/*      */     case -5:
/*      */     case 1:
/*      */     case 2:
/*      */     case 31:
/*      */     case 178:
/*      */     case 870:
/*      */     case 871:
/*      */     case 873:
/*  157 */       break;
/*      */     default:
/*  160 */       unexpectedCharset(paramShort2);
/*      */     }
/*      */ 
/*  165 */     this.serverCharSetId = paramShort1;
/*  166 */     this.clientCharSetId = paramShort2;
/*  167 */     this.serverCharSet = CharacterSet.make(this.serverCharSetId);
/*      */ 
/*  169 */     this.serverNCharSetId = paramShort3;
/*  170 */     this.serverNCharSet = CharacterSet.make(this.serverNCharSetId);
/*      */ 
/*  172 */     this.clientCharSet = CharacterSet.make(this.clientCharSetId);
/*      */ 
/*  174 */     this.c2sNlsRatio = CharacterSetMetaData.getRatio(paramShort1, paramShort2);
/*  175 */     this.s2cNlsRatio = CharacterSetMetaData.getRatio(paramShort2, paramShort1);
/*  176 */     this.sMaxCharSize = CharacterSetMetaData.getRatio(paramShort1, 1);
/*  177 */     this.cMaxCharSize = CharacterSetMetaData.getRatio(paramShort2, 1);
/*  178 */     this.maxNCharSize = CharacterSetMetaData.getRatio(paramShort3, 1);
/*      */ 
/*  180 */     findFixedWidthInfo();
/*      */   }
/*      */ 
/*      */   void findFixedWidthInfo()
/*      */     throws SQLException
/*      */   {
/*  191 */     this.isServerCharSetFixedWidth = CharacterSetMetaData.isFixedWidth(this.serverCharSetId);
/*  192 */     this.isServerNCharSetFixedWidth = CharacterSetMetaData.isFixedWidth(this.serverNCharSetId);
/*  193 */     this.isServerCSMultiByte = (this.sMaxCharSize > 1);
/*      */   }
/*      */ 
/*      */   public short getServerCharSetId()
/*      */   {
/*  205 */     return this.serverCharSetId;
/*      */   }
/*      */ 
/*      */   public short getNCharSetId()
/*      */   {
/*  217 */     return this.serverNCharSetId;
/*      */   }
/*      */ 
/*      */   public boolean IsNCharFixedWith()
/*      */   {
/*  226 */     return this.serverNCharSetId == 2000;
/*      */   }
/*      */ 
/*      */   public short getClientCharSet()
/*      */   {
/*  241 */     if (this.clientCharSetId == -1) {
/*  242 */       return this.serverCharSetId;
/*      */     }
/*  244 */     return this.clientCharSetId;
/*      */   }
/*      */ 
/*      */   public CharacterSet getDbCharSetObj()
/*      */   {
/*  258 */     return this.serverCharSet;
/*      */   }
/*      */ 
/*      */   public CharacterSet getDriverCharSetObj()
/*      */   {
/*  273 */     return this.clientCharSet;
/*      */   }
/*      */ 
/*      */   public CharacterSet getDriverNCharSetObj()
/*      */   {
/*  281 */     return this.serverNCharSet;
/*      */   }
/*      */ 
/*      */   CharacterSet getCharacterSet(short paramShort)
/*      */   {
/*  292 */     if (paramShort == 2) {
/*  293 */       return getDriverNCharSetObj();
/*      */     }
/*  295 */     return getDriverCharSetObj();
/*      */   }
/*      */ 
/*      */   public static final short findDriverCharSet(short paramShort1, short paramShort2)
/*      */   {
/*  358 */     short s = 0;
/*      */ 
/*  360 */     switch (paramShort1)
/*      */     {
/*      */     case 1:
/*      */     case 2:
/*      */     case 31:
/*      */     case 178:
/*      */     case 873:
/*  374 */       s = paramShort1;
/*      */ 
/*  376 */       break;
/*      */     default:
/*  379 */       s = paramShort2 >= 8030 ? 871 : 870;
/*      */     }
/*      */ 
/*  385 */     return s;
/*      */   }
/*      */ 
/*      */   public static final byte[] stringToDriverCharBytes(String paramString, short paramShort)
/*      */     throws SQLException
/*      */   {
/*  420 */     if (paramString == null)
/*      */     {
/*  422 */       return null;
/*      */     }
/*      */ 
/*  425 */     byte[] arrayOfByte = null;
/*      */ 
/*  427 */     switch (paramShort)
/*      */     {
/*      */     case -5:
/*      */     case 2000:
/*  433 */       arrayOfByte = CharacterSet.stringToAL16UTF16Bytes(paramString);
/*      */ 
/*  436 */       break;
/*      */     case 1:
/*      */     case 2:
/*  443 */       arrayOfByte = CharacterSet.stringToASCII(paramString);
/*      */ 
/*  446 */       break;
/*      */     case 870:
/*      */     case 871:
/*  451 */       arrayOfByte = CharacterSet.stringToUTF(paramString);
/*      */ 
/*  454 */       break;
/*      */     case 873:
/*  457 */       arrayOfByte = CharacterSet.stringToAL32UTF8(paramString);
/*      */ 
/*  460 */       break;
/*      */     case -1:
/*      */     default:
/*  466 */       unexpectedCharset(paramShort);
/*      */     }
/*      */ 
/*  471 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public byte[] StringToCharBytes(String paramString)
/*      */     throws SQLException
/*      */   {
/*  493 */     if (paramString.length() == 0) {
/*  494 */       return null;
/*      */     }
/*  496 */     switch (this.clientCharSetId)
/*      */     {
/*      */     case -1:
/*  500 */       return this.serverCharSet.convertWithReplacement(paramString);
/*      */     case 2:
/*      */     case 31:
/*      */     case 178:
/*  505 */       return this.clientCharSet.convertWithReplacement(paramString);
/*      */     }
/*      */ 
/*  513 */     return stringToDriverCharBytes(paramString, this.clientCharSetId);
/*      */   }
/*      */ 
/*      */   public String CharBytesToString(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  563 */     return CharBytesToString(paramArrayOfByte, paramInt, true);
/*      */   }
/*      */ 
/*      */   public String CharBytesToString(byte[] paramArrayOfByte, int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  572 */     String str = null;
/*  573 */     if (paramArrayOfByte.length == 0) {
/*  574 */       return str;
/*      */     }
/*  576 */     switch (this.clientCharSetId)
/*      */     {
/*      */     case -5:
/*  580 */       str = CharacterSet.AL16UTF16BytesToString(paramArrayOfByte, paramInt);
/*      */ 
/*  583 */       break;
/*      */     case 1:
/*  587 */       str = new String(paramArrayOfByte, 0, 0, paramInt);
/*      */ 
/*  589 */       break;
/*      */     case 2:
/*      */     case 31:
/*      */     case 178:
/*  597 */       if (paramBoolean)
/*  598 */         str = this.clientCharSet.toStringWithReplacement(paramArrayOfByte, 0, paramInt);
/*      */       else {
/*  600 */         str = this.clientCharSet.toString(paramArrayOfByte, 0, paramInt);
/*      */       }
/*  602 */       break;
/*      */     case 870:
/*      */     case 871:
/*  607 */       str = CharacterSet.UTFToString(paramArrayOfByte, 0, paramInt, paramBoolean);
/*      */ 
/*  610 */       break;
/*      */     case 873:
/*  616 */       str = CharacterSet.AL32UTF8ToString(paramArrayOfByte, 0, paramInt, paramBoolean);
/*      */ 
/*  618 */       break;
/*      */     case -1:
/*  621 */       str = this.serverCharSet.toStringWithReplacement(paramArrayOfByte, 0, paramInt);
/*      */ 
/*  623 */       break;
/*      */     default:
/*  626 */       unexpectedCharset(this.clientCharSetId);
/*      */     }
/*      */ 
/*  631 */     return str;
/*      */   }
/*      */ 
/*      */   public String NCharBytesToString(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  639 */     String str = null;
/*      */ 
/*  641 */     if (this.clientCharSetId == -1)
/*      */     {
/*  645 */       str = this.serverNCharSet.toStringWithReplacement(paramArrayOfByte, 0, paramInt);
/*      */     }
/*      */     else
/*      */     {
/*  649 */       switch (this.serverNCharSetId)
/*      */       {
/*      */       case -5:
/*      */       case 2000:
/*  655 */         str = CharacterSet.AL16UTF16BytesToString(paramArrayOfByte, paramInt);
/*      */ 
/*  658 */         break;
/*      */       case 1:
/*      */       case 2:
/*  664 */         str = new String(paramArrayOfByte, 0, 0, paramInt);
/*      */ 
/*  666 */         break;
/*      */       case 31:
/*      */       case 178:
/*  672 */         str = this.serverNCharSet.toStringWithReplacement(paramArrayOfByte, 0, paramInt);
/*  673 */         break;
/*      */       case 870:
/*      */       case 871:
/*  678 */         str = CharacterSet.UTFToString(paramArrayOfByte, 0, paramInt);
/*      */ 
/*  681 */         break;
/*      */       case 873:
/*  687 */         str = CharacterSet.AL32UTF8ToString(paramArrayOfByte, 0, paramInt);
/*      */ 
/*  689 */         break;
/*      */       case -1:
/*  692 */         str = this.serverCharSet.toStringWithReplacement(paramArrayOfByte, 0, paramInt);
/*      */ 
/*  694 */         break;
/*      */       default:
/*  697 */         unexpectedCharset(this.clientCharSetId);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  703 */     return str;
/*      */   }
/*      */ 
/*      */   public int javaCharsToCHARBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  730 */     return javaCharsToCHARBytes(paramArrayOfChar, paramInt, paramArrayOfByte, this.clientCharSetId);
/*      */   }
/*      */ 
/*      */   public int javaCharsToCHARBytes(char[] paramArrayOfChar, int paramInt1, byte[] paramArrayOfByte, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/*  740 */     return javaCharsToCHARBytes(paramArrayOfChar, paramInt1, paramArrayOfByte, paramInt2, this.clientCharSetId, paramInt3);
/*      */   }
/*      */ 
/*      */   public int javaCharsToNCHARBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  750 */     return javaCharsToCHARBytes(paramArrayOfChar, paramInt, paramArrayOfByte, this.serverNCharSetId);
/*      */   }
/*      */ 
/*      */   public int javaCharsToNCHARBytes(char[] paramArrayOfChar, int paramInt1, byte[] paramArrayOfByte, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/*  760 */     return javaCharsToCHARBytes(paramArrayOfChar, paramInt1, paramArrayOfByte, paramInt2, this.serverNCharSetId, paramInt3);
/*      */   }
/*      */ 
/*      */   protected int javaCharsToCHARBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte, short paramShort)
/*      */     throws SQLException
/*      */   {
/*  770 */     return javaCharsToCHARBytes(paramArrayOfChar, 0, paramArrayOfByte, 0, paramShort, paramInt);
/*      */   }
/*      */ 
/*      */   protected int javaCharsToCHARBytes(char[] paramArrayOfChar, int paramInt1, byte[] paramArrayOfByte, int paramInt2, short paramShort, int paramInt3)
/*      */     throws SQLException
/*      */   {
/*  779 */     int i = 0;
/*      */ 
/*  781 */     switch (paramShort)
/*      */     {
/*      */     case -5:
/*      */     case 2000:
/*  789 */       i = CharacterSet.convertJavaCharsToAL16UTF16Bytes(paramArrayOfChar, paramInt1, paramArrayOfByte, paramInt2, paramInt3);
/*      */ 
/*  792 */       break;
/*      */     case 2:
/*      */     case 178:
/*  798 */       byte[] arrayOfByte = this.clientCharSet.convertWithReplacement(new String(paramArrayOfChar, paramInt1, paramInt3));
/*  799 */       System.arraycopy(arrayOfByte, 0, paramArrayOfByte, 0, arrayOfByte.length);
/*      */ 
/*  801 */       i = arrayOfByte.length;
/*      */ 
/*  803 */       break;
/*      */     case 1:
/*  807 */       i = CharacterSet.convertJavaCharsToASCIIBytes(paramArrayOfChar, paramInt1, paramArrayOfByte, paramInt2, paramInt3, this.isStrictASCIIConversion);
/*      */ 
/*  810 */       break;
/*      */     case 31:
/*  813 */       i = CharacterSet.convertJavaCharsToISOLATIN1Bytes(paramArrayOfChar, paramInt1, paramArrayOfByte, paramInt2, paramInt3);
/*      */ 
/*  816 */       break;
/*      */     case 870:
/*      */     case 871:
/*  823 */       i = CharacterSet.convertJavaCharsToUTFBytes(paramArrayOfChar, paramInt1, paramArrayOfByte, paramInt2, paramInt3);
/*      */ 
/*  826 */       break;
/*      */     case 873:
/*  832 */       i = CharacterSet.convertJavaCharsToAL32UTF8Bytes(paramArrayOfChar, paramInt1, paramArrayOfByte, paramInt2, paramInt3);
/*      */ 
/*  835 */       break;
/*      */     case -1:
/*  838 */       i = javaCharsToDbCsBytes(paramArrayOfChar, paramInt1, paramArrayOfByte, paramInt2, paramInt3);
/*      */ 
/*  840 */       break;
/*      */     default:
/*  843 */       unexpectedCharset(this.clientCharSetId);
/*      */     }
/*      */ 
/*  848 */     return i;
/*      */   }
/*      */ 
/*      */   public int CHARBytesToJavaChars(byte[] paramArrayOfByte, int paramInt1, char[] paramArrayOfChar, int paramInt2, int[] paramArrayOfInt, int paramInt3, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  879 */     if (paramBoolean) {
/*  880 */       return NCHARBytesToJavaChars(paramArrayOfByte, paramInt1, paramArrayOfChar, paramInt2, paramArrayOfInt, paramInt3);
/*      */     }
/*  882 */     return CHARBytesToJavaChars(paramArrayOfByte, paramInt1, paramArrayOfChar, paramInt2, paramArrayOfInt, paramInt3);
/*      */   }
/*      */ 
/*      */   public int CHARBytesToJavaChars(byte[] paramArrayOfByte, int paramInt1, char[] paramArrayOfChar, int paramInt2, int[] paramArrayOfInt, int paramInt3)
/*      */     throws SQLException
/*      */   {
/*  913 */     return _CHARBytesToJavaChars(paramArrayOfByte, paramInt1, paramArrayOfChar, paramInt2, this.clientCharSetId, paramArrayOfInt, paramInt3, this.serverCharSet, this.serverNCharSet, this.clientCharSet, false);
/*      */   }
/*      */ 
/*      */   public int NCHARBytesToJavaChars(byte[] paramArrayOfByte, int paramInt1, char[] paramArrayOfChar, int paramInt2, int[] paramArrayOfInt, int paramInt3)
/*      */     throws SQLException
/*      */   {
/*  931 */     return _CHARBytesToJavaChars(paramArrayOfByte, paramInt1, paramArrayOfChar, paramInt2, this.serverNCharSetId, paramArrayOfInt, paramInt3, this.serverCharSet, this.serverNCharSet, this.clientCharSet, true);
/*      */   }
/*      */ 
/*      */   static final int _CHARBytesToJavaChars(byte[] paramArrayOfByte, int paramInt1, char[] paramArrayOfChar, int paramInt2, short paramShort, int[] paramArrayOfInt, int paramInt3, CharacterSet paramCharacterSet1, CharacterSet paramCharacterSet2, CharacterSet paramCharacterSet3, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  958 */     int i = 0;
/*  959 */     int j = 0;
/*      */ 
/*  961 */     switch (paramShort)
/*      */     {
/*      */     case -5:
/*      */     case 2000:
/*  967 */       j = paramArrayOfInt[0] - paramArrayOfInt[0] % 2;
/*      */ 
/*  970 */       if (paramInt3 > paramArrayOfChar.length - paramInt2) {
/*  971 */         paramInt3 = paramArrayOfChar.length - paramInt2;
/*      */       }
/*      */ 
/*  975 */       if (paramInt3 * 2 < j) {
/*  976 */         j = paramInt3 * 2;
/*      */       }
/*  978 */       i = CharacterSet.convertAL16UTF16BytesToJavaChars(paramArrayOfByte, paramInt1, paramArrayOfChar, paramInt2, j, true);
/*      */ 
/*  982 */       paramArrayOfInt[0] -= j;
/*      */ 
/*  984 */       break;
/*      */     case 1:
/*  988 */       j = paramArrayOfInt[0];
/*      */ 
/*  991 */       if (paramInt3 > paramArrayOfChar.length - paramInt2) {
/*  992 */         paramInt3 = paramArrayOfChar.length - paramInt2;
/*      */       }
/*      */ 
/*  996 */       if (paramInt3 < j) {
/*  997 */         j = paramInt3;
/*      */       }
/*  999 */       i = CharacterSet.convertASCIIBytesToJavaChars(paramArrayOfByte, paramInt1, paramArrayOfChar, paramInt2, j);
/*      */ 
/* 1001 */       paramArrayOfInt[0] -= j;
/*      */ 
/* 1003 */       break;
/*      */     case 31:
/*      */     case 178:
/* 1008 */       j = paramArrayOfInt[0];
/*      */ 
/* 1010 */       i = paramCharacterSet1.toCharWithReplacement(paramArrayOfByte, paramInt1, paramArrayOfChar, paramInt2, j);
/* 1011 */       paramArrayOfInt[0] -= i;
/*      */ 
/* 1013 */       break;
/*      */     case 870:
/*      */     case 871:
/* 1020 */       if (paramInt3 > paramArrayOfChar.length - paramInt2) {
/* 1021 */         paramInt3 = paramArrayOfChar.length - paramInt2;
/*      */       }
/* 1023 */       i = CharacterSet.convertUTFBytesToJavaChars(paramArrayOfByte, paramInt1, paramArrayOfChar, paramInt2, paramArrayOfInt, true, paramInt3);
/*      */ 
/* 1027 */       break;
/*      */     case 873:
/* 1032 */       if (paramInt3 > paramArrayOfChar.length - paramInt2) {
/* 1033 */         paramInt3 = paramArrayOfChar.length - paramInt2;
/*      */       }
/* 1035 */       i = CharacterSet.convertAL32UTF8BytesToJavaChars(paramArrayOfByte, paramInt1, paramArrayOfChar, paramInt2, paramArrayOfInt, true, paramInt3);
/*      */ 
/* 1039 */       break;
/*      */     case -1:
/* 1056 */       unexpectedCharset((short)-1);
/* 1057 */       break;
/*      */     default:
/* 1062 */       CharacterSet localCharacterSet = paramCharacterSet3;
/*      */ 
/* 1064 */       if (paramBoolean) {
/* 1065 */         localCharacterSet = paramCharacterSet2;
/*      */       }
/* 1067 */       String str = localCharacterSet.toStringWithReplacement(paramArrayOfByte, paramInt1, paramArrayOfInt[0]);
/* 1068 */       char[] arrayOfChar = str.toCharArray();
/* 1069 */       int k = arrayOfChar.length;
/*      */ 
/* 1071 */       if (k > paramInt3) {
/* 1072 */         k = paramInt3;
/*      */       }
/* 1074 */       i = k;
/* 1075 */       paramArrayOfInt[0] -= k;
/*      */ 
/* 1077 */       System.arraycopy(arrayOfChar, 0, paramArrayOfChar, paramInt2, k);
/*      */     }
/*      */ 
/* 1082 */     return i;
/*      */   }
/*      */ 
/*      */   public byte[] asciiBytesToCHARBytes(byte[] paramArrayOfByte)
/*      */   {
/* 1104 */     byte[] arrayOfByte = null;
/*      */     int i;
/*      */     int j;
/* 1114 */     switch (this.clientCharSetId)
/*      */     {
/*      */     case -5:
/* 1118 */       arrayOfByte = new byte[paramArrayOfByte.length * 2];
/*      */ 
/* 1120 */       i = 0; for (j = 0; i < paramArrayOfByte.length; )
/*      */       {
/* 1122 */         arrayOfByte[(j++)] = 0;
/* 1123 */         arrayOfByte[(j++)] = paramArrayOfByte[i];
/*      */ 
/* 1120 */         i++; continue;
/*      */ 
/* 1129 */         if (this.asciiCharSet == null) {
/* 1130 */           this.asciiCharSet = CharacterSet.make(1);
/*      */         }
/*      */         try
/*      */         {
/* 1134 */           arrayOfByte = this.serverCharSet.convert(this.asciiCharSet, paramArrayOfByte, 0, paramArrayOfByte.length);
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*      */         }
/*      */ 
/* 1144 */         arrayOfByte = paramArrayOfByte;
/*      */       }
/*      */     case -1:
/*      */     }
/*      */ 
/* 1149 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public int javaCharsToDbCsBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1186 */     int i = javaCharsToDbCsBytes(paramArrayOfChar, 0, paramArrayOfByte, 0, paramInt);
/*      */ 
/* 1188 */     return i;
/*      */   }
/*      */ 
/*      */   public int javaCharsToDbCsBytes(char[] paramArrayOfChar, int paramInt1, byte[] paramArrayOfByte, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 1225 */     int i = 0;
/*      */ 
/* 1228 */     catchCharsLen(paramArrayOfChar, paramInt1, paramInt3);
/*      */ 
/* 1230 */     String str = new String(paramArrayOfChar, paramInt1, paramInt3);
/* 1231 */     byte[] arrayOfByte = this.serverCharSet.convertWithReplacement(str);
/*      */ 
/* 1233 */     str = null;
/*      */ 
/* 1235 */     if (arrayOfByte != null)
/*      */     {
/* 1241 */       i = arrayOfByte.length;
/*      */ 
/* 1243 */       catchBytesLen(paramArrayOfByte, paramInt2, i);
/* 1244 */       System.arraycopy(arrayOfByte, 0, paramArrayOfByte, paramInt2, i);
/*      */ 
/* 1246 */       arrayOfByte = null;
/*      */     }
/*      */ 
/* 1249 */     return i;
/*      */   }
/*      */ 
/*      */   public static final int javaCharsToUcs2Bytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1282 */     int i = javaCharsToUcs2Bytes(paramArrayOfChar, 0, paramArrayOfByte, 0, paramInt);
/*      */ 
/* 1284 */     return i;
/*      */   }
/*      */ 
/*      */   public static final int javaCharsToUcs2Bytes(char[] paramArrayOfChar, int paramInt1, byte[] paramArrayOfByte, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 1320 */     catchCharsLen(paramArrayOfChar, paramInt1, paramInt3);
/* 1321 */     catchBytesLen(paramArrayOfByte, paramInt2, paramInt3 * 2);
/*      */ 
/* 1323 */     int k = paramInt3 + paramInt1;
/*      */ 
/* 1325 */     int i = paramInt1; for (int j = paramInt2; i < k; i++)
/*      */     {
/* 1327 */       paramArrayOfByte[(j++)] = ((byte)(paramArrayOfChar[i] >> '\b' & 0xFF));
/* 1328 */       paramArrayOfByte[(j++)] = ((byte)(paramArrayOfChar[i] & 0xFF));
/*      */     }
/*      */ 
/* 1331 */     return j - paramInt2;
/*      */   }
/*      */ 
/*      */   public static final int ucs2BytesToJavaChars(byte[] paramArrayOfByte, int paramInt, char[] paramArrayOfChar)
/*      */     throws SQLException
/*      */   {
/* 1381 */     return CharacterSet.AL16UTF16BytesToJavaChars(paramArrayOfByte, paramInt, paramArrayOfChar);
/*      */   }
/*      */ 
/*      */   public static final byte[] stringToAsciiBytes(String paramString)
/*      */   {
/* 1403 */     return CharacterSet.stringToASCII(paramString);
/*      */   }
/*      */ 
/*      */   public static final int asciiBytesToJavaChars(byte[] paramArrayOfByte, int paramInt, char[] paramArrayOfChar)
/*      */     throws SQLException
/*      */   {
/* 1430 */     return CharacterSet.convertASCIIBytesToJavaChars(paramArrayOfByte, 0, paramArrayOfChar, 0, paramInt);
/*      */   }
/*      */ 
/*      */   public static final int javaCharsToAsciiBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1458 */     return CharacterSet.convertJavaCharsToASCIIBytes(paramArrayOfChar, 0, paramArrayOfByte, 0, paramInt);
/*      */   }
/*      */ 
/*      */   public static final boolean isCharSetMultibyte(short paramShort)
/*      */   {
/* 1637 */     switch (paramShort)
/*      */     {
/*      */     case 1:
/*      */     case 31:
/* 1643 */       return false;
/*      */     case -5:
/*      */     case -1:
/*      */     case 870:
/*      */     case 871:
/*      */     case 873:
/* 1654 */       return true;
/*      */     }
/*      */ 
/* 1657 */     return false;
/*      */   }
/*      */ 
/*      */   public int getMaxCharbyteSize()
/*      */   {
/* 1695 */     return _getMaxCharbyteSize(this.clientCharSetId);
/*      */   }
/*      */ 
/*      */   public int getMaxNCharbyteSize()
/*      */   {
/* 1703 */     return _getMaxCharbyteSize(this.serverNCharSetId);
/*      */   }
/*      */ 
/*      */   public int _getMaxCharbyteSize(short paramShort)
/*      */   {
/* 1711 */     switch (paramShort)
/*      */     {
/*      */     case 1:
/* 1715 */       return 1;
/*      */     case 31:
/* 1718 */       return 1;
/*      */     case 870:
/*      */     case 871:
/* 1723 */       return 3;
/*      */     case -5:
/*      */     case 2000:
/* 1728 */       return 2;
/*      */     case -1:
/* 1731 */       return 4;
/*      */     case 873:
/* 1734 */       return 4;
/*      */     }
/*      */ 
/* 1737 */     return 1;
/*      */   }
/*      */ 
/*      */   public boolean isUcs2CharSet()
/*      */   {
/* 1748 */     return this.clientCharSetId == -5;
/*      */   }
/*      */ 
/*      */   public static final int RAWBytesToHexChars(byte[] paramArrayOfByte, int paramInt, char[] paramArrayOfChar)
/*      */   {
/* 1760 */     int i = 0; for (int j = 0; i < paramInt; i++)
/*      */     {
/* 1762 */       paramArrayOfChar[(j++)] = ((char)RepConversion.nibbleToHex((byte)(paramArrayOfByte[i] >> 4 & 0xF)));
/*      */ 
/* 1765 */       paramArrayOfChar[(j++)] = ((char)RepConversion.nibbleToHex((byte)(paramArrayOfByte[i] & 0xF)));
/*      */     }
/*      */ 
/* 1769 */     return j;
/*      */   }
/*      */ 
/*      */   public final int hexDigit2Nibble(char paramChar)
/*      */     throws SQLException
/*      */   {
/* 1785 */     int i = Character.digit(paramChar, 16);
/*      */ 
/* 1787 */     if (i == -1)
/*      */     {
/* 1790 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, "Invalid hex digit: " + paramChar);
/* 1791 */       localSQLException.fillInStackTrace();
/* 1792 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1796 */     return i;
/*      */   }
/*      */ 
/*      */   public final byte[] hexString2Bytes(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1812 */     int i = paramString.length();
/* 1813 */     char[] arrayOfChar = new char[i];
/*      */ 
/* 1815 */     paramString.getChars(0, i, arrayOfChar, 0);
/* 1816 */     return hexChars2Bytes(arrayOfChar, 0, i);
/*      */   }
/*      */ 
/*      */   public final byte[] hexChars2Bytes(char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1824 */     int i = 0;
/* 1825 */     int j = paramInt1;
/*      */ 
/* 1827 */     if (paramInt2 == 0)
/* 1828 */       return new byte[0];
/*      */     byte[] arrayOfByte;
/* 1830 */     if (paramInt2 % 2 > 0)
/*      */     {
/* 1832 */       arrayOfByte = new byte[(paramInt2 + 1) / 2];
/* 1833 */       arrayOfByte[(i++)] = ((byte)hexDigit2Nibble(paramArrayOfChar[(j++)]));
/*      */     }
/*      */     else
/*      */     {
/* 1837 */       arrayOfByte = new byte[paramInt2 / 2];
/*      */     }
/*      */ 
/* 1840 */     for (; i < arrayOfByte.length; i++)
/*      */     {
/* 1842 */       arrayOfByte[i] = ((byte)(hexDigit2Nibble(paramArrayOfChar[(j++)]) << 4 | hexDigit2Nibble(paramArrayOfChar[(j++)])));
/*      */     }
/*      */ 
/* 1845 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public InputStream ConvertStream(InputStream paramInputStream, int paramInt)
/*      */   {
/* 1854 */     return new OracleConversionInputStream(this, paramInputStream, paramInt);
/*      */   }
/*      */ 
/*      */   public InputStream ConvertStream(InputStream paramInputStream, int paramInt1, int paramInt2)
/*      */   {
/* 1863 */     return new OracleConversionInputStream(this, paramInputStream, paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   public InputStream ConvertStreamInternal(InputStream paramInputStream, int paramInt1, int paramInt2)
/*      */   {
/* 1872 */     return new OracleConversionInputStreamInternal(this, paramInputStream, paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   public InputStream ConvertStream(Reader paramReader, int paramInt1, int paramInt2, short paramShort)
/*      */   {
/* 1894 */     OracleConversionInputStream localOracleConversionInputStream = new OracleConversionInputStream(this, paramReader, paramInt1, paramInt2, paramShort);
/*      */ 
/* 1897 */     return localOracleConversionInputStream;
/*      */   }
/*      */ 
/*      */   public InputStream ConvertStreamInternal(Reader paramReader, int paramInt1, int paramInt2, short paramShort)
/*      */   {
/* 1906 */     OracleConversionInputStreamInternal localOracleConversionInputStreamInternal = new OracleConversionInputStreamInternal(this, paramReader, paramInt1, paramInt2, paramShort);
/*      */ 
/* 1909 */     return localOracleConversionInputStreamInternal;
/*      */   }
/*      */ 
/*      */   public Reader ConvertCharacterStream(InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1919 */     return new OracleConversionReader(this, paramInputStream, paramInt);
/*      */   }
/*      */ 
/*      */   public Reader ConvertCharacterStream(InputStream paramInputStream, int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 1928 */     OracleConversionReader localOracleConversionReader = new OracleConversionReader(this, paramInputStream, paramInt);
/*      */ 
/* 1931 */     localOracleConversionReader.setFormOfUse(paramShort);
/*      */ 
/* 1933 */     return localOracleConversionReader;
/*      */   }
/*      */ 
/*      */   public InputStream CharsToStream(char[] paramArrayOfChar, int paramInt1, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 1942 */     if (paramInt3 == 10) {
/* 1943 */       return new AsciiStream(paramArrayOfChar, paramInt1, paramInt2);
/*      */     }
/* 1945 */     if (paramInt3 == 11) {
/* 1946 */       return new UnicodeStream(paramArrayOfChar, paramInt1, paramInt2);
/*      */     }
/*      */ 
/* 1949 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 39, "unknownConversion");
/* 1950 */     localSQLException.fillInStackTrace();
/* 1951 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   static final void unexpectedCharset(short paramShort)
/*      */     throws SQLException
/*      */   {
/* 2036 */     SQLException localSQLException = DatabaseError.createSqlException(null, 35, "DBConversion");
/* 2037 */     localSQLException.fillInStackTrace();
/* 2038 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   protected static final void catchBytesLen(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2069 */     if (paramInt1 + paramInt2 > paramArrayOfByte.length)
/*      */     {
/* 2072 */       SQLException localSQLException = DatabaseError.createSqlException(null, 39, "catchBytesLen");
/* 2073 */       localSQLException.fillInStackTrace();
/* 2074 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected static final void catchCharsLen(char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2105 */     if (paramInt1 + paramInt2 > paramArrayOfChar.length)
/*      */     {
/* 2108 */       SQLException localSQLException = DatabaseError.createSqlException(null, 39, "catchCharsLen");
/* 2109 */       localSQLException.fillInStackTrace();
/* 2110 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public static final int getUtfLen(char paramChar)
/*      */   {
/* 2127 */     int i = 0;
/*      */ 
/* 2129 */     if ((paramChar & 0xFF80) == 0)
/*      */     {
/* 2131 */       i = 1;
/*      */     }
/* 2133 */     else if ((paramChar & 0xF800) == 0)
/*      */     {
/* 2135 */       i = 2;
/*      */     }
/*      */     else
/*      */     {
/* 2139 */       i = 3;
/*      */     }
/*      */ 
/* 2142 */     return i;
/*      */   }
/*      */ 
/*      */   int encodedByteLength(String paramString, boolean paramBoolean)
/*      */   {
/* 2158 */     int i = 0;
/* 2159 */     if (paramString != null)
/*      */     {
/* 2161 */       i = paramString.length();
/* 2162 */       if (i != 0)
/*      */       {
/* 2164 */         if (paramBoolean)
/*      */         {
/* 2166 */           i = this.isServerNCharSetFixedWidth ? i * this.maxNCharSize : this.serverNCharSet.encodedByteLength(paramString);
/*      */         }
/*      */         else
/*      */         {
/* 2170 */           i = this.isServerCharSetFixedWidth ? i * this.sMaxCharSize : this.serverCharSet.encodedByteLength(paramString);
/*      */         }
/*      */       }
/*      */     }
/* 2174 */     return i;
/*      */   }
/*      */ 
/*      */   int encodedByteLength(char[] paramArrayOfChar, boolean paramBoolean)
/*      */   {
/* 2189 */     int i = 0;
/* 2190 */     if (paramArrayOfChar != null)
/*      */     {
/* 2192 */       i = paramArrayOfChar.length;
/* 2193 */       if (i != 0)
/*      */       {
/* 2195 */         if (paramBoolean)
/*      */         {
/* 2197 */           i = this.isServerNCharSetFixedWidth ? i * this.maxNCharSize : this.serverNCharSet.encodedByteLength(paramArrayOfChar);
/*      */         }
/*      */         else
/*      */         {
/* 2201 */           i = this.isServerCharSetFixedWidth ? i * this.sMaxCharSize : this.serverCharSet.encodedByteLength(paramArrayOfChar);
/*      */         }
/*      */       }
/*      */     }
/* 2205 */     return i;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 2220 */     return null;
/*      */   }
/*      */ 
/*      */   class UnicodeStream extends OracleBufferedStream
/*      */   {
/*      */     UnicodeStream(char[] paramInt1, int paramInt2, int arg4)
/*      */     {
/* 1996 */       super();
/* 1997 */       this.currentBufferSize = this.initialBufferSize;
/* 1998 */       this.resizableBuffer = new byte[this.currentBufferSize];
/*      */ 
/* 2000 */       int j = paramInt2; for (int k = 0; k < i; )
/*      */       {
/* 2002 */         int m = paramInt1[(j++)];
/*      */ 
/* 2004 */         this.resizableBuffer[(k++)] = ((byte)(m >> 8 & 0xFF));
/* 2005 */         this.resizableBuffer[(k++)] = ((byte)(m & 0xFF));
/*      */       }
/*      */ 
/* 2008 */       this.count = i;
/*      */     }
/*      */ 
/*      */     public boolean needBytes()
/*      */     {
/* 2013 */       return (!this.closed) && (this.pos < this.count);
/*      */     }
/*      */ 
/*      */     public boolean needBytes(int paramInt)
/*      */     {
/* 2018 */       return (!this.closed) && (this.pos < this.count);
/*      */     }
/*      */   }
/*      */ 
/*      */   class AsciiStream extends OracleBufferedStream
/*      */   {
/*      */     AsciiStream(char[] paramInt1, int paramInt2, int arg4)
/*      */     {
/* 1961 */       super();
/* 1962 */       this.currentBufferSize = this.initialBufferSize;
/* 1963 */       this.resizableBuffer = new byte[this.currentBufferSize];
/*      */ 
/* 1965 */       if ((DBConversion.this.serverCharSetId == 1) || (!DBConversion.this.isStrictASCIIConversion))
/*      */       {
/* 1967 */         int j = paramInt2; for (int k = 0; k < i; k++)
/* 1968 */           this.resizableBuffer[k] = ((byte)paramInt1[(j++)]);
/*      */       }
/*      */       else
/*      */       {
/* 1972 */         if (DBConversion.this.asciiCharSet == null)
/* 1973 */           DBConversion.this.asciiCharSet = CharacterSet.make(1);
/* 1974 */         this.resizableBuffer = DBConversion.this.asciiCharSet.convertWithReplacement(new String(paramInt1, paramInt2, i));
/*      */       }
/*      */ 
/* 1977 */       this.count = i;
/*      */     }
/*      */ 
/*      */     public boolean needBytes()
/*      */     {
/* 1982 */       return (!this.closed) && (this.pos < this.count);
/*      */     }
/*      */ 
/*      */     public boolean needBytes(int paramInt)
/*      */     {
/* 1987 */       return (!this.closed) && (this.pos < this.count);
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.DBConversion
 * JD-Core Version:    0.6.2
 */