/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.StringWriter;
/*     */ import java.sql.Clob;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.sql.CLOB;
/*     */ import oracle.sql.CharacterSet;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.NCLOB;
/*     */ 
/*     */ class ClobAccessor extends LobCommonAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 4000;
/*     */   int[] prefetchedDataCharset;
/*     */   int[] prefetchedDataFormOfUse;
/* 324 */   private CharacterSet cachedCharSet = null;
/*     */ 
/* 534 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   ClobAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  33 */     super(paramShort == 2 ? Representation.NCLOB : Representation.CLOB, paramOracleStatement, 4000, paramBoolean);
/*     */ 
/*  39 */     init(paramOracleStatement, 112, 112, paramShort, paramBoolean);
/*  40 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   ClobAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  48 */     super(paramShort == 2 ? Representation.NCLOB : Representation.CLOB, paramOracleStatement, 4000, false);
/*     */ 
/*  54 */     init(paramOracleStatement, 112, 112, paramShort, false);
/*  55 */     initForDescribe(112, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  57 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   void setCapacity(int paramInt)
/*     */   {
/*  62 */     super.setCapacity(paramInt);
/*  63 */     if (this.prefetchedDataCharset == null) {
/*  64 */       this.prefetchedDataCharset = new int[paramInt];
/*  65 */       this.prefetchedDataFormOfUse = new int[paramInt];
/*     */     }
/*  67 */     else if (paramInt > this.prefetchedDataCharset.length) {
/*  68 */       int[] arrayOfInt = new int[paramInt];
/*  69 */       System.arraycopy(this.prefetchedDataCharset, 0, arrayOfInt, 0, this.prefetchedDataCharset.length);
/*  70 */       this.prefetchedDataCharset = arrayOfInt;
/*  71 */       arrayOfInt = new int[paramInt];
/*  72 */       System.arraycopy(this.prefetchedDataFormOfUse, 0, arrayOfInt, 0, this.prefetchedDataFormOfUse.length);
/*  73 */       this.prefetchedDataFormOfUse = arrayOfInt;
/*     */     }
/*     */   }
/*     */ 
/*     */   Accessor copyForDefine(OracleStatement paramOracleStatement)
/*     */   {
/*  85 */     ClobAccessor localClobAccessor = (ClobAccessor)super.copyForDefine(paramOracleStatement);
/*  86 */     localClobAccessor.prefetchedDataCharset = null;
/*  87 */     localClobAccessor.prefetchedDataFormOfUse = null;
/*  88 */     return localClobAccessor;
/*     */   }
/*     */ 
/*     */   protected void copyFromInternal(Accessor paramAccessor, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 105 */     super.copyFromInternal(paramAccessor, paramInt1, paramInt2);
/*     */ 
/* 107 */     if (isPrefetched()) {
/* 108 */       ClobAccessor localClobAccessor = (ClobAccessor)paramAccessor;
/* 109 */       setPrefetchedDataCharset(paramInt2, localClobAccessor.getPrefetchedDataCharset(paramInt1));
/* 110 */       setPrefetchedDataFormOfUse(paramInt2, localClobAccessor.getPrefetchedDataFormOfUse(paramInt1));
/*     */     }
/*     */   }
/*     */ 
/*     */   void deleteRow(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 126 */     super.deleteRow(paramInt);
/*     */ 
/* 128 */     if (isPrefetched()) {
/* 129 */       delete(this.prefetchedDataCharset, paramInt);
/* 130 */       delete(this.prefetchedDataFormOfUse, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   final int getPrefetchedDataCharset(int paramInt)
/*     */   {
/* 137 */     return this.prefetchedDataCharset[paramInt];
/*     */   }
/*     */ 
/*     */   final void setPrefetchedDataCharset(int paramInt1, int paramInt2)
/*     */   {
/* 143 */     this.prefetchedDataCharset[paramInt1] = paramInt2;
/*     */   }
/*     */ 
/*     */   final int getPrefetchedDataFormOfUse(int paramInt)
/*     */   {
/* 149 */     return this.prefetchedDataFormOfUse[paramInt];
/*     */   }
/*     */ 
/*     */   final void setPrefetchedDataFormOfUse(int paramInt1, int paramInt2)
/*     */   {
/* 155 */     this.prefetchedDataFormOfUse[paramInt1] = paramInt2;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 175 */     return getCLOB(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 192 */     return getCLOB(paramInt);
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 214 */     return getCLOB(paramInt);
/*     */   }
/*     */ 
/*     */   protected void normalizeFormOfUse(byte[] paramArrayOfByte)
/*     */   {
/* 219 */     short s = CLOB.getFormOfUseFromLocator(paramArrayOfByte);
/*     */ 
/* 222 */     if (s != -1)
/* 223 */       this.formOfUse = s;
/*     */   }
/*     */ 
/*     */   private CLOB getCLOB_(int paramInt, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/*     */     Object localObject;
/* 240 */     if (this.formOfUse == 1)
/* 241 */       localObject = new CLOB(this.statement.connection, paramArrayOfByte, this.formOfUse);
/*     */     else {
/* 243 */       localObject = new NCLOB(this.statement.connection, paramArrayOfByte);
/*     */     }
/*     */ 
/* 246 */     if (isPrefetched()) {
/* 247 */       ((CLOB)localObject).setActivePrefetch(true);
/* 248 */       ((CLOB)localObject).setLength(getPrefetchedLength(paramInt));
/* 249 */       ((CLOB)localObject).setChunkSize(getPrefetchedChunkSize(paramInt));
/* 250 */       int[] arrayOfInt = new int[1];
/* 251 */       ((CLOB)localObject).setPrefetchedData(getPrefetchedCharData(paramInt, arrayOfInt), arrayOfInt[0]);
/*     */     }
/*     */ 
/* 255 */     return localObject;
/*     */   }
/*     */ 
/*     */   CLOB getCLOB(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 261 */     if (isNull(paramInt)) return null;
/*     */ 
/* 264 */     byte[] arrayOfByte = getBytesInternal(paramInt);
/* 265 */     normalizeFormOfUse(arrayOfByte);
/* 266 */     CLOB localCLOB = getCLOB_(paramInt, arrayOfByte);
/* 267 */     return localCLOB;
/*     */   }
/*     */ 
/*     */   NCLOB getNCLOB(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 275 */     if (isNull(paramInt)) return null;
/*     */ 
/* 277 */     byte[] arrayOfByte = getBytesInternal(paramInt);
/* 278 */     normalizeFormOfUse(arrayOfByte);
/* 279 */     if (this.formOfUse != 2)
/*     */     {
/* 281 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/* 282 */       localSQLException.fillInStackTrace();
/* 283 */       throw localSQLException;
/*     */     }
/*     */ 
/* 286 */     return (NCLOB)getCLOB_(paramInt, arrayOfByte);
/*     */   }
/*     */ 
/*     */   final char[] XgetPrefetchedCharData(int paramInt, int[] paramArrayOfInt) throws SQLException
/*     */   {
/* 291 */     if (getPrefetchLength() == -1) return null;
/*     */ 
/* 293 */     int i = -1;
/* 294 */     int j = getPrefetchedDataLength(paramInt);
/* 295 */     char[] arrayOfChar = new char[getPrefetchedDataLength(paramInt)];
/* 296 */     byte[] arrayOfByte = this.rowData.get(getPrefetchedDataOffset(paramInt), getPrefetchedDataLength(paramInt));
/*     */ 
/* 300 */     if (getPrefetchedDataCharset(paramInt) != 0) {
/* 301 */       if (getPrefetchedDataCharset(paramInt) == 2000) {
/* 302 */         i = CharacterSet.convertAL16UTF16BytesToJavaChars(arrayOfByte, 0, arrayOfChar, 0, j, true);
/*     */       }
/*     */       else
/* 305 */         i = CharacterSet.convertAL16UTF16LEBytesToJavaChars(arrayOfByte, 0, arrayOfChar, 0, j, true);
/*     */     }
/*     */     else
/*     */     {
/* 309 */       int[] arrayOfInt = { j };
/* 310 */       if (this.formOfUse == 1) {
/* 311 */         i = this.statement.connection.conversion.CHARBytesToJavaChars(arrayOfByte, 0, arrayOfChar, 0, arrayOfInt, arrayOfChar.length);
/*     */       }
/*     */       else {
/* 314 */         i = this.statement.connection.conversion.NCHARBytesToJavaChars(arrayOfByte, 0, arrayOfChar, 0, arrayOfInt, arrayOfChar.length);
/*     */       }
/*     */     }
/* 317 */     paramArrayOfInt[0] = i;
/* 318 */     return arrayOfChar;
/*     */   }
/*     */ 
/*     */   final char[] getPrefetchedCharData(int paramInt, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 328 */     if (getPrefetchLength() == -1) return null;
/* 329 */     if (getPrefetchedDataCharset(paramInt) == 0) {
/* 330 */       arrayOfChar = ((DynamicByteArray)this.rowData).getChars(getPrefetchedDataOffset(paramInt), getPrefetchedDataLength(paramInt), this.statement.connection.conversion.getCharacterSet((short)getPrefetchedDataFormOfUse(paramInt)), paramArrayOfInt);
/*     */ 
/* 334 */       return arrayOfChar;
/*     */     }
/*     */ 
/* 337 */     if ((this.cachedCharSet == null) || (this.cachedCharSet.getOracleId() != getPrefetchedDataCharset(paramInt)))
/*     */     {
/* 339 */       this.cachedCharSet = CharacterSet.make(getPrefetchedDataCharset(paramInt));
/*     */     }
/* 341 */     char[] arrayOfChar = ((DynamicByteArray)this.rowData).getChars(getPrefetchedDataOffset(paramInt), getPrefetchedDataLength(paramInt), this.cachedCharSet, paramArrayOfInt);
/*     */ 
/* 345 */     return arrayOfChar;
/*     */   }
/*     */ 
/*     */   InputStream getAsciiStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 363 */     CLOB localCLOB = getCLOB(paramInt);
/*     */ 
/* 365 */     if (localCLOB == null) {
/* 366 */       return null;
/*     */     }
/* 368 */     return localCLOB.getAsciiStream();
/*     */   }
/*     */ 
/*     */   Reader getCharacterStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 384 */     CLOB localCLOB = getCLOB(paramInt);
/*     */ 
/* 386 */     if (localCLOB == null) {
/* 387 */       return null;
/*     */     }
/* 389 */     return localCLOB.getCharacterStream();
/*     */   }
/*     */ 
/*     */   InputStream getBinaryStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 405 */     CLOB localCLOB = getCLOB(paramInt);
/*     */ 
/* 407 */     if (localCLOB == null) {
/* 408 */       return null;
/*     */     }
/* 410 */     return localCLOB.getAsciiStream();
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 427 */     if (isNull(paramInt)) return null;
/*     */     Object localObject;
/* 428 */     if ((isPrefetched()) && (getPrefetchedLength(paramInt) > 2147483647L))
/*     */     {
/* 434 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 151);
/* 435 */       ((SQLException)localObject).fillInStackTrace();
/* 436 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 439 */     if ((isPrefetched()) && (getPrefetchedLength(paramInt) == getPrefetchedDataLength(paramInt)))
/*     */     {
/* 445 */       return this.rowData.getString(getPrefetchedDataOffset(paramInt), getPrefetchedDataLength(paramInt), this.statement.connection.conversion.getCharacterSet((short)getPrefetchedDataFormOfUse(paramInt)));
/*     */     }
/*     */ 
/* 449 */     if (isPrefetched())
/*     */     {
/* 452 */       localObject = getCLOB(paramInt);
/* 453 */       if (localObject == null) return null;
/* 454 */       return ((CLOB)localObject).getSubString(1L, (int)getPrefetchedLength(paramInt));
/*     */     }
/* 456 */     return getStringNoPrefetch(paramInt);
/*     */   }
/*     */ 
/*     */   String getStringNoPrefetch(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 464 */     CLOB localCLOB = getCLOB(paramInt);
/*     */ 
/* 466 */     if (localCLOB == null) {
/* 467 */       return null;
/*     */     }
/* 469 */     Reader localReader = localCLOB.getCharacterStream();
/* 470 */     int i = localCLOB.getBufferSize();
/* 471 */     int j = 0;
/* 472 */     StringWriter localStringWriter = new StringWriter(i);
/* 473 */     char[] arrayOfChar = new char[i];
/*     */     try
/*     */     {
/* 477 */       while ((j = localReader.read(arrayOfChar)) != -1)
/*     */       {
/* 479 */         localStringWriter.write(arrayOfChar, 0, j);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 485 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 486 */       localSQLException.fillInStackTrace();
/* 487 */       throw localSQLException;
/*     */     }
/*     */     catch (IndexOutOfBoundsException localIndexOutOfBoundsException)
/*     */     {
/* 493 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 151);
/* 494 */       localSQLException.fillInStackTrace();
/* 495 */       throw localSQLException;
/*     */     }
/*     */ 
/* 499 */     if (localCLOB.isTemporary()) this.statement.addToTempLobsToFree(localCLOB);
/* 500 */     return localStringWriter.getBuffer().substring(0);
/*     */   }
/*     */ 
/*     */   byte[] getBytes(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 518 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 519 */     localSQLException.fillInStackTrace();
/* 520 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   long updateChecksum(long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 528 */     unimpl("updateChecksum");
/* 529 */     return -1L;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.ClobAccessor
 * JD-Core Version:    0.6.2
 */