/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.StringReader;
/*     */ import java.math.BigDecimal;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.text.DateFormat;
/*     */ import java.text.ParseException;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Calendar;
/*     */ import java.util.Map;
/*     */ import oracle.sql.CHAR;
/*     */ import oracle.sql.CharacterSet;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.ROWID;
/*     */ 
/*     */ abstract class CharCommonAccessor extends Accessor
/*     */ {
/* 433 */   protected static final String[] DATE_FORMATS = { "yyyy-MM-dd HH:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "HH:mm:ss z", "HH:mm:ss" };
/*     */ 
/* 701 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharCommonAccessor(OracleStatement paramOracleStatement, int paramInt, short paramShort, boolean paramBoolean)
/*     */   {
/*  43 */     super(paramShort == 2 ? Representation.NVARCHAR : Representation.VARCHAR, paramOracleStatement, paramInt, paramBoolean);
/*     */   }
/*     */ 
/*     */   void init(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, int paramInt3, short paramShort, int paramInt4, boolean paramBoolean, int paramInt5)
/*     */     throws SQLException
/*     */   {
/*  54 */     if (paramBoolean)
/*     */     {
/*  56 */       if (paramInt1 != 23) {
/*  57 */         paramInt1 = 1;
/*     */       }
/*  59 */       if ((paramOracleStatement.maxFieldSize > 0) && ((paramInt3 == -1) || (paramInt3 < paramOracleStatement.maxFieldSize))) {
/*  60 */         paramInt3 = paramOracleStatement.maxFieldSize;
/*     */       }
/*     */     }
/*  63 */     init(paramOracleStatement, paramInt1, paramInt2, paramShort, paramBoolean);
/*     */ 
/*  66 */     if ((paramBoolean) && (paramOracleStatement.connection.defaultnchar)) {
/*  67 */       this.formOfUse = 2;
/*     */     }
/*  69 */     initForDataAccess(paramInt4, paramInt3, null);
/*     */   }
/*     */ 
/*     */   void init(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, short paramShort, int paramInt9)
/*     */     throws SQLException
/*     */   {
/*  78 */     init(paramOracleStatement, paramInt1, paramInt2, paramShort, false);
/*  79 */     initForDescribe(paramInt1, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort, null);
/*     */ 
/*  82 */     int i = paramOracleStatement.maxFieldSize;
/*     */ 
/*  84 */     if ((i != 0) && (i <= paramInt3)) {
/*  85 */       paramInt3 = i;
/*     */     }
/*  87 */     initForDataAccess(0, paramInt3, null);
/*     */   }
/*     */ 
/*     */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/*  95 */     if (paramInt1 != 0) {
/*  96 */       this.externalType = paramInt1;
/*     */     }
/*  98 */     this.charLength = ((paramInt2 >= 0) && ((paramInt2 < this.representationMaxLength) || (this.statement.isFetchStreams)) ? paramInt2 + 1 : this.isNullByDescribe ? 0 : this.representationMaxLength + 1);
/*     */   }
/*     */ 
/*     */   int getInt(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 110 */     if (isNull(paramInt)) return 0;
/*     */ 
/* 112 */     String str = getString(paramInt);
/*     */     try {
/* 114 */       return Integer.parseInt(str);
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException1) {
/*     */       try {
/* 118 */         return Double.valueOf(str).intValue();
/*     */       }
/*     */       catch (NumberFormatException localNumberFormatException2)
/*     */       {
/* 122 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 123 */         localSQLException.fillInStackTrace();
/* 124 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   boolean getBoolean(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 161 */     String str = getString(paramInt);
/*     */ 
/* 163 */     if ((str == null) || (str.trim().equals("0")) || (str.trim().compareToIgnoreCase("f") == 0) || (str.trim().compareToIgnoreCase("false") == 0) || (str.trim().compareToIgnoreCase("n") == 0) || (str.trim().compareToIgnoreCase("no") == 0))
/*     */     {
/* 170 */       return false;
/*     */     }
/* 172 */     if ((str.trim().equals("1")) || (str.trim().compareToIgnoreCase("t") == 0) || (str.trim().compareToIgnoreCase("true") == 0) || (str.trim().compareToIgnoreCase("y") == 0) || (str.trim().compareToIgnoreCase("yes") == 0))
/*     */     {
/* 178 */       return true;
/*     */     }
/*     */ 
/* 182 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 183 */     localSQLException.fillInStackTrace();
/* 184 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   short getShort(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 193 */     if (isNull(paramInt)) return 0;
/*     */ 
/* 195 */     String str = getString(paramInt);
/*     */     try {
/* 197 */       return Short.valueOf(str).shortValue();
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException1) {
/*     */       try {
/* 201 */         return Double.valueOf(str).shortValue();
/*     */       }
/*     */       catch (NumberFormatException localNumberFormatException2)
/*     */       {
/* 205 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 206 */         localSQLException.fillInStackTrace();
/* 207 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   byte getByte(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 219 */     if (isNull(paramInt)) return 0;
/*     */ 
/* 221 */     String str = getString(paramInt);
/*     */     try {
/* 223 */       return Byte.valueOf(str).byteValue();
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException1) {
/*     */       try {
/* 227 */         return Double.valueOf(str).byteValue();
/*     */       }
/*     */       catch (NumberFormatException localNumberFormatException2)
/*     */       {
/* 231 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 232 */         localSQLException.fillInStackTrace();
/* 233 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   long getLong(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 245 */     if (isNull(paramInt)) return 0L;
/*     */ 
/* 247 */     String str = getString(paramInt);
/*     */     try {
/* 249 */       return Long.valueOf(str).longValue();
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException1) {
/*     */       try {
/* 253 */         return Double.valueOf(str).longValue();
/*     */       }
/*     */       catch (NumberFormatException localNumberFormatException2)
/*     */       {
/* 257 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 258 */         localSQLException.fillInStackTrace();
/* 259 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   float getFloat(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 271 */     if (isNull(paramInt)) return 0.0F;
/*     */ 
/* 273 */     String str = getString(paramInt);
/*     */     try {
/* 275 */       return Float.valueOf(str).floatValue();
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException1) {
/*     */       try {
/* 279 */         return Double.valueOf(str).floatValue();
/*     */       }
/*     */       catch (NumberFormatException localNumberFormatException2)
/*     */       {
/* 283 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 284 */         localSQLException.fillInStackTrace();
/* 285 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   double getDouble(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 297 */     if (isNull(paramInt)) return 0.0D;
/*     */     try
/*     */     {
/* 300 */       return Double.valueOf(getString(paramInt)).doubleValue();
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException)
/*     */     {
/* 304 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 305 */       localSQLException.fillInStackTrace();
/* 306 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   BigDecimal getBigDecimal(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 317 */     if (isNull(paramInt)) return null;
/*     */     try
/*     */     {
/* 320 */       return new BigDecimal(getString(paramInt).trim());
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException)
/*     */     {
/* 324 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 325 */       localSQLException.fillInStackTrace();
/* 326 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 337 */     BigDecimal localBigDecimal = getBigDecimal(paramInt1);
/*     */ 
/* 339 */     if (localBigDecimal != null) {
/* 340 */       localBigDecimal.setScale(paramInt2, 6);
/*     */     }
/* 342 */     return localBigDecimal;
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 350 */     if (isNull(paramInt)) return null;
/*     */ 
/* 352 */     String str = this.rowData.getString(getOffset(paramInt), getLength(paramInt), this.statement.connection.conversion.getCharacterSet(this.formOfUse));
/*     */ 
/* 357 */     if (str.length() > this.charLength - 1)
/* 358 */       str = str.substring(0, this.charLength - 1);
/* 359 */     return str;
/*     */   }
/*     */ 
/*     */   java.sql.Date getDate(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 368 */     if (isNull(paramInt)) return null;
/*     */ 
/* 370 */     java.sql.Date localDate = null;
/*     */     try { localDate = java.sql.Date.valueOf(getString(paramInt).trim()); }
/*     */     catch (IllegalArgumentException localIllegalArgumentException)
/*     */     {
/* 375 */       SQLException localSQLException = DatabaseError.createSqlException(null, 132, null, localIllegalArgumentException);
/* 376 */       localSQLException.fillInStackTrace();
/* 377 */       throw localSQLException;
/*     */     }
/*     */ 
/* 381 */     return localDate;
/*     */   }
/*     */ 
/*     */   Time getTime(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 390 */     if (isNull(paramInt)) return null;
/*     */ 
/* 392 */     Time localTime = null;
/*     */     try { localTime = Time.valueOf(getString(paramInt).trim()); }
/*     */     catch (IllegalArgumentException localIllegalArgumentException)
/*     */     {
/* 397 */       SQLException localSQLException = DatabaseError.createSqlException(null, 132, null, localIllegalArgumentException);
/* 398 */       localSQLException.fillInStackTrace();
/* 399 */       throw localSQLException;
/*     */     }
/*     */ 
/* 403 */     return localTime;
/*     */   }
/*     */ 
/*     */   Timestamp getTimestamp(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 412 */     if (isNull(paramInt)) return null;
/*     */ 
/* 414 */     Timestamp localTimestamp = null;
/*     */     try { localTimestamp = Timestamp.valueOf(getString(paramInt).trim()); }
/*     */     catch (IllegalArgumentException localIllegalArgumentException)
/*     */     {
/* 419 */       SQLException localSQLException = DatabaseError.createSqlException(null, 132, null, localIllegalArgumentException);
/* 420 */       localSQLException.fillInStackTrace();
/* 421 */       throw localSQLException;
/*     */     }
/*     */ 
/* 425 */     return localTimestamp;
/*     */   }
/*     */ 
/*     */   java.util.Date getJavaUtilDate(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 445 */     if (isNull(paramInt)) return null;
/*     */ 
/* 447 */     java.util.Date localDate = null;
/* 448 */     for (String str : DATE_FORMATS) {
/* 449 */       SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat(str);
/*     */       try {
/* 451 */         localDate = localSimpleDateFormat.parse(getString(paramInt).trim());
/*     */       }
/*     */       catch (ParseException localParseException)
/*     */       {
/* 455 */         continue;
/*     */       }
/* 457 */       return localDate;
/*     */     }
/*     */ 
/* 460 */     ??? = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/* 461 */     ((SQLException)???).fillInStackTrace();
/* 462 */     throw ((Throwable)???);
/*     */   }
/*     */ 
/*     */   Calendar getCalendar(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 472 */     if (isNull(paramInt)) return null;
/*     */ 
/* 474 */     Calendar localCalendar = (Calendar)this.statement.getDefaultCalendar().clone();
/* 475 */     localCalendar.setTime(getJavaUtilDate(paramInt));
/* 476 */     return localCalendar;
/*     */   }
/*     */ 
/*     */   InputStream getAsciiStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 493 */     if (isNull(paramInt)) return null;
/*     */ 
/* 497 */     DBConversion localDBConversion = this.statement.connection.conversion;
/* 498 */     int[] arrayOfInt = new int[1];
/* 499 */     char[] arrayOfChar = this.rowData.getChars(getOffset(paramInt), getLength(paramInt), localDBConversion.getCharacterSet(this.formOfUse), arrayOfInt);
/*     */ 
/* 503 */     return localDBConversion.CharsToStream(arrayOfChar, 0, arrayOfInt[0], 10);
/*     */   }
/*     */ 
/*     */   InputStream getUnicodeStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 521 */     if (isNull(paramInt)) return null;
/*     */ 
/* 525 */     DBConversion localDBConversion = this.statement.connection.conversion;
/* 526 */     int[] arrayOfInt = new int[1];
/* 527 */     char[] arrayOfChar = this.rowData.getChars(getOffset(paramInt), getLength(paramInt), localDBConversion.getCharacterSet(this.formOfUse), arrayOfInt);
/*     */ 
/* 531 */     return localDBConversion.CharsToStream(arrayOfChar, 0, arrayOfInt[0] << 1, 11);
/*     */   }
/*     */ 
/*     */   Reader getCharacterStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 550 */     if (isNull(paramInt)) return null;
/* 551 */     return new StringReader(getString(paramInt));
/*     */   }
/*     */ 
/*     */   InputStream getBinaryStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 565 */     if (isNull(paramInt)) return null;
/* 566 */     return new ByteArrayInputStream(getBytes(paramInt));
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 580 */     return getString(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 595 */     return getString(paramInt);
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 609 */     return getCHAR(paramInt);
/*     */   }
/*     */ 
/*     */   CHAR getCHAR(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 623 */     byte[] arrayOfByte = getBytes(paramInt);
/*     */ 
/* 626 */     if ((arrayOfByte == null) || (arrayOfByte.length == 0))
/*     */     {
/* 628 */       return null;
/*     */     }
/*     */ 
/* 631 */     CharacterSet localCharacterSet = this.statement.connection.conversion.getCharacterSet(this.formOfUse);
/* 632 */     return new CHAR(arrayOfByte, localCharacterSet);
/*     */   }
/*     */ 
/*     */   URL getURL(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 646 */     if (isNull(paramInt)) return null;
/*     */ 
/*     */     try
/*     */     {
/* 650 */       return new URL(getString(paramInt));
/*     */     }
/*     */     catch (MalformedURLException localMalformedURLException)
/*     */     {
/* 655 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 136);
/* 656 */       localSQLException.fillInStackTrace();
/* 657 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   ROWID getROWID(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 668 */     if (isNull(paramInt)) return null;
/*     */ 
/* 670 */     byte[] arrayOfByte = getBytesInternal(paramInt);
/* 671 */     ROWID localROWID = null;
/* 672 */     if (arrayOfByte != null) {
/* 673 */       localROWID = new ROWID(arrayOfByte);
/*     */     }
/* 675 */     return localROWID;
/*     */   }
/*     */ 
/*     */   byte[] getBytesFromHexChars(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 683 */     if (isNull(paramInt)) return null;
/*     */ 
/* 685 */     Object localObject = this.rowData.getBytesFromHex(getOffset(paramInt), getLength(paramInt), this.statement.connection.conversion.getCharacterSet(this.formOfUse));
/*     */ 
/* 690 */     if (localObject.length > this.charLength - 1) {
/* 691 */       byte[] arrayOfByte = new byte[this.charLength - 1];
/* 692 */       System.arraycopy(localObject, 0, arrayOfByte, 0, arrayOfByte.length);
/* 693 */       localObject = arrayOfByte;
/*     */     }
/* 695 */     return localObject;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.CharCommonAccessor
 * JD-Core Version:    0.6.2
 */