/*    */ package oracle.jdbc.driver;
/*    */ 
/*    */ class CancelLock
/*    */ {
/* 47 */   private State state = State.IDLE;
/*    */ 
/*    */   boolean isIdle() {
/* 50 */     return this.state == State.IDLE;
/*    */   }
/*    */ 
/*    */   synchronized void enterExecuting()
/*    */   {
/* 55 */     assert (this.state == State.IDLE);
/* 56 */     this.state = State.EXECUTING;
/*    */   }
/*    */ 
/*    */   synchronized void exitExecuting()
/*    */   {
/* 61 */     while (this.state != State.EXECUTING)
/*    */     {
/* 63 */       assert (this.state == State.CANCELING);
/*    */       try {
/* 65 */         wait(); } catch (InterruptedException localInterruptedException) {
/*    */       }
/*    */     }
/* 68 */     this.state = State.IDLE;
/*    */   }
/*    */ 
/*    */   synchronized boolean enterCanceling()
/*    */   {
/* 73 */     if (this.state == State.EXECUTING)
/*    */     {
/* 75 */       this.state = State.CANCELING;
/* 76 */       return true;
/*    */     }
/*    */ 
/* 79 */     return false;
/*    */   }
/*    */ 
/*    */   synchronized void exitCanceling()
/*    */   {
/* 84 */     assert (this.state == State.CANCELING);
/* 85 */     this.state = State.EXECUTING;
/* 86 */     notify();
/*    */   }
/*    */ 
/*    */   private static enum State
/*    */   {
/* 45 */     IDLE, EXECUTING, CANCELING;
/*    */   }
/*    */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.CancelLock
 * JD-Core Version:    0.6.2
 */