/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*       */ 
/*       */ abstract class ByteCopyingBinder extends Binder
/*       */ {
/* 16507 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   Binder copyingBinder()
/*       */   {
/* 16441 */     return this;
/*       */   }
/*       */ 
/*       */   long bind(OraclePreparedStatement paramOraclePreparedStatement, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte, char[] paramArrayOfChar, short[] paramArrayOfShort, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, int paramInt9, boolean paramBoolean, long paramLong)
/*       */   {
/* 16455 */     int j = paramOraclePreparedStatement.lastBoundByteLens[paramInt1];
/*       */     byte[] arrayOfByte;
/*       */     int i;
/* 16457 */     if (paramInt2 == 0)
/*       */     {
/* 16459 */       arrayOfByte = paramOraclePreparedStatement.lastBoundBytes;
/* 16460 */       i = paramOraclePreparedStatement.lastBoundByteOffsets[paramInt1];
/* 16461 */       paramArrayOfShort[paramInt9] = paramOraclePreparedStatement.lastBoundInds[paramInt1];
/* 16462 */       paramArrayOfShort[paramInt8] = paramOraclePreparedStatement.lastBoundLens[paramInt1];
/*       */ 
/* 16464 */       if ((arrayOfByte == paramArrayOfByte) && (i == paramInt6)) {
/* 16465 */         if (paramOraclePreparedStatement.connection.checksumMode.needToCalculateBindChecksum()) {
/* 16466 */           if (paramArrayOfShort[paramInt9] == -1) {
/* 16467 */             paramLong = CRC64.updateChecksum(paramLong, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
/*       */           }
/*       */           else
/*       */           {
/* 16471 */             j = paramOraclePreparedStatement.lastBoundByteLens[paramInt1];
/* 16472 */             paramLong = CRC64.updateChecksum(paramLong, arrayOfByte, i, j);
/*       */           }
/*       */         }
/*       */ 
/* 16476 */         return paramLong;
/*       */       }
/* 16478 */       j = paramOraclePreparedStatement.lastBoundByteLens[paramInt1];
/*       */ 
/* 16480 */       if (j > paramInt4) j = paramInt4;
/*       */     }
/*       */     else
/*       */     {
/* 16484 */       arrayOfByte = paramArrayOfByte;
/* 16485 */       i = paramInt6 - paramInt4;
/* 16486 */       paramArrayOfShort[paramInt9] = paramArrayOfShort[(paramInt9 - 1)];
/* 16487 */       paramArrayOfShort[paramInt8] = paramArrayOfShort[(paramInt8 - 1)];
/* 16488 */       j = paramInt4;
/*       */     }
/*       */ 
/* 16491 */     System.arraycopy(arrayOfByte, i, paramArrayOfByte, paramInt6, j);
/* 16492 */     if (paramOraclePreparedStatement.connection.checksumMode.needToCalculateBindChecksum()) {
/* 16493 */       if (paramArrayOfShort[paramInt9] == -1) {
/* 16494 */         paramLong = CRC64.updateChecksum(paramLong, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
/*       */       }
/*       */       else
/*       */       {
/* 16498 */         paramLong = CRC64.updateChecksum(paramLong, arrayOfByte, i, j);
/*       */       }
/*       */     }
/*       */ 
/* 16502 */     return paramLong;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.ByteCopyingBinder
 * JD-Core Version:    0.6.2
 */