/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.CharacterSet;
/*     */ 
/*     */ abstract class ByteArray
/*     */ {
/*  24 */   protected long position = 0L;
/*     */ 
/* 555 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   abstract long length();
/*     */ 
/*     */   final long getPosition()
/*     */   {
/*  43 */     return this.position;
/*     */   }
/*     */ 
/*     */   final void setPosition(long paramLong)
/*     */   {
/*  53 */     assert (paramLong >= 0L) : ("index: " + paramLong);
/*  54 */     this.position = paramLong;
/*     */   }
/*     */ 
/*     */   final void reset()
/*     */   {
/*  62 */     setPosition(0L);
/*     */   }
/*     */ 
/*     */   final byte get()
/*     */   {
/*  77 */     assert (this.position < length()) : ("position: " + this.position + " length: " + length());
/*  78 */     return get(this.position++);
/*     */   }
/*     */ 
/*     */   final byte[] getBytes(int paramInt)
/*     */   {
/*  92 */     assert ((paramInt >= 0) && (length() >= getPosition() + paramInt)) : ("this.length: " + length() + " position: " + this.position + " length: " + paramInt);
/*  93 */     byte[] arrayOfByte = get(this.position, paramInt);
/*  94 */     this.position += paramInt;
/*     */ 
/*  96 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   final void getBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/* 112 */     assert (paramArrayOfByte != null) : "dest is null";
/*     */ 
/* 114 */     assert ((paramInt1 >= 0) && (paramInt2 >= 0) && (paramArrayOfByte.length >= paramInt1 + paramInt2)) : ("destOffset: " + paramInt1 + " length: " + paramInt2 + " dest.length: " + paramArrayOfByte.length);
/*     */ 
/* 116 */     assert (length() >= this.position + paramInt2) : (" this.length: " + length() + " this.position: " + this.position + " length: " + paramInt2);
/* 117 */     get(this.position, paramArrayOfByte, paramInt1, paramInt2);
/* 118 */     this.position += paramInt2;
/*     */   }
/*     */ 
/*     */   final int getShort()
/*     */   {
/* 130 */     assert (this.position + 1L < length()) : ("position: " + this.position + " length: " + length());
/* 131 */     return (get() & 0xFF) << 8 | get() & 0xFF;
/*     */   }
/*     */ 
/*     */   final int getInt()
/*     */   {
/* 142 */     assert (this.position + 3L < length()) : ("position: " + this.position + " length: " + length());
/* 143 */     return (get() & 0xFF) << 24 | (get() & 0xFF) << 16 | (get() & 0xFF) << 8 | get() & 0xFF;
/*     */   }
/*     */ 
/*     */   final String getString(int paramInt, CharacterSet paramCharacterSet)
/*     */     throws SQLException
/*     */   {
/* 159 */     String str = getString(this.position, paramInt, paramCharacterSet);
/* 160 */     this.position += paramInt;
/* 161 */     return str;
/*     */   }
/*     */ 
/*     */   final void put(byte paramByte)
/*     */   {
/* 176 */     put(this.position++, paramByte);
/*     */   }
/*     */ 
/*     */   final void putShort(short paramShort)
/*     */   {
/* 184 */     putShort(this.position, paramShort);
/* 185 */     this.position += 2L;
/*     */   }
/*     */ 
/*     */   final void putInt(int paramInt)
/*     */   {
/* 194 */     putInt(this.position, paramInt);
/* 195 */     this.position += 4L;
/*     */   }
/*     */ 
/*     */   final void put(byte[] paramArrayOfByte)
/*     */   {
/* 207 */     put(this.position, paramArrayOfByte);
/* 208 */     this.position += paramArrayOfByte.length;
/*     */   }
/*     */ 
/*     */   final void put(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/* 225 */     assert (paramArrayOfByte != null) : "src is null";
/* 226 */     assert ((paramInt1 >= 0) && (paramInt2 >= 0)) : ("srcOffset: " + paramInt1 + " length: " + paramInt2);
/*     */ 
/* 228 */     assert (paramArrayOfByte.length >= paramInt1 + paramInt2) : ("src.length: " + paramArrayOfByte.length + " srcOffset: " + paramInt1 + " length: " + paramInt2);
/* 229 */     put(this.position, paramArrayOfByte, paramInt1, paramInt2);
/* 230 */     this.position += paramInt2;
/*     */   }
/*     */ 
/*     */   abstract void put(long paramLong, byte paramByte);
/*     */ 
/*     */   abstract byte get(long paramLong);
/*     */ 
/*     */   final void putShort(long paramLong, short paramShort)
/*     */   {
/* 267 */     put(paramLong, (byte)(paramShort >> 8 & 0xFF));
/* 268 */     put(paramLong + 1L, (byte)(paramShort & 0xFF));
/*     */   }
/*     */ 
/*     */   final void putInt(long paramLong, int paramInt)
/*     */   {
/* 284 */     for (int i = 3; i >= 0; i--) {
/* 285 */       put(paramLong + i, (byte)(paramInt & 0xFF));
/* 286 */       paramInt >>= 8;
/*     */     }
/*     */   }
/*     */ 
/*     */   final void put(long paramLong, byte[] paramArrayOfByte)
/*     */   {
/* 300 */     assert ((paramLong >= 0L) && (paramArrayOfByte != null)) : ("offset: " + paramLong + " src: " + paramArrayOfByte);
/* 301 */     put(paramLong, paramArrayOfByte, 0, paramArrayOfByte.length);
/*     */   }
/*     */ 
/*     */   abstract void put(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2);
/*     */ 
/*     */   void put(long paramLong1, ByteArray paramByteArray, long paramLong2, int paramInt)
/*     */   {
/* 334 */     assert ((paramLong1 >= 0L) && (paramByteArray != null) && (paramLong2 >= 0L)) : ("offset: " + paramLong1 + " src: " + paramByteArray + " srcOffset: " + paramLong2);
/* 335 */     byte[] arrayOfByte = paramByteArray.get(paramLong2, paramInt);
/* 336 */     put(paramLong1, arrayOfByte, 0, paramInt);
/*     */   }
/*     */ 
/*     */   final byte[] get(long paramLong, int paramInt)
/*     */   {
/* 351 */     assert ((paramLong >= 0L) && (paramInt >= 0) && (length() >= paramLong + paramInt)) : ("this.length: " + length() + " offset: " + paramLong + " length: " + paramInt);
/* 352 */     byte[] arrayOfByte = new byte[paramInt];
/* 353 */     get(paramLong, arrayOfByte, 0, paramInt);
/* 354 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   abstract void get(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2);
/*     */ 
/*     */   String getString(long paramLong, int paramInt, CharacterSet paramCharacterSet)
/*     */     throws SQLException
/*     */   {
/* 387 */     int[] arrayOfInt = new int[1];
/* 388 */     char[] arrayOfChar = getChars(paramLong, paramInt, paramCharacterSet, arrayOfInt);
/* 389 */     if (arrayOfInt[0] == arrayOfChar.length) {
/* 390 */       return new String(arrayOfChar);
/*     */     }
/* 392 */     return String.valueOf(arrayOfChar, 0, arrayOfInt[0]);
/*     */   }
/*     */ 
/*     */   char[] getChars(long paramLong, int paramInt, CharacterSet paramCharacterSet)
/*     */     throws SQLException
/*     */   {
/* 411 */     int[] arrayOfInt = new int[1];
/* 412 */     char[] arrayOfChar1 = getChars(paramLong, paramInt, paramCharacterSet, arrayOfInt);
/* 413 */     if (arrayOfInt[0] == arrayOfChar1.length) {
/* 414 */       return arrayOfChar1;
/*     */     }
/* 416 */     char[] arrayOfChar2 = new char[arrayOfInt[0]];
/* 417 */     System.arraycopy(arrayOfChar1, 0, arrayOfChar2, 0, arrayOfChar2.length);
/* 418 */     return arrayOfChar2;
/*     */   }
/*     */ 
/*     */   abstract char[] getChars(long paramLong, int paramInt, CharacterSet paramCharacterSet, int[] paramArrayOfInt)
/*     */     throws SQLException;
/*     */ 
/*     */   boolean equalBytes(long paramLong1, int paramInt, ByteArray paramByteArray, long paramLong2)
/*     */     throws SQLException
/*     */   {
/* 462 */     if ((paramLong1 + paramInt >= length()) || (paramLong2 + paramInt >= paramByteArray.length()))
/* 463 */       return false;
/* 464 */     for (int i = 0; i < paramInt; i++) {
/* 465 */       if (get(paramLong1 + i) != paramByteArray.get(paramLong2 + i)) return false;
/*     */     }
/* 467 */     return true;
/*     */   }
/*     */ 
/*     */   abstract long updateChecksum(long paramLong1, int paramInt, CRC64 paramCRC64, long paramLong2);
/*     */ 
/*     */   byte[] getBytesFromHex(long paramLong, int paramInt, CharacterSet paramCharacterSet)
/*     */     throws SQLException
/*     */   {
/* 496 */     int[] arrayOfInt = new int[1];
/* 497 */     char[] arrayOfChar1 = getChars(paramLong, paramInt, paramCharacterSet, arrayOfInt);
/* 498 */     int i = arrayOfInt[0];
/* 499 */     byte[] arrayOfByte = new byte[(i + 1) / 2];
/* 500 */     int j = 1;
/* 501 */     int k = 0;
/* 502 */     for (char c : arrayOfChar1) {
/* 503 */       if (j != 0) { arrayOfByte[k] = ((byte)(hexDigit2Nibble(c) << 4)); }
/*     */       else
/*     */       {
/*     */         int tmp94_91 = (k++);
/*     */         byte[] tmp94_87 = arrayOfByte; tmp94_87[tmp94_91] = ((byte)(tmp94_87[tmp94_91] + (hexDigit2Nibble(c) & 0xF)));
/* 505 */       }j = j == 0 ? 1 : 0;
/*     */     }
/* 507 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   final int hexDigit2Nibble(char paramChar)
/*     */     throws SQLException
/*     */   {
/* 521 */     int i = Character.digit(paramChar, 16);
/* 522 */     if (i == -1)
/*     */     {
/* 524 */       SQLException localSQLException = DatabaseError.createSqlException(null, 59, "Invalid hex digit: " + paramChar);
/* 525 */       localSQLException.fillInStackTrace();
/* 526 */       throw localSQLException;
/*     */     }
/* 528 */     return i;
/*     */   }
/*     */ 
/*     */   final void freeSpace(long paramLong, int paramInt)
/*     */   {
/*     */   }
/*     */ 
/*     */   byte[] getBlockBasic(long paramLong, int[] paramArrayOfInt)
/*     */   {
/* 547 */     throw new Error("not implemented");
/*     */   }
/*     */ 
/*     */   abstract void free();
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.ByteArray
 * JD-Core Version:    0.6.2
 */