/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.lang.ref.SoftReference;
/*     */ import java.lang.reflect.Array;
/*     */ import oracle.jdbc.internal.OracleConnection.BufferCacheStatistics;
/*     */ 
/*     */ class BufferCache<T>
/*     */ {
/* 142 */   private static final double ln2 = Math.log(2.0D);
/*     */   private static final int BUFFERS_PER_BUCKET = 8;
/*     */   private static final int MIN_INDEX = 12;
/*     */   private final InternalStatistics stats;
/*     */   private final int[] bufferSize;
/*     */   private final SoftReference<T>[][] buckets;
/*     */   private final int[] top;
/* 362 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   BufferCache(int paramInt)
/*     */   {
/*     */     int i;
/* 168 */     if (paramInt < 31) {
/* 169 */       i = paramInt;
/*     */     }
/*     */     else
/*     */     {
/* 174 */       i = (int)Math.ceil(Math.log(paramInt) / ln2);
/*     */     }
/*     */ 
/* 177 */     int j = Math.max(0, i - 12 + 1);
/*     */ 
/* 179 */     this.buckets = ((SoftReference[][])new SoftReference[j][8]);
/* 180 */     this.top = new int[j];
/*     */ 
/* 182 */     this.bufferSize = new int[j];
/* 183 */     int k = 4096;
/* 184 */     for (int m = 0; m < this.bufferSize.length; m++) {
/* 185 */       this.bufferSize[m] = k;
/* 186 */       k <<= 1;
/*     */     }
/* 188 */     this.stats = new InternalStatistics(this.bufferSize);
/*     */   }
/*     */ 
/*     */   T get(Class<?> paramClass, int paramInt)
/*     */   {
/* 206 */     int i = bufferIndex(paramInt);
/*     */ 
/* 208 */     if (i >= this.buckets.length) {
/* 209 */       this.stats.requestTooBig();
/* 210 */       return Array.newInstance(paramClass, paramInt);
/*     */     }
/*     */ 
/* 213 */     while (this.top[i] > 0) {
/* 214 */       SoftReference localSoftReference = this.buckets[i][(this.top[i] -= 1)];
/* 215 */       this.buckets[i][this.top[i]] = null;
/* 216 */       Object localObject = localSoftReference.get();
/* 217 */       if (localObject != null) {
/* 218 */         this.stats.cacheHit(i);
/* 219 */         return localObject;
/*     */       }
/*     */     }
/*     */ 
/* 223 */     this.stats.cacheMiss(i);
/* 224 */     return Array.newInstance(paramClass, this.bufferSize[i]);
/*     */   }
/*     */ 
/*     */   void put(T paramT)
/*     */   {
/* 238 */     int i = Array.getLength(paramT);
/*     */ 
/* 240 */     int j = bufferIndex(i);
/*     */ 
/* 243 */     if ((j >= this.buckets.length) || (i != this.bufferSize[j])) {
/* 244 */       this.stats.cacheTooBig();
/* 245 */       return;
/*     */     }
/*     */ 
/* 248 */     if (this.top[j] < 8) {
/* 249 */       this.stats.bufferCached(j);
/*     */       int tmp68_67 = j;
/*     */       int[] tmp68_64 = this.top;
/*     */       int tmp70_69 = tmp68_64[tmp68_67]; tmp68_64[tmp68_67] = (tmp70_69 + 1); this.buckets[j][tmp70_69] = new SoftReference(paramT);
/*     */     }
/*     */     else
/*     */     {
/* 256 */       for (int k = this.top[j]; k > 0; ) {
/* 257 */         if (this.buckets[j][(--k)].get() == null)
/*     */         {
/* 259 */           this.stats.refCleared(j);
/* 260 */           this.buckets[j][k] = new SoftReference(paramT);
/* 261 */           return;
/*     */         }
/*     */       }
/* 264 */       this.stats.bucketFull(j);
/*     */     }
/*     */   }
/*     */ 
/*     */   OracleConnection.BufferCacheStatistics getStatistics()
/*     */   {
/* 272 */     return this.stats;
/*     */   }
/*     */ 
/*     */   private int bufferIndex(int paramInt)
/*     */   {
/* 280 */     for (int i = 0; i < this.bufferSize.length; i++) {
/* 281 */       if (paramInt <= this.bufferSize[i]) return i;
/*     */     }
/* 283 */     return 2147483647; } 
/* 288 */   private static final class InternalStatistics implements OracleConnection.BufferCacheStatistics { private static int CACHE_COUNT = 0;
/*     */ 
/* 290 */     private final int cacheId = ++CACHE_COUNT;
/*     */     private final int[] sizes;
/*     */     private final int[] nCacheHit;
/*     */     private final int[] nCacheMiss;
/*     */     private int nRequestTooBig;
/*     */     private final int[] nBufferCached;
/*     */     private final int[] nBucketFull;
/*     */     private final int[] nRefCleared;
/*     */     private int nCacheTooBig;
/*     */ 
/* 304 */     InternalStatistics(int[] paramArrayOfInt) { this.sizes = paramArrayOfInt;
/* 305 */       int i = paramArrayOfInt.length;
/* 306 */       this.nCacheHit = new int[i];
/* 307 */       this.nCacheMiss = new int[i];
/* 308 */       this.nRequestTooBig = 0;
/* 309 */       this.nBufferCached = new int[i];
/* 310 */       this.nBucketFull = new int[i];
/* 311 */       this.nRefCleared = new int[i];
/* 312 */       this.nCacheTooBig = 0; }
/*     */ 
/*     */     void cacheHit(int paramInt) {
/* 315 */       this.nCacheHit[paramInt] += 1; } 
/* 316 */     void cacheMiss(int paramInt) { this.nCacheMiss[paramInt] += 1; } 
/* 317 */     void requestTooBig() { this.nRequestTooBig += 1; } 
/* 318 */     void bufferCached(int paramInt) { this.nBufferCached[paramInt] += 1; } 
/* 319 */     void bucketFull(int paramInt) { this.nBucketFull[paramInt] += 1; } 
/* 320 */     void refCleared(int paramInt) { this.nRefCleared[paramInt] += 1; } 
/* 321 */     void cacheTooBig() { this.nCacheTooBig += 1; }
/*     */ 
/*     */     public int getId() {
/* 324 */       return this.cacheId;
/*     */     }
/* 326 */     public int[] getBufferSizes() { int[] arrayOfInt = new int[this.sizes.length];
/* 327 */       System.arraycopy(this.sizes, 0, arrayOfInt, 0, this.sizes.length);
/* 328 */       return arrayOfInt; } 
/*     */     public int getCacheHits(int paramInt) {
/* 330 */       return this.nCacheHit[paramInt]; } 
/* 331 */     public int getCacheMisses(int paramInt) { return this.nCacheMiss[paramInt]; } 
/* 332 */     public int getRequestsTooBig() { return this.nRequestTooBig; } 
/* 333 */     public int getBuffersCached(int paramInt) { return this.nBufferCached[paramInt]; } 
/* 334 */     public int getBucketsFull(int paramInt) { return this.nBucketFull[paramInt]; } 
/* 335 */     public int getReferencesCleared(int paramInt) { return this.nRefCleared[paramInt]; } 
/* 336 */     public int getTooBigToCache() { return this.nCacheTooBig; }
/*     */ 
/*     */     public String toString() {
/* 339 */       int i = 0;
/* 340 */       int j = 0;
/* 341 */       int k = 0;
/* 342 */       int m = 0;
/* 343 */       int n = 0;
/* 344 */       for (int i1 = 0; i1 < this.sizes.length; i1++) {
/* 345 */         i += this.nCacheHit[i1];
/* 346 */         j += this.nCacheMiss[i1];
/* 347 */         k += this.nBufferCached[i1];
/* 348 */         m += this.nBucketFull[i1];
/* 349 */         n += this.nRefCleared[i1];
/*     */       }
/* 351 */       String str = "oracle.jdbc.driver.BufferCache<" + this.cacheId + ">\n" + "\tTotal Hits   :\t" + i + "\n" + "\tTotal Misses :\t" + (j + this.nRequestTooBig) + "\n" + "\tTotal Cached :\t" + k + "\n" + "\tTotal Dropped:\t" + (m + this.nCacheTooBig) + "\n" + "\tTotal Cleared:\t" + n + "\n";
/*     */ 
/* 357 */       return str;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.BufferCache
 * JD-Core Version:    0.6.2
 */