/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.lang.management.ManagementFactory;
/*     */ import java.lang.management.MemoryMXBean;
/*     */ import java.lang.management.MemoryPoolMXBean;
/*     */ import java.lang.management.MemoryType;
/*     */ import java.lang.management.MemoryUsage;
/*     */ import java.lang.ref.SoftReference;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationEmitter;
/*     */ import javax.management.NotificationListener;
/*     */ 
/*     */ abstract class BlockSource
/*     */ {
/*     */   private static final int BLOCK_SIZE = 32768;
/* 654 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   static final BlockSource createBlockSource(boolean paramBoolean, Implementation paramImplementation)
/*     */   {
/*  69 */     if (paramBoolean) return ThreadLocalBlockSource.createBlockSource(paramImplementation);
/*  70 */     return createBlockSource(paramImplementation);
/*     */   }
/*     */ 
/*     */   static BlockSource createBlockSource(Implementation paramImplementation)
/*     */   {
/*  76 */     switch (1.$SwitchMap$oracle$jdbc$driver$BlockSource$Implementation[paramImplementation.ordinal()]) { case 1:
/*  77 */       return DumbBlockSource.createBlockSource();
/*     */     case 2:
/*  78 */       return SimpleCachingBlockSource.createBlockSource();
/*     */     case 3:
/*  79 */       return SoftCachingBlockSource.access$000();
/*     */     case 4:
/*  80 */       return ThreadedCachingBlockSource.createBlockSource();
/*     */     }
/*  82 */     return null;
/*     */   }
/*     */ 
/*     */   abstract int getBlockSize();
/*     */ 
/*     */   abstract byte[] get();
/*     */ 
/*     */   abstract void put(byte[] paramArrayOfByte);
/*     */ 
/*     */   private static final class ThreadLocalBlockSource extends BlockSource
/*     */   {
/* 612 */     private static BlockSource.Implementation IMPL = null;
/*     */ 
/* 614 */     private static final ThreadLocal<BlockSource> REF = new ThreadLocal() {
/*     */       protected BlockSource initialValue() {
/* 616 */         return BlockSource.createBlockSource(BlockSource.ThreadLocalBlockSource.IMPL);
/*     */       }
/* 614 */     };
/*     */ 
/*     */     static BlockSource createBlockSource(BlockSource.Implementation paramImplementation)
/*     */     {
/* 622 */       assert ((IMPL == null) || (IMPL == paramImplementation)) : ("IMPL: " + IMPL + " impl: " + paramImplementation);
/* 623 */       IMPL = paramImplementation;
/* 624 */       return new ThreadLocalBlockSource();
/*     */     }
/*     */ 
/*     */     int getBlockSize()
/*     */     {
/* 633 */       return ((BlockSource)REF.get()).getBlockSize();
/*     */     }
/*     */ 
/*     */     byte[] get()
/*     */     {
/* 639 */       BlockSource localBlockSource = (BlockSource)REF.get();
/* 640 */       return localBlockSource.get();
/*     */     }
/*     */ 
/*     */     void put(byte[] paramArrayOfByte)
/*     */     {
/* 646 */       BlockSource localBlockSource = (BlockSource)REF.get();
/* 647 */       localBlockSource.put(paramArrayOfByte);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class SoftCachingBlockSource extends BlockSource
/*     */   {
/*     */     private static final int CACHE_SIZE = 1024;
/* 533 */     private final SoftReference<byte[]>[] blocks = new SoftReference[1024];
/* 534 */     private int top = 0;
/*     */ 
/* 598 */     private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */     public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */     public static final boolean TRACE = false;
/*     */ 
/*     */     private static BlockSource createBlockSource()
/*     */     {
/* 529 */       return new SoftCachingBlockSource();
/*     */     }
/*     */ 
/*     */     int getBlockSize()
/*     */     {
/* 545 */       return 32768;
/*     */     }
/*     */ 
/*     */     byte[] get()
/*     */     {
/* 555 */       while (this.top > 0) {
/* 556 */         SoftReference localSoftReference = this.blocks[(--this.top)];
/* 557 */         this.blocks[this.top] = null;
/* 558 */         byte[] arrayOfByte = (byte[])localSoftReference.get();
/* 559 */         if (arrayOfByte != null) {
/* 560 */           return arrayOfByte;
/*     */         }
/*     */       }
/*     */ 
/* 564 */       return new byte[32768];
/*     */     }
/*     */ 
/*     */     void put(byte[] paramArrayOfByte)
/*     */     {
/* 577 */       assert (paramArrayOfByte != null) : "block is null";
/* 578 */       assert (paramArrayOfByte.length == 32768) : ("block.length: " + paramArrayOfByte.length);
/*     */       int i;
/* 579 */       if (this.top < this.blocks.length) {
/* 580 */         this.blocks[(this.top++)] = new SoftReference(paramArrayOfByte);
/*     */       }
/*     */       else
/*     */       {
/* 586 */         for (i = this.top; i > 0; )
/* 587 */           if (this.blocks[(--i)].get() == null)
/*     */           {
/* 589 */             this.blocks[i] = new SoftReference(paramArrayOfByte);
/* 590 */             return;
/*     */           }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static final class ThreadedCachingBlockSource extends BlockSource
/*     */   {
/* 401 */     private static final BlockReleaser RELEASER = BlockReleaser.SOLE_INSTANCE;
/* 402 */     private static final BlockReleaserListener LISTENER = BlockReleaserListener.SOLE_INSTANCE;
/*     */ 
/* 404 */     private static final Collection<WeakReference<ThreadedCachingBlockSource>> ALL_INSTANCES = new LinkedList();
/*     */     private static final int INITIAL_CACHE_SIZE = 32;
/* 447 */     private int top = 0;
/* 448 */     private byte[][] stack = new byte[32][];
/*     */ 
/* 450 */     private int lowWaterMark = 0;
/* 451 */     private int recentLowWaterMark = 0;
/*     */ 
/*     */     private static void releaseFromAllSources()
/*     */     {
/* 409 */       synchronized (ALL_INSTANCES) {
/* 410 */         Iterator localIterator = ALL_INSTANCES.iterator();
/* 411 */         while (localIterator.hasNext()) {
/* 412 */           ThreadedCachingBlockSource localThreadedCachingBlockSource = (ThreadedCachingBlockSource)((WeakReference)localIterator.next()).get();
/* 413 */           if (localThreadedCachingBlockSource == null) localIterator.remove(); else
/* 414 */             localThreadedCachingBlockSource.releaseUnusedBlocks();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     static BlockSource createBlockSource()
/*     */     {
/* 429 */       ThreadedCachingBlockSource localThreadedCachingBlockSource = new ThreadedCachingBlockSource();
/* 430 */       WeakReference localWeakReference = new WeakReference(localThreadedCachingBlockSource);
/* 431 */       synchronized (ALL_INSTANCES) {
/* 432 */         ALL_INSTANCES.add(localWeakReference);
/*     */       }
/* 434 */       return localThreadedCachingBlockSource;
/*     */     }
/*     */ 
/*     */     final synchronized void releaseUnusedBlocks()
/*     */     {
/* 461 */       assert (this.top >= this.recentLowWaterMark);
/*     */ 
/* 464 */       this.lowWaterMark = Math.min((this.lowWaterMark + this.recentLowWaterMark) / 2, this.recentLowWaterMark);
/* 465 */       int i = this.top - this.lowWaterMark;
/*     */ 
/* 467 */       while (this.top > i) this.stack[(--this.top)] = null;
/* 468 */       this.recentLowWaterMark = this.top;
/*     */     }
/*     */ 
/*     */     private final void checkLowWater()
/*     */     {
/* 476 */       this.recentLowWaterMark = Math.min(this.recentLowWaterMark, this.top);
/*     */     }
/*     */ 
/*     */     final int getBlockSize()
/*     */     {
/* 485 */       return 32768;
/*     */     }
/*     */ 
/*     */     final synchronized byte[] get()
/*     */     {
/* 491 */       if (this.top == 0) return new byte[32768];
/*     */ 
/* 493 */       byte[] arrayOfByte = this.stack[(--this.top)];
/* 494 */       checkLowWater();
/* 495 */       return arrayOfByte;
/*     */     }
/*     */ 
/*     */     final synchronized void put(byte[] paramArrayOfByte)
/*     */     {
/* 502 */       assert (paramArrayOfByte.length == 32768) : ("block.length: " + paramArrayOfByte.length);
/* 503 */       if (this.top == this.stack.length)
/*     */       {
/* 505 */         byte[][] arrayOfByte = new byte[this.stack.length * 4][];
/* 506 */         System.arraycopy(this.stack, 0, arrayOfByte, 0, this.stack.length);
/* 507 */         this.stack = arrayOfByte;
/*     */       }
/* 509 */       this.stack[(this.top++)] = paramArrayOfByte;
/*     */     }
/*     */ 
/*     */     private static final class BlockReleaserListener
/*     */       implements NotificationListener
/*     */     {
/* 348 */       private static final BlockReleaserListener SOLE_INSTANCE = new BlockReleaserListener();
/*     */ 
/*     */       private BlockReleaserListener()
/*     */       {
/* 358 */         MemoryMXBean localMemoryMXBean = ManagementFactory.getMemoryMXBean();
/* 359 */         NotificationEmitter localNotificationEmitter = (NotificationEmitter)localMemoryMXBean;
/*     */ 
/* 361 */         localNotificationEmitter.addNotificationListener(this, null, null);
/*     */ 
/* 363 */         Pattern localPattern = Pattern.compile(".*Old.*");
/* 364 */         for (MemoryPoolMXBean localMemoryPoolMXBean1 : ManagementFactory.getMemoryPoolMXBeans())
/* 365 */           if ((localMemoryPoolMXBean1.getType() == MemoryType.HEAP) && (localMemoryPoolMXBean1.isCollectionUsageThresholdSupported()) && (localPattern.matcher(localMemoryPoolMXBean1.getName()).matches()) && (localMemoryPoolMXBean1.getCollectionUsageThreshold() == 0L))
/*     */           {
/* 369 */             MemoryUsage localMemoryUsage = localMemoryPoolMXBean1.getUsage();
/* 370 */             final long l = ()(localMemoryUsage.getMax() == -1L ? Runtime.getRuntime().maxMemory() * 0.9D : localMemoryUsage.getMax() * 0.9D);
/*     */ 
/* 372 */             final MemoryPoolMXBean localMemoryPoolMXBean2 = localMemoryPoolMXBean1;
/*     */ 
/* 374 */             AccessController.doPrivileged(new PrivilegedAction() {
/*     */               public Object run() {
/* 376 */                 localMemoryPoolMXBean2.setCollectionUsageThreshold(l);
/* 377 */                 return null;
/*     */               }
/*     */             });
/*     */           }
/*     */       }
/*     */ 
/*     */       public void handleNotification(Notification paramNotification, Object paramObject)
/*     */       {
/* 391 */         String str = paramNotification.getType();
/* 392 */         if (str.equals("java.management.memory.collection.threshold.exceeded"))
/*     */         {
/* 394 */           BlockSource.ThreadedCachingBlockSource.BlockReleaser.releaseAllUnusedBlocks();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     private static final class BlockReleaser extends Thread
/*     */     {
/*     */       private static final String BLOCK_RELEASER_THREAD_NAME = "oracle.jdbc.driver.BlockSource.ThreadedCachingBlockSource.BlockReleaser";
/*     */       private static final int DELAY_MILLIS = 300000;
/* 291 */       private static final BlockReleaser SOLE_INSTANCE = new BlockReleaser();
/*     */ 
/*     */       static void releaseAllUnusedBlocks()
/*     */       {
/* 300 */         synchronized (SOLE_INSTANCE) {
/* 301 */           SOLE_INSTANCE.notifyAll();
/*     */         }
/*     */       }
/*     */ 
/*     */       private BlockReleaser()
/*     */       {
/* 311 */         super();
/* 312 */         setDaemon(true);
/* 313 */         setPriority(4);
/* 314 */         start();
/*     */       }
/*     */ 
/*     */       public void run()
/*     */       {
/*     */         while (true)
/*     */           try
/*     */           {
/* 326 */             synchronized (SOLE_INSTANCE) {
/* 327 */               SOLE_INSTANCE.wait(300000L);
/*     */             }
/*     */ 
/* 330 */             BlockSource.ThreadedCachingBlockSource.access$100();
/*     */           }
/*     */           catch (Throwable localThrowable)
/*     */           {
/*     */           }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static final class SimpleCachingBlockSource extends BlockSource
/*     */   {
/*     */     private static final int INITIAL_CACHE_SIZE = 32;
/*     */     private static final long RELEASE_NANOS = 300000000L;
/* 178 */     private int top = 0;
/* 179 */     private byte[][] stack = new byte[32][];
/*     */ 
/* 181 */     private int lowWaterMark = 0;
/* 182 */     private int recentLowWaterMark = 0;
/* 183 */     private long nextReleaseNanos = System.nanoTime() + 300000000L;
/*     */ 
/*     */     static BlockSource createBlockSource()
/*     */     {
/* 164 */       return new SimpleCachingBlockSource();
/*     */     }
/*     */ 
/*     */     final void releaseUnusedBlocks()
/*     */     {
/* 193 */       long l = System.nanoTime();
/* 194 */       if (l < this.nextReleaseNanos) return;
/*     */ 
/* 196 */       this.nextReleaseNanos = (l + 300000000L);
/* 197 */       assert (this.top >= this.recentLowWaterMark);
/*     */ 
/* 200 */       this.lowWaterMark = Math.min((this.lowWaterMark + this.recentLowWaterMark) / 2, this.recentLowWaterMark);
/* 201 */       int i = this.top - this.lowWaterMark;
/*     */ 
/* 203 */       while (this.top > i) this.stack[(--this.top)] = null;
/* 204 */       this.recentLowWaterMark = this.top;
/*     */     }
/*     */ 
/*     */     private final void checkLowWater()
/*     */     {
/* 213 */       this.recentLowWaterMark = Math.min(this.recentLowWaterMark, this.top);
/*     */     }
/*     */ 
/*     */     final int getBlockSize()
/*     */     {
/* 222 */       return 32768;
/*     */     }
/*     */ 
/*     */     final byte[] get()
/*     */     {
/* 228 */       if (this.top == 0) return new byte[32768];
/*     */ 
/* 230 */       byte[] arrayOfByte = this.stack[(--this.top)];
/* 231 */       checkLowWater();
/* 232 */       return arrayOfByte;
/*     */     }
/*     */ 
/*     */     final void put(byte[] paramArrayOfByte)
/*     */     {
/* 239 */       assert (paramArrayOfByte.length == 32768) : ("block.length: " + paramArrayOfByte.length);
/* 240 */       if (this.top == this.stack.length)
/*     */       {
/* 242 */         byte[][] arrayOfByte = new byte[this.stack.length * 4][];
/* 243 */         System.arraycopy(this.stack, 0, arrayOfByte, 0, this.stack.length);
/* 244 */         this.stack = arrayOfByte;
/*     */       }
/* 246 */       this.stack[(this.top++)] = paramArrayOfByte;
/* 247 */       releaseUnusedBlocks();
/*     */     }
/*     */   }
/*     */ 
/*     */   static class DumbBlockSource extends BlockSource
/*     */   {
/*     */     static final BlockSource createBlockSource()
/*     */     {
/* 119 */       return new DumbBlockSource();
/*     */     }
/*     */ 
/*     */     final int getBlockSize()
/*     */     {
/* 131 */       return 32768;
/*     */     }
/*     */ 
/*     */     final byte[] get()
/*     */     {
/* 137 */       return new byte[32768];
/*     */     }
/*     */ 
/*     */     final void put(byte[] paramArrayOfByte)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   static enum Implementation
/*     */   {
/*  63 */     DUMB, SIMPLE, SOFT, THREADED;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.BlockSource
 * JD-Core Version:    0.6.2
 */