/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.sql.BLOB;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ class BlobAccessor extends LobCommonAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 4000;
/* 273 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   BlobAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  29 */     super(Representation.BLOB, paramOracleStatement, 4000, paramBoolean);
/*     */ 
/*  31 */     init(paramOracleStatement, 113, 113, paramShort, paramBoolean);
/*  32 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   BlobAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  40 */     super(Representation.BLOB, paramOracleStatement, 4000, false);
/*     */ 
/*  42 */     init(paramOracleStatement, 113, 113, paramShort, false);
/*  43 */     initForDescribe(113, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  45 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  66 */     return getBLOB(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/*  83 */     return getBLOB(paramInt);
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 105 */     return getBLOB(paramInt);
/*     */   }
/*     */ 
/*     */   BLOB getBLOB(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 124 */     if (isNull(paramInt)) return null;
/*     */ 
/* 126 */     BLOB localBLOB = new BLOB(this.statement.connection, getBytesInternal(paramInt));
/*     */ 
/* 132 */     if (isPrefetched())
/*     */     {
/* 134 */       localBLOB.setActivePrefetch(true);
/* 135 */       localBLOB.setLength(getPrefetchedLength(paramInt));
/* 136 */       localBLOB.setChunkSize(getPrefetchedChunkSize(paramInt));
/*     */ 
/* 138 */       localBLOB.setPrefetchedData(getPrefetchedData(paramInt));
/*     */     }
/* 140 */     return localBLOB;
/*     */   }
/*     */ 
/*     */   InputStream getAsciiStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 158 */     BLOB localBLOB = getBLOB(paramInt);
/*     */ 
/* 160 */     if (localBLOB == null) {
/* 161 */       return null;
/*     */     }
/* 163 */     return localBLOB.asciiStreamValue();
/*     */   }
/*     */ 
/*     */   Reader getCharacterStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 179 */     BLOB localBLOB = getBLOB(paramInt);
/*     */ 
/* 181 */     if (localBLOB == null) {
/* 182 */       return null;
/*     */     }
/* 184 */     return localBLOB.characterStreamValue();
/*     */   }
/*     */ 
/*     */   InputStream getBinaryStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 200 */     BLOB localBLOB = getBLOB(paramInt);
/*     */ 
/* 202 */     if (localBLOB == null) {
/* 203 */       return null;
/*     */     }
/* 205 */     return localBLOB.getBinaryStream();
/*     */   }
/*     */ 
/*     */   byte[] getBytes(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 221 */     if (isNull(paramInt)) return null;
/* 222 */     if ((isPrefetched()) && (getPrefetchedLength(paramInt) > 2147483647L))
/*     */     {
/* 227 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 151);
/* 228 */       ((SQLException)localObject).fillInStackTrace();
/* 229 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 232 */     if ((isPrefetched()) && (getPrefetchedDataLength(paramInt) == getPrefetchedLength(paramInt)))
/*     */     {
/* 235 */       return getPrefetchedData(paramInt);
/*     */     }
/*     */ 
/* 238 */     Object localObject = getBLOB(paramInt);
/* 239 */     if (localObject == null) return null;
/* 240 */     return ((BLOB)localObject).getBytes(1L, (int)((BLOB)localObject).length());
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 250 */     unimpl("getString/getNString");
/* 251 */     return null;
/*     */   }
/*     */ 
/*     */   String getNString(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 259 */     unimpl("getNString");
/* 260 */     return null;
/*     */   }
/*     */ 
/*     */   long updateChecksum(long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 267 */     unimpl("updateChecksum");
/* 268 */     return -1L;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.BlobAccessor
 * JD-Core Version:    0.6.2
 */