/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ class BinaryFloatBinder extends Binder
/*       */ {
/* 19719 */   Binder theBinaryFloatCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatCopyingBinder;
/*       */ 
/* 19801 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   static void init(Binder paramBinder)
/*       */   {
/* 19725 */     paramBinder.type = 100;
/* 19726 */     paramBinder.bytelen = 4;
/*       */   }
/*       */ 
/*       */   BinaryFloatBinder()
/*       */   {
/* 19733 */     init(this);
/*       */   }
/*       */ 
/*       */   Binder copyingBinder()
/*       */   {
/* 19740 */     return this.theBinaryFloatCopyingBinder;
/*       */   }
/*       */ 
/*       */   long bind(OraclePreparedStatement paramOraclePreparedStatement, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte, char[] paramArrayOfChar, short[] paramArrayOfShort, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, int paramInt9, boolean paramBoolean, long paramLong)
/*       */   {
/* 19752 */     byte[] arrayOfByte = paramArrayOfByte;
/* 19753 */     int i = paramInt6;
/* 19754 */     float f = paramOraclePreparedStatement.parameterFloat[paramInt3][paramInt1];
/*       */ 
/* 19756 */     if (f == 0.0D)
/* 19757 */       f = 0.0F;
/* 19758 */     else if (f != f) {
/* 19759 */       f = (0.0F / 0.0F);
/*       */     }
/* 19761 */     int j = Float.floatToIntBits(f);
/*       */ 
/* 19765 */     int k = j;
/*       */ 
/* 19767 */     j >>= 8;
/*       */ 
/* 19769 */     int m = j;
/*       */ 
/* 19771 */     j >>= 8;
/*       */ 
/* 19773 */     int n = j;
/*       */ 
/* 19775 */     j >>= 8;
/*       */ 
/* 19777 */     int i1 = j;
/*       */ 
/* 19779 */     if ((i1 & 0x80) == 0) {
/* 19780 */       i1 |= 128;
/*       */     }
/*       */     else {
/* 19783 */       i1 ^= -1;
/* 19784 */       n ^= -1;
/* 19785 */       m ^= -1;
/* 19786 */       k ^= -1;
/*       */     }
/*       */ 
/* 19789 */     arrayOfByte[(i + 3)] = ((byte)k);
/* 19790 */     arrayOfByte[(i + 2)] = ((byte)m);
/* 19791 */     arrayOfByte[(i + 1)] = ((byte)n);
/* 19792 */     arrayOfByte[i] = ((byte)i1);
/*       */ 
/* 19794 */     paramArrayOfShort[paramInt9] = 0;
/* 19795 */     paramArrayOfShort[paramInt8] = 4;
/* 19796 */     return paramLong;
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.BinaryFloatBinder
 * JD-Core Version:    0.6.2
 */