/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.sql.BINARY_FLOAT;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.NUMBER;
/*     */ 
/*     */ class BinaryFloatAccessor extends Accessor
/*     */ {
/*     */   static final int MAXLENGTH = 4;
/*     */   private final byte[] tmpBytes;
/* 297 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   BinaryFloatAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  28 */     super(Representation.BINARY_FLOAT, paramOracleStatement, 4, paramBoolean);
/*     */ 
/*  30 */     this.tmpBytes = new byte[this.representationMaxLength];
/*  31 */     init(paramOracleStatement, 100, 100, paramShort, paramBoolean);
/*  32 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   BinaryFloatAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  40 */     super(Representation.BINARY_FLOAT, paramOracleStatement, 4, false);
/*     */ 
/*  42 */     this.tmpBytes = new byte[this.representationMaxLength];
/*  43 */     init(paramOracleStatement, 100, 100, paramShort, false);
/*  44 */     initForDescribe(100, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  47 */     int i = paramOracleStatement.maxFieldSize;
/*     */ 
/*  49 */     if ((i > 0) && ((paramInt1 == 0) || (i < paramInt1))) {
/*  50 */       paramInt1 = i;
/*     */     }
/*  52 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   void init(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, int paramInt3, short paramShort, int paramInt4)
/*     */     throws SQLException
/*     */   {
/*  60 */     init(paramOracleStatement, paramInt1, paramInt2, paramShort, false);
/*  61 */     initForDataAccess(paramInt4, paramInt3, null);
/*     */   }
/*     */ 
/*     */   void init(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  70 */     init(paramOracleStatement, paramInt1, paramInt2, paramShort, false);
/*  71 */     initForDescribe(paramInt1, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort, null);
/*     */ 
/*  74 */     int i = paramOracleStatement.maxFieldSize;
/*     */ 
/*  76 */     if ((i > 0) && ((paramInt3 == 0) || (i < paramInt3))) {
/*  77 */       paramInt3 = i;
/*     */     }
/*  79 */     initForDataAccess(0, paramInt3, null);
/*     */   }
/*     */ 
/*     */   float getFloat(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  98 */     if (isNull(paramInt)) return 0.0F;
/*     */ 
/* 121 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, this.representationMaxLength);
/* 122 */     int i = this.tmpBytes[0];
/* 123 */     int j = this.tmpBytes[1];
/* 124 */     int k = this.tmpBytes[2];
/* 125 */     int m = this.tmpBytes[3];
/*     */ 
/* 127 */     if ((i & 0x80) != 0)
/*     */     {
/* 129 */       i &= 127;
/* 130 */       j &= 255;
/* 131 */       k &= 255;
/* 132 */       m &= 255;
/*     */     }
/*     */     else
/*     */     {
/* 136 */       i = (i ^ 0xFFFFFFFF) & 0xFF;
/* 137 */       j = (j ^ 0xFFFFFFFF) & 0xFF;
/* 138 */       k = (k ^ 0xFFFFFFFF) & 0xFF;
/* 139 */       m = (m ^ 0xFFFFFFFF) & 0xFF;
/*     */     }
/*     */ 
/* 142 */     int n = i << 24 | j << 16 | k << 8 | m;
/*     */ 
/* 144 */     return Float.intBitsToFloat(n);
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 158 */     if (isNull(paramInt)) {
/* 159 */       return null;
/*     */     }
/* 161 */     return Float.toString(getFloat(paramInt));
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 175 */     if (isNull(paramInt)) {
/* 176 */       return null;
/*     */     }
/* 178 */     return new Float(getFloat(paramInt));
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 193 */     if (isNull(paramInt)) {
/* 194 */       return null;
/*     */     }
/* 196 */     return new Float(getFloat(paramInt));
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 210 */     return getBINARY_FLOAT(paramInt);
/*     */   }
/*     */ 
/*     */   BINARY_FLOAT getBINARY_FLOAT(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 224 */     if (isNull(paramInt)) {
/* 225 */       return null;
/*     */     }
/* 227 */     return new BINARY_FLOAT(this.rowData.get(getOffset(paramInt), getLength(paramInt)));
/*     */   }
/*     */ 
/*     */   NUMBER getNUMBER(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 234 */     if (isNull(paramInt)) {
/* 235 */       return null;
/*     */     }
/* 237 */     return new NUMBER(getFloat(paramInt));
/*     */   }
/*     */ 
/*     */   BigInteger getBigInteger(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 244 */     if (isNull(paramInt)) {
/* 245 */       return null;
/*     */     }
/* 247 */     return new BigInteger(getString(paramInt));
/*     */   }
/*     */ 
/*     */   BigDecimal getBigDecimal(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 254 */     if (isNull(paramInt)) {
/* 255 */       return null;
/*     */     }
/* 257 */     return new BigDecimal(getString(paramInt));
/*     */   }
/*     */ 
/*     */   byte getByte(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 264 */     return (byte)(int)getFloat(paramInt);
/*     */   }
/*     */ 
/*     */   short getShort(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 271 */     return (short)(int)getFloat(paramInt);
/*     */   }
/*     */ 
/*     */   int getInt(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 278 */     return (int)getFloat(paramInt);
/*     */   }
/*     */ 
/*     */   long getLong(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 285 */     return ()getFloat(paramInt);
/*     */   }
/*     */ 
/*     */   double getDouble(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 292 */     return getFloat(paramInt);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.BinaryFloatAccessor
 * JD-Core Version:    0.6.2
 */