/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.sql.BINARY_DOUBLE;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.NUMBER;
/*     */ 
/*     */ class BinaryDoubleAccessor extends Accessor
/*     */ {
/*     */   static final int MAXLENGTH = 8;
/*     */   private final byte[] tmpBytes;
/* 288 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   BinaryDoubleAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  28 */     super(Representation.BINARY_DOUBLE, paramOracleStatement, 8, paramBoolean);
/*     */ 
/*  30 */     this.tmpBytes = new byte[this.representationMaxLength];
/*  31 */     init(paramOracleStatement, 101, 101, paramShort, paramBoolean);
/*  32 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   BinaryDoubleAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  40 */     super(Representation.BINARY_DOUBLE, paramOracleStatement, 8, false);
/*     */ 
/*  42 */     this.tmpBytes = new byte[this.representationMaxLength];
/*  43 */     init(paramOracleStatement, 101, 101, paramShort, false);
/*  44 */     initForDescribe(101, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  47 */     int i = paramOracleStatement.maxFieldSize;
/*     */ 
/*  49 */     if ((i > 0) && ((paramInt1 == 0) || (i < paramInt1))) {
/*  50 */       paramInt1 = i;
/*     */     }
/*  52 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   void init(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, int paramInt3, short paramShort, int paramInt4)
/*     */     throws SQLException
/*     */   {
/*  60 */     init(paramOracleStatement, paramInt1, paramInt2, paramShort, false);
/*  61 */     initForDataAccess(paramInt4, paramInt3, null);
/*     */   }
/*     */ 
/*     */   void init(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  70 */     init(paramOracleStatement, paramInt1, paramInt2, paramShort, false);
/*  71 */     initForDescribe(paramInt1, paramInt3, paramBoolean, paramInt4, paramInt5, paramInt6, paramInt7, paramInt8, paramShort, null);
/*     */ 
/*  74 */     int i = paramOracleStatement.maxFieldSize;
/*     */ 
/*  76 */     if ((i > 0) && ((paramInt3 == 0) || (i < paramInt3))) {
/*  77 */       paramInt3 = i;
/*     */     }
/*  79 */     initForDataAccess(0, paramInt3, null);
/*     */   }
/*     */ 
/*     */   double getDouble(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 100 */     if (isNull(paramInt)) return 0.0D;
/*     */ 
/* 113 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, this.representationMaxLength);
/* 114 */     int i = this.tmpBytes[0];
/* 115 */     int j = this.tmpBytes[1];
/* 116 */     int k = this.tmpBytes[2];
/* 117 */     int m = this.tmpBytes[3];
/* 118 */     int n = this.tmpBytes[4];
/* 119 */     int i1 = this.tmpBytes[5];
/* 120 */     int i2 = this.tmpBytes[6];
/* 121 */     int i3 = this.tmpBytes[7];
/*     */ 
/* 123 */     if ((i & 0x80) != 0)
/*     */     {
/* 125 */       i &= 127;
/* 126 */       j &= 255;
/* 127 */       k &= 255;
/* 128 */       m &= 255;
/* 129 */       n &= 255;
/* 130 */       i1 &= 255;
/* 131 */       i2 &= 255;
/* 132 */       i3 &= 255;
/*     */     }
/*     */     else
/*     */     {
/* 136 */       i = (i ^ 0xFFFFFFFF) & 0xFF;
/* 137 */       j = (j ^ 0xFFFFFFFF) & 0xFF;
/* 138 */       k = (k ^ 0xFFFFFFFF) & 0xFF;
/* 139 */       m = (m ^ 0xFFFFFFFF) & 0xFF;
/* 140 */       n = (n ^ 0xFFFFFFFF) & 0xFF;
/* 141 */       i1 = (i1 ^ 0xFFFFFFFF) & 0xFF;
/* 142 */       i2 = (i2 ^ 0xFFFFFFFF) & 0xFF;
/* 143 */       i3 = (i3 ^ 0xFFFFFFFF) & 0xFF;
/*     */     }
/*     */ 
/* 146 */     int i4 = i << 24 | j << 16 | k << 8 | m;
/* 147 */     int i5 = n << 24 | i1 << 16 | i2 << 8 | i3;
/* 148 */     long l = i4 << 32 | i5 & 0xFFFFFFFF;
/*     */ 
/* 150 */     return Double.longBitsToDouble(l);
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 164 */     if (isNull(paramInt)) return null;
/* 165 */     return Double.toString(getDouble(paramInt));
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 179 */     if (isNull(paramInt)) return null;
/* 180 */     return new Double(getDouble(paramInt));
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 195 */     return new Double(getDouble(paramInt));
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 209 */     return getBINARY_DOUBLE(paramInt);
/*     */   }
/*     */ 
/*     */   BINARY_DOUBLE getBINARY_DOUBLE(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 223 */     if (isNull(paramInt)) return null;
/* 224 */     return new BINARY_DOUBLE(this.rowData.get(getOffset(paramInt), getLength(paramInt)));
/*     */   }
/*     */ 
/*     */   NUMBER getNUMBER(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 231 */     if (isNull(paramInt)) return null;
/* 232 */     return new NUMBER(getDouble(paramInt));
/*     */   }
/*     */ 
/*     */   BigInteger getBigInteger(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 239 */     if (isNull(paramInt)) return null;
/* 240 */     return new BigInteger(getString(paramInt));
/*     */   }
/*     */ 
/*     */   BigDecimal getBigDecimal(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 247 */     if (isNull(paramInt)) return null;
/* 248 */     return new BigDecimal(getString(paramInt));
/*     */   }
/*     */ 
/*     */   byte getByte(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 255 */     return (byte)(int)getDouble(paramInt);
/*     */   }
/*     */ 
/*     */   short getShort(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 262 */     return (short)(int)getDouble(paramInt);
/*     */   }
/*     */ 
/*     */   int getInt(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 269 */     return (int)getDouble(paramInt);
/*     */   }
/*     */ 
/*     */   long getLong(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 276 */     return ()getDouble(paramInt);
/*     */   }
/*     */ 
/*     */   float getFloat(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 283 */     return (float)getDouble(paramInt);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.BinaryDoubleAccessor
 * JD-Core Version:    0.6.2
 */