/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.sql.BFILE;
/*     */ import oracle.sql.Datum;
/*     */ 
/*     */ class BfileAccessor extends LobCommonAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 530;
/* 248 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   BfileAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  29 */     super(Representation.BFILE, paramOracleStatement, 530, paramBoolean);
/*     */ 
/*  31 */     init(paramOracleStatement, 114, 114, paramShort, paramBoolean);
/*  32 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   BfileAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  40 */     super(Representation.BFILE, paramOracleStatement, 530, false);
/*     */ 
/*  42 */     init(paramOracleStatement, 114, 114, paramShort, false);
/*  43 */     initForDescribe(114, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  45 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  65 */     return getBFILE(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/*  82 */     return getBFILE(paramInt);
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 104 */     return getBFILE(paramInt);
/*     */   }
/*     */ 
/*     */   BFILE getBFILE(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 122 */     if (isNull(paramInt)) return null;
/*     */ 
/* 124 */     BFILE localBFILE = new BFILE(this.statement.connection, getBytesInternal(paramInt));
/* 125 */     if (isPrefetched()) localBFILE.setLength(getPrefetchedLength(paramInt));
/* 126 */     return localBFILE;
/*     */   }
/*     */ 
/*     */   InputStream getAsciiStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 144 */     BFILE localBFILE = getBFILE(paramInt);
/*     */ 
/* 146 */     if (localBFILE == null) {
/* 147 */       return null;
/*     */     }
/* 149 */     return localBFILE.asciiStreamValue();
/*     */   }
/*     */ 
/*     */   Reader getCharacterStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 165 */     BFILE localBFILE = getBFILE(paramInt);
/*     */ 
/* 167 */     if (localBFILE == null) {
/* 168 */       return null;
/*     */     }
/* 170 */     return localBFILE.characterStreamValue();
/*     */   }
/*     */ 
/*     */   InputStream getBinaryStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 186 */     BFILE localBFILE = getBFILE(paramInt);
/*     */ 
/* 188 */     if (localBFILE == null) {
/* 189 */       return null;
/*     */     }
/* 191 */     return localBFILE.getBinaryStream();
/*     */   }
/*     */ 
/*     */   byte[] getBytes(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 208 */     BFILE localBFILE = getBFILE(paramInt);
/*     */ 
/* 210 */     if (localBFILE == null) {
/* 211 */       return null;
/*     */     }
/* 213 */     InputStream localInputStream = localBFILE.getBinaryStream();
/* 214 */     int i = 4096;
/* 215 */     int j = 0;
/* 216 */     ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream(i);
/* 217 */     byte[] arrayOfByte = new byte[i];
/*     */     try
/*     */     {
/* 221 */       while ((j = localInputStream.read(arrayOfByte)) != -1)
/*     */       {
/* 223 */         localByteArrayOutputStream.write(arrayOfByte, 0, j);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 229 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 230 */       localSQLException.fillInStackTrace();
/* 231 */       throw localSQLException;
/*     */     }
/*     */     catch (IndexOutOfBoundsException localIndexOutOfBoundsException)
/*     */     {
/* 237 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 151);
/* 238 */       localSQLException.fillInStackTrace();
/* 239 */       throw localSQLException;
/*     */     }
/*     */ 
/* 243 */     return localByteArrayOutputStream.toByteArray();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.BfileAccessor
 * JD-Core Version:    0.6.2
 */