/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class AutoKeyInfo extends OracleResultSetMetaData
/*     */ {
/*     */   String originalSql;
/*     */   String newSql;
/*     */   String tableName;
/*  25 */   OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
/*     */   int sqlParserParamCount;
/*     */   String[] sqlParserParamList;
/*     */   boolean useNamedParameter;
/*     */   int current_argument;
/*     */   String[] columnNames;
/*     */   int[] columnIndexes;
/*     */   int numColumns;
/*     */   String[] tableColumnNames;
/*     */   int[] tableColumnTypes;
/*     */   int[] tableMaxLengths;
/*     */   boolean[] tableNullables;
/*     */   short[] tableFormOfUses;
/*     */   int[] tablePrecisions;
/*     */   int[] tableScales;
/*     */   String[] tableTypeNames;
/*     */   int autoKeyType;
/*     */   static final int KEYFLAG = 0;
/*     */   static final int COLUMNAME = 1;
/*     */   static final int COLUMNINDEX = 2;
/*     */   static final char QMARK = '?';
/*     */   int[] returnTypes;
/*     */   Accessor[] returnAccessors;
/* 295 */   private static final ThreadLocal<OracleSql> SQL_PARSER = new ThreadLocal() {
/*     */     protected OracleSql initialValue() {
/* 297 */       return new OracleSql(null);
/*     */     }
/* 295 */   };
/*     */ 
/* 486 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   AutoKeyInfo(String paramString)
/*     */   {
/*  61 */     this.originalSql = paramString;
/*  62 */     this.autoKeyType = 0;
/*     */   }
/*     */ 
/*     */   AutoKeyInfo(String paramString, String[] paramArrayOfString)
/*     */   {
/*  69 */     this.originalSql = paramString;
/*  70 */     this.columnNames = paramArrayOfString;
/*  71 */     this.autoKeyType = 1;
/*     */   }
/*     */ 
/*     */   AutoKeyInfo(String paramString, int[] paramArrayOfInt)
/*     */   {
/*  78 */     this.originalSql = paramString;
/*  79 */     this.columnIndexes = paramArrayOfInt;
/*  80 */     this.autoKeyType = 2;
/*     */   }
/*     */ 
/*     */   private void parseSql() throws SQLException
/*     */   {
/*  85 */     if (this.originalSql == null)
/*     */     {
/*  87 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  88 */       ((SQLException)localObject).fillInStackTrace();
/*  89 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/*  92 */     Object localObject = (OracleSql)SQL_PARSER.get();
/*  93 */     ((OracleSql)localObject).initialize(this.originalSql);
/*     */ 
/* 107 */     this.sqlKind = ((OracleSql)localObject).getSqlKind();
/*     */ 
/* 110 */     if (this.sqlKind == OracleStatement.SqlKind.INSERT)
/*     */     {
/* 112 */       this.sqlParserParamCount = ((OracleSql)localObject).getParameterCount();
/* 113 */       this.sqlParserParamList = ((OracleSql)localObject).getParameterList();
/*     */ 
/* 115 */       if (this.sqlParserParamList == OracleSql.EMPTY_LIST) {
/* 116 */         this.useNamedParameter = false;
/*     */       }
/*     */       else {
/* 119 */         this.useNamedParameter = true;
/*     */ 
/* 121 */         this.current_argument = this.sqlParserParamCount;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String generateUniqueNamedParameter()
/*     */   {
/*     */     int i;
/*     */     String str;
/*     */     do
/*     */     {
/* 133 */       i = 0;
/* 134 */       str = Integer.toString(++this.current_argument).intern();
/*     */ 
/* 136 */       for (int j = 0; j < this.sqlParserParamCount; j++)
/*     */       {
/* 138 */         if (this.sqlParserParamList[j] == str)
/*     */         {
/* 140 */           i = 1;
/* 141 */           break;
/*     */         }
/*     */       }
/*     */     }
/* 144 */     while (i != 0);
/*     */ 
/* 146 */     return new StringBuilder().append(":").append(str).toString();
/*     */   }
/*     */ 
/*     */   String getNewSql()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 158 */       if (this.newSql != null) return this.newSql;
/*     */ 
/* 160 */       if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) parseSql();
/*     */ 
/* 162 */       switch (this.autoKeyType)
/*     */       {
/*     */       case 0:
/* 165 */         this.newSql = new StringBuilder().append(this.originalSql).append(" RETURNING ROWID INTO ").append(this.useNamedParameter ? generateUniqueNamedParameter() : Character.valueOf('?')).toString();
/*     */ 
/* 167 */         this.returnTypes = new int[1];
/* 168 */         this.returnTypes[0] = 104;
/* 169 */         break;
/*     */       case 1:
/* 171 */         getNewSqlByColumnName();
/* 172 */         break;
/*     */       case 2:
/* 174 */         getNewSqlByColumnIndexes();
/*     */       }
/*     */ 
/* 179 */       this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
/* 180 */       this.sqlParserParamList = null;
/* 181 */       return this.newSql;
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 186 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localException);
/* 187 */       localSQLException.fillInStackTrace();
/* 188 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getNewSqlByColumnName()
/*     */     throws SQLException
/*     */   {
/* 196 */     this.returnTypes = new int[this.columnNames.length];
/*     */ 
/* 199 */     this.columnIndexes = new int[this.columnNames.length];
/*     */ 
/* 201 */     StringBuffer localStringBuffer = new StringBuffer(this.originalSql);
/* 202 */     localStringBuffer.append(" RETURNING ");
/*     */ 
/* 205 */     for (int j = 0; j < this.columnNames.length; j++)
/*     */     {
/* 207 */       int i = getReturnParamTypeCode(j, this.columnNames[j], this.columnIndexes);
/* 208 */       this.returnTypes[j] = i;
/*     */ 
/* 210 */       localStringBuffer.append(this.columnNames[j]);
/*     */ 
/* 212 */       if (j < this.columnNames.length - 1) localStringBuffer.append(", ");
/*     */     }
/*     */ 
/* 215 */     localStringBuffer.append(" INTO ");
/*     */ 
/* 217 */     for (j = 0; j < this.columnNames.length - 1; j++)
/*     */     {
/* 219 */       localStringBuffer.append(new StringBuilder().append(this.useNamedParameter ? generateUniqueNamedParameter() : Character.valueOf('?')).append(", ").toString());
/*     */     }
/*     */ 
/* 222 */     localStringBuffer.append(this.useNamedParameter ? generateUniqueNamedParameter() : Character.valueOf('?'));
/*     */ 
/* 224 */     this.newSql = new String(localStringBuffer);
/* 225 */     return this.newSql;
/*     */   }
/*     */ 
/*     */   private String getNewSqlByColumnIndexes() throws SQLException
/*     */   {
/* 230 */     this.returnTypes = new int[this.columnIndexes.length];
/*     */ 
/* 232 */     StringBuffer localStringBuffer = new StringBuffer(this.originalSql);
/* 233 */     localStringBuffer.append(" RETURNING ");
/*     */ 
/* 238 */     for (int j = 0; j < this.columnIndexes.length; j++)
/*     */     {
/* 240 */       int k = this.columnIndexes[j] - 1;
/* 241 */       if ((k < 0) || (k > this.tableColumnNames.length))
/*     */       {
/* 244 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 245 */         localSQLException.fillInStackTrace();
/* 246 */         throw localSQLException;
/*     */       }
/*     */ 
/* 250 */       int i = this.tableColumnTypes[k];
/* 251 */       String str = this.tableColumnNames[k];
/* 252 */       this.returnTypes[j] = i;
/*     */ 
/* 254 */       localStringBuffer.append(str);
/*     */ 
/* 256 */       if (j < this.columnIndexes.length - 1) localStringBuffer.append(", ");
/*     */     }
/*     */ 
/* 259 */     localStringBuffer.append(" INTO ");
/*     */ 
/* 261 */     for (j = 0; j < this.columnIndexes.length - 1; j++)
/*     */     {
/* 263 */       localStringBuffer.append(new StringBuilder().append(this.useNamedParameter ? generateUniqueNamedParameter() : Character.valueOf('?')).append(", ").toString());
/*     */     }
/*     */ 
/* 266 */     localStringBuffer.append(this.useNamedParameter ? generateUniqueNamedParameter() : Character.valueOf('?'));
/*     */ 
/* 268 */     this.newSql = new String(localStringBuffer);
/* 269 */     return this.newSql;
/*     */   }
/*     */ 
/*     */   private final int getReturnParamTypeCode(int paramInt, String paramString, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 277 */     for (int i = 0; i < this.tableColumnNames.length; i++)
/*     */     {
/* 279 */       if (paramString.equalsIgnoreCase(this.tableColumnNames[i]))
/*     */       {
/* 281 */         paramArrayOfInt[paramInt] = (i + 1);
/* 282 */         return this.tableColumnTypes[i];
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 288 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 289 */     localSQLException.fillInStackTrace();
/* 290 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   final boolean isInsertSqlStmt()
/*     */     throws SQLException
/*     */   {
/* 303 */     if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
/* 304 */       parseSql();
/*     */     }
/* 306 */     return this.sqlKind == OracleStatement.SqlKind.INSERT;
/*     */   }
/*     */ 
/*     */   String getTableName() throws SQLException
/*     */   {
/* 311 */     if (this.tableName != null) return this.tableName;
/*     */ 
/* 313 */     String str = this.originalSql.trim().toUpperCase();
/*     */ 
/* 315 */     int i = str.indexOf("INSERT");
/* 316 */     i = str.indexOf("INTO", i);
/*     */ 
/* 318 */     if (i < 0)
/*     */     {
/* 320 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 321 */       localSQLException1.fillInStackTrace();
/* 322 */       throw localSQLException1;
/*     */     }
/*     */ 
/* 325 */     int j = str.length();
/* 326 */     int k = i + 5;
/*     */ 
/* 328 */     while ((k < j) && (str.charAt(k) == ' ')) k++;
/*     */ 
/* 330 */     if (k >= j)
/*     */     {
/* 332 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 333 */       localSQLException2.fillInStackTrace();
/* 334 */       throw localSQLException2;
/*     */     }
/*     */ 
/* 337 */     int m = k + 1;
/*     */ 
/* 340 */     while ((m < j) && (str.charAt(m) != ' ') && (str.charAt(m) != '(')) m++;
/*     */ 
/* 342 */     if (k == m - 1)
/*     */     {
/* 344 */       SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 345 */       localSQLException3.fillInStackTrace();
/* 346 */       throw localSQLException3;
/*     */     }
/*     */ 
/* 349 */     this.tableName = str.substring(k, m);
/*     */ 
/* 351 */     return this.tableName;
/*     */   }
/*     */ 
/*     */   void allocateSpaceForDescribedData(int paramInt) throws SQLException
/*     */   {
/* 356 */     this.numColumns = paramInt;
/*     */ 
/* 358 */     this.tableColumnNames = new String[paramInt];
/* 359 */     this.tableColumnTypes = new int[paramInt];
/* 360 */     this.tableMaxLengths = new int[paramInt];
/* 361 */     this.tableNullables = new boolean[paramInt];
/* 362 */     this.tableFormOfUses = new short[paramInt];
/* 363 */     this.tablePrecisions = new int[paramInt];
/* 364 */     this.tableScales = new int[paramInt];
/* 365 */     this.tableTypeNames = new String[paramInt];
/*     */   }
/*     */ 
/*     */   void fillDescribedData(int paramInt1, String paramString1, int paramInt2, int paramInt3, boolean paramBoolean, short paramShort, int paramInt4, int paramInt5, String paramString2)
/*     */     throws SQLException
/*     */   {
/* 373 */     this.tableColumnNames[paramInt1] = paramString1;
/* 374 */     this.tableColumnTypes[paramInt1] = paramInt2;
/* 375 */     this.tableMaxLengths[paramInt1] = paramInt3;
/* 376 */     this.tableNullables[paramInt1] = paramBoolean;
/* 377 */     this.tableFormOfUses[paramInt1] = paramShort;
/* 378 */     this.tablePrecisions[paramInt1] = paramInt4;
/* 379 */     this.tableScales[paramInt1] = paramInt5;
/* 380 */     this.tableTypeNames[paramInt1] = paramString2;
/*     */   }
/*     */ 
/*     */   void initMetaData(OracleResultSet paramOracleResultSet) throws SQLException {
/* 384 */     if (this.returnAccessors != null) return;
/*     */ 
/* 386 */     this.returnAccessors = paramOracleResultSet.getOracleStatement().accessors;
/*     */ 
/* 389 */     switch (this.autoKeyType)
/*     */     {
/*     */     case 0:
/* 392 */       initMetaDataKeyFlag();
/* 393 */       break;
/*     */     case 1:
/*     */     case 2:
/* 396 */       initMetaDataColumnIndexes();
/*     */     }
/*     */   }
/*     */ 
/*     */   void initMetaDataKeyFlag()
/*     */     throws SQLException
/*     */   {
/* 404 */     this.returnAccessors[0].columnName = "ROWID";
/* 405 */     this.returnAccessors[0].describeType = 104;
/* 406 */     this.returnAccessors[0].describeMaxLength = 4;
/* 407 */     this.returnAccessors[0].nullable = true;
/* 408 */     this.returnAccessors[0].precision = 0;
/* 409 */     this.returnAccessors[0].scale = 0;
/* 410 */     this.returnAccessors[0].formOfUse = 0;
/*     */   }
/*     */ 
/*     */   void initMetaDataColumnIndexes()
/*     */     throws SQLException
/*     */   {
/* 418 */     for (int j = 0; j < this.returnAccessors.length; j++)
/*     */     {
/* 420 */       Accessor localAccessor = this.returnAccessors[j];
/* 421 */       int i = this.columnIndexes[j] - 1;
/*     */ 
/* 423 */       localAccessor.columnName = this.tableColumnNames[i];
/* 424 */       localAccessor.describeType = this.tableColumnTypes[i];
/* 425 */       localAccessor.describeMaxLength = this.tableMaxLengths[i];
/* 426 */       localAccessor.nullable = this.tableNullables[i];
/* 427 */       localAccessor.precision = this.tablePrecisions[i];
/* 428 */       localAccessor.scale = this.tablePrecisions[i];
/* 429 */       localAccessor.formOfUse = this.tableFormOfUses[i];
/*     */     }
/*     */   }
/*     */ 
/*     */   int getValidColumnIndex(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 439 */     if ((paramInt <= 0) || (paramInt > this.returnAccessors.length))
/*     */     {
/* 441 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 442 */       localSQLException.fillInStackTrace();
/* 443 */       throw localSQLException;
/*     */     }
/*     */ 
/* 446 */     return paramInt - 1;
/*     */   }
/*     */ 
/*     */   public int getColumnCount() throws SQLException
/*     */   {
/* 451 */     return this.returnAccessors.length;
/*     */   }
/*     */ 
/*     */   public String getColumnName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 457 */     if ((paramInt <= 0) || (paramInt > this.returnAccessors.length))
/*     */     {
/* 459 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 460 */       localSQLException.fillInStackTrace();
/* 461 */       throw localSQLException;
/*     */     }
/*     */ 
/* 464 */     return this.returnAccessors[(paramInt - 1)].columnName;
/*     */   }
/*     */ 
/*     */   public String getTableName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 470 */     if ((paramInt <= 0) || (paramInt > this.returnAccessors.length))
/*     */     {
/* 472 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 473 */       localSQLException.fillInStackTrace();
/* 474 */       throw localSQLException;
/*     */     }
/*     */ 
/* 477 */     return getTableName();
/*     */   }
/*     */ 
/*     */   Accessor[] getDescription() throws SQLException
/*     */   {
/* 482 */     return this.returnAccessors;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.AutoKeyInfo
 * JD-Core Version:    0.6.2
 */