/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.sql.ARRAY;
/*     */ import oracle.sql.ArrayDescriptor;
/*     */ 
/*     */ class ArrayLocatorResultSet extends ForwardOnlyResultSet
/*     */ {
/*  23 */   static int COUNT_UNLIMITED = -1;
/*     */   Map map;
/*     */   long beginIndex;
/*     */   int count;
/*     */   long currentIndex;
/* 235 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   static ArrayLocatorResultSet create(PhysicalConnection paramPhysicalConnection, ArrayDescriptor paramArrayDescriptor, byte[] paramArrayOfByte, Map paramMap)
/*     */     throws SQLException
/*     */   {
/*  40 */     return create(paramPhysicalConnection, paramArrayDescriptor, paramArrayOfByte, 0L, COUNT_UNLIMITED, paramMap);
/*     */   }
/*     */ 
/*     */   static ArrayLocatorResultSet create(PhysicalConnection paramPhysicalConnection, ArrayDescriptor paramArrayDescriptor, byte[] paramArrayOfByte, long paramLong, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/*  69 */     OraclePreparedStatement localOraclePreparedStatement = null;
/*     */ 
/*  72 */     ARRAY localARRAY = new ARRAY(paramArrayDescriptor, paramPhysicalConnection, (byte[])null);
/*  73 */     localARRAY.setLocator(paramArrayOfByte);
/*     */ 
/*  76 */     if ((paramArrayDescriptor.getBaseType() == 2002) || (paramArrayDescriptor.getBaseType() == 2008))
/*     */     {
/*  80 */       localOraclePreparedStatement = paramPhysicalConnection.prepareStatementInternal("SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(:1 AS " + paramArrayDescriptor.getName() + ") )", 1003, 1007);
/*     */     }
/*     */     else
/*     */     {
/*  89 */       localOraclePreparedStatement = paramPhysicalConnection.prepareStatementInternal("SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(:1 AS " + paramArrayDescriptor.getName() + ") )", 1003, 1007);
/*     */     }
/*     */ 
/*  95 */     localOraclePreparedStatement.setArray(1, localARRAY);
/*  96 */     localOraclePreparedStatement.executeQuery();
/*     */ 
/*  98 */     return new ArrayLocatorResultSet(paramPhysicalConnection, localOraclePreparedStatement, paramLong, paramInt, paramMap);
/*     */   }
/*     */ 
/*     */   private ArrayLocatorResultSet(OracleConnection paramOracleConnection, OracleStatement paramOracleStatement, long paramLong, int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 123 */     super((PhysicalConnection)paramOracleConnection, paramOracleStatement);
/*     */ 
/* 126 */     if ((paramOracleConnection == null) || (paramOracleStatement == null))
/*     */     {
/* 128 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Invalid arguments");
/* 129 */       localSQLException.fillInStackTrace();
/* 130 */       throw localSQLException;
/*     */     }
/*     */ 
/* 135 */     this.closeStatementOnClose = true;
/*     */ 
/* 137 */     this.count = paramInt;
/* 138 */     this.currentIndex = 0L;
/* 139 */     this.beginIndex = paramLong;
/* 140 */     this.map = paramMap;
/*     */   }
/*     */ 
/*     */   public boolean next()
/*     */     throws SQLException
/*     */   {
/* 149 */     synchronized (this.connection)
/*     */     {
/* 157 */       if (this.currentIndex < this.beginIndex)
/*     */       {
/* 159 */         while (this.currentIndex < this.beginIndex)
/*     */         {
/* 161 */           this.currentIndex += 1L;
/*     */ 
/* 163 */           if (!super.next()) {
/* 164 */             return false;
/*     */           }
/*     */         }
/* 167 */         return true;
/*     */       }
/*     */ 
/* 171 */       if (this.count == COUNT_UNLIMITED)
/*     */       {
/* 173 */         return super.next();
/*     */       }
/* 175 */       if (this.currentIndex < this.beginIndex + this.count - 1L)
/*     */       {
/* 177 */         this.currentIndex += 1L;
/*     */ 
/* 179 */         return super.next();
/*     */       }
/*     */ 
/* 183 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 193 */     synchronized (this.connection)
/*     */     {
/* 201 */       return getObject(paramInt, this.map);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int findColumn(String paramString)
/*     */     throws SQLException
/*     */   {
/* 211 */     synchronized (this.connection)
/*     */     {
/* 219 */       if (paramString.equalsIgnoreCase("index"))
/* 220 */         return 1;
/* 221 */       if (paramString.equalsIgnoreCase("value")) {
/* 222 */         return 2;
/*     */       }
/*     */ 
/* 225 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6, "get_column_index");
/* 226 */       localSQLException.fillInStackTrace();
/* 227 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.ArrayLocatorResultSet
 * JD-Core Version:    0.6.2
 */