/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.math.BigDecimal;
/*      */ import java.net.URL;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Date;
/*      */ import java.sql.NClob;
/*      */ import java.sql.Ref;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLXML;
/*      */ import java.sql.Statement;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Calendar;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleDataFactory;
/*      */ import oracle.jdbc.OracleResultSet.AuthorizationIndicator;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CHAR;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.CustomDatum;
/*      */ import oracle.sql.CustomDatumFactory;
/*      */ import oracle.sql.DATE;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.INTERVALDS;
/*      */ import oracle.sql.INTERVALYM;
/*      */ import oracle.sql.NCLOB;
/*      */ import oracle.sql.NUMBER;
/*      */ import oracle.sql.OPAQUE;
/*      */ import oracle.sql.ORAData;
/*      */ import oracle.sql.ORADataFactory;
/*      */ import oracle.sql.RAW;
/*      */ import oracle.sql.REF;
/*      */ import oracle.sql.ROWID;
/*      */ import oracle.sql.STRUCT;
/*      */ import oracle.sql.TIMESTAMP;
/*      */ import oracle.sql.TIMESTAMPLTZ;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ 
/*      */ class ArrayDataResultSet extends OracleResultSet
/*      */ {
/*      */   Datum[] data;
/*      */   Map map;
/*      */   private int currentIndex;
/*      */   private int lastIndex;
/*      */   private Boolean wasNull;
/*      */   private int fetchSize;
/*      */   ARRAY array;
/* 2076 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   ArrayDataResultSet(PhysicalConnection paramPhysicalConnection, Datum[] paramArrayOfDatum, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*   55 */     super(paramPhysicalConnection);
/*      */ 
/*   58 */     this.connection = paramPhysicalConnection;
/*   59 */     this.data = paramArrayOfDatum;
/*   60 */     this.map = paramMap;
/*   61 */     this.currentIndex = 0;
/*   62 */     this.lastIndex = (this.data == null ? 0 : this.data.length);
/*   63 */     this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
/*      */   }
/*      */ 
/*      */   ArrayDataResultSet(PhysicalConnection paramPhysicalConnection, Datum[] paramArrayOfDatum, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*   79 */     super(paramPhysicalConnection);
/*      */ 
/*   82 */     this.connection = paramPhysicalConnection;
/*   83 */     this.data = paramArrayOfDatum;
/*   84 */     this.map = paramMap;
/*   85 */     this.currentIndex = ((int)paramLong - 1);
/*      */ 
/*   87 */     int i = this.data == null ? 0 : this.data.length;
/*      */ 
/*   89 */     this.lastIndex = (this.currentIndex + Math.min(i - this.currentIndex, paramInt));
/*      */ 
/*   91 */     this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
/*      */   }
/*      */ 
/*      */   ArrayDataResultSet(PhysicalConnection paramPhysicalConnection, ARRAY paramARRAY, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*   98 */     super(paramPhysicalConnection);
/*      */ 
/*  101 */     this.connection = paramPhysicalConnection;
/*  102 */     this.array = paramARRAY;
/*  103 */     this.map = paramMap;
/*  104 */     this.currentIndex = ((int)paramLong - 1);
/*      */ 
/*  106 */     int i = this.array == null ? 0 : paramARRAY.length();
/*      */ 
/*  108 */     this.lastIndex = (this.currentIndex + (paramInt == -1 ? i - this.currentIndex : Math.min(i - this.currentIndex, paramInt)));
/*      */ 
/*  111 */     this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
/*      */   }
/*      */ 
/*      */   OracleStatement getOracleStatement()
/*      */     throws SQLException
/*      */   {
/*  125 */     return null;
/*      */   }
/*      */ 
/*      */   int refreshRows(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  139 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "beforeFirst");
/*  140 */     localSQLException.fillInStackTrace();
/*  141 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   void removeCurrentRowFromCache()
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   int getColumnCount()
/*      */     throws SQLException
/*      */   {
/*  155 */     return 2;
/*      */   }
/*      */ 
/*      */   protected void doneFetchingRows(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   public boolean next()
/*      */     throws SQLException
/*      */   {
/*  178 */     if (this.closed)
/*      */     {
/*  180 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "next");
/*  181 */       localSQLException.fillInStackTrace();
/*  182 */       throw localSQLException;
/*      */     }
/*      */ 
/*  187 */     this.currentIndex += 1;
/*      */ 
/*  189 */     return this.currentIndex <= this.lastIndex;
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws SQLException
/*      */   {
/*  195 */     synchronized (this.connection)
/*      */     {
/*  202 */       super.close();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean wasNull()
/*      */     throws SQLException
/*      */   {
/*  209 */     synchronized (this.connection)
/*      */     {
/*  217 */       if (this.wasNull == null)
/*      */       {
/*  219 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 24, null);
/*  220 */         localSQLException.fillInStackTrace();
/*  221 */         throw localSQLException;
/*      */       }
/*      */ 
/*  224 */       return this.wasNull.booleanValue();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void beforeFirst()
/*      */     throws SQLException
/*      */   {
/*  241 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "beforeFirst");
/*  242 */     localSQLException.fillInStackTrace();
/*  243 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void afterLast()
/*      */     throws SQLException
/*      */   {
/*  256 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "afterLast");
/*  257 */     localSQLException.fillInStackTrace();
/*  258 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public boolean first()
/*      */     throws SQLException
/*      */   {
/*  271 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "first");
/*  272 */     localSQLException.fillInStackTrace();
/*  273 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public boolean last()
/*      */     throws SQLException
/*      */   {
/*  286 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "last");
/*  287 */     localSQLException.fillInStackTrace();
/*  288 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public boolean absolute(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  301 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "absolute");
/*  302 */     localSQLException.fillInStackTrace();
/*  303 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public boolean relative(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  316 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "relative");
/*  317 */     localSQLException.fillInStackTrace();
/*  318 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public boolean previous()
/*      */     throws SQLException
/*      */   {
/*  331 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "previous");
/*  332 */     localSQLException.fillInStackTrace();
/*  333 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public String getString(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  345 */     synchronized (this.connection)
/*      */     {
/*  353 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  355 */       if (localDatum != null) {
/*  356 */         if (((localDatum instanceof TIMESTAMPTZ)) || ((localDatum instanceof TIMESTAMPLTZ))) {
/*  357 */           return localDatum.stringValue(this.connection);
/*      */         }
/*  359 */         return localDatum.stringValue();
/*      */       }
/*      */ 
/*  362 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public ResultSet getCursor(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  369 */     synchronized (this.connection)
/*      */     {
/*  378 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCursor");
/*  379 */       localSQLException.fillInStackTrace();
/*  380 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Datum getOracleObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  396 */     if (this.currentIndex <= 0)
/*      */     {
/*  398 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14, null);
/*  399 */       ((SQLException)localObject).fillInStackTrace();
/*  400 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  403 */     if (paramInt == 1)
/*      */     {
/*  405 */       this.wasNull = Boolean.FALSE;
/*      */ 
/*  407 */       return new NUMBER(this.currentIndex);
/*      */     }
/*  409 */     if (paramInt == 2)
/*      */     {
/*  411 */       if (this.data != null)
/*      */       {
/*  413 */         this.wasNull = (this.data[(this.currentIndex - 1)] == null ? Boolean.TRUE : Boolean.FALSE);
/*      */ 
/*  416 */         return this.data[(this.currentIndex - 1)];
/*      */       }
/*  418 */       if (this.array != null)
/*      */       {
/*  422 */         localObject = this.array.getOracleArray(this.currentIndex, 1);
/*      */ 
/*  424 */         if ((localObject != null) && (localObject.length >= 1))
/*      */         {
/*  426 */           this.wasNull = (localObject[0] == null ? Boolean.TRUE : Boolean.FALSE);
/*      */ 
/*  428 */           return localObject[0];
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  433 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Out of sync");
/*  434 */       ((SQLException)localObject).fillInStackTrace();
/*  435 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  440 */     Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3, null);
/*  441 */     ((SQLException)localObject).fillInStackTrace();
/*  442 */     throw ((Throwable)localObject);
/*      */   }
/*      */ 
/*      */   public ROWID getROWID(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  450 */     synchronized (this.connection)
/*      */     {
/*  458 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  460 */       if (localDatum != null)
/*      */       {
/*  462 */         if ((localDatum instanceof ROWID)) {
/*  463 */           return (ROWID)localDatum;
/*      */         }
/*      */ 
/*  466 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getROWID");
/*  467 */         localSQLException.fillInStackTrace();
/*  468 */         throw localSQLException;
/*      */       }
/*      */ 
/*  472 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public NUMBER getNUMBER(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  479 */     synchronized (this.connection)
/*      */     {
/*  487 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  489 */       if (localDatum != null)
/*      */       {
/*  491 */         if ((localDatum instanceof NUMBER)) {
/*  492 */           return (NUMBER)localDatum;
/*      */         }
/*      */ 
/*  495 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getNUMBER");
/*  496 */         localSQLException.fillInStackTrace();
/*  497 */         throw localSQLException;
/*      */       }
/*      */ 
/*  501 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public DATE getDATE(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  508 */     synchronized (this.connection)
/*      */     {
/*  516 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  518 */       if (localDatum != null)
/*      */       {
/*  520 */         if ((localDatum instanceof DATE)) {
/*  521 */           return (DATE)localDatum;
/*      */         }
/*      */ 
/*  524 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getDATE");
/*  525 */         localSQLException.fillInStackTrace();
/*  526 */         throw localSQLException;
/*      */       }
/*      */ 
/*  530 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public ARRAY getARRAY(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  537 */     synchronized (this.connection)
/*      */     {
/*  545 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  547 */       if (localDatum != null)
/*      */       {
/*  549 */         if ((localDatum instanceof ARRAY)) {
/*  550 */           return (ARRAY)localDatum;
/*      */         }
/*      */ 
/*  553 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getARRAY");
/*  554 */         localSQLException.fillInStackTrace();
/*  555 */         throw localSQLException;
/*      */       }
/*      */ 
/*  559 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public STRUCT getSTRUCT(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  566 */     synchronized (this.connection)
/*      */     {
/*  574 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  576 */       if (localDatum != null)
/*      */       {
/*  578 */         if ((localDatum instanceof STRUCT)) {
/*  579 */           return (STRUCT)localDatum;
/*      */         }
/*      */ 
/*  582 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
/*  583 */         localSQLException.fillInStackTrace();
/*  584 */         throw localSQLException;
/*      */       }
/*      */ 
/*  588 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public OPAQUE getOPAQUE(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  595 */     synchronized (this.connection)
/*      */     {
/*  603 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  605 */       if (localDatum != null)
/*      */       {
/*  607 */         if ((localDatum instanceof OPAQUE)) {
/*  608 */           return (OPAQUE)localDatum;
/*      */         }
/*      */ 
/*  611 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
/*  612 */         localSQLException.fillInStackTrace();
/*  613 */         throw localSQLException;
/*      */       }
/*      */ 
/*  617 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public REF getREF(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  624 */     synchronized (this.connection)
/*      */     {
/*  632 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  634 */       if (localDatum != null)
/*      */       {
/*  636 */         if ((localDatum instanceof REF)) {
/*  637 */           return (REF)localDatum;
/*      */         }
/*      */ 
/*  640 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getREF");
/*  641 */         localSQLException.fillInStackTrace();
/*  642 */         throw localSQLException;
/*      */       }
/*      */ 
/*  646 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public CHAR getCHAR(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  653 */     synchronized (this.connection)
/*      */     {
/*  661 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  663 */       if (localDatum != null)
/*      */       {
/*  665 */         if ((localDatum instanceof CHAR)) {
/*  666 */           return (CHAR)localDatum;
/*      */         }
/*      */ 
/*  669 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCHAR");
/*  670 */         localSQLException.fillInStackTrace();
/*  671 */         throw localSQLException;
/*      */       }
/*      */ 
/*  675 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public RAW getRAW(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  682 */     synchronized (this.connection)
/*      */     {
/*  690 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  692 */       if (localDatum != null)
/*      */       {
/*  694 */         if ((localDatum instanceof RAW)) {
/*  695 */           return (RAW)localDatum;
/*      */         }
/*      */ 
/*  698 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getRAW");
/*  699 */         localSQLException.fillInStackTrace();
/*  700 */         throw localSQLException;
/*      */       }
/*      */ 
/*  704 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public BLOB getBLOB(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  711 */     synchronized (this.connection)
/*      */     {
/*  719 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  721 */       if (localDatum != null)
/*      */       {
/*  723 */         if ((localDatum instanceof BLOB)) {
/*  724 */           return (BLOB)localDatum;
/*      */         }
/*      */ 
/*  727 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBLOB");
/*  728 */         localSQLException.fillInStackTrace();
/*  729 */         throw localSQLException;
/*      */       }
/*      */ 
/*  733 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public CLOB getCLOB(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  740 */     synchronized (this.connection)
/*      */     {
/*  748 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  750 */       if (localDatum != null)
/*      */       {
/*  752 */         if ((localDatum instanceof CLOB)) {
/*  753 */           return (CLOB)localDatum;
/*      */         }
/*      */ 
/*  756 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCLOB");
/*  757 */         localSQLException.fillInStackTrace();
/*  758 */         throw localSQLException;
/*      */       }
/*      */ 
/*  762 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public BFILE getBFILE(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  769 */     synchronized (this.connection)
/*      */     {
/*  777 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  779 */       if (localDatum != null)
/*      */       {
/*  781 */         if ((localDatum instanceof BFILE)) {
/*  782 */           return (BFILE)localDatum;
/*      */         }
/*      */ 
/*  785 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBFILE");
/*  786 */         localSQLException.fillInStackTrace();
/*  787 */         throw localSQLException;
/*      */       }
/*      */ 
/*  791 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public INTERVALDS getINTERVALDS(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  798 */     synchronized (this.connection)
/*      */     {
/*  806 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  808 */       if (localDatum != null)
/*      */       {
/*  810 */         if ((localDatum instanceof INTERVALDS)) {
/*  811 */           return (INTERVALDS)localDatum;
/*      */         }
/*      */ 
/*  814 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/*  815 */         localSQLException.fillInStackTrace();
/*  816 */         throw localSQLException;
/*      */       }
/*      */ 
/*  820 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public INTERVALYM getINTERVALYM(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  827 */     synchronized (this.connection)
/*      */     {
/*  835 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  837 */       if (localDatum != null)
/*      */       {
/*  839 */         if ((localDatum instanceof INTERVALYM)) {
/*  840 */           return (INTERVALYM)localDatum;
/*      */         }
/*      */ 
/*  843 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/*  844 */         localSQLException.fillInStackTrace();
/*  845 */         throw localSQLException;
/*      */       }
/*      */ 
/*  849 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public BFILE getBfile(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  857 */     synchronized (this.connection)
/*      */     {
/*  865 */       return getBFILE(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public TIMESTAMP getTIMESTAMP(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  872 */     synchronized (this.connection)
/*      */     {
/*  880 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  882 */       if (localDatum != null)
/*      */       {
/*  884 */         if ((localDatum instanceof TIMESTAMP)) {
/*  885 */           return (TIMESTAMP)localDatum;
/*      */         }
/*      */ 
/*  888 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
/*  889 */         localSQLException.fillInStackTrace();
/*  890 */         throw localSQLException;
/*      */       }
/*      */ 
/*  894 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  901 */     synchronized (this.connection)
/*      */     {
/*  909 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  911 */       if (localDatum != null)
/*      */       {
/*  913 */         if ((localDatum instanceof TIMESTAMPTZ)) {
/*  914 */           return (TIMESTAMPTZ)localDatum;
/*      */         }
/*      */ 
/*  917 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
/*  918 */         localSQLException.fillInStackTrace();
/*  919 */         throw localSQLException;
/*      */       }
/*      */ 
/*  923 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ getTIMESTAMPLTZ(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  930 */     synchronized (this.connection)
/*      */     {
/*  938 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  940 */       if (localDatum != null)
/*      */       {
/*  942 */         if ((localDatum instanceof TIMESTAMPLTZ)) {
/*  943 */           return (TIMESTAMPLTZ)localDatum;
/*      */         }
/*      */ 
/*  946 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
/*  947 */         localSQLException.fillInStackTrace();
/*  948 */         throw localSQLException;
/*      */       }
/*      */ 
/*  952 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  959 */     synchronized (this.connection)
/*      */     {
/*  967 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  969 */       if (localDatum != null) {
/*  970 */         return localDatum.booleanValue();
/*      */       }
/*  972 */       return false;
/*      */     }
/*      */   }
/*      */ 
/*      */   public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  986 */     return null;
/*      */   }
/*      */ 
/*      */   public byte getByte(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  992 */     synchronized (this.connection)
/*      */     {
/* 1000 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1002 */       if (localDatum != null) {
/* 1003 */         return localDatum.byteValue();
/*      */       }
/* 1005 */       return 0;
/*      */     }
/*      */   }
/*      */ 
/*      */   public short getShort(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1012 */     synchronized (this.connection)
/*      */     {
/* 1020 */       long l = getLong(paramInt);
/*      */ 
/* 1022 */       if ((l > 65537L) || (l < -65538L))
/*      */       {
/* 1024 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 26, "getShort");
/* 1025 */         localSQLException.fillInStackTrace();
/* 1026 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1029 */       return (short)(int)l;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getInt(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1036 */     synchronized (this.connection)
/*      */     {
/* 1044 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1046 */       if (localDatum != null)
/*      */       {
/* 1048 */         return localDatum.intValue();
/*      */       }
/*      */ 
/* 1051 */       return 0;
/*      */     }
/*      */   }
/*      */ 
/*      */   public long getLong(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1058 */     synchronized (this.connection)
/*      */     {
/* 1066 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1068 */       if (localDatum != null)
/*      */       {
/* 1070 */         return localDatum.longValue();
/*      */       }
/*      */ 
/* 1073 */       return 0L;
/*      */     }
/*      */   }
/*      */ 
/*      */   public float getFloat(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1080 */     synchronized (this.connection)
/*      */     {
/* 1088 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1090 */       if (localDatum != null)
/*      */       {
/* 1092 */         return localDatum.floatValue();
/*      */       }
/*      */ 
/* 1095 */       return 0.0F;
/*      */     }
/*      */   }
/*      */ 
/*      */   public double getDouble(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1102 */     synchronized (this.connection)
/*      */     {
/* 1110 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1112 */       if (localDatum != null)
/*      */       {
/* 1114 */         return localDatum.doubleValue();
/*      */       }
/*      */ 
/* 1117 */       return 0.0D;
/*      */     }
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1125 */     synchronized (this.connection)
/*      */     {
/* 1133 */       Datum localDatum = getOracleObject(paramInt1);
/*      */ 
/* 1135 */       if (localDatum != null)
/*      */       {
/* 1137 */         return localDatum.bigDecimalValue();
/*      */       }
/*      */ 
/* 1140 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1147 */     synchronized (this.connection)
/*      */     {
/* 1155 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1157 */       if (localDatum != null)
/*      */       {
/* 1159 */         if ((localDatum instanceof RAW)) {
/* 1160 */           return ((RAW)localDatum).shareBytes();
/*      */         }
/*      */ 
/* 1163 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBytes");
/* 1164 */         localSQLException.fillInStackTrace();
/* 1165 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1169 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Date getDate(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1176 */     synchronized (this.connection)
/*      */     {
/* 1184 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1186 */       if (localDatum != null)
/*      */       {
/* 1188 */         return localDatum.dateValue();
/*      */       }
/*      */ 
/* 1191 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Time getTime(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1198 */     synchronized (this.connection)
/*      */     {
/* 1206 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1208 */       if (localDatum != null)
/*      */       {
/* 1210 */         return localDatum.timeValue();
/*      */       }
/*      */ 
/* 1213 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1221 */     synchronized (this.connection)
/*      */     {
/* 1229 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1231 */       if (localDatum != null)
/*      */       {
/* 1233 */         return localDatum.timestampValue();
/*      */       }
/*      */ 
/* 1236 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1244 */     synchronized (this.connection)
/*      */     {
/* 1252 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1254 */       if (localDatum != null)
/*      */       {
/* 1256 */         localDatum.asciiStreamValue();
/*      */       }
/*      */ 
/* 1259 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public InputStream getUnicodeStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1267 */     synchronized (this.connection)
/*      */     {
/* 1275 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1277 */       if (localDatum != null)
/*      */       {
/* 1279 */         DBConversion localDBConversion = this.connection.conversion;
/* 1280 */         byte[] arrayOfByte = localDatum.shareBytes();
/*      */ 
/* 1282 */         if ((localDatum instanceof RAW))
/*      */         {
/* 1284 */           return localDBConversion.ConvertStream(new ByteArrayInputStream(arrayOfByte), 3);
/*      */         }
/* 1286 */         if ((localDatum instanceof CHAR))
/*      */         {
/* 1288 */           return localDBConversion.ConvertStream(new ByteArrayInputStream(arrayOfByte), 1);
/*      */         }
/*      */ 
/* 1292 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
/* 1293 */         localSQLException.fillInStackTrace();
/* 1294 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1298 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1306 */     synchronized (this.connection)
/*      */     {
/* 1314 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1316 */       if (localDatum != null)
/*      */       {
/* 1318 */         return localDatum.binaryStreamValue();
/*      */       }
/*      */ 
/* 1321 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt, OracleDataFactory paramOracleDataFactory)
/*      */     throws SQLException
/*      */   {
/* 1329 */     synchronized (this.connection)
/*      */     {
/* 1336 */       Object localObject1 = getObject(paramInt);
/* 1337 */       return paramOracleDataFactory.create(localObject1, 0);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1344 */     synchronized (this.connection)
/*      */     {
/* 1353 */       return getObject(paramInt, this.map);
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public CustomDatum getCustomDatum(int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */     throws SQLException
/*      */   {
/* 1364 */     synchronized (this.connection)
/*      */     {
/* 1372 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1377 */       return paramCustomDatumFactory.create(localDatum, 0);
/*      */     }
/*      */   }
/*      */ 
/*      */   public ORAData getORAData(int paramInt, ORADataFactory paramORADataFactory)
/*      */     throws SQLException
/*      */   {
/* 1385 */     synchronized (this.connection)
/*      */     {
/* 1393 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1398 */       return paramORADataFactory.create(localDatum, 0);
/*      */     }
/*      */   }
/*      */ 
/*      */   public ResultSetMetaData getMetaData()
/*      */     throws SQLException
/*      */   {
/* 1408 */     synchronized (this.connection)
/*      */     {
/* 1416 */       if (this.closed)
/*      */       {
/* 1418 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getMetaData");
/* 1419 */         localSQLException.fillInStackTrace();
/* 1420 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1426 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23, "getMetaData");
/* 1427 */       localSQLException.fillInStackTrace();
/* 1428 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int findColumn(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1437 */     synchronized (this.connection)
/*      */     {
/* 1445 */       if (paramString.equalsIgnoreCase("index"))
/* 1446 */         return 1;
/* 1447 */       if (paramString.equalsIgnoreCase("value")) {
/* 1448 */         return 2;
/*      */       }
/*      */ 
/* 1451 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6, "get_column_index");
/* 1452 */       localSQLException.fillInStackTrace();
/* 1453 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Statement getStatement()
/*      */     throws SQLException
/*      */   {
/* 1473 */     return null;
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1480 */     synchronized (this.connection)
/*      */     {
/* 1488 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1490 */       if (localDatum != null)
/*      */       {
/* 1492 */         if ((localDatum instanceof STRUCT)) {
/* 1493 */           return ((STRUCT)localDatum).toJdbc(paramMap);
/*      */         }
/* 1495 */         return localDatum.toJdbc();
/*      */       }
/*      */ 
/* 1498 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Ref getRef(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1505 */     synchronized (this.connection)
/*      */     {
/* 1513 */       return getREF(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Blob getBlob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1520 */     synchronized (this.connection)
/*      */     {
/* 1528 */       return getBLOB(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Clob getClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1535 */     synchronized (this.connection)
/*      */     {
/* 1543 */       return getCLOB(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Array getArray(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1551 */     synchronized (this.connection)
/*      */     {
/* 1559 */       return getARRAY(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1574 */     synchronized (this.connection)
/*      */     {
/* 1582 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1584 */       if (localDatum != null)
/*      */       {
/* 1586 */         return localDatum.characterStreamValue();
/*      */       }
/*      */ 
/* 1589 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1597 */     synchronized (this.connection)
/*      */     {
/* 1605 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1607 */       if (localDatum != null)
/*      */       {
/* 1609 */         return localDatum.bigDecimalValue();
/*      */       }
/*      */ 
/* 1612 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Date getDate(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1620 */     synchronized (this.connection)
/*      */     {
/* 1628 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1630 */       if (localDatum != null)
/*      */       {
/* 1632 */         DATE localDATE = null;
/*      */ 
/* 1634 */         if ((localDatum instanceof DATE))
/* 1635 */           localDATE = (DATE)localDatum;
/*      */         else {
/* 1637 */           localDATE = new DATE(localDatum.stringValue());
/*      */         }
/* 1639 */         if (localDATE != null) {
/* 1640 */           return localDATE.dateValue(paramCalendar);
/*      */         }
/*      */       }
/* 1643 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Time getTime(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1651 */     synchronized (this.connection)
/*      */     {
/* 1659 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1661 */       if (localDatum != null)
/*      */       {
/* 1663 */         DATE localDATE = null;
/*      */ 
/* 1665 */         if ((localDatum instanceof DATE))
/* 1666 */           localDATE = (DATE)localDatum;
/*      */         else {
/* 1668 */           localDATE = new DATE(localDatum.stringValue());
/*      */         }
/* 1670 */         if (localDATE != null) {
/* 1671 */           return localDATE.timeValue(paramCalendar);
/*      */         }
/*      */       }
/* 1674 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1682 */     synchronized (this.connection)
/*      */     {
/* 1690 */       Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1692 */       if (localDatum != null)
/*      */       {
/* 1694 */         DATE localDATE = null;
/*      */ 
/* 1696 */         if ((localDatum instanceof DATE))
/* 1697 */           localDATE = (DATE)localDatum;
/*      */         else {
/* 1699 */           localDATE = new DATE(localDatum.stringValue());
/*      */         }
/* 1701 */         if (localDATE != null) {
/* 1702 */           return localDATE.timestampValue(paramCalendar);
/*      */         }
/*      */       }
/* 1705 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public URL getURL(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1714 */     synchronized (this.connection)
/*      */     {
/* 1756 */       SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 1757 */       localSQLException.fillInStackTrace();
/* 1758 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getCursorName()
/*      */     throws SQLException
/*      */   {
/* 1766 */     synchronized (this.connection)
/*      */     {
/* 1774 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23, "getCursorName");
/* 1775 */       localSQLException.fillInStackTrace();
/* 1776 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public NClob getNClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1791 */     Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1793 */     if (localDatum != null)
/*      */     {
/* 1795 */       if ((localDatum instanceof NCLOB)) {
/* 1796 */         return (NCLOB)localDatum;
/*      */       }
/*      */ 
/* 1799 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 1800 */       localSQLException.fillInStackTrace();
/* 1801 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1805 */     return null;
/*      */   }
/*      */ 
/*      */   public String getNString(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1817 */     Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1819 */     if (localDatum != null)
/*      */     {
/* 1821 */       return localDatum.stringValue();
/*      */     }
/*      */ 
/* 1824 */     return null;
/*      */   }
/*      */ 
/*      */   public Reader getNCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1837 */     Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1839 */     if (localDatum != null)
/*      */     {
/* 1841 */       return localDatum.characterStreamValue();
/*      */     }
/*      */ 
/* 1844 */     return null;
/*      */   }
/*      */ 
/*      */   public RowId getRowId(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1856 */     return getROWID(paramInt);
/*      */   }
/*      */ 
/*      */   public SQLXML getSQLXML(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1869 */     Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1871 */     if (localDatum != null)
/*      */     {
/* 1873 */       if ((localDatum instanceof SQLXML)) {
/* 1874 */         return (SQLXML)localDatum;
/*      */       }
/*      */ 
/* 1877 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 1878 */       localSQLException.fillInStackTrace();
/* 1879 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1883 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean isBeforeFirst()
/*      */     throws SQLException
/*      */   {
/* 1904 */     if (this.closed)
/*      */     {
/* 1906 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1907 */       localSQLException.fillInStackTrace();
/* 1908 */       throw localSQLException;
/*      */     }
/* 1910 */     return this.currentIndex < 1;
/*      */   }
/*      */ 
/*      */   public boolean isAfterLast()
/*      */     throws SQLException
/*      */   {
/* 1923 */     if (this.closed)
/*      */     {
/* 1925 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1926 */       localSQLException.fillInStackTrace();
/* 1927 */       throw localSQLException;
/*      */     }
/* 1929 */     return this.currentIndex > this.lastIndex;
/*      */   }
/*      */ 
/*      */   public boolean isFirst()
/*      */     throws SQLException
/*      */   {
/* 1942 */     if (this.closed)
/*      */     {
/* 1944 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1945 */       localSQLException.fillInStackTrace();
/* 1946 */       throw localSQLException;
/*      */     }
/* 1948 */     return this.currentIndex == 1;
/*      */   }
/*      */ 
/*      */   public boolean isLast()
/*      */     throws SQLException
/*      */   {
/* 1961 */     if (this.closed)
/*      */     {
/* 1963 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1964 */       localSQLException.fillInStackTrace();
/* 1965 */       throw localSQLException;
/*      */     }
/* 1967 */     return this.currentIndex == this.lastIndex;
/*      */   }
/*      */ 
/*      */   public int getRow()
/*      */     throws SQLException
/*      */   {
/* 1980 */     if (this.closed)
/*      */     {
/* 1982 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1983 */       localSQLException.fillInStackTrace();
/* 1984 */       throw localSQLException;
/*      */     }
/* 1986 */     return this.currentIndex;
/*      */   }
/*      */ 
/*      */   public void setFetchSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2003 */     if (paramInt < 0)
/*      */     {
/* 2005 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 2006 */       localSQLException.fillInStackTrace();
/* 2007 */       throw localSQLException;
/*      */     }
/* 2009 */     if (paramInt == 0)
/* 2010 */       this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
/*      */     else
/* 2012 */       this.fetchSize = paramInt;
/*      */   }
/*      */ 
/*      */   public int getFetchSize()
/*      */     throws SQLException
/*      */   {
/* 2024 */     return this.fetchSize;
/*      */   }
/*      */ 
/*      */   public int getType()
/*      */   {
/* 2040 */     return 1003;
/*      */   }
/*      */ 
/*      */   public int getConcurrency()
/*      */   {
/* 2056 */     return 1007;
/*      */   }
/*      */ 
/*      */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 2071 */     return this.connection;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.ArrayDataResultSet
 * JD-Core Version:    0.6.2
 */