/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.CharacterSet;
/*     */ 
/*     */ class AggregateByteArray extends SimpleByteArray
/*     */ {
/*     */   protected ByteArray extension;
/* 183 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   AggregateByteArray(byte[] paramArrayOfByte, ByteArray paramByteArray)
/*     */   {
/*  29 */     super(paramArrayOfByte);
/*  30 */     this.extension = paramByteArray;
/*     */   }
/*     */ 
/*     */   long length()
/*     */   {
/*  39 */     return this.bytes.length + this.extension.length();
/*     */   }
/*     */ 
/*     */   void put(long paramLong, byte paramByte)
/*     */   {
/*  53 */     if (paramLong < this.bytes.length) super.put(paramLong, paramByte); else
/*  54 */       this.extension.put(paramLong - this.bytes.length, paramByte);
/*     */   }
/*     */ 
/*     */   byte get(long paramLong)
/*     */   {
/*  69 */     if (paramLong < this.bytes.length) return super.get(paramLong);
/*  70 */     return this.extension.get(paramLong - this.bytes.length);
/*     */   }
/*     */ 
/*     */   void put(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/*  89 */     if (!$assertionsDisabled) if ((paramLong < this.bytes.length ? 1 : 0) != (paramLong + paramInt2 <= this.bytes.length ? 1 : 0)) throw new AssertionError("offset:" + paramLong + " length:" + paramInt2 + " bytes.length:" + this.bytes.length);
/*  90 */     if (paramLong < this.bytes.length) super.put(paramLong, paramArrayOfByte, paramInt1, paramInt2); else
/*  91 */       this.extension.put(paramLong - this.bytes.length, paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   void get(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/* 110 */     if (!$assertionsDisabled) if ((paramLong < this.bytes.length ? 1 : 0) != (paramLong + paramInt2 <= this.bytes.length ? 1 : 0)) throw new AssertionError("offset:" + paramLong + " length:" + paramInt2 + " bytes.length:" + this.bytes.length);
/* 111 */     if (paramLong < this.bytes.length) super.get(paramLong, paramArrayOfByte, paramInt1, paramInt2); else
/* 112 */       this.extension.get(paramLong - this.bytes.length, paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   char[] getChars(long paramLong, int paramInt, CharacterSet paramCharacterSet, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 137 */     if (!$assertionsDisabled) if ((paramLong < this.bytes.length ? 1 : 0) != (paramLong + paramInt <= this.bytes.length ? 1 : 0)) throw new AssertionError("offset:" + paramLong + " lengthInBytes:" + paramInt + " bytes.length:" + this.bytes.length);
/* 138 */     if (paramLong < this.bytes.length) return super.getChars(paramLong, paramInt, paramCharacterSet, paramArrayOfInt);
/* 139 */     return this.extension.getChars(paramLong - this.bytes.length, paramInt, paramCharacterSet, paramArrayOfInt);
/*     */   }
/*     */ 
/*     */   long updateChecksum(long paramLong1, int paramInt, CRC64 paramCRC64, long paramLong2)
/*     */   {
/* 155 */     if (!$assertionsDisabled) if ((paramLong1 < this.bytes.length ? 1 : 0) != (paramLong1 + paramInt <= this.bytes.length ? 1 : 0)) throw new AssertionError("offset:" + paramLong1 + " length:" + paramInt + " bytes.length:" + this.bytes.length);
/* 156 */     if (paramLong1 < this.bytes.length) return super.updateChecksum(paramLong1, paramInt, paramCRC64, paramLong2);
/* 157 */     return this.extension.updateChecksum(paramLong1 - this.bytes.length, paramInt, paramCRC64, paramLong2);
/*     */   }
/*     */ 
/*     */   byte[] getBlockBasic(long paramLong, int[] paramArrayOfInt)
/*     */   {
/* 166 */     if (paramLong < this.bytes.length) {
/* 167 */       return super.getBlockBasic(paramLong, paramArrayOfInt);
/*     */     }
/* 169 */     return this.extension.getBlockBasic(paramLong, paramArrayOfInt);
/*     */   }
/*     */ 
/*     */   void free()
/*     */   {
/* 177 */     super.free();
/* 178 */     this.extension.free();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.AggregateByteArray
 * JD-Core Version:    0.6.2
 */