/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.Reader;
/*      */ import java.lang.reflect.Array;
/*      */ import java.sql.NClob;
/*      */ import java.sql.SQLException;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleDataFactory;
/*      */ import oracle.jdbc.OracleResultSet.AuthorizationIndicator;
/*      */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.oracore.OracleType;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.ORAData;
/*      */ import oracle.sql.ORADataFactory;
/*      */ 
/*      */ abstract class Accessor extends GeneratedAccessor
/*      */   implements Cloneable
/*      */ {
/*      */   static final int FIXED_CHAR = 999;
/*      */   static final int CHAR = 96;
/*      */   static final int VARCHAR = 1;
/*      */   static final int VCS = 9;
/*      */   static final int LONG = 8;
/*      */   static final int NUMBER = 2;
/*      */   static final int VARNUM = 6;
/*      */   static final int BINARY_FLOAT = 100;
/*      */   static final int BINARY_DOUBLE = 101;
/*      */   static final int RAW = 23;
/*      */   static final int VBI = 15;
/*      */   static final int LONG_RAW = 24;
/*      */   static final int ROWID = 104;
/*      */   static final int RESULT_SET = 102;
/*      */   static final int RSET = 116;
/*      */   static final int DATE = 12;
/*      */   static final int BLOB = 113;
/*      */   static final int CLOB = 112;
/*      */   static final int BFILE = 114;
/*      */   static final int NAMED_TYPE = 109;
/*      */   static final int REF_TYPE = 111;
/*      */   static final int TIMESTAMP = 180;
/*      */   static final int TIMESTAMPTZ = 181;
/*      */   static final int TIMESTAMPLTZ = 231;
/*      */   static final int INTERVALYM = 182;
/*      */   static final int INTERVALDS = 183;
/*      */   static final int UROWID = 208;
/*      */   static final int PLSQL_INDEX_TABLE = 998;
/*      */   static final int T2S_OVERLONG_RAW = 997;
/*      */   static final int SET_CHAR_BYTES = 996;
/*      */   static final int NULL_TYPE = 995;
/*      */   static final int DML_RETURN_PARAM = 994;
/*      */   static final int XMLTYPE = 257;
/*      */   static final int ONLY_FORM_USABLE = 0;
/*      */   static final int NOT_USABLE = 1;
/*      */   static final int NO_NEED_TO_PREPARE = 2;
/*      */   static final int NEED_TO_PREPARE = 3;
/*      */   static final byte DATA_UNAUTHORIZED = 1;
/*      */   static final int NO_LOB_PREFETCH = -1;
/*      */   OracleStatement statement;
/*      */   boolean outBind;
/*      */   int internalType;
/*  153 */   boolean isStream = false;
/*      */ 
/*  156 */   boolean isColumnNumberAware = false;
/*      */ 
/*  158 */   short formOfUse = 2;
/*      */   OracleType internalOtype;
/*      */   int externalType;
/*      */   String internalTypeName;
/*      */   String columnName;
/*      */   int describeType;
/*      */   int describeMaxLength;
/*      */   int describeMaxLengthChars;
/*      */   boolean nullable;
/*      */   int precision;
/*      */   int scale;
/*      */   int flags;
/*      */   int contflag;
/*      */   int total_elems;
/*      */   OracleType describeOtype;
/*      */   String describeTypeName;
/*  187 */   int definedColumnType = 0;
/*  188 */   int definedColumnSize = 0;
/*  189 */   int oacmxl = 0;
/*      */ 
/*  192 */   short udskpos = -1;
/*      */ 
/*  199 */   int lobPrefetchSizeForThisColumn = -1;
/*      */   OracleResultSetMetaData.SecurityAttribute securityAttribute;
/*  205 */   protected boolean columnInvisible = false;
/*      */ 
/*  212 */   short[] rowSpaceIndicator = null;
/*      */ 
/*  214 */   int columnDataOffset = 0;
/*  215 */   int lengthIndex = 0;
/*  216 */   int indicatorIndex = 0;
/*  217 */   int byteLength = 0;
/*  218 */   int charLength = 0;
/*      */   int defineType;
/*  222 */   boolean isDMLReturnedParam = false;
/*      */ 
/*  227 */   int lastRowProcessed = 0;
/*      */ 
/*  233 */   boolean isUseLess = false;
/*      */ 
/*  241 */   int physicalColumnIndex = -2;
/*      */ 
/*  245 */   boolean isNullByDescribe = false;
/*      */ 
/*  293 */   static final byte[] NULL_DATA_BYTES = { 2, 3, 5, 7, 11, 13, 17, 19 };
/*      */   static final int ROW_METADATA_LENGTH = 1;
/*      */   final Representation representation;
/*      */   final int representationMaxLength;
/*      */   ByteArray rowData;
/*  594 */   long[] rowOffset = null;
/*  595 */   int[] rowLength = null;
/*  596 */   boolean[] rowNull = null;
/*      */ 
/*  598 */   byte[] rowMetadata = null;
/*      */   Object driverSpecificData;
/*  601 */   int previousRowProcessed = -1;
/*  602 */   final int[] escapeSequenceArr = new int[1];
/*  603 */   final boolean[] readHeaderArr = new boolean[1];
/*  604 */   final boolean[] readAsNonStreamArr = new boolean[1];
/*      */ 
/* 1159 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   void setNoPrefetch()
/*      */   {
/*      */   }
/*      */ 
/*      */   void setPrefetchLength(int paramInt)
/*      */   {
/*      */   }
/*      */ 
/*      */   PlsqlIbtBindInfo plsqlIndexTableBindInfo()
/*      */     throws SQLException
/*      */   {
/*  279 */     return null;
/*      */   }
/*      */ 
/*      */   void unimpl(String paramString)
/*      */     throws SQLException
/*      */   {
/*  286 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, paramString + " not implemented for " + getClass());
/*      */ 
/*  288 */     localSQLException.fillInStackTrace();
/*  289 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   long updateChecksum(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  298 */     if (isNull(paramInt)) {
/*  299 */       return CRC64.updateChecksum(paramLong, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
/*      */     }
/*      */ 
/*  305 */     return this.rowData.updateChecksum(getOffset(paramInt), getLength(paramInt), PhysicalConnection.CHECKSUM, paramLong);
/*      */   }
/*      */ 
/*      */   void init(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, short paramShort, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  317 */     this.statement = paramOracleStatement;
/*  318 */     this.outBind = paramBoolean;
/*  319 */     this.internalType = paramInt1;
/*  320 */     this.defineType = paramInt2;
/*  321 */     this.formOfUse = paramShort;
/*      */   }
/*      */ 
/*      */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*      */     throws SQLException
/*      */   {
/*  328 */     if (paramInt1 != 0) {
/*  329 */       this.externalType = paramInt1;
/*      */     }
/*  331 */     if ((paramInt2 > 0) && (paramInt2 < this.representationMaxLength)) {
/*  332 */       this.byteLength = paramInt2;
/*      */     }
/*      */     else
/*  335 */       this.byteLength = this.representationMaxLength;
/*      */   }
/*      */ 
/*      */   void initForDescribe(int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort)
/*      */     throws SQLException
/*      */   {
/*  345 */     this.nullable = paramBoolean;
/*  346 */     this.precision = paramInt4;
/*  347 */     this.scale = paramInt5;
/*  348 */     this.flags = paramInt3;
/*  349 */     this.contflag = paramInt6;
/*  350 */     this.total_elems = paramInt7;
/*  351 */     this.describeType = paramInt1;
/*  352 */     this.describeMaxLength = paramInt2;
/*  353 */     this.describeMaxLengthChars = paramInt2;
/*  354 */     if (!this.statement.columnsDefinedByUser)
/*  355 */       this.formOfUse = paramShort;
/*      */   }
/*      */ 
/*      */   void initForDescribe(int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort, String paramString)
/*      */     throws SQLException
/*      */   {
/*  364 */     this.describeTypeName = paramString;
/*  365 */     this.describeOtype = null;
/*      */ 
/*  367 */     initForDescribe(paramInt1, paramInt2, paramBoolean, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramShort);
/*      */   }
/*      */ 
/*      */   OracleInputStream initForNewRow()
/*      */     throws SQLException
/*      */   {
/*  380 */     unimpl("initForNewRow");
/*  381 */     return null;
/*      */   }
/*      */ 
/*      */   int useForDataAccessIfPossible(int paramInt1, int paramInt2, int paramInt3, String paramString)
/*      */     throws SQLException
/*      */   {
/*  396 */     int i = 3;
/*  397 */     int j = 0;
/*  398 */     int k = 0;
/*      */ 
/*  400 */     if (this.internalType != 0)
/*      */     {
/*  402 */       if (this.internalType != paramInt1) {
/*  403 */         i = 0;
/*  404 */       } else if (this.rowSpaceIndicator != null)
/*      */       {
/*  406 */         j = this.byteLength;
/*  407 */         k = this.charLength;
/*      */       }
/*      */     }
/*      */ 
/*  411 */     if (i == 3)
/*      */     {
/*  413 */       initForDataAccess(paramInt2, paramInt3, paramString);
/*      */ 
/*  415 */       if ((!this.outBind) && (j >= this.byteLength) && (k >= this.charLength))
/*      */       {
/*  417 */         i = 2;
/*      */       }
/*      */     }
/*  420 */     return i;
/*      */   }
/*      */ 
/*      */   boolean useForDescribeIfPossible(int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort, String paramString)
/*      */     throws SQLException
/*      */   {
/*  432 */     if ((!this.statement.columnsDefinedByUser) && (this.externalType == 0) && (this.describeType == 0) && (paramInt1 != this.describeType))
/*      */     {
/*  436 */       return false;
/*      */     }
/*  438 */     initForDescribe(paramInt1, paramInt2, paramBoolean, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramShort, paramString);
/*      */ 
/*  441 */     return true;
/*      */   }
/*      */ 
/*      */   void setFormOfUse(short paramShort)
/*      */   {
/*  450 */     this.formOfUse = paramShort;
/*      */   }
/*      */ 
/*      */   void updateColumnNumber(int paramInt)
/*      */   {
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  467 */     return super.toString() + ", statement=" + this.statement + ", outBind=" + this.outBind + ", internalType=" + this.internalType + ", isStream=" + this.isStream + ", formOfUse=" + this.formOfUse + ", internalOtype=" + this.internalOtype + ", externalType=" + this.externalType + ", internalTypeName=" + this.internalTypeName + ", columnName=" + this.columnName + ", describeType=" + this.describeType + ", describeMaxLength=" + this.describeMaxLength + ", nullable=" + this.nullable + ", precision=" + this.precision + ", scale=" + this.scale + ", flags=" + this.flags + ", contflag=" + this.contflag + ", total_elems=" + this.total_elems + ", describeOtype=" + this.describeOtype + ", describeTypeName=" + this.describeTypeName + ", rowData=" + this.rowData + ", rowOffset=" + this.rowOffset + ", rowLength=" + this.rowLength + ", rowNull=" + this.rowNull + ", rowMetadata=" + this.rowMetadata + ", driverSpecificData=" + this.driverSpecificData;
/*      */   }
/*      */ 
/*      */   void fetchNextColumns()
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   void calculateSizeTmpByteArray()
/*      */   {
/*      */   }
/*      */ 
/*      */   boolean unmarshalOneRow()
/*      */     throws SQLException, IOException
/*      */   {
/*  513 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 148);
/*  514 */     localSQLException.fillInStackTrace();
/*  515 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   void copyRow()
/*      */     throws SQLException, IOException
/*      */   {
/*  526 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 148);
/*  527 */     localSQLException.fillInStackTrace();
/*  528 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   int readStream(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException, IOException
/*      */   {
/*  537 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 148);
/*  538 */     localSQLException.fillInStackTrace();
/*  539 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   int getPreviousRowProcessed()
/*      */     throws SQLException
/*      */   {
/*  548 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 148);
/*  549 */     localSQLException.fillInStackTrace();
/*  550 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   void initMetadata()
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   void setDisplaySize(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  567 */     this.describeMaxLength = paramInt;
/*  568 */     this.describeMaxLengthChars = paramInt;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/*  580 */     return this.statement.getConnectionDuringExceptionHandling();
/*      */   }
/*      */ 
/*      */   protected Accessor(Representation paramRepresentation, OracleStatement paramOracleStatement, int paramInt, boolean paramBoolean)
/*      */   {
/*  611 */     this.representation = paramRepresentation;
/*  612 */     this.statement = paramOracleStatement;
/*  613 */     this.representationMaxLength = paramInt;
/*  614 */     this.rowData = (paramBoolean ? this.statement.bindData : this.statement.rowData);
/*  615 */     this.statement.setDriverSpecificData(this);
/*      */   }
/*      */ 
/*      */   protected final long getOffset(int paramInt)
/*      */   {
/*  626 */     return this.rowOffset[paramInt];
/*      */   }
/*      */ 
/*      */   protected final void setOffset(int paramInt, long paramLong)
/*      */   {
/*  637 */     this.rowOffset[paramInt] = paramLong;
/*      */   }
/*      */ 
/*      */   protected final void setOffset(int paramInt)
/*      */   {
/*  649 */     long l = this.rowData.getPosition();
/*      */ 
/*  651 */     this.rowOffset[paramInt] = l;
/*      */   }
/*      */ 
/*      */   protected final int getLength(int paramInt)
/*      */   {
/*  663 */     return this.rowLength[paramInt];
/*      */   }
/*      */ 
/*      */   protected final void setLength(int paramInt1, int paramInt2)
/*      */   {
/*  674 */     this.rowLength[paramInt1] = paramInt2;
/*      */   }
/*      */ 
/*      */   protected final void setLengthAndNull(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  686 */     if (paramInt2 == 0) { setNull(paramInt1, true);
/*      */     } else {
/*  688 */       setNull(paramInt1, false);
/*  689 */       setLength(paramInt1, paramInt2);
/*      */     }
/*      */   }
/*      */ 
/*      */   final byte getRowMetadata(int paramInt)
/*      */   {
/*  703 */     return this.rowMetadata[paramInt];
/*      */   }
/*      */ 
/*      */   final void setRowMetadata(int paramInt, byte paramByte)
/*      */   {
/*  716 */     this.rowMetadata[paramInt] = paramByte;
/*      */   }
/*      */ 
/*      */   boolean isNull(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  731 */     if (this.rowNull == null) {
/*  732 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/*  733 */       localSQLException.fillInStackTrace();
/*  734 */       throw localSQLException;
/*      */     }
/*  736 */     return this.rowNull[paramInt];
/*      */   }
/*      */ 
/*      */   void setNull(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  756 */     if (this.rowNull == null)
/*      */     {
/*  760 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 21);
/*  761 */       localSQLException.fillInStackTrace();
/*  762 */       throw localSQLException;
/*      */     }
/*      */ 
/*  767 */     this.rowNull[paramInt] = paramBoolean;
/*  768 */     if ((paramBoolean) && (this.statement.connection.protocolId != 3)) {
/*  769 */       setOffset(paramInt, -1L);
/*  770 */       setLength(paramInt, -1);
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean isNullByDescribe()
/*      */   {
/*  778 */     return this.isNullByDescribe;
/*      */   }
/*      */ 
/*      */   boolean isUseless()
/*      */   {
/*  784 */     return this.isUseLess;
/*      */   }
/*      */ 
/*      */   boolean isUnexpected()
/*      */   {
/*  790 */     return this.rowNull == null;
/*      */   }
/*      */ 
/*      */   void setColumnInvisible(boolean paramBoolean)
/*      */   {
/*  800 */     this.columnInvisible = paramBoolean;
/*      */   }
/*      */ 
/*      */   boolean isColumnInvisible()
/*      */   {
/*  810 */     return this.columnInvisible;
/*      */   }
/*      */ 
/*      */   void setCapacity(int paramInt)
/*      */   {
/*  821 */     if (this.rowNull == null) {
/*  822 */       this.rowLength = new int[paramInt];
/*  823 */       this.rowOffset = new long[paramInt];
/*  824 */       this.rowNull = new boolean[paramInt];
/*  825 */       this.rowMetadata = new byte[paramInt];
/*      */     }
/*  827 */     else if (this.rowNull.length < paramInt) {
/*  828 */       Object localObject = new int[paramInt];
/*  829 */       System.arraycopy(this.rowLength, 0, localObject, 0, this.rowLength.length);
/*  830 */       this.rowLength = ((int[])localObject);
/*  831 */       localObject = new long[paramInt];
/*  832 */       System.arraycopy(this.rowOffset, 0, localObject, 0, this.rowOffset.length);
/*  833 */       this.rowOffset = ((long[])localObject);
/*  834 */       localObject = new boolean[paramInt];
/*  835 */       System.arraycopy(this.rowNull, 0, localObject, 0, this.rowNull.length);
/*  836 */       this.rowNull = ((boolean[])localObject);
/*  837 */       localObject = new byte[paramInt];
/*  838 */       System.arraycopy(this.rowMetadata, 0, localObject, 0, this.rowMetadata.length);
/*  839 */       this.rowMetadata = ((byte[])localObject);
/*      */     }
/*      */   }
/*      */ 
/*      */   Accessor copyForDefine(OracleStatement paramOracleStatement)
/*      */   {
/*  856 */     Accessor localAccessor = null;
/*      */     try {
/*  858 */       localAccessor = (Accessor)clone();
/*      */     } catch (CloneNotSupportedException localCloneNotSupportedException) {
/*      */     }
/*  861 */     localAccessor.rowNull = null;
/*  862 */     localAccessor.rowLength = null;
/*  863 */     localAccessor.rowOffset = null;
/*  864 */     localAccessor.rowMetadata = null;
/*  865 */     localAccessor.statement = paramOracleStatement;
/*  866 */     localAccessor.rowData = paramOracleStatement.rowData;
/*  867 */     paramOracleStatement.setDriverSpecificData(localAccessor);
/*  868 */     return localAccessor;
/*      */   }
/*      */ 
/*      */   OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  875 */     int i = getRowMetadata(paramInt);
/*      */ 
/*  878 */     if ((i & 0x1) != 0)
/*  879 */       return OracleResultSet.AuthorizationIndicator.UNAUTHORIZED;
/*  880 */     if ((this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) || (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.NONE))
/*      */     {
/*  882 */       return OracleResultSet.AuthorizationIndicator.NONE;
/*      */     }
/*  884 */     return OracleResultSet.AuthorizationIndicator.UNKNOWN;
/*      */   }
/*      */ 
/*      */   byte[] getBytesInternal(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  912 */     assert (!isNull(paramInt));
/*  913 */     int i = getLength(paramInt);
/*  914 */     long l = getOffset(paramInt);
/*  915 */     return this.rowData.get(l, i);
/*      */   }
/*      */ 
/*      */   final void getBytesInternal(int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  934 */     int i = getLength(paramInt);
/*  935 */     assert (paramArrayOfByte.length >= i) : ("data.length: " + paramArrayOfByte.length + " len: " + i);
/*  936 */     long l = getOffset(paramInt);
/*  937 */     this.rowData.get(l, paramArrayOfByte, 0, i);
/*      */   }
/*      */ 
/*      */   byte[] getBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  950 */     if (isNull(paramInt)) return null;
/*  951 */     return getBytesInternal(paramInt);
/*      */   }
/*      */ 
/*      */   String getString(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  963 */     return null;
/*      */   }
/*      */ 
/*      */   <T> T getObject(int paramInt, Class<T> paramClass)
/*      */     throws SQLException
/*      */   {
/*  981 */     if (paramClass == null) {
/*  982 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 282);
/*  983 */       localSQLException.fillInStackTrace();
/*  984 */       throw localSQLException;
/*      */     }
/*  986 */     return this.representation.getObject(this, paramInt, paramClass);
/*      */   }
/*      */ 
/*      */   Object getObject(int paramInt, OracleDataFactory paramOracleDataFactory)
/*      */     throws SQLException
/*      */   {
/*  994 */     if (paramOracleDataFactory == null) {
/*  995 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 281);
/*  996 */       ((SQLException)localObject).fillInStackTrace();
/*  997 */       throw ((Throwable)localObject);
/*      */     }
/*  999 */     Object localObject = getObject(paramInt, (Map)null);
/* 1000 */     return paramOracleDataFactory.create(localObject, 0);
/*      */   }
/*      */ 
/*      */   ORAData getORAData(int paramInt, ORADataFactory paramORADataFactory)
/*      */     throws SQLException
/*      */   {
/* 1008 */     if (paramORADataFactory == null) {
/* 1009 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 281);
/* 1010 */       ((SQLException)localObject).fillInStackTrace();
/* 1011 */       throw ((Throwable)localObject);
/*      */     }
/* 1013 */     Object localObject = getOracleObject(paramInt);
/*      */ 
/* 1018 */     return paramORADataFactory.create((Datum)localObject, 0);
/*      */   }
/*      */ 
/*      */   Datum[] getOraclePlsqlIndexTable(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1026 */     if (isNull(paramInt)) return null;
/*      */ 
/* 1028 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOraclePlsqlIndexTable not implemented for " + getClass().getName());
/* 1029 */     localSQLException.fillInStackTrace();
/* 1030 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   NClob getNClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1038 */     if (this.formOfUse != 2)
/*      */     {
/* 1040 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 1041 */       localSQLException.fillInStackTrace();
/* 1042 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1045 */     return (NClob)getCLOB(paramInt);
/*      */   }
/*      */ 
/*      */   String getNString(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1052 */     return getString(paramInt);
/*      */   }
/*      */ 
/*      */   Reader getNCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1059 */     return getCharacterStream(paramInt);
/*      */   }
/*      */ 
/*      */   final void copyFrom(Accessor paramAccessor, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1076 */     assert (getClass() == paramAccessor.getClass()) : ("srcAcc.class: " + paramAccessor.getClass());
/*      */ 
/* 1078 */     assert ((0 <= paramInt1) && (paramInt1 < paramAccessor.rowNull.length)) : ("srcRow: " + paramInt1 + " srcAcc.capacity: " + paramAccessor.rowNull.length);
/*      */ 
/* 1080 */     assert ((0 <= paramInt2) && (paramInt2 < this.rowNull.length)) : ("destRow: " + paramInt2 + " capacity: " + this.rowNull.length);
/* 1081 */     if (paramAccessor.isNull(paramInt1)) {
/* 1082 */       setNull(paramInt2, true);
/*      */     }
/*      */     else
/* 1085 */       copyFromInternal(paramAccessor, paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   protected void copyFromInternal(Accessor paramAccessor, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1101 */     setNull(paramInt2, false);
/*      */ 
/* 1104 */     int i = ((paramInt2 > 0) && (getOffset(paramInt2 - 1) == getOffset(paramInt2))) || ((paramInt2 + 1 < this.statement.storedRowCount) && (getOffset(paramInt2 + 1) == getOffset(paramInt2))) ? 1 : 0;
/*      */ 
/* 1109 */     if ((i != 0) && (getLength(paramInt2) == paramAccessor.getLength(paramInt1)) && (this.rowData.equalBytes(getOffset(paramInt2), getLength(paramInt2), paramAccessor.rowData, paramAccessor.getOffset(paramInt1))))
/*      */     {
/* 1116 */       setRowMetadata(paramInt2, paramAccessor.getRowMetadata(paramInt1));
/*      */     }
/*      */     else
/*      */     {
/* 1120 */       if ((i != 0) || (paramAccessor.getLength(paramInt1) > getLength(paramInt2)))
/*      */       {
/* 1123 */         this.statement.locationToPutBytes(this, paramInt2, paramAccessor.getLength(paramInt1));
/*      */       }
/* 1125 */       this.rowData.put(getOffset(paramInt2), paramAccessor.rowData, paramAccessor.getOffset(paramInt1), paramAccessor.getLength(paramInt1));
/* 1126 */       setLength(paramInt2, paramAccessor.getLength(paramInt1));
/* 1127 */       setRowMetadata(paramInt2, paramAccessor.getRowMetadata(paramInt1));
/*      */     }
/*      */   }
/*      */ 
/*      */   void deleteRow(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1141 */     this.rowData.freeSpace(getOffset(paramInt), getLength(paramInt));
/* 1142 */     delete(this.rowNull, paramInt);
/* 1143 */     delete(this.rowOffset, paramInt);
/* 1144 */     delete(this.rowLength, paramInt);
/* 1145 */     delete(this.rowMetadata, paramInt);
/*      */   }
/*      */ 
/*      */   protected final void delete(Object paramObject, int paramInt)
/*      */   {
/* 1153 */     int i = Array.getLength(paramObject);
/* 1154 */     assert ((paramInt >= 0) && (paramInt < i)) : ("row: " + paramInt + " len: " + i);
/* 1155 */     System.arraycopy(paramObject, paramInt + 1, paramObject, paramInt, i - paramInt - 1);
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.Accessor
 * JD-Core Version:    0.6.2
 */