/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Timestamp;
/*     */ import oracle.jdbc.aq.AQAgent;
/*     */ import oracle.jdbc.aq.AQMessageProperties;
/*     */ import oracle.jdbc.aq.AQMessageProperties.DeliveryMode;
/*     */ import oracle.jdbc.aq.AQMessageProperties.MessageState;
/*     */ 
/*     */ class AQMessagePropertiesI
/*     */   implements AQMessageProperties
/*     */ {
/*     */   private int attrAttempts;
/*     */   private String attrCorrelation;
/*     */   private int attrDelay;
/*     */   private Timestamp attrEnqTime;
/*     */   private String attrExceptionQueue;
/*     */   private int attrExpiration;
/*     */   private AQMessageProperties.MessageState attrMsgState;
/*     */   private int attrPriority;
/*     */   private AQAgentI[] attrRecipientList;
/*     */   private AQAgentI attrSenderId;
/*     */   private String attrTransactionGroup;
/*     */   private byte[] attrPreviousQueueMsgId;
/*     */   private AQMessageProperties.DeliveryMode deliveryMode;
/* 461 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   AQMessagePropertiesI()
/*     */   {
/*  68 */     this.attrAttempts = -1;
/*  69 */     this.attrCorrelation = null;
/*  70 */     this.attrDelay = 0;
/*  71 */     this.attrEnqTime = null;
/*  72 */     this.attrExceptionQueue = null;
/*  73 */     this.attrExpiration = -1;
/*  74 */     this.attrMsgState = null;
/*  75 */     this.attrPriority = 0;
/*  76 */     this.attrRecipientList = null;
/*  77 */     this.attrSenderId = null;
/*  78 */     this.attrTransactionGroup = null;
/*  79 */     this.attrPreviousQueueMsgId = null;
/*  80 */     this.deliveryMode = null;
/*     */   }
/*     */ 
/*     */   public int getDequeueAttemptsCount()
/*     */   {
/*  93 */     return this.attrAttempts;
/*     */   }
/*     */ 
/*     */   public void setCorrelation(String paramString)
/*     */     throws SQLException
/*     */   {
/* 106 */     this.attrCorrelation = paramString;
/*     */   }
/*     */ 
/*     */   public String getCorrelation()
/*     */   {
/* 118 */     return this.attrCorrelation;
/*     */   }
/*     */ 
/*     */   public void setDelay(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 130 */     this.attrDelay = paramInt;
/*     */   }
/*     */ 
/*     */   public int getDelay()
/*     */   {
/* 142 */     return this.attrDelay;
/*     */   }
/*     */ 
/*     */   public Timestamp getEnqueueTime()
/*     */   {
/* 154 */     return this.attrEnqTime;
/*     */   }
/*     */ 
/*     */   public void setExceptionQueue(String paramString)
/*     */     throws SQLException
/*     */   {
/* 167 */     this.attrExceptionQueue = paramString;
/*     */   }
/*     */ 
/*     */   public String getExceptionQueue()
/*     */   {
/* 179 */     return this.attrExceptionQueue;
/*     */   }
/*     */ 
/*     */   public void setExpiration(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 192 */     this.attrExpiration = paramInt;
/*     */   }
/*     */ 
/*     */   public int getExpiration()
/*     */   {
/* 204 */     return this.attrExpiration;
/*     */   }
/*     */ 
/*     */   public AQMessageProperties.MessageState getState()
/*     */   {
/* 216 */     return this.attrMsgState;
/*     */   }
/*     */ 
/*     */   public void setPriority(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 228 */     this.attrPriority = paramInt;
/*     */   }
/*     */ 
/*     */   public int getPriority()
/*     */   {
/* 240 */     return this.attrPriority;
/*     */   }
/*     */ 
/*     */   public void setRecipientList(AQAgent[] paramArrayOfAQAgent)
/*     */     throws SQLException
/*     */   {
/* 253 */     if (paramArrayOfAQAgent == null)
/*     */     {
/* 255 */       this.attrRecipientList = null;
/*     */     }
/*     */     else
/*     */     {
/* 259 */       this.attrRecipientList = new AQAgentI[paramArrayOfAQAgent.length];
/* 260 */       for (int i = 0; i < paramArrayOfAQAgent.length; i++)
/* 261 */         this.attrRecipientList[i] = ((AQAgentI)paramArrayOfAQAgent[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public AQAgent[] getRecipientList()
/*     */   {
/* 274 */     return this.attrRecipientList;
/*     */   }
/*     */ 
/*     */   public void setSender(AQAgent paramAQAgent)
/*     */     throws SQLException
/*     */   {
/* 286 */     this.attrSenderId = ((AQAgentI)paramAQAgent);
/*     */   }
/*     */ 
/*     */   public AQAgent getSender()
/*     */   {
/* 298 */     return this.attrSenderId;
/*     */   }
/*     */ 
/*     */   public String getTransactionGroup()
/*     */   {
/* 310 */     return this.attrTransactionGroup;
/*     */   }
/*     */ 
/*     */   void setTransactionGroup(String paramString)
/*     */   {
/* 317 */     this.attrTransactionGroup = paramString;
/*     */   }
/*     */ 
/*     */   void setPreviousQueueMessageId(byte[] paramArrayOfByte)
/*     */   {
/* 324 */     this.attrPreviousQueueMsgId = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public byte[] getPreviousQueueMessageId()
/*     */   {
/* 336 */     return this.attrPreviousQueueMsgId;
/*     */   }
/*     */ 
/*     */   public AQMessageProperties.DeliveryMode getDeliveryMode()
/*     */   {
/* 348 */     return this.deliveryMode;
/*     */   }
/*     */ 
/*     */   void setDeliveryMode(AQMessageProperties.DeliveryMode paramDeliveryMode)
/*     */   {
/* 355 */     this.deliveryMode = paramDeliveryMode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 398 */     StringBuffer localStringBuffer = new StringBuffer();
/* 399 */     localStringBuffer.append("Correlation             : " + getCorrelation() + "\n");
/* 400 */     Timestamp localTimestamp = getEnqueueTime();
/* 401 */     if (localTimestamp != null)
/* 402 */       localStringBuffer.append("Enqueue time            : " + localTimestamp + "\n");
/* 403 */     localStringBuffer.append("Exception Queue         : " + getExceptionQueue() + "\n");
/* 404 */     localStringBuffer.append("Sender                  : (" + getSender() + ")\n");
/* 405 */     int i = getDequeueAttemptsCount();
/* 406 */     if (i != -1)
/* 407 */       localStringBuffer.append("Attempts                : " + i + "\n");
/* 408 */     localStringBuffer.append("Delay                   : " + getDelay() + "\n");
/* 409 */     localStringBuffer.append("Expiration              : " + getExpiration() + "\n");
/* 410 */     AQMessageProperties.MessageState localMessageState = getState();
/*     */ 
/* 412 */     if (localMessageState != null)
/* 413 */       localStringBuffer.append("State                   : " + localMessageState + "\n");
/* 414 */     localStringBuffer.append("Priority                : " + getPriority() + "\n");
/* 415 */     AQMessageProperties.DeliveryMode localDeliveryMode = getDeliveryMode();
/*     */ 
/* 417 */     if (localDeliveryMode != null)
/* 418 */       localStringBuffer.append("Delivery Mode           : " + localDeliveryMode + "\n");
/* 419 */     localStringBuffer.append("Recipient List          : {");
/* 420 */     AQAgent[] arrayOfAQAgent = getRecipientList();
/* 421 */     if (arrayOfAQAgent != null)
/*     */     {
/* 423 */       for (int j = 0; j < arrayOfAQAgent.length; j++)
/*     */       {
/* 425 */         localStringBuffer.append(arrayOfAQAgent[j]);
/* 426 */         if (j != arrayOfAQAgent.length - 1)
/* 427 */           localStringBuffer.append("; ");
/*     */       }
/*     */     }
/* 430 */     localStringBuffer.append("}");
/*     */ 
/* 432 */     return localStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   void setAttempts(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 439 */     this.attrAttempts = paramInt;
/*     */   }
/*     */ 
/*     */   void setEnqueueTime(Timestamp paramTimestamp)
/*     */     throws SQLException
/*     */   {
/* 448 */     this.attrEnqTime = paramTimestamp;
/*     */   }
/*     */ 
/*     */   void setMessageState(AQMessageProperties.MessageState paramMessageState)
/*     */     throws SQLException
/*     */   {
/* 456 */     this.attrMsgState = paramMessageState;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.AQMessagePropertiesI
 * JD-Core Version:    0.6.2
 */