/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.aq.AQMessage;
/*     */ import oracle.jdbc.aq.AQMessageProperties;
/*     */ import oracle.jdbc.oracore.OracleTypeADT;
/*     */ import oracle.sql.ANYDATA;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.OPAQUE;
/*     */ import oracle.sql.OpaqueDescriptor;
/*     */ import oracle.sql.RAW;
/*     */ import oracle.sql.STRUCT;
/*     */ import oracle.sql.StructDescriptor;
/*     */ import oracle.sql.TypeDescriptor;
/*     */ import oracle.xdb.XMLType;
/*     */ 
/*     */ class AQMessageI
/*     */   implements AQMessage
/*     */ {
/*  64 */   private byte[] id = null;
/*  65 */   private AQMessagePropertiesI properties = null;
/*  66 */   private byte[] toid = null;
/*     */   private byte[] payload;
/*     */   private STRUCT payLoadSTRUCT;
/*     */   private ANYDATA payLoadANYDATA;
/*     */   private RAW payLoadRAW;
/*     */   private XMLType payLoadXMLType;
/*     */   private Connection conn;
/*     */   private String typeName;
/*     */   private TypeDescriptor sd;
/* 547 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   AQMessageI(AQMessagePropertiesI paramAQMessagePropertiesI, Connection paramConnection)
/*     */   {
/*  81 */     this.properties = paramAQMessagePropertiesI;
/*  82 */     this.conn = paramConnection;
/*     */   }
/*     */ 
/*     */   AQMessageI(AQMessagePropertiesI paramAQMessagePropertiesI)
/*     */     throws SQLException
/*     */   {
/*  90 */     this.properties = paramAQMessagePropertiesI;
/*     */   }
/*     */ 
/*     */   void setTypeName(String paramString)
/*     */   {
/*  97 */     this.typeName = paramString;
/*     */   }
/*     */ 
/*     */   void setTypeDescriptor(TypeDescriptor paramTypeDescriptor)
/*     */   {
/* 104 */     this.sd = paramTypeDescriptor;
/*     */   }
/*     */ 
/*     */   public byte[] getMessageId()
/*     */   {
/* 116 */     return this.id;
/*     */   }
/*     */ 
/*     */   void setMessageId(byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 123 */     this.id = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public AQMessageProperties getMessageProperties()
/*     */   {
/* 135 */     return this.properties;
/*     */   }
/*     */ 
/*     */   AQMessagePropertiesI getMessagePropertiesI()
/*     */   {
/* 142 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void setPayload(byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 160 */     this.payload = paramArrayOfByte;
/* 161 */     this.toid = TypeDescriptor.RAWTOID;
/*     */   }
/*     */ 
/*     */   public void setPayload(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*     */     throws SQLException
/*     */   {
/* 174 */     this.payload = paramArrayOfByte1;
/* 175 */     this.toid = paramArrayOfByte2;
/*     */   }
/*     */ 
/*     */   public void setPayload(STRUCT paramSTRUCT)
/*     */     throws SQLException
/*     */   {
/* 188 */     this.payload = paramSTRUCT.toBytes();
/* 189 */     this.payLoadSTRUCT = paramSTRUCT;
/* 190 */     this.toid = paramSTRUCT.getDescriptor().getOracleTypeADT().getTOID();
/*     */   }
/*     */ 
/*     */   public void setPayload(ANYDATA paramANYDATA)
/*     */     throws SQLException
/*     */   {
/* 203 */     this.payload = paramANYDATA.toDatum(this.conn).shareBytes();
/* 204 */     this.payLoadANYDATA = paramANYDATA;
/* 205 */     this.toid = TypeDescriptor.ANYDATATOID;
/*     */   }
/*     */ 
/*     */   public void setPayload(RAW paramRAW)
/*     */     throws SQLException
/*     */   {
/* 217 */     this.payload = paramRAW.shareBytes();
/* 218 */     this.payLoadRAW = paramRAW;
/* 219 */     this.toid = TypeDescriptor.RAWTOID;
/*     */   }
/*     */ 
/*     */   public void setPayload(XMLType paramXMLType)
/*     */     throws SQLException
/*     */   {
/* 231 */     this.payload = paramXMLType.toBytes();
/* 232 */     this.payLoadXMLType = paramXMLType;
/* 233 */     this.toid = TypeDescriptor.XMLTYPETOID;
/*     */   }
/*     */ 
/*     */   public byte[] getPayload()
/*     */   {
/* 245 */     return this.payload;
/*     */   }
/*     */ 
/*     */   public RAW getRAWPayload()
/*     */     throws SQLException
/*     */   {
/* 257 */     RAW localRAW = null;
/* 258 */     if (this.payLoadRAW != null) {
/* 259 */       localRAW = this.payLoadRAW;
/* 260 */     } else if (isRAWPayload())
/*     */     {
/* 262 */       this.payLoadRAW = new RAW(this.payload);
/* 263 */       localRAW = this.payLoadRAW;
/*     */     }
/*     */     else
/*     */     {
/* 267 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 193);
/* 268 */       localSQLException.fillInStackTrace();
/* 269 */       throw localSQLException;
/*     */     }
/* 271 */     return localRAW;
/*     */   }
/*     */ 
/*     */   public boolean isRAWPayload()
/*     */     throws SQLException
/*     */   {
/* 284 */     if ((this.toid == null) || (this.toid.length != 16))
/*     */     {
/* 286 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 252);
/* 287 */       localSQLException.fillInStackTrace();
/* 288 */       throw localSQLException;
/*     */     }
/*     */ 
/* 291 */     if (compareToid(this.toid, TypeDescriptor.RAWTOID)) {
/* 292 */       return true;
/*     */     }
/* 294 */     return false;
/*     */   }
/*     */ 
/*     */   public STRUCT getSTRUCTPayload()
/*     */     throws SQLException
/*     */   {
/* 307 */     STRUCT localSTRUCT = null;
/*     */     SQLException localSQLException;
/* 309 */     if (!isSTRUCTPayload())
/*     */     {
/* 311 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 193);
/* 312 */       localSQLException.fillInStackTrace();
/* 313 */       throw localSQLException;
/*     */     }
/*     */ 
/* 316 */     if (this.payLoadSTRUCT != null) {
/* 317 */       localSTRUCT = this.payLoadSTRUCT;
/*     */     }
/*     */     else {
/* 320 */       if (this.sd == null)
/*     */       {
/* 322 */         this.typeName = OracleTypeADT.toid2typename(this.conn, this.toid);
/* 323 */         this.sd = TypeDescriptor.getTypeDescriptor(this.typeName, (OracleConnection)this.conn);
/*     */       }
/*     */ 
/* 326 */       if ((this.sd instanceof StructDescriptor))
/*     */       {
/* 331 */         localSTRUCT = new STRUCT((StructDescriptor)this.sd, this.payload, this.conn);
/* 332 */         this.payLoadSTRUCT = localSTRUCT;
/*     */       }
/*     */       else
/*     */       {
/* 336 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 193);
/* 337 */         localSQLException.fillInStackTrace();
/* 338 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */ 
/* 342 */     return localSTRUCT;
/*     */   }
/*     */ 
/*     */   public boolean isSTRUCTPayload()
/*     */     throws SQLException
/*     */   {
/* 354 */     if ((this.toid == null) || (this.toid.length != 16))
/*     */     {
/* 356 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 252);
/* 357 */       localSQLException.fillInStackTrace();
/* 358 */       throw localSQLException;
/*     */     }
/*     */ 
/* 361 */     boolean bool = true;
/*     */ 
/* 363 */     int i = 1;
/* 364 */     for (int j = 0; j < 15; j++) {
/* 365 */       if (this.toid[j] != 0)
/*     */       {
/* 367 */         i = 0;
/* 368 */         break;
/*     */       }
/*     */     }
/* 371 */     if ((i != 0) || (isRAWPayload()) || (isANYDATAPayload())) {
/* 372 */       bool = false;
/*     */     }
/* 374 */     return bool;
/*     */   }
/*     */ 
/*     */   public ANYDATA getANYDATAPayload()
/*     */     throws SQLException
/*     */   {
/* 386 */     ANYDATA localANYDATA = null;
/*     */ 
/* 388 */     if (this.payLoadANYDATA != null) {
/* 389 */       localANYDATA = this.payLoadANYDATA;
/*     */     }
/*     */     else
/*     */     {
/*     */       Object localObject;
/* 390 */       if (isANYDATAPayload())
/*     */       {
/* 392 */         localObject = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", this.conn);
/*     */ 
/* 394 */         OPAQUE localOPAQUE = new OPAQUE((OpaqueDescriptor)localObject, this.payload, this.conn);
/* 395 */         this.payLoadANYDATA = new ANYDATA(localOPAQUE);
/* 396 */         localANYDATA = this.payLoadANYDATA;
/*     */       }
/*     */       else
/*     */       {
/* 400 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 193);
/* 401 */         ((SQLException)localObject).fillInStackTrace();
/* 402 */         throw ((Throwable)localObject);
/*     */       }
/*     */     }
/* 404 */     return localANYDATA;
/*     */   }
/*     */ 
/*     */   public boolean isANYDATAPayload()
/*     */     throws SQLException
/*     */   {
/* 416 */     if ((this.toid == null) || (this.toid.length != 16))
/*     */     {
/* 418 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 252);
/* 419 */       localSQLException.fillInStackTrace();
/* 420 */       throw localSQLException;
/*     */     }
/* 422 */     if (((this.typeName != null) && (this.typeName.equals("SYS.ANYDATA"))) || (compareToid(this.toid, TypeDescriptor.ANYDATATOID)))
/*     */     {
/* 424 */       return true;
/*     */     }
/* 426 */     return false;
/*     */   }
/*     */ 
/*     */   public XMLType getXMLTypePayload()
/*     */     throws SQLException
/*     */   {
/* 438 */     XMLType localXMLType = null;
/*     */ 
/* 440 */     if (this.payLoadXMLType != null) {
/* 441 */       localXMLType = this.payLoadXMLType;
/*     */     }
/*     */     else
/*     */     {
/*     */       Object localObject;
/* 442 */       if (isXMLTypePayload())
/*     */       {
/* 444 */         localObject = OpaqueDescriptor.createDescriptor("SYS.XMLTYPE", this.conn);
/*     */ 
/* 446 */         OPAQUE localOPAQUE = new OPAQUE((OpaqueDescriptor)localObject, this.payload, this.conn);
/* 447 */         this.payLoadXMLType = XMLType.createXML(localOPAQUE);
/* 448 */         localXMLType = this.payLoadXMLType;
/*     */       }
/*     */       else
/*     */       {
/* 452 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 193);
/* 453 */         ((SQLException)localObject).fillInStackTrace();
/* 454 */         throw ((Throwable)localObject);
/*     */       }
/*     */     }
/* 456 */     return localXMLType;
/*     */   }
/*     */ 
/*     */   public boolean isXMLTypePayload()
/*     */     throws SQLException
/*     */   {
/* 468 */     if ((this.toid == null) || (this.toid.length != 16))
/*     */     {
/* 470 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 252);
/* 471 */       localSQLException.fillInStackTrace();
/* 472 */       throw localSQLException;
/*     */     }
/* 474 */     if (((this.typeName != null) && (this.typeName.equals("SYS.XMLTYPE"))) || (compareToid(this.toid, TypeDescriptor.XMLTYPETOID)))
/*     */     {
/* 476 */       return true;
/*     */     }
/* 478 */     return false;
/*     */   }
/*     */ 
/*     */   public byte[] getPayloadTOID()
/*     */   {
/* 485 */     return this.toid;
/*     */   }
/*     */ 
/*     */   static boolean compareToid(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*     */   {
/* 492 */     boolean bool = false;
/*     */ 
/* 494 */     if (paramArrayOfByte1 != null)
/*     */     {
/* 496 */       if (paramArrayOfByte1 == paramArrayOfByte2) {
/* 497 */         bool = true;
/* 498 */       } else if (paramArrayOfByte1.length == paramArrayOfByte2.length)
/*     */       {
/* 500 */         int i = 1;
/* 501 */         for (int j = 0; j < paramArrayOfByte1.length; j++)
/* 502 */           if (paramArrayOfByte1[j] != paramArrayOfByte2[j])
/*     */           {
/* 504 */             i = 0;
/* 505 */             break;
/*     */           }
/* 507 */         if (i != 0)
/* 508 */           bool = true;
/*     */       }
/*     */     }
/* 511 */     return bool;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 523 */     StringBuffer localStringBuffer = new StringBuffer();
/* 524 */     localStringBuffer.append("Message Properties={");
/* 525 */     localStringBuffer.append(this.properties);
/* 526 */     localStringBuffer.append("} ");
/* 527 */     return localStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 542 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.AQMessageI
 * JD-Core Version:    0.6.2
 */