/*     */ package oracle.jdbc.diagnostics;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Hashtable;
/*     */ import java.util.logging.FileHandler;
/*     */ import java.util.logging.Handler;
/*     */ import java.util.logging.LogManager;
/*     */ import java.util.logging.LogRecord;
/*     */ 
/*     */ public class DemultiplexingLogHandler extends FileHandler
/*     */ {
/*     */   static final String PROPERTY_PATTERN = "oracle.jdbc.diagnostics.DemultiplexingLogHandler.pattern";
/*     */   static final String PROPERTY_LIMIT = "oracle.jdbc.diagnostics.DemultiplexingLogHandler.limit";
/*     */   static final String PROPERTY_COUNT = "oracle.jdbc.diagnostics.DemultiplexingLogHandler.count";
/*     */   static final String PROPERTY_APPEND = "oracle.jdbc.diagnostics.DemultiplexingLogHandler.append";
/*     */   static final String DEFAULT_PATTERN = "%h/ojdbc_%s.trc";
/*  49 */   static final String DEFAULT_APPEND = String.valueOf(false);
/*  50 */   static final String DEFAULT_LIMIT = String.valueOf(2147483647);
/*  51 */   static final String DEFAULT_COUNT = String.valueOf(1);
/*     */   String localPattern;
/*     */   boolean localAppend;
/*     */   int localLimit;
/*     */   int localCount;
/* 143 */   Hashtable<Object, Handler> handlerList = new Hashtable(50);
/*     */ 
/*     */   public DemultiplexingLogHandler()
/*     */     throws IOException
/*     */   {
/*  61 */     super(getFilename(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.pattern", "%h/ojdbc_%s.trc"), "MAIN"), Integer.parseInt(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.limit", DEFAULT_LIMIT)), Integer.parseInt(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.count", DEFAULT_COUNT)), Boolean.getBoolean(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.append", DEFAULT_APPEND)));
/*     */   }
/*     */ 
/*     */   public DemultiplexingLogHandler(String paramString)
/*     */     throws IOException
/*     */   {
/*  70 */     super(getFilename(paramString, "MAIN"), Integer.parseInt(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.limit", DEFAULT_LIMIT)), Integer.parseInt(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.count", DEFAULT_COUNT)), Boolean.getBoolean(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.append", DEFAULT_APPEND)));
/*     */   }
/*     */ 
/*     */   public DemultiplexingLogHandler(String paramString, boolean paramBoolean)
/*     */     throws IOException
/*     */   {
/*  79 */     super(getFilename(paramString, "MAIN"), Integer.parseInt(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.limit", DEFAULT_LIMIT)), Integer.parseInt(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.count", DEFAULT_COUNT)), paramBoolean);
/*     */   }
/*     */ 
/*     */   public DemultiplexingLogHandler(String paramString, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/*  88 */     super(getFilename(paramString, "MAIN"), paramInt1, paramInt2, Boolean.getBoolean(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.append", DEFAULT_APPEND)));
/*     */   }
/*     */ 
/*     */   public DemultiplexingLogHandler(String paramString, int paramInt1, int paramInt2, boolean paramBoolean)
/*     */     throws IOException
/*     */   {
/*  99 */     super(getFilename(paramString, "MAIN"), paramInt1, paramInt2, paramBoolean);
/*     */   }
/*     */ 
/*     */   void initValues()
/*     */   {
/* 110 */     this.localPattern = getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.pattern", "%h/ojdbc_%s.trc");
/* 111 */     this.localLimit = Integer.parseInt(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.limit", DEFAULT_LIMIT));
/* 112 */     this.localCount = Integer.parseInt(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.count", DEFAULT_COUNT));
/* 113 */     this.localAppend = Boolean.getBoolean(getProperty("oracle.jdbc.diagnostics.DemultiplexingLogHandler.append", DEFAULT_APPEND));
/*     */   }
/*     */ 
/*     */   static final String getFilename(String paramString1, String paramString2)
/*     */   {
/* 122 */     if (paramString1 == null) {
/* 123 */       paramString1 = "%h/ojdbc_%s.trc";
/*     */     }
/* 125 */     if (paramString1.contains("%s"))
/*     */     {
/* 127 */       return paramString1.replaceAll("%s", paramString2);
/*     */     }
/*     */ 
/* 130 */     return paramString1 + "." + paramString2;
/*     */   }
/*     */ 
/*     */   static String getProperty(String paramString1, String paramString2)
/*     */   {
/* 138 */     String str = LogManager.getLogManager().getProperty(paramString1);
/* 139 */     return str != null ? str : paramString2;
/*     */   }
/*     */ 
/*     */   public void publish(LogRecord paramLogRecord)
/*     */   {
/* 147 */     Object[] arrayOfObject = paramLogRecord.getParameters();
/* 148 */     if ((arrayOfObject != null) && (arrayOfObject.length > 0))
/*     */     {
/* 151 */       Object localObject = (Handler)this.handlerList.get(arrayOfObject[0]);
/* 152 */       if (localObject == null)
/*     */       {
/* 154 */         if (this.localPattern == null)
/* 155 */           initValues();
/*     */         try
/*     */         {
/* 158 */           localObject = new FileHandler(getFilename(this.localPattern, (String)arrayOfObject[0]), this.localLimit, this.localCount, this.localAppend);
/*     */ 
/* 163 */           ((Handler)localObject).setFormatter(getFormatter());
/* 164 */           ((Handler)localObject).setFilter(getFilter());
/* 165 */           ((Handler)localObject).setLevel(getLevel());
/* 166 */           ((Handler)localObject).setEncoding(getEncoding());
/* 167 */           ((Handler)localObject).setErrorManager(getErrorManager());
/*     */         }
/*     */         catch (IOException localIOException)
/*     */         {
/* 171 */           reportError("Unable open FileHandler", localIOException, 0);
/*     */         }
/*     */ 
/* 174 */         this.handlerList.put(arrayOfObject[0], localObject);
/*     */       }
/* 176 */       ((Handler)localObject).publish(paramLogRecord);
/*     */     }
/*     */     else {
/* 179 */       super.publish(paramLogRecord);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void close()
/*     */   {
/* 185 */     for (Handler localHandler : this.handlerList.values()) {
/* 186 */       localHandler.close();
/*     */     }
/* 188 */     super.close();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.diagnostics.DemultiplexingLogHandler
 * JD-Core Version:    0.6.2
 */