/*     */ package oracle.jdbc.dcn;
/*     */ 
/*     */ import java.util.EnumSet;
/*     */ 
/*     */ public abstract interface TableChangeDescription
/*     */ {
/*     */   public abstract EnumSet<TableOperation> getTableOperations();
/*     */ 
/*     */   public abstract String getTableName();
/*     */ 
/*     */   public abstract int getObjectNumber();
/*     */ 
/*     */   public abstract RowChangeDescription[] getRowChangeDescription();
/*     */ 
/*     */   public static enum TableOperation
/*     */   {
/*  57 */     ALL_ROWS(1), 
/*     */ 
/*  61 */     INSERT(2), 
/*     */ 
/*  65 */     UPDATE(4), 
/*     */ 
/*  69 */     DELETE(8), 
/*     */ 
/*  73 */     ALTER(16), 
/*     */ 
/*  77 */     DROP(32);
/*     */ 
/*     */     private final int code;
/*     */ 
/*  81 */     private TableOperation(int paramInt) { this.code = paramInt; }
/*     */ 
/*     */ 
/*     */     public final int getCode()
/*     */     {
/*  88 */       return this.code;
/*     */     }
/*     */ 
/*     */     public static final EnumSet<TableOperation> getTableOperations(int paramInt)
/*     */     {
/*  95 */       EnumSet localEnumSet = EnumSet.noneOf(TableOperation.class);
/*  96 */       if ((paramInt & ALL_ROWS.getCode()) != 0)
/*  97 */         localEnumSet.add(ALL_ROWS);
/*  98 */       if ((paramInt & INSERT.getCode()) != 0)
/*  99 */         localEnumSet.add(INSERT);
/* 100 */       if ((paramInt & UPDATE.getCode()) != 0)
/* 101 */         localEnumSet.add(UPDATE);
/* 102 */       if ((paramInt & DELETE.getCode()) != 0)
/* 103 */         localEnumSet.add(DELETE);
/* 104 */       if ((paramInt & ALTER.getCode()) != 0)
/* 105 */         localEnumSet.add(ALTER);
/* 106 */       if ((paramInt & DROP.getCode()) != 0)
/* 107 */         localEnumSet.add(DROP);
/* 108 */       return localEnumSet;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.dcn.TableChangeDescription
 * JD-Core Version:    0.6.2
 */