/*     */ package oracle.jdbc.dcn;
/*     */ 
/*     */ import java.util.EventObject;
/*     */ 
/*     */ public abstract class DatabaseChangeEvent extends EventObject
/*     */ {
/* 256 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected DatabaseChangeEvent(Object paramObject)
/*     */   {
/*  49 */     super(paramObject);
/*     */   }
/*     */ 
/*     */   public abstract EventType getEventType();
/*     */ 
/*     */   public abstract AdditionalEventType getAdditionalEventType();
/*     */ 
/*     */   public abstract TableChangeDescription[] getTableChangeDescription();
/*     */ 
/*     */   public abstract QueryChangeDescription[] getQueryChangeDescription();
/*     */ 
/*     */   public abstract String getConnectionInformation();
/*     */ 
/*     */   public abstract String getDatabaseName();
/*     */ 
/*     */   /** @deprecated */
/*     */   public abstract int getRegistrationId();
/*     */ 
/*     */   public abstract long getRegId();
/*     */ 
/*     */   public abstract byte[] getTransactionId();
/*     */ 
/*     */   public abstract String getTransactionId(boolean paramBoolean);
/*     */ 
/*     */   public abstract String toString();
/*     */ 
/*     */   public static enum AdditionalEventType
/*     */   {
/* 131 */     NONE(0), 
/*     */ 
/* 135 */     TIMEOUT(1), 
/*     */ 
/* 139 */     GROUPING(2);
/*     */ 
/*     */     private final int code;
/*     */ 
/*     */     private AdditionalEventType(int paramInt)
/*     */     {
/* 145 */       this.code = paramInt;
/*     */     }
/*     */ 
/*     */     public final int getCode()
/*     */     {
/* 153 */       return this.code;
/*     */     }
/*     */ 
/*     */     public static final AdditionalEventType getEventType(int paramInt)
/*     */     {
/* 160 */       if (paramInt == TIMEOUT.getCode())
/* 161 */         return TIMEOUT;
/* 162 */       if (paramInt == GROUPING.getCode()) {
/* 163 */         return GROUPING;
/*     */       }
/* 165 */       return NONE;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum EventType
/*     */   {
/*  59 */     NONE(0), 
/*     */ 
/*  63 */     STARTUP(1), 
/*     */ 
/*  67 */     SHUTDOWN(2), 
/*     */ 
/*  71 */     SHUTDOWN_ANY(3), 
/*     */ 
/*  75 */     DEREG(5), 
/*     */ 
/*  79 */     OBJCHANGE(6), 
/*     */ 
/*  83 */     QUERYCHANGE(7);
/*     */ 
/*     */     private final int code;
/*     */ 
/*     */     private EventType(int paramInt) {
/*  88 */       this.code = paramInt;
/*     */     }
/*     */ 
/*     */     public final int getCode()
/*     */     {
/*  96 */       return this.code;
/*     */     }
/*     */ 
/*     */     public static final EventType getEventType(int paramInt)
/*     */     {
/* 103 */       if (paramInt == STARTUP.getCode())
/* 104 */         return STARTUP;
/* 105 */       if (paramInt == SHUTDOWN.getCode())
/* 106 */         return SHUTDOWN;
/* 107 */       if (paramInt == SHUTDOWN_ANY.getCode())
/* 108 */         return SHUTDOWN_ANY;
/* 109 */       if (paramInt == DEREG.getCode())
/* 110 */         return DEREG;
/* 111 */       if (paramInt == OBJCHANGE.getCode())
/* 112 */         return OBJCHANGE;
/* 113 */       if (paramInt == QUERYCHANGE.getCode()) {
/* 114 */         return QUERYCHANGE;
/*     */       }
/* 116 */       return NONE;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.dcn.DatabaseChangeEvent
 * JD-Core Version:    0.6.2
 */