/*     */ package oracle.jdbc.connector;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.EISSystemException;
/*     */ import javax.resource.spi.ManagedConnectionMetaData;
/*     */ import oracle.jdbc.OracleConnection;
/*     */ import oracle.jdbc.OracleDatabaseMetaData;
/*     */ 
/*     */ public class OracleManagedConnectionMetaData
/*     */   implements ManagedConnectionMetaData
/*     */ {
/*  28 */   private OracleManagedConnection managedConnection = null;
/*  29 */   private OracleDatabaseMetaData databaseMetaData = null;
/*     */ 
/* 213 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   OracleManagedConnectionMetaData(OracleManagedConnection paramOracleManagedConnection)
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/*  40 */       this.managedConnection = paramOracleManagedConnection;
/*     */ 
/*  42 */       OracleConnection localOracleConnection = (OracleConnection)paramOracleManagedConnection.getPhysicalConnection();
/*     */ 
/*  44 */       this.databaseMetaData = ((OracleDatabaseMetaData)localOracleConnection.getMetaData());
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*  48 */       EISSystemException localEISSystemException = new EISSystemException("Exception: " + localException.getMessage());
/*     */ 
/*  51 */       localEISSystemException.setLinkedException(localException);
/*     */ 
/*  53 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getEISProductName()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/*  79 */       return this.databaseMetaData.getDatabaseProductName();
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*  85 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/*  88 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/*  90 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getEISProductVersion()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 116 */       return this.databaseMetaData.getDatabaseProductVersion();
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 121 */       EISSystemException localEISSystemException = new EISSystemException("Exception: " + localException.getMessage());
/*     */ 
/* 124 */       localEISSystemException.setLinkedException(localException);
/*     */ 
/* 126 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getMaxConnections()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 154 */       return this.databaseMetaData.getMaxConnections();
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 160 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/* 163 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/* 165 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getUserName()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 193 */       return this.databaseMetaData.getUserName();
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 199 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/* 202 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/* 204 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.connector.OracleManagedConnectionMetaData
 * JD-Core Version:    0.6.2
 */