/*     */ package oracle.jdbc.connector;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Iterator;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.EISSystemException;
/*     */ import javax.resource.spi.ManagedConnection;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import javax.resource.spi.ResourceAdapterInternalException;
/*     */ import javax.resource.spi.security.PasswordCredential;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.sql.DataSource;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.sql.XADataSource;
/*     */ 
/*     */ public class OracleManagedConnectionFactory
/*     */   implements ManagedConnectionFactory
/*     */ {
/*  42 */   private XADataSource xaDataSource = null;
/*  43 */   private String xaDataSourceName = null;
/*     */   private static final String RAERR_MCF_SET_XADS = "invalid xads";
/*     */   private static final String RAERR_MCF_GET_PCRED = "no password credential";
/* 489 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleManagedConnectionFactory()
/*     */     throws ResourceException
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleManagedConnectionFactory(XADataSource paramXADataSource)
/*     */     throws ResourceException
/*     */   {
/*  73 */     this.xaDataSource = paramXADataSource;
/*  74 */     this.xaDataSourceName = "XADataSource";
/*     */   }
/*     */ 
/*     */   public void setXADataSourceName(String paramString)
/*     */   {
/*  88 */     this.xaDataSourceName = paramString;
/*     */   }
/*     */ 
/*     */   public String getXADataSourceName()
/*     */   {
/* 102 */     return this.xaDataSourceName;
/*     */   }
/*     */ 
/*     */   public Object createConnectionFactory(ConnectionManager paramConnectionManager)
/*     */     throws ResourceException
/*     */   {
/* 127 */     if (this.xaDataSource == null)
/*     */     {
/* 129 */       setupXADataSource();
/*     */     }
/*     */ 
/* 132 */     return (DataSource)this.xaDataSource;
/*     */   }
/*     */ 
/*     */   public Object createConnectionFactory()
/*     */     throws ResourceException
/*     */   {
/* 155 */     return createConnectionFactory(null);
/*     */   }
/*     */ 
/*     */   public ManagedConnection createManagedConnection(Subject paramSubject, ConnectionRequestInfo paramConnectionRequestInfo)
/*     */     throws ResourceException
/*     */   {
/*     */     Object localObject;
/*     */     try
/*     */     {
/* 185 */       if (this.xaDataSource == null)
/*     */       {
/* 187 */         setupXADataSource();
/*     */       }
/*     */ 
/* 190 */       XAConnection localXAConnection = null;
/* 191 */       localObject = getPasswordCredential(paramSubject, paramConnectionRequestInfo);
/*     */ 
/* 193 */       if (localObject == null)
/*     */       {
/* 195 */         localXAConnection = this.xaDataSource.getXAConnection();
/*     */       }
/*     */       else
/*     */       {
/* 199 */         localXAConnection = this.xaDataSource.getXAConnection(((PasswordCredential)localObject).getUserName(), new String(((PasswordCredential)localObject).getPassword()));
/*     */       }
/*     */ 
/* 203 */       OracleManagedConnection localOracleManagedConnection = new OracleManagedConnection(localXAConnection);
/*     */ 
/* 205 */       localOracleManagedConnection.setPasswordCredential((PasswordCredential)localObject);
/*     */ 
/* 208 */       localOracleManagedConnection.setLogWriter(getLogWriter());
/*     */ 
/* 210 */       return localOracleManagedConnection;
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 214 */       localObject = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/* 217 */       ((ResourceException)localObject).setLinkedException(localSQLException);
/*     */     }
/* 219 */     throw ((Throwable)localObject);
/*     */   }
/*     */ 
/*     */   public ManagedConnection matchManagedConnections(Set paramSet, Subject paramSubject, ConnectionRequestInfo paramConnectionRequestInfo)
/*     */     throws ResourceException
/*     */   {
/* 252 */     PasswordCredential localPasswordCredential = getPasswordCredential(paramSubject, paramConnectionRequestInfo);
/* 253 */     Iterator localIterator = paramSet.iterator();
/*     */ 
/* 255 */     while (localIterator.hasNext())
/*     */     {
/* 257 */       Object localObject = localIterator.next();
/*     */ 
/* 259 */       if ((localObject instanceof OracleManagedConnection))
/*     */       {
/* 261 */         OracleManagedConnection localOracleManagedConnection = (OracleManagedConnection)localObject;
/*     */ 
/* 264 */         if (localOracleManagedConnection.getPasswordCredential().equals(localPasswordCredential))
/*     */         {
/* 266 */           return localOracleManagedConnection;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 271 */     return null;
/*     */   }
/*     */ 
/*     */   public void setLogWriter(PrintWriter paramPrintWriter)
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 296 */       if (this.xaDataSource == null)
/*     */       {
/* 298 */         setupXADataSource();
/*     */       }
/*     */ 
/* 301 */       this.xaDataSource.setLogWriter(paramPrintWriter);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 307 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/* 310 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/* 312 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public PrintWriter getLogWriter()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 337 */       if (this.xaDataSource == null)
/*     */       {
/* 339 */         setupXADataSource();
/*     */       }
/*     */ 
/* 342 */       return this.xaDataSource.getLogWriter();
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 348 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/* 351 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/* 353 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setupXADataSource()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 400 */       InitialContext localInitialContext = null;
/*     */       try
/*     */       {
/* 404 */         Properties localProperties = System.getProperties();
/*     */ 
/* 406 */         localInitialContext = new InitialContext(localProperties);
/*     */       }
/*     */       catch (java.lang.SecurityException localSecurityException)
/*     */       {
/*     */       }
/*     */ 
/* 412 */       if (localInitialContext == null)
/*     */       {
/* 414 */         localInitialContext = new InitialContext();
/*     */       }
/*     */ 
/* 417 */       localObject = (XADataSource)localInitialContext.lookup(this.xaDataSourceName);
/*     */ 
/* 419 */       if (localObject == null)
/*     */       {
/* 421 */         throw new ResourceAdapterInternalException("Invalid XADataSource object");
/*     */       }
/*     */ 
/* 424 */       this.xaDataSource = ((XADataSource)localObject);
/*     */     }
/*     */     catch (NamingException localNamingException)
/*     */     {
/* 428 */       Object localObject = new ResourceException("NamingException: " + localNamingException.getMessage());
/*     */ 
/* 431 */       ((ResourceException)localObject).setLinkedException(localNamingException);
/*     */ 
/* 433 */       throw ((Throwable)localObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   private PasswordCredential getPasswordCredential(Subject paramSubject, ConnectionRequestInfo paramConnectionRequestInfo)
/*     */     throws ResourceException
/*     */   {
/* 446 */     if (paramSubject != null)
/*     */     {
/* 450 */       localObject1 = paramSubject.getPrivateCredentials(PasswordCredential.class);
/* 451 */       localObject2 = ((Set)localObject1).iterator();
/*     */ 
/* 453 */       while (((Iterator)localObject2).hasNext())
/*     */       {
/* 455 */         PasswordCredential localPasswordCredential = (PasswordCredential)((Iterator)localObject2).next();
/*     */ 
/* 457 */         if (localPasswordCredential.getManagedConnectionFactory().equals(this))
/*     */         {
/* 459 */           return localPasswordCredential;
/*     */         }
/*     */       }
/*     */ 
/* 463 */       throw new javax.resource.spi.SecurityException("Can not find user/password information", "no password credential");
/*     */     }
/*     */ 
/* 467 */     if (paramConnectionRequestInfo == null)
/*     */     {
/* 469 */       return null;
/*     */     }
/*     */ 
/* 473 */     Object localObject1 = (OracleConnectionRequestInfo)paramConnectionRequestInfo;
/*     */ 
/* 475 */     Object localObject2 = new PasswordCredential(((OracleConnectionRequestInfo)localObject1).getUser(), ((OracleConnectionRequestInfo)localObject1).getPassword().toCharArray());
/*     */ 
/* 478 */     ((PasswordCredential)localObject2).setManagedConnectionFactory(this);
/*     */ 
/* 480 */     return localObject2;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.connector.OracleManagedConnectionFactory
 * JD-Core Version:    0.6.2
 */