/*     */ package oracle.jdbc.connector;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionEvent;
/*     */ import javax.resource.spi.ConnectionEventListener;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.EISSystemException;
/*     */ import javax.resource.spi.IllegalStateException;
/*     */ import javax.resource.spi.LocalTransaction;
/*     */ import javax.resource.spi.ManagedConnection;
/*     */ import javax.resource.spi.ManagedConnectionMetaData;
/*     */ import javax.resource.spi.security.PasswordCredential;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.xa.OracleXAConnection;
/*     */ 
/*     */ public class OracleManagedConnection
/*     */   implements ManagedConnection
/*     */ {
/*  39 */   private OracleXAConnection xaConnection = null;
/*  40 */   private Hashtable connectionListeners = null;
/*  41 */   private Connection connection = null;
/*  42 */   private PrintWriter logWriter = null;
/*  43 */   private PasswordCredential passwordCredential = null;
/*  44 */   private OracleLocalTransaction localTxn = null;
/*     */ 
/* 503 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   OracleManagedConnection(XAConnection paramXAConnection)
/*     */   {
/*  51 */     this.xaConnection = ((OracleXAConnection)paramXAConnection);
/*  52 */     this.connectionListeners = new Hashtable(10);
/*     */   }
/*     */ 
/*     */   public Object getConnection(Subject paramSubject, ConnectionRequestInfo paramConnectionRequestInfo)
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/*  90 */       if (this.connection != null) {
/*  91 */         this.connection.close();
/*     */       }
/*  93 */       this.connection = this.xaConnection.getConnection();
/*     */ 
/*  95 */       return this.connection;
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*  99 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/* 102 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/* 104 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 127 */       if (this.xaConnection != null)
/*     */       {
/* 131 */         Connection localConnection = this.xaConnection.getPhysicalHandle();
/*     */ 
/* 135 */         if (((this.localTxn != null) && (this.localTxn.isBeginCalled)) || (((OracleConnection)localConnection).getTxnMode() == 1))
/*     */         {
/* 139 */           throw new IllegalStateException("Could not close connection while transaction is active");
/*     */         }
/*     */       }
/*     */ 
/* 143 */       if (this.connection != null) {
/* 144 */         this.connection.close();
/*     */       }
/* 146 */       if (this.xaConnection != null) {
/* 147 */         this.xaConnection.close();
/*     */       }
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 152 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/* 155 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/* 157 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void cleanup()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 187 */       if (this.connection != null)
/*     */       {
/* 192 */         if (((this.localTxn != null) && (this.localTxn.isBeginCalled)) || (((OracleConnection)this.connection).getTxnMode() == 1))
/*     */         {
/* 196 */           throw new IllegalStateException("Could not close connection while transaction is active");
/*     */         }
/*     */ 
/* 199 */         this.connection.close();
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 205 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/* 208 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/* 210 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void associateConnection(Object paramObject)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void addConnectionEventListener(ConnectionEventListener paramConnectionEventListener)
/*     */   {
/* 257 */     this.connectionListeners.put(paramConnectionEventListener, paramConnectionEventListener);
/*     */   }
/*     */ 
/*     */   public void removeConnectionEventListener(ConnectionEventListener paramConnectionEventListener)
/*     */   {
/* 283 */     this.connectionListeners.remove(paramConnectionEventListener);
/*     */   }
/*     */ 
/*     */   public XAResource getXAResource()
/*     */     throws ResourceException
/*     */   {
/* 309 */     return this.xaConnection.getXAResource();
/*     */   }
/*     */ 
/*     */   public LocalTransaction getLocalTransaction()
/*     */     throws ResourceException
/*     */   {
/* 331 */     if (this.localTxn == null)
/*     */     {
/* 333 */       this.localTxn = new OracleLocalTransaction(this);
/*     */     }
/*     */ 
/* 336 */     return this.localTxn;
/*     */   }
/*     */ 
/*     */   public ManagedConnectionMetaData getMetaData()
/*     */     throws ResourceException
/*     */   {
/* 357 */     return new OracleManagedConnectionMetaData(this);
/*     */   }
/*     */ 
/*     */   public void setLogWriter(PrintWriter paramPrintWriter)
/*     */     throws ResourceException
/*     */   {
/* 379 */     this.logWriter = paramPrintWriter;
/*     */   }
/*     */ 
/*     */   public PrintWriter getLogWriter()
/*     */     throws ResourceException
/*     */   {
/* 400 */     return this.logWriter;
/*     */   }
/*     */ 
/*     */   Connection getPhysicalConnection()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 411 */       return this.xaConnection.getPhysicalHandle();
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 416 */       EISSystemException localEISSystemException = new EISSystemException("Exception: " + localException.getMessage());
/*     */ 
/* 419 */       localEISSystemException.setLinkedException(localException);
/*     */ 
/* 421 */       throw localEISSystemException;
/*     */     }
/*     */   }
/*     */ 
/*     */   void setPasswordCredential(PasswordCredential paramPasswordCredential)
/*     */   {
/* 432 */     this.passwordCredential = paramPasswordCredential;
/*     */   }
/*     */ 
/*     */   PasswordCredential getPasswordCredential()
/*     */   {
/* 441 */     return this.passwordCredential;
/*     */   }
/*     */ 
/*     */   void eventOccurred(int paramInt)
/*     */     throws ResourceException
/*     */   {
/* 450 */     Enumeration localEnumeration = this.connectionListeners.keys();
/*     */ 
/* 452 */     while (localEnumeration.hasMoreElements())
/*     */     {
/* 456 */       ConnectionEventListener localConnectionEventListener = (ConnectionEventListener)localEnumeration.nextElement();
/*     */ 
/* 460 */       ConnectionEvent localConnectionEvent = new ConnectionEvent(this, paramInt);
/*     */ 
/* 462 */       switch (paramInt)
/*     */       {
/*     */       case 1:
/* 467 */         localConnectionEventListener.connectionClosed(localConnectionEvent);
/*     */ 
/* 469 */         break;
/*     */       case 2:
/* 473 */         localConnectionEventListener.localTransactionStarted(localConnectionEvent);
/*     */ 
/* 475 */         break;
/*     */       case 3:
/* 478 */         localConnectionEventListener.localTransactionCommitted(localConnectionEvent);
/*     */ 
/* 480 */         break;
/*     */       case 4:
/* 483 */         localConnectionEventListener.localTransactionRolledback(localConnectionEvent);
/*     */ 
/* 485 */         break;
/*     */       case 5:
/* 489 */         localConnectionEventListener.connectionErrorOccurred(localConnectionEvent);
/*     */ 
/* 491 */         break;
/*     */       default:
/* 494 */         throw new IllegalArgumentException("Illegal eventType in eventOccurred(): " + paramInt);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.connector.OracleManagedConnection
 * JD-Core Version:    0.6.2
 */