/*     */ package oracle.jdbc.connector;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.EISSystemException;
/*     */ import javax.resource.spi.IllegalStateException;
/*     */ import javax.resource.spi.LocalTransaction;
/*     */ import javax.resource.spi.LocalTransactionException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class OracleLocalTransaction
/*     */   implements LocalTransaction
/*     */ {
/*  30 */   private OracleManagedConnection managedConnection = null;
/*  31 */   private Connection connection = null;
/*  32 */   boolean isBeginCalled = false;
/*     */   private static final String RAERR_LTXN_COMMIT = "commit without begin";
/*     */   private static final String RAERR_LTXN_ROLLBACK = "rollback without begin";
/* 193 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   OracleLocalTransaction(OracleManagedConnection paramOracleManagedConnection)
/*     */     throws ResourceException
/*     */   {
/*  43 */     this.managedConnection = paramOracleManagedConnection;
/*  44 */     this.connection = paramOracleManagedConnection.getPhysicalConnection();
/*  45 */     this.isBeginCalled = false;
/*     */   }
/*     */ 
/*     */   public void begin()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/*  74 */       if (((OracleConnection)this.connection).getTxnMode() == 1)
/*     */       {
/*  77 */         throw new IllegalStateException("Could not start a new transaction inside an active transaction");
/*     */       }
/*     */ 
/*  80 */       if (this.connection.getAutoCommit()) {
/*  81 */         this.connection.setAutoCommit(false);
/*     */       }
/*  83 */       this.isBeginCalled = true;
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*  88 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/*  91 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/*  93 */       throw localEISSystemException;
/*     */     }
/*     */ 
/*  97 */     this.managedConnection.eventOccurred(2);
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws ResourceException
/*     */   {
/* 121 */     if (!this.isBeginCalled) {
/* 122 */       throw new LocalTransactionException("begin() must be called before commit()", "commit without begin");
/*     */     }
/*     */     try
/*     */     {
/* 126 */       this.connection.commit();
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 131 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/* 134 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/* 136 */       throw localEISSystemException;
/*     */     }
/*     */ 
/* 140 */     this.isBeginCalled = false;
/*     */ 
/* 142 */     this.managedConnection.eventOccurred(3);
/*     */   }
/*     */ 
/*     */   public void rollback()
/*     */     throws ResourceException
/*     */   {
/* 166 */     if (!this.isBeginCalled) {
/* 167 */       throw new LocalTransactionException("begin() must be called before rollback()", "rollback without begin");
/*     */     }
/*     */     try
/*     */     {
/* 171 */       this.connection.rollback();
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 176 */       EISSystemException localEISSystemException = new EISSystemException("SQLException: " + localSQLException.getMessage());
/*     */ 
/* 179 */       localEISSystemException.setLinkedException(localSQLException);
/*     */ 
/* 181 */       throw localEISSystemException;
/*     */     }
/*     */ 
/* 185 */     this.isBeginCalled = false;
/*     */ 
/* 187 */     this.managedConnection.eventOccurred(4);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.connector.OracleLocalTransaction
 * JD-Core Version:    0.6.2
 */