/*     */ package oracle.jdbc.babelfish;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class Translator
/*     */ {
/*     */   private final File localErrorTranslationFile;
/*     */   private final String translationProfile;
/*     */   private Connection conn;
/*     */   private CallableStatement queryTranslationStatement;
/*     */   private CallableStatement errorTranslationStatement;
/*     */   private final Map<String, String> queryCache;
/*     */   private final Map<Integer, TranslatedErrorInfo> errorCache;
/*     */   private final Map<Integer, TranslatedErrorInfo> localErrorCache;
/* 379 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   Translator(String paramString, File paramFile, TranslationCache paramTranslationCache)
/*     */     throws SQLException
/*     */   {
/*  85 */     this.translationProfile = paramString;
/*  86 */     this.localErrorTranslationFile = paramFile;
/*     */ 
/*  88 */     this.queryCache = paramTranslationCache.getQueryCache();
/*  89 */     this.errorCache = paramTranslationCache.getErrorCache();
/*  90 */     this.localErrorCache = paramTranslationCache.getLocalErrorCache();
/*     */   }
/*     */ 
/*     */   public SQLException translateError(SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 106 */     if (this.conn == null)
/*     */     {
/* 108 */       return translateErrorLocal(paramSQLException);
/*     */     }
/*     */ 
/* 112 */     TranslatedErrorInfo localTranslatedErrorInfo = (TranslatedErrorInfo)this.errorCache.get(Integer.valueOf(paramSQLException.getErrorCode()));
/*     */ 
/* 114 */     if (localTranslatedErrorInfo != null)
/*     */     {
/* 116 */       SQLException localSQLException1 = new SQLException(new StringBuilder().append("[Translated Error Codes] ").append(paramSQLException.getMessage()).toString(), localTranslatedErrorInfo.getSqlState(), localTranslatedErrorInfo.getErrorCode(), paramSQLException);
/* 117 */       localSQLException1.setStackTrace(paramSQLException.getStackTrace());
/* 118 */       return localSQLException1;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 124 */       this.errorTranslationStatement.clearParameters();
/* 125 */       this.errorTranslationStatement.setInt(1, paramSQLException.getErrorCode());
/* 126 */       this.errorTranslationStatement.registerOutParameter(2, 4);
/* 127 */       this.errorTranslationStatement.registerOutParameter(3, 12);
/* 128 */       this.errorTranslationStatement.execute();
/*     */ 
/* 130 */       int i = this.errorTranslationStatement.getInt(2);
/* 131 */       if (this.errorTranslationStatement.wasNull())
/*     */       {
/* 133 */         i = paramSQLException.getErrorCode();
/*     */       }
/*     */ 
/* 136 */       localObject = this.errorTranslationStatement.getString(3);
/* 137 */       if (localObject == null)
/*     */       {
/* 139 */         localObject = paramSQLException.getSQLState();
/*     */       }
/* 141 */       localTranslatedErrorInfo = new TranslatedErrorInfo(i, (String)localObject);
/*     */     }
/*     */     catch (SQLException localSQLException2)
/*     */     {
/* 146 */       Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 280, null, localSQLException2);
/* 147 */       ((SQLException)localObject).fillInStackTrace();
/* 148 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 151 */     this.errorCache.put(Integer.valueOf(paramSQLException.getErrorCode()), localTranslatedErrorInfo);
/*     */ 
/* 153 */     SQLException localSQLException3 = new SQLException(new StringBuilder().append("[Translated Error Codes] ").append(paramSQLException.getMessage()).toString(), localTranslatedErrorInfo.getSqlState(), localTranslatedErrorInfo.getErrorCode(), paramSQLException);
/*     */ 
/* 155 */     localSQLException3.setStackTrace(paramSQLException.getStackTrace());
/* 156 */     return localSQLException3;
/*     */   }
/*     */ 
/*     */   SQLException translateErrorLocal(SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 172 */     if (this.localErrorCache == null)
/*     */     {
/* 175 */       return paramSQLException;
/*     */     }
/*     */ 
/* 179 */     TranslatedErrorInfo localTranslatedErrorInfo = (TranslatedErrorInfo)this.localErrorCache.get(Integer.valueOf(paramSQLException.getErrorCode()));
/* 180 */     if (localTranslatedErrorInfo != null)
/*     */     {
/* 182 */       localObject = new StringBuilder().append("[Translated Error Codes] ").append(paramSQLException.getMessage()).toString();
/*     */ 
/* 184 */       SQLException localSQLException = new SQLException((String)localObject, localTranslatedErrorInfo.getSqlState(), localTranslatedErrorInfo.getErrorCode(), paramSQLException);
/*     */ 
/* 189 */       localSQLException.setStackTrace(paramSQLException.getStackTrace());
/* 190 */       return localSQLException;
/*     */     }
/*     */ 
/* 194 */     Object localObject = new SQLException(new StringBuilder().append("[Error Translation Not Available] ").append(paramSQLException.getMessage()).toString(), paramSQLException.getSQLState(), paramSQLException.getErrorCode(), paramSQLException);
/*     */ 
/* 198 */     ((SQLException)localObject).setStackTrace(paramSQLException.getStackTrace());
/* 199 */     return localObject;
/*     */   }
/*     */ 
/*     */   String translateQuery(String paramString)
/*     */     throws SQLException
/*     */   {
/* 215 */     if (this.conn != null)
/*     */     {
/* 217 */       localObject = (String)this.queryCache.get(paramString);
/* 218 */       if (localObject != null)
/*     */       {
/* 220 */         return localObject;
/*     */       }
/*     */ 
/* 224 */       String str = convertParameterMarkersToOracleStyle(paramString);
/*     */       try
/*     */       {
/* 227 */         this.queryTranslationStatement.clearParameters();
/* 228 */         this.queryTranslationStatement.setString(1, str);
/* 229 */         this.queryTranslationStatement.registerOutParameter(2, 12);
/*     */ 
/* 231 */         this.queryTranslationStatement.execute();
/* 232 */         localObject = this.queryTranslationStatement.getString(2);
/*     */       }
/*     */       catch (SQLException localSQLException1)
/*     */       {
/* 238 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 280, null, localSQLException1);
/* 239 */         localSQLException2.fillInStackTrace();
/* 240 */         throw localSQLException2;
/*     */       }
/*     */ 
/* 244 */       if (localObject == null)
/*     */       {
/* 246 */         localObject = str;
/*     */       }
/* 248 */       this.queryCache.put(paramString, localObject);
/* 249 */       return localObject;
/*     */     }
/*     */ 
/* 255 */     Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 279);
/* 256 */     ((SQLException)localObject).fillInStackTrace();
/* 257 */     throw ((Throwable)localObject);
/*     */   }
/*     */ 
/*     */   public void activateServerTranslation(Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 279 */     CallableStatement localCallableStatement = paramConnection.prepareCall("begin execute immediate 'alter session set sql_translation_profile = ' || dbms_assert.qualified_sql_name(?); end;");
/* 280 */     localCallableStatement.setString(1, this.translationProfile);
/* 281 */     localCallableStatement.execute();
/*     */ 
/* 288 */     this.queryTranslationStatement = paramConnection.prepareCall("begin dbms_sql_translator.translate_sql(?, ? ); end;");
/*     */ 
/* 296 */     this.errorTranslationStatement = paramConnection.prepareCall("begin dbms_sql_translator.translate_error(?, ?, ? ); end;");
/*     */ 
/* 298 */     this.conn = paramConnection;
/*     */   }
/*     */ 
/*     */   void deactivateServerTranslation()
/*     */     throws SQLException
/*     */   {
/* 305 */     this.queryTranslationStatement.close();
/* 306 */     this.errorTranslationStatement.close();
/* 307 */     this.conn = null;
/*     */   }
/*     */ 
/*     */   String convertParameterMarkersToOracleStyle(String paramString)
/*     */   {
/* 327 */     StringBuilder localStringBuilder = new StringBuilder();
/*     */ 
/* 329 */     int i = 0;
/* 330 */     int j = 1;
/* 331 */     for (int k = 0; k < paramString.length(); k++)
/*     */     {
/* 333 */       char c = paramString.charAt(k);
/* 334 */       switch (c)
/*     */       {
/*     */       case '\\':
/* 338 */         localStringBuilder.append(c);
/* 339 */         if (k < paramString.length() - 1)
/*     */         {
/* 341 */           localStringBuilder.append(paramString.charAt(++k)); } break;
/*     */       case '?':
/* 346 */         if (i == 0)
/*     */         {
/* 348 */           localStringBuilder.append(" :").append(BabelfishPreparedStatement.NAMED_PARAMETER_PREFIX).append(j++).append(" "); } break;
/*     */       case '\'':
/* 353 */         i = i != 0 ? 0 : 1;
/*     */       default:
/* 355 */         localStringBuilder.append(c);
/*     */       }
/*     */     }
/* 358 */     return localStringBuilder.toString();
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 374 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.babelfish.Translator
 * JD-Core Version:    0.6.2
 */