/*     */ package oracle.jdbc.babelfish;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ 
/*     */ public class TranslationManager
/*     */ {
/*  49 */   private static final ConcurrentHashMap<String, TranslationCache> translationCacheRegistry = new ConcurrentHashMap();
/*  50 */   private static Map<String, String> defaultErrorFile = new ConcurrentHashMap();
/*     */   private static final String SEPARATOR = "";
/* 113 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public static Translator getTranslator(String paramString1, String paramString2, String paramString3, String paramString4)
/*     */     throws SQLException
/*     */   {
/*  74 */     if (paramString4 == null)
/*     */     {
/*  76 */       if (defaultErrorFile.containsKey(paramString3))
/*     */       {
/*  78 */         paramString4 = (String)defaultErrorFile.get(paramString3);
/*     */       }
/*     */     }
/*     */ 
/*  82 */     File localFile = null;
/*     */ 
/*  84 */     if (paramString4 != null)
/*     */     {
/*  86 */       localFile = new File(paramString4);
/*  87 */       if (!localFile.exists())
/*     */       {
/*  90 */         localObject = DatabaseError.createSqlException(null, 277);
/*  91 */         ((SQLException)localObject).fillInStackTrace();
/*  92 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  97 */     assert ((!"".matches(paramString1)) && (!"".matches(paramString2)) && (!"".matches(paramString3)));
/*  98 */     Object localObject = paramString1 + "" + paramString2 + "" + paramString3;
/*  99 */     TranslationCache localTranslationCache = (TranslationCache)translationCacheRegistry.get(localObject);
/*     */ 
/* 101 */     if (localTranslationCache == null)
/*     */     {
/* 103 */       localTranslationCache = new TranslationCache(localFile);
/* 104 */       translationCacheRegistry.putIfAbsent(localObject, localTranslationCache);
/*     */     }
/*     */ 
/* 107 */     Translator localTranslator = new Translator(paramString3, localFile, localTranslationCache);
/* 108 */     return localTranslator;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.babelfish.TranslationManager
 * JD-Core Version:    0.6.2
 */