/*     */ package oracle.jdbc.babelfish;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ class TranslationCache
/*     */ {
/*     */   private Map<String, String> queryCache;
/*     */   private Map<Integer, TranslatedErrorInfo> errorCache;
/*     */   private Map<Integer, TranslatedErrorInfo> localErrorCache;
/* 232 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   TranslationCache(File paramFile)
/*     */     throws SQLException
/*     */   {
/*  83 */     this.queryCache = new ConcurrentHashMap();
/*  84 */     this.errorCache = new ConcurrentHashMap();
/*     */ 
/*  86 */     if (paramFile != null)
/*     */     {
/*  88 */       this.localErrorCache = new ConcurrentHashMap();
/*  89 */       readLocalErrorFile(paramFile);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readLocalErrorFile(File paramFile)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 114 */       DocumentBuilderFactory localDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
/* 115 */       localDocumentBuilderFactory.setValidating(true);
/* 116 */       localObject = localDocumentBuilderFactory.newDocumentBuilder();
/* 117 */       Document localDocument = ((DocumentBuilder)localObject).parse(paramFile);
/*     */ 
/* 119 */       int i = 0;
/* 120 */       TranslatedErrorInfo localTranslatedErrorInfo = null;
/* 121 */       NodeList localNodeList1 = localDocument.getElementsByTagName("Exception");
/*     */ 
/* 123 */       for (int j = 0; j < localNodeList1.getLength(); j++)
/*     */       {
/* 125 */         localTranslatedErrorInfo = new TranslatedErrorInfo();
/* 126 */         Node localNode = localNodeList1.item(j);
/* 127 */         NodeList localNodeList2 = localNode.getChildNodes();
/*     */ 
/* 129 */         for (int k = 0; k < localNodeList2.getLength(); k++)
/*     */         {
/* 131 */           if (localNodeList2.item(k).getNodeType() == 1)
/*     */           {
/* 135 */             Element localElement = (Element)localNodeList2.item(k);
/*     */ 
/* 137 */             if (localElement.getTagName().equals("ORAError"))
/*     */             {
/* 139 */               i = Integer.parseInt(localElement.getFirstChild().getNodeValue());
/*     */             }
/* 141 */             else if (localElement.getTagName().equals("ErrorCode"))
/*     */             {
/* 143 */               localTranslatedErrorInfo.setErrorCode(Integer.parseInt(localElement.getFirstChild().getNodeValue()));
/*     */             }
/* 145 */             else if (localElement.getTagName().equals("SQLState"))
/*     */             {
/* 147 */               localTranslatedErrorInfo.setSqlState(localElement.getFirstChild().getNodeValue());
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 156 */         this.localErrorCache.put(Integer.valueOf(i), localTranslatedErrorInfo);
/* 157 */         i = 0;
/*     */       }
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 162 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 277);
/* 163 */       ((SQLException)localObject).fillInStackTrace();
/* 164 */       throw ((Throwable)localObject);
/*     */     }
/*     */     catch (SAXException localSAXException)
/*     */     {
/* 169 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 278);
/* 170 */       ((SQLException)localObject).fillInStackTrace();
/* 171 */       throw ((Throwable)localObject);
/*     */     }
/*     */     catch (ParserConfigurationException localParserConfigurationException)
/*     */     {
/* 177 */       Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 278);
/* 178 */       ((SQLException)localObject).fillInStackTrace();
/* 179 */       throw ((Throwable)localObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   Map<String, String> getQueryCache()
/*     */   {
/* 191 */     return this.queryCache;
/*     */   }
/*     */ 
/*     */   Map<Integer, TranslatedErrorInfo> getErrorCache()
/*     */   {
/* 201 */     return this.errorCache;
/*     */   }
/*     */ 
/*     */   Map<Integer, TranslatedErrorInfo> getLocalErrorCache()
/*     */   {
/* 211 */     return this.localErrorCache;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 227 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.babelfish.TranslationCache
 * JD-Core Version:    0.6.2
 */