/*     */ package oracle.jdbc.babelfish;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import oracle.jdbc.OracleStatement;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ 
/*     */ @ProxyFor({OracleStatement.class, Statement.class})
/*     */ public abstract class BabelfishStatement extends BabelfishGenericProxy
/*     */ {
/* 319 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object translateError(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/*  88 */     throw this.translator.translateError(paramSQLException);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object post_Methods(Method paramMethod, Object paramObject)
/*     */   {
/* 104 */     if ((paramObject instanceof BabelfishGenericProxy))
/*     */     {
/* 106 */       ((BabelfishGenericProxy)paramObject).setTranslator(this.translator);
/*     */     }
/* 108 */     return paramObject;
/*     */   }
/*     */ 
/*     */   public void addBatch(String paramString)
/*     */     throws SQLException
/*     */   {
/* 122 */     String str = this.translator.translateQuery(paramString);
/* 123 */     ((Statement)getDelegate()).addBatch(str);
/*     */   }
/*     */ 
/*     */   public boolean execute(String paramString)
/*     */     throws SQLException
/*     */   {
/* 139 */     String str = this.translator.translateQuery(paramString);
/* 140 */     return ((Statement)getDelegate()).execute(str);
/*     */   }
/*     */ 
/*     */   public boolean execute(String paramString, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 156 */     String str = this.translator.translateQuery(paramString);
/* 157 */     return ((Statement)getDelegate()).execute(str, paramInt);
/*     */   }
/*     */ 
/*     */   public boolean execute(String paramString, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 173 */     String str = this.translator.translateQuery(paramString);
/* 174 */     return ((Statement)getDelegate()).execute(str, paramArrayOfInt);
/*     */   }
/*     */ 
/*     */   public boolean execute(String paramString, String[] paramArrayOfString)
/*     */     throws SQLException
/*     */   {
/* 190 */     String str = this.translator.translateQuery(paramString);
/* 191 */     return ((Statement)getDelegate()).execute(str, paramArrayOfString);
/*     */   }
/*     */ 
/*     */   public ResultSet executeQuery(String paramString)
/*     */     throws SQLException
/*     */   {
/* 206 */     String str = this.translator.translateQuery(paramString);
/* 207 */     return ((Statement)getDelegate()).executeQuery(str);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String paramString)
/*     */     throws SQLException
/*     */   {
/* 222 */     String str = this.translator.translateQuery(paramString);
/* 223 */     return ((Statement)getDelegate()).executeUpdate(str);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String paramString, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 239 */     String str = this.translator.translateQuery(paramString);
/* 240 */     return ((Statement)getDelegate()).executeUpdate(str, paramInt);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String paramString, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 256 */     String str = this.translator.translateQuery(paramString);
/* 257 */     return ((Statement)getDelegate()).executeUpdate(str, paramArrayOfInt);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String paramString, String[] paramArrayOfString)
/*     */     throws SQLException
/*     */   {
/* 273 */     String str = this.translator.translateQuery(paramString);
/* 274 */     return ((Statement)getDelegate()).executeUpdate(str, paramArrayOfString);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.babelfish.BabelfishStatement
 * JD-Core Version:    0.6.2
 */