/*     */ package oracle.jdbc.babelfish;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.lang.reflect.Method;
/*     */ import java.math.BigDecimal;
/*     */ import java.net.URL;
/*     */ import java.sql.Array;
/*     */ import java.sql.Blob;
/*     */ import java.sql.Clob;
/*     */ import java.sql.Date;
/*     */ import java.sql.NClob;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.Ref;
/*     */ import java.sql.RowId;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLXML;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ import oracle.jdbc.OraclePreparedStatement;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ 
/*     */ @ProxyFor({OraclePreparedStatement.class, PreparedStatement.class})
/*     */ public abstract class BabelfishPreparedStatement extends BabelfishStatement
/*     */ {
/*  70 */   static String NAMED_PARAMETER_PREFIX = "b";
/*     */ 
/* 694 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object translateError(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 100 */     throw this.translator.translateError(paramSQLException);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object post_Methods(Method paramMethod, Object paramObject)
/*     */   {
/* 116 */     if ((paramObject instanceof BabelfishGenericProxy))
/*     */     {
/* 118 */       ((BabelfishGenericProxy)paramObject).setTranslator(this.translator);
/*     */     }
/* 120 */     return paramObject;
/*     */   }
/*     */ 
/*     */   public void setArray(int paramInt, Array paramArray)
/*     */     throws SQLException
/*     */   {
/* 135 */     ((OraclePreparedStatement)getDelegate()).setArrayAtName(NAMED_PARAMETER_PREFIX + paramInt, paramArray);
/*     */   }
/*     */ 
/*     */   public void setAsciiStream(int paramInt, InputStream paramInputStream)
/*     */     throws SQLException
/*     */   {
/* 146 */     ((OraclePreparedStatement)getDelegate()).setAsciiStreamAtName(NAMED_PARAMETER_PREFIX + paramInt, paramInputStream);
/*     */   }
/*     */ 
/*     */   public void setAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 157 */     ((OraclePreparedStatement)getDelegate()).setAsciiStreamAtName(NAMED_PARAMETER_PREFIX + paramInt1, paramInputStream, paramInt2);
/*     */   }
/*     */ 
/*     */   public void setAsciiStream(int paramInt, InputStream paramInputStream, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 168 */     ((OraclePreparedStatement)getDelegate()).setAsciiStreamAtName(NAMED_PARAMETER_PREFIX + paramInt, paramInputStream, paramLong);
/*     */   }
/*     */ 
/*     */   public void setBigDecimal(int paramInt, BigDecimal paramBigDecimal)
/*     */     throws SQLException
/*     */   {
/* 179 */     ((OraclePreparedStatement)getDelegate()).setBigDecimalAtName(NAMED_PARAMETER_PREFIX + paramInt, paramBigDecimal);
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(int paramInt, InputStream paramInputStream)
/*     */     throws SQLException
/*     */   {
/* 190 */     ((OraclePreparedStatement)getDelegate()).setBinaryStreamAtName(NAMED_PARAMETER_PREFIX + paramInt, paramInputStream);
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 201 */     ((OraclePreparedStatement)getDelegate()).setBinaryStreamAtName(NAMED_PARAMETER_PREFIX + paramInt1, paramInputStream, paramInt2);
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(int paramInt, InputStream paramInputStream, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 212 */     ((OraclePreparedStatement)getDelegate()).setBinaryStreamAtName(NAMED_PARAMETER_PREFIX + paramInt, paramInputStream, paramLong);
/*     */   }
/*     */ 
/*     */   public void setBlob(int paramInt, Blob paramBlob)
/*     */     throws SQLException
/*     */   {
/* 223 */     ((OraclePreparedStatement)getDelegate()).setBlobAtName(NAMED_PARAMETER_PREFIX + paramInt, paramBlob);
/*     */   }
/*     */ 
/*     */   public void setBlob(int paramInt, InputStream paramInputStream)
/*     */     throws SQLException
/*     */   {
/* 234 */     ((OraclePreparedStatement)getDelegate()).setBlobAtName(NAMED_PARAMETER_PREFIX + paramInt, paramInputStream);
/*     */   }
/*     */ 
/*     */   public void setBlob(int paramInt, InputStream paramInputStream, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 245 */     ((OraclePreparedStatement)getDelegate()).setBlobAtName(NAMED_PARAMETER_PREFIX + paramInt, paramInputStream, paramLong);
/*     */   }
/*     */ 
/*     */   public void setBoolean(int paramInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 256 */     ((OraclePreparedStatement)getDelegate()).setBooleanAtName(NAMED_PARAMETER_PREFIX + paramInt, paramBoolean);
/*     */   }
/*     */ 
/*     */   public void setByte(int paramInt, byte paramByte)
/*     */     throws SQLException
/*     */   {
/* 267 */     ((OraclePreparedStatement)getDelegate()).setByteAtName(NAMED_PARAMETER_PREFIX + paramInt, paramByte);
/*     */   }
/*     */ 
/*     */   public void setBytes(int paramInt, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 278 */     ((OraclePreparedStatement)getDelegate()).setBytesAtName(NAMED_PARAMETER_PREFIX + paramInt, paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(int paramInt, Reader paramReader)
/*     */     throws SQLException
/*     */   {
/* 289 */     ((OraclePreparedStatement)getDelegate()).setCharacterStreamAtName(NAMED_PARAMETER_PREFIX + paramInt, paramReader);
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 300 */     ((OraclePreparedStatement)getDelegate()).setCharacterStreamAtName(NAMED_PARAMETER_PREFIX + paramInt1, paramReader, paramInt2);
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 311 */     ((OraclePreparedStatement)getDelegate()).setCharacterStreamAtName(NAMED_PARAMETER_PREFIX + paramInt, paramReader, paramLong);
/*     */   }
/*     */ 
/*     */   public void setClob(int paramInt, Clob paramClob)
/*     */     throws SQLException
/*     */   {
/* 322 */     ((OraclePreparedStatement)getDelegate()).setClobAtName(NAMED_PARAMETER_PREFIX + paramInt, paramClob);
/*     */   }
/*     */ 
/*     */   public void setClob(int paramInt, Reader paramReader)
/*     */     throws SQLException
/*     */   {
/* 333 */     ((OraclePreparedStatement)getDelegate()).setClobAtName(NAMED_PARAMETER_PREFIX + paramInt, paramReader);
/*     */   }
/*     */ 
/*     */   public void setClob(int paramInt, Reader paramReader, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 344 */     ((OraclePreparedStatement)getDelegate()).setClobAtName(NAMED_PARAMETER_PREFIX + paramInt, paramReader, paramLong);
/*     */   }
/*     */ 
/*     */   public void setDate(int paramInt, Date paramDate)
/*     */     throws SQLException
/*     */   {
/* 355 */     ((OraclePreparedStatement)getDelegate()).setDateAtName(NAMED_PARAMETER_PREFIX + paramInt, paramDate);
/*     */   }
/*     */ 
/*     */   public void setDate(int paramInt, Date paramDate, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 366 */     ((OraclePreparedStatement)getDelegate()).setDateAtName(NAMED_PARAMETER_PREFIX + paramInt, paramDate, paramCalendar);
/*     */   }
/*     */ 
/*     */   public void setDouble(int paramInt, double paramDouble)
/*     */     throws SQLException
/*     */   {
/* 377 */     ((OraclePreparedStatement)getDelegate()).setDoubleAtName(NAMED_PARAMETER_PREFIX + paramInt, paramDouble);
/*     */   }
/*     */ 
/*     */   public void setFloat(int paramInt, float paramFloat)
/*     */     throws SQLException
/*     */   {
/* 388 */     ((OraclePreparedStatement)getDelegate()).setFloatAtName(NAMED_PARAMETER_PREFIX + paramInt, paramFloat);
/*     */   }
/*     */ 
/*     */   public void setInt(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 399 */     ((OraclePreparedStatement)getDelegate()).setIntAtName(NAMED_PARAMETER_PREFIX + paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   public void setLong(int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 410 */     ((OraclePreparedStatement)getDelegate()).setLongAtName(NAMED_PARAMETER_PREFIX + paramInt, paramLong);
/*     */   }
/*     */ 
/*     */   public void setNCharacterStream(int paramInt, Reader paramReader)
/*     */     throws SQLException
/*     */   {
/* 421 */     ((OraclePreparedStatement)getDelegate()).setNCharacterStreamAtName(NAMED_PARAMETER_PREFIX + paramInt, paramReader);
/*     */   }
/*     */ 
/*     */   public void setNCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 432 */     ((OraclePreparedStatement)getDelegate()).setNCharacterStreamAtName(NAMED_PARAMETER_PREFIX + paramInt, paramReader, paramLong);
/*     */   }
/*     */ 
/*     */   public void setNClob(int paramInt, NClob paramNClob)
/*     */     throws SQLException
/*     */   {
/* 443 */     ((OraclePreparedStatement)getDelegate()).setNClobAtName(NAMED_PARAMETER_PREFIX + paramInt, paramNClob);
/*     */   }
/*     */ 
/*     */   public void setNClob(int paramInt, Reader paramReader)
/*     */     throws SQLException
/*     */   {
/* 454 */     ((OraclePreparedStatement)getDelegate()).setNClobAtName(NAMED_PARAMETER_PREFIX + paramInt, paramReader);
/*     */   }
/*     */ 
/*     */   public void setNClob(int paramInt, Reader paramReader, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 465 */     ((OraclePreparedStatement)getDelegate()).setNClobAtName(NAMED_PARAMETER_PREFIX + paramInt, paramReader, paramLong);
/*     */   }
/*     */ 
/*     */   public void setNString(int paramInt, String paramString)
/*     */     throws SQLException
/*     */   {
/* 476 */     ((OraclePreparedStatement)getDelegate()).setNStringAtName(NAMED_PARAMETER_PREFIX + paramInt, paramString);
/*     */   }
/*     */ 
/*     */   public void setNull(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 487 */     ((OraclePreparedStatement)getDelegate()).setNullAtName(NAMED_PARAMETER_PREFIX + paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   public void setNull(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/* 498 */     ((OraclePreparedStatement)getDelegate()).setNullAtName(NAMED_PARAMETER_PREFIX + paramInt1, paramInt2, paramString);
/*     */   }
/*     */ 
/*     */   public void setObject(int paramInt, Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 509 */     ((OraclePreparedStatement)getDelegate()).setObjectAtName(NAMED_PARAMETER_PREFIX + paramInt, paramObject);
/*     */   }
/*     */ 
/*     */   public void setObject(int paramInt1, Object paramObject, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 520 */     ((OraclePreparedStatement)getDelegate()).setObjectAtName(NAMED_PARAMETER_PREFIX + paramInt1, paramObject, paramInt2);
/*     */   }
/*     */ 
/*     */   public void setObject(int paramInt1, Object paramObject, int paramInt2, int paramInt3)
/*     */     throws SQLException
/*     */   {
/* 531 */     ((OraclePreparedStatement)getDelegate()).setObjectAtName(NAMED_PARAMETER_PREFIX + paramInt1, paramObject, paramInt2, paramInt3);
/*     */   }
/*     */ 
/*     */   public void setRef(int paramInt, Ref paramRef)
/*     */     throws SQLException
/*     */   {
/* 542 */     ((OraclePreparedStatement)getDelegate()).setRefAtName(NAMED_PARAMETER_PREFIX + paramInt, paramRef);
/*     */   }
/*     */ 
/*     */   public void setRowId(int paramInt, RowId paramRowId)
/*     */     throws SQLException
/*     */   {
/* 553 */     ((OraclePreparedStatement)getDelegate()).setRowIdAtName(NAMED_PARAMETER_PREFIX + paramInt, paramRowId);
/*     */   }
/*     */ 
/*     */   public void setShort(int paramInt, short paramShort)
/*     */     throws SQLException
/*     */   {
/* 564 */     ((OraclePreparedStatement)getDelegate()).setShortAtName(NAMED_PARAMETER_PREFIX + paramInt, paramShort);
/*     */   }
/*     */ 
/*     */   public void setSQLXML(int paramInt, SQLXML paramSQLXML)
/*     */     throws SQLException
/*     */   {
/* 575 */     ((OraclePreparedStatement)getDelegate()).setSQLXMLAtName(NAMED_PARAMETER_PREFIX + paramInt, paramSQLXML);
/*     */   }
/*     */ 
/*     */   public void setString(int paramInt, String paramString)
/*     */     throws SQLException
/*     */   {
/* 586 */     ((OraclePreparedStatement)getDelegate()).setStringAtName(NAMED_PARAMETER_PREFIX + paramInt, paramString);
/*     */   }
/*     */ 
/*     */   public void setTime(int paramInt, Time paramTime)
/*     */     throws SQLException
/*     */   {
/* 597 */     ((OraclePreparedStatement)getDelegate()).setTimeAtName(NAMED_PARAMETER_PREFIX + paramInt, paramTime);
/*     */   }
/*     */ 
/*     */   public void setTime(int paramInt, Time paramTime, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 608 */     ((OraclePreparedStatement)getDelegate()).setTimeAtName(NAMED_PARAMETER_PREFIX + paramInt, paramTime, paramCalendar);
/*     */   }
/*     */ 
/*     */   public void setTimestamp(int paramInt, Timestamp paramTimestamp)
/*     */     throws SQLException
/*     */   {
/* 619 */     ((OraclePreparedStatement)getDelegate()).setTimestampAtName(NAMED_PARAMETER_PREFIX + paramInt, paramTimestamp);
/*     */   }
/*     */ 
/*     */   public void setTimestamp(int paramInt, Timestamp paramTimestamp, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 630 */     ((OraclePreparedStatement)getDelegate()).setTimestampAtName(NAMED_PARAMETER_PREFIX + paramInt, paramTimestamp, paramCalendar);
/*     */   }
/*     */ 
/*     */   public void setUnicodeStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 641 */     ((OraclePreparedStatement)getDelegate()).setUnicodeStreamAtName(NAMED_PARAMETER_PREFIX + paramInt1, paramInputStream, paramInt2);
/*     */   }
/*     */ 
/*     */   public void setURL(int paramInt, URL paramURL)
/*     */     throws SQLException
/*     */   {
/* 652 */     ((OraclePreparedStatement)getDelegate()).setURLAtName(NAMED_PARAMETER_PREFIX + paramInt, paramURL);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.babelfish.BabelfishPreparedStatement
 * JD-Core Version:    0.6.2
 */