/*     */ package oracle.jdbc.babelfish;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import java.util.EnumMap;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.OracleTranslatingConnection;
/*     */ import oracle.jdbc.OracleTranslatingConnection.SqlTranslationVersion;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyLocale;
/*     */ 
/*     */ @ProxyFor({Connection.class, oracle.jdbc.OracleConnection.class, oracle.jdbc.internal.OracleConnection.class})
/*     */ @ProxyLocale
/*     */ public abstract class BabelfishConnection extends BabelfishGenericProxy
/*     */   implements OracleTranslatingConnection
/*     */ {
/* 806 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object translateError(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/*  93 */     throw this.translator.translateError(paramSQLException);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object post_Methods(Method paramMethod, Object paramObject)
/*     */   {
/* 106 */     if ((paramObject instanceof BabelfishGenericProxy))
/*     */     {
/* 108 */       ((BabelfishGenericProxy)paramObject).setTranslator(this.translator);
/*     */     }
/* 110 */     return paramObject;
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString)
/*     */     throws SQLException
/*     */   {
/* 124 */     String str = this.translator.translateQuery(paramString);
/* 125 */     return ((Connection)getDelegate()).prepareStatement(str);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 139 */     String str = this.translator.translateQuery(paramString);
/* 140 */     return ((Connection)getDelegate()).prepareStatement(str, paramInt);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 154 */     String str = this.translator.translateQuery(paramString);
/* 155 */     return ((Connection)getDelegate()).prepareStatement(str, paramArrayOfInt);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, String[] paramArrayOfString)
/*     */     throws SQLException
/*     */   {
/* 169 */     String str = this.translator.translateQuery(paramString);
/* 170 */     return ((Connection)getDelegate()).prepareStatement(str, paramArrayOfString);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 184 */     String str = this.translator.translateQuery(paramString);
/* 185 */     return ((Connection)getDelegate()).prepareStatement(str, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2, int paramInt3)
/*     */     throws SQLException
/*     */   {
/* 199 */     String str = this.translator.translateQuery(paramString);
/* 200 */     return ((Connection)getDelegate()).prepareStatement(str, paramInt1, paramInt2, paramInt3);
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String paramString)
/*     */     throws SQLException
/*     */   {
/* 214 */     String str = this.translator.translateQuery(paramString);
/* 215 */     return ((Connection)getDelegate()).prepareCall(str);
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 229 */     String str = this.translator.translateQuery(paramString);
/* 230 */     return ((Connection)getDelegate()).prepareCall(str, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2, int paramInt3)
/*     */     throws SQLException
/*     */   {
/* 244 */     String str = this.translator.translateQuery(paramString);
/* 245 */     return ((Connection)getDelegate()).prepareCall(str, paramInt1, paramInt2, paramInt3);
/*     */   }
/*     */ 
/*     */   public String nativeSQL(String paramString)
/*     */     throws SQLException
/*     */   {
/* 265 */     String str = this.translator.translateQuery(paramString);
/* 266 */     return ((Connection)getDelegate()).nativeSQL(str);
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws SQLException
/*     */   {
/* 289 */     this.translator.deactivateServerTranslation();
/* 290 */     ((Connection)getDelegate()).close();
/*     */   }
/*     */ 
/*     */   public abstract Statement createStatement()
/*     */     throws SQLException;
/*     */ 
/*     */   public Statement createStatement(boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     Statement localStatement;
/* 319 */     if (!paramBoolean)
/*     */     {
/* 321 */       localStatement = ((Connection)getDelegate()).createStatement();
/*     */     }
/*     */     else
/*     */     {
/* 325 */       localStatement = createStatement();
/*     */     }
/* 327 */     return localStatement;
/*     */   }
/*     */ 
/*     */   public abstract Statement createStatement(int paramInt1, int paramInt2)
/*     */     throws SQLException;
/*     */ 
/*     */   public Statement createStatement(int paramInt1, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     Statement localStatement;
/* 353 */     if (!paramBoolean)
/*     */     {
/* 355 */       localStatement = ((Connection)getDelegate()).createStatement(paramInt1, paramInt2);
/*     */     }
/*     */     else
/*     */     {
/* 359 */       localStatement = createStatement(paramInt1, paramInt2);
/*     */     }
/* 361 */     return localStatement;
/*     */   }
/*     */ 
/*     */   public abstract Statement createStatement(int paramInt1, int paramInt2, int paramInt3)
/*     */     throws SQLException;
/*     */ 
/*     */   public Statement createStatement(int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     Statement localStatement;
/* 387 */     if (!paramBoolean)
/*     */     {
/* 389 */       localStatement = ((Connection)getDelegate()).createStatement(paramInt1, paramInt2, paramInt3);
/*     */     }
/*     */     else
/*     */     {
/* 393 */       localStatement = createStatement(paramInt1, paramInt2, paramInt3);
/*     */     }
/* 395 */     return localStatement;
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     PreparedStatement localPreparedStatement;
/* 414 */     if (!paramBoolean)
/*     */     {
/* 416 */       localPreparedStatement = ((Connection)getDelegate()).prepareStatement(paramString);
/*     */     }
/*     */     else
/*     */     {
/* 420 */       localPreparedStatement = prepareStatement(paramString);
/*     */     }
/* 422 */     return localPreparedStatement;
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, int paramInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     PreparedStatement localPreparedStatement;
/* 440 */     if (!paramBoolean)
/*     */     {
/* 442 */       localPreparedStatement = ((Connection)getDelegate()).prepareStatement(paramString, paramInt);
/*     */     }
/*     */     else
/*     */     {
/* 446 */       localPreparedStatement = prepareStatement(paramString, paramInt);
/*     */     }
/* 448 */     return localPreparedStatement;
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, int[] paramArrayOfInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     PreparedStatement localPreparedStatement;
/* 467 */     if (!paramBoolean)
/*     */     {
/* 469 */       localPreparedStatement = ((Connection)getDelegate()).prepareStatement(paramString, paramArrayOfInt);
/*     */     }
/*     */     else
/*     */     {
/* 473 */       localPreparedStatement = prepareStatement(paramString, paramArrayOfInt);
/*     */     }
/* 475 */     return localPreparedStatement;
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, String[] paramArrayOfString, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     PreparedStatement localPreparedStatement;
/* 494 */     if (!paramBoolean)
/*     */     {
/* 496 */       localPreparedStatement = ((Connection)getDelegate()).prepareStatement(paramString, paramArrayOfString);
/*     */     }
/*     */     else
/*     */     {
/* 500 */       localPreparedStatement = prepareStatement(paramString, paramArrayOfString);
/*     */     }
/* 502 */     return localPreparedStatement;
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     PreparedStatement localPreparedStatement;
/* 521 */     if (!paramBoolean)
/*     */     {
/* 523 */       localPreparedStatement = ((Connection)getDelegate()).prepareStatement(paramString, paramInt1, paramInt2);
/*     */     }
/*     */     else
/*     */     {
/* 527 */       localPreparedStatement = prepareStatement(paramString, paramInt1, paramInt2);
/*     */     }
/* 529 */     return localPreparedStatement;
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     PreparedStatement localPreparedStatement;
/* 548 */     if (!paramBoolean)
/*     */     {
/* 550 */       localPreparedStatement = ((Connection)getDelegate()).prepareStatement(paramString, paramInt1, paramInt2, paramInt3);
/*     */     }
/*     */     else
/*     */     {
/* 554 */       localPreparedStatement = prepareStatement(paramString, paramInt1, paramInt2, paramInt3);
/*     */     }
/* 556 */     return localPreparedStatement;
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String paramString, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     CallableStatement localCallableStatement;
/* 574 */     if (!paramBoolean)
/*     */     {
/* 576 */       localCallableStatement = ((Connection)getDelegate()).prepareCall(paramString);
/*     */     }
/*     */     else
/*     */     {
/* 580 */       localCallableStatement = prepareCall(paramString);
/*     */     }
/* 582 */     return localCallableStatement;
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     CallableStatement localCallableStatement;
/* 600 */     if (!paramBoolean)
/*     */     {
/* 602 */       localCallableStatement = ((Connection)getDelegate()).prepareCall(paramString, paramInt1, paramInt2);
/*     */     }
/*     */     else
/*     */     {
/* 606 */       localCallableStatement = prepareCall(paramString, paramInt1, paramInt2);
/*     */     }
/* 608 */     return localCallableStatement;
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*     */     CallableStatement localCallableStatement;
/* 626 */     if (!paramBoolean)
/*     */     {
/* 628 */       localCallableStatement = ((Connection)getDelegate()).prepareCall(paramString, paramInt1, paramInt2, paramInt3);
/*     */     }
/*     */     else
/*     */     {
/* 632 */       localCallableStatement = prepareCall(paramString, paramInt1, paramInt2, paramInt3);
/*     */     }
/* 634 */     return localCallableStatement;
/*     */   }
/*     */ 
/*     */   public Map<OracleTranslatingConnection.SqlTranslationVersion, String> getSqlTranslationVersions(String paramString, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 777 */     EnumMap localEnumMap = new EnumMap(OracleTranslatingConnection.SqlTranslationVersion.class);
/* 778 */     localEnumMap.put(OracleTranslatingConnection.SqlTranslationVersion.ORIGINAL_SQL, paramString);
/*     */ 
/* 780 */     String str = this.translator.convertParameterMarkersToOracleStyle(paramString);
/* 781 */     localEnumMap.put(OracleTranslatingConnection.SqlTranslationVersion.JDBC_MARKER_CONVERTED, str);
/*     */     try
/*     */     {
/* 785 */       str = this.translator.translateQuery(paramString);
/* 786 */       localEnumMap.put(OracleTranslatingConnection.SqlTranslationVersion.TRANSLATED, str);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 790 */       if (paramBoolean)
/*     */       {
/* 792 */         localEnumMap.put(OracleTranslatingConnection.SqlTranslationVersion.TRANSLATED, null);
/*     */       }
/*     */       else
/*     */       {
/* 796 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */ 
/* 800 */     return localEnumMap;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.babelfish.BabelfishConnection
 * JD-Core Version:    0.6.2
 */