/*     */ package oracle.jdbc.aq;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.EventObject;
/*     */ 
/*     */ public abstract class AQNotificationEvent extends EventObject
/*     */ {
/* 183 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected AQNotificationEvent(Object paramObject)
/*     */   {
/* 118 */     super(paramObject);
/*     */   }
/*     */ 
/*     */   public abstract AQMessageProperties getMessageProperties()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract String getRegistration()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract byte[] getPayload()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract String getQueueName()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract byte[] getMessageId()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract String getConsumerName()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract String getConnectionInformation();
/*     */ 
/*     */   public abstract EventType getEventType();
/*     */ 
/*     */   public abstract AdditionalEventType getAdditionalEventType();
/*     */ 
/*     */   public abstract String toString();
/*     */ 
/*     */   public static enum AdditionalEventType
/*     */   {
/*  79 */     NONE(0), 
/*     */ 
/*  83 */     TIMEOUT(1), 
/*     */ 
/*  87 */     GROUPING(2);
/*     */ 
/*     */     private final int code;
/*     */ 
/*     */     private AdditionalEventType(int paramInt)
/*     */     {
/*  93 */       this.code = paramInt;
/*     */     }
/*     */ 
/*     */     public final int getCode()
/*     */     {
/* 101 */       return this.code;
/*     */     }
/*     */ 
/*     */     public static final AdditionalEventType getEventType(int paramInt)
/*     */     {
/* 108 */       if (paramInt == TIMEOUT.getCode())
/* 109 */         return TIMEOUT;
/* 110 */       if (paramInt == GROUPING.getCode()) {
/* 111 */         return GROUPING;
/*     */       }
/* 113 */       return NONE;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum EventType
/*     */   {
/*  48 */     REGULAR(0), 
/*     */ 
/*  52 */     DEREG(1);
/*     */ 
/*     */     private final int code;
/*     */ 
/*     */     private EventType(int paramInt) {
/*  57 */       this.code = paramInt;
/*     */     }
/*     */ 
/*     */     public final int getCode()
/*     */     {
/*  65 */       return this.code;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.aq.AQNotificationEvent
 * JD-Core Version:    0.6.2
 */