/*     */ package oracle.jdbc.aq;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Timestamp;
/*     */ 
/*     */ public abstract interface AQMessageProperties
/*     */ {
/*     */   public static final int MESSAGE_NO_DELAY = 0;
/*     */   public static final int MESSAGE_NO_EXPIRATION = -1;
/*     */ 
/*     */   public abstract int getDequeueAttemptsCount();
/*     */ 
/*     */   public abstract void setCorrelation(String paramString)
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract String getCorrelation();
/*     */ 
/*     */   public abstract void setDelay(int paramInt)
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract int getDelay();
/*     */ 
/*     */   public abstract Timestamp getEnqueueTime();
/*     */ 
/*     */   public abstract void setExceptionQueue(String paramString)
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract String getExceptionQueue();
/*     */ 
/*     */   public abstract void setExpiration(int paramInt)
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract int getExpiration();
/*     */ 
/*     */   public abstract MessageState getState();
/*     */ 
/*     */   public abstract void setPriority(int paramInt)
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract int getPriority();
/*     */ 
/*     */   public abstract void setRecipientList(AQAgent[] paramArrayOfAQAgent)
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract AQAgent[] getRecipientList();
/*     */ 
/*     */   public abstract void setSender(AQAgent paramAQAgent)
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract AQAgent getSender();
/*     */ 
/*     */   public abstract String getTransactionGroup();
/*     */ 
/*     */   public abstract byte[] getPreviousQueueMessageId();
/*     */ 
/*     */   public abstract DeliveryMode getDeliveryMode();
/*     */ 
/*     */   public abstract String toString();
/*     */ 
/*     */   public static enum DeliveryMode
/*     */   {
/* 121 */     PERSISTENT(1), 
/*     */ 
/* 125 */     BUFFERED(2);
/*     */ 
/*     */     private final int code;
/*     */ 
/* 129 */     private DeliveryMode(int paramInt) { this.code = paramInt; }
/*     */ 
/*     */ 
/*     */     public final int getCode()
/*     */     {
/* 137 */       return this.code;
/*     */     }
/*     */ 
/*     */     public static final DeliveryMode getDeliveryMode(int paramInt)
/*     */     {
/* 145 */       if (paramInt == BUFFERED.getCode()) {
/* 146 */         return BUFFERED;
/*     */       }
/* 148 */       return PERSISTENT;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum MessageState
/*     */   {
/*  72 */     WAITING(1), 
/*     */ 
/*  76 */     READY(0), 
/*     */ 
/*  80 */     PROCESSED(2), 
/*     */ 
/*  84 */     EXPIRED(3);
/*     */ 
/*     */     private final int code;
/*     */ 
/*  88 */     private MessageState(int paramInt) { this.code = paramInt; }
/*     */ 
/*     */ 
/*     */     public final int getCode()
/*     */     {
/*  96 */       return this.code;
/*     */     }
/*     */ 
/*     */     public static final MessageState getMessageState(int paramInt)
/*     */     {
/* 104 */       if (paramInt == WAITING.getCode())
/* 105 */         return WAITING;
/* 106 */       if (paramInt == READY.getCode())
/* 107 */         return READY;
/* 108 */       if (paramInt == PROCESSED.getCode()) {
/* 109 */         return PROCESSED;
/*     */       }
/* 111 */       return EXPIRED;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.aq.AQMessageProperties
 * JD-Core Version:    0.6.2
 */