/*     */ package oracle.jdbc.aq;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ public class AQDequeueOptions
/*     */ {
/*     */   public static final int DEQUEUE_WAIT_FOREVER = -1;
/*     */   public static final int DEQUEUE_NO_WAIT = 0;
/*     */   private String attrConsumerName;
/*     */   private String attrCorrelation;
/*     */   private DequeueMode attrDeqMode;
/*     */   private byte[] attrDeqMsgId;
/*     */   private NavigationOption attrNavigation;
/*     */   private VisibilityOption attrVisibility;
/*     */   private int attrWait;
/*     */   private int maxBufferLength;
/*     */   private DeliveryFilter attrDeliveryMode;
/*     */   private boolean retrieveMsgId;
/*     */   private String transformation;
/*     */   private String condition;
/*     */   public static final int MAX_RAW_PAYLOAD = 67108787;
/* 737 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public AQDequeueOptions()
/*     */   {
/* 215 */     this.attrConsumerName = null;
/* 216 */     this.attrCorrelation = null;
/* 217 */     this.attrDeqMode = DequeueMode.REMOVE;
/* 218 */     this.attrDeqMsgId = null;
/* 219 */     this.attrNavigation = NavigationOption.NEXT_MESSAGE;
/* 220 */     this.attrVisibility = VisibilityOption.ON_COMMIT;
/* 221 */     this.attrWait = -1;
/* 222 */     this.maxBufferLength = 67108787;
/* 223 */     this.attrDeliveryMode = DeliveryFilter.PERSISTENT;
/*     */ 
/* 227 */     this.retrieveMsgId = false;
/*     */   }
/*     */ 
/*     */   public void setConsumerName(String paramString)
/*     */     throws SQLException
/*     */   {
/* 247 */     this.attrConsumerName = paramString;
/*     */   }
/*     */ 
/*     */   public String getConsumerName()
/*     */   {
/* 264 */     return this.attrConsumerName;
/*     */   }
/*     */ 
/*     */   public void setCorrelation(String paramString)
/*     */     throws SQLException
/*     */   {
/* 292 */     this.attrCorrelation = paramString;
/*     */   }
/*     */ 
/*     */   public String getCorrelation()
/*     */   {
/* 309 */     return this.attrCorrelation;
/*     */   }
/*     */ 
/*     */   public void setDequeueMode(DequeueMode paramDequeueMode)
/*     */     throws SQLException
/*     */   {
/* 333 */     this.attrDeqMode = paramDequeueMode;
/*     */   }
/*     */ 
/*     */   public DequeueMode getDequeueMode()
/*     */   {
/* 350 */     return this.attrDeqMode;
/*     */   }
/*     */ 
/*     */   public void setDequeueMessageId(byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 370 */     this.attrDeqMsgId = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public byte[] getDequeueMessageId()
/*     */   {
/* 388 */     return this.attrDeqMsgId;
/*     */   }
/*     */ 
/*     */   public void setNavigation(NavigationOption paramNavigationOption)
/*     */     throws SQLException
/*     */   {
/* 417 */     this.attrNavigation = paramNavigationOption;
/*     */   }
/*     */ 
/*     */   public NavigationOption getNavigation()
/*     */   {
/* 434 */     return this.attrNavigation;
/*     */   }
/*     */ 
/*     */   public void setVisibility(VisibilityOption paramVisibilityOption)
/*     */     throws SQLException
/*     */   {
/* 456 */     this.attrVisibility = paramVisibilityOption;
/*     */   }
/*     */ 
/*     */   public VisibilityOption getVisibility()
/*     */   {
/* 473 */     return this.attrVisibility;
/*     */   }
/*     */ 
/*     */   public void setWait(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 503 */     this.attrWait = paramInt;
/*     */   }
/*     */ 
/*     */   public int getWait()
/*     */   {
/* 520 */     return this.attrWait;
/*     */   }
/*     */ 
/*     */   public void setMaximumBufferLength(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 543 */     if (paramInt > 0)
/* 544 */       this.maxBufferLength = paramInt;
/*     */   }
/*     */ 
/*     */   public int getMaximumBufferLength()
/*     */   {
/* 561 */     return this.maxBufferLength;
/*     */   }
/*     */ 
/*     */   public void setDeliveryFilter(DeliveryFilter paramDeliveryFilter)
/*     */     throws SQLException
/*     */   {
/* 589 */     this.attrDeliveryMode = paramDeliveryFilter;
/*     */   }
/*     */ 
/*     */   public DeliveryFilter getDeliveryFilter()
/*     */   {
/* 606 */     return this.attrDeliveryMode;
/*     */   }
/*     */ 
/*     */   public void setRetrieveMessageId(boolean paramBoolean)
/*     */   {
/* 624 */     this.retrieveMsgId = paramBoolean;
/*     */   }
/*     */ 
/*     */   public boolean getRetrieveMessageId()
/*     */   {
/* 642 */     return this.retrieveMsgId;
/*     */   }
/*     */ 
/*     */   public void setTransformation(String paramString)
/*     */   {
/* 667 */     this.transformation = paramString;
/*     */   }
/*     */ 
/*     */   public String getTransformation()
/*     */   {
/* 684 */     return this.transformation;
/*     */   }
/*     */ 
/*     */   public void setCondition(String paramString)
/*     */   {
/* 716 */     this.condition = paramString;
/*     */   }
/*     */ 
/*     */   public String getCondition()
/*     */   {
/* 733 */     return this.condition;
/*     */   }
/*     */ 
/*     */   public static enum DeliveryFilter
/*     */   {
/* 159 */     PERSISTENT(1), BUFFERED(2), PERSISTENT_OR_BUFFERED(3);
/*     */ 
/*     */     private final int mode;
/*     */ 
/* 163 */     private DeliveryFilter(int paramInt) { this.mode = paramInt; }
/*     */ 
/*     */ 
/*     */     public final int getCode()
/*     */     {
/* 170 */       return this.mode;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum VisibilityOption
/*     */   {
/* 135 */     ON_COMMIT(2), 
/*     */ 
/* 140 */     IMMEDIATE(1);
/*     */ 
/*     */     private final int mode;
/*     */ 
/* 144 */     private VisibilityOption(int paramInt) { this.mode = paramInt; }
/*     */ 
/*     */ 
/*     */     public final int getCode()
/*     */     {
/* 151 */       return this.mode;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum NavigationOption
/*     */   {
/*  91 */     FIRST_MESSAGE(1), 
/*     */ 
/*  98 */     NEXT_MESSAGE(3), 
/*     */ 
/* 105 */     NEXT_TRANSACTION(2);
/*     */ 
/*     */     private final int mode;
/*     */ 
/* 109 */     private NavigationOption(int paramInt) { this.mode = paramInt; }
/*     */ 
/*     */ 
/*     */     public final int getCode()
/*     */     {
/* 116 */       return this.mode;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum DequeueMode
/*     */   {
/*  51 */     BROWSE(1), 
/*     */ 
/*  57 */     LOCKED(2), 
/*     */ 
/*  63 */     REMOVE(3), 
/*     */ 
/*  68 */     REMOVE_NODATA(4);
/*     */ 
/*     */     private final int mode;
/*     */ 
/*     */     private DequeueMode(int paramInt) {
/*  73 */       this.mode = paramInt;
/*     */     }
/*     */ 
/*     */     public final int getCode()
/*     */     {
/*  80 */       return this.mode;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.aq.AQDequeueOptions
 * JD-Core Version:    0.6.2
 */