/*    */ package oracle.jdbc;
/*    */ 
/*    */ import java.sql.ResultSetMetaData;
/*    */ import java.sql.SQLException;
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import oracle.sql.SQLName;
/*    */ 
/*    */ public abstract interface OracleTypeMetaData
/*    */ {
/*    */   public abstract Kind getKind();
/*    */ 
/*    */   public abstract String getName()
/*    */     throws SQLException;
/*    */ 
/*    */   public abstract SQLName getSQLName()
/*    */     throws SQLException;
/*    */ 
/*    */   public abstract String getSchemaName()
/*    */     throws SQLException;
/*    */ 
/*    */   public abstract int getTypeCode()
/*    */     throws SQLException;
/*    */ 
/*    */   public abstract String getTypeCodeName()
/*    */     throws SQLException;
/*    */ 
/*    */   public static abstract interface Struct extends OracleTypeMetaData
/*    */   {
/*    */     public abstract int getTypeVersion()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract int getLength()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract ResultSetMetaData getMetaData()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract boolean isFinalType()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract boolean isSubtype()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract boolean isInstantiable()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract String getSupertypeName()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract int getLocalAttributeCount()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract String[] getSubtypeNames()
/*    */       throws SQLException;
/*    */   }
/*    */ 
/*    */   public static abstract interface Opaque extends OracleTypeMetaData
/*    */   {
/*    */     public abstract long getMaxLength()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract boolean isTrustedLibrary()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract boolean isModeledInC()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract boolean hasUnboundedSize()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract boolean hasFixedSize()
/*    */       throws SQLException;
/*    */   }
/*    */ 
/*    */   public static abstract interface Array extends OracleTypeMetaData
/*    */   {
/*    */     public abstract int getBaseType()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract String getBaseName()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract OracleTypeMetaData.ArrayStorage getArrayStorage()
/*    */       throws SQLException;
/*    */ 
/*    */     public abstract long getMaxLength()
/*    */       throws SQLException;
/*    */   }
/*    */ 
/*    */   public static enum ArrayStorage
/*    */   {
/* 48 */     VARRAY(3), 
/* 49 */     NESTED_TABLE(2);
/*    */ 
/*    */     private static final Map<Integer, ArrayStorage> lookup;
/*    */     private final int code;
/*    */ 
/*    */     public static ArrayStorage withCode(int paramInt)
/*    */     {
/* 60 */       return (ArrayStorage)lookup.get(Integer.valueOf(paramInt));
/*    */     }
/*    */ 
/*    */     private ArrayStorage(int paramInt)
/*    */     {
/* 66 */       this.code = paramInt;
/*    */     }
/*    */     public int getCode() {
/* 69 */       return this.code;
/*    */     }
/*    */ 
/*    */     static
/*    */     {
/* 51 */       lookup = new HashMap(2);
/*    */ 
/* 55 */       for (ArrayStorage localArrayStorage : values())
/* 56 */         lookup.put(Integer.valueOf(localArrayStorage.getCode()), localArrayStorage);
/*    */     }
/*    */   }
/*    */ 
/*    */   public static enum Kind
/*    */   {
/* 38 */     ARRAY, 
/* 39 */     OPAQUE, 
/* 40 */     STRUCT, 
/* 41 */     TYPE;
/*    */   }
/*    */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.OracleTypeMetaData
 * JD-Core Version:    0.6.2
 */