/*      */ package oracle.jdbc;
/*      */ 
/*      */ import java.sql.CallableStatement;
/*      */ import java.sql.Connection;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.RowIdLifetime;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Statement;
/*      */ import java.util.regex.Matcher;
/*      */ import java.util.regex.Pattern;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.driver.OracleSql;
/*      */ import oracle.jdbc.internal.OracleResultSet;
/*      */ import oracle.sql.SQLName;
/*      */ import oracle.sql.TypeDescriptor;
/*      */ 
/*      */ public class OracleDatabaseMetaData
/*      */   implements AdditionalDatabaseMetaData
/*      */ {
/*   67 */   private static String DRIVER_NAME = "Oracle JDBC driver";
/*   68 */   private static String DRIVER_VERSION = "12.1.0.1.0";
/*   69 */   private static int DRIVER_MAJOR_VERSION = 12;
/*   70 */   private static int DRIVER_MINOR_VERSION = 1;
/*   71 */   private static String LOB_MAXSIZE = "4294967295";
/*   72 */   private static long LOB_MAXLENGTH_32BIT = 4294967295L;
/*      */   protected oracle.jdbc.internal.OracleConnection connection;
/*   80 */   private static int DRIVER_API_MAJOR_VERSION = 4;
/*   81 */   private static int DRIVER_API_MINOR_VERSION = 0;
/*      */ 
/* 2753 */   int procedureResultUnknown = 0;
/*      */ 
/* 2758 */   int procedureNoResult = 1;
/*      */ 
/* 2763 */   int procedureReturnsResult = 2;
/*      */ 
/* 3434 */   int procedureColumnUnknown = 0;
/*      */ 
/* 3439 */   int procedureColumnIn = 1;
/*      */ 
/* 3444 */   int procedureColumnInOut = 2;
/*      */ 
/* 3449 */   int procedureColumnOut = 4;
/*      */ 
/* 3454 */   int procedureColumnReturn = 5;
/*      */ 
/* 3459 */   int procedureColumnResult = 3;
/*      */ 
/* 3464 */   int procedureNoNulls = 0;
/*      */ 
/* 3469 */   int procedureNullable = 1;
/*      */ 
/* 3474 */   int procedureNullableUnknown = 2;
/*      */ 
/* 3861 */   int columnNoNulls = 0;
/*      */ 
/* 3866 */   int columnNullable = 1;
/*      */ 
/* 3871 */   int columnNullableUnknown = 2;
/*      */   static final int bestRowTemporary = 0;
/*      */   static final int bestRowTransaction = 1;
/*      */   static final int bestRowSession = 2;
/*      */   static final int bestRowUnknown = 0;
/*      */   static final int bestRowNotPseudo = 1;
/*      */   static final int bestRowPseudo = 2;
/* 4224 */   int versionColumnUnknown = 0;
/*      */ 
/* 4229 */   int versionColumnNotPseudo = 1;
/*      */ 
/* 4234 */   int versionColumnPseudo = 2;
/*      */ 
/* 4443 */   int importedKeyCascade = 0;
/*      */ 
/* 4449 */   int importedKeyRestrict = 1;
/*      */ 
/* 4455 */   int importedKeySetNull = 2;
/*      */ 
/* 4669 */   int typeNoNulls = 0;
/*      */ 
/* 4674 */   int typeNullable = 1;
/*      */ 
/* 4679 */   int typeNullableUnknown = 2;
/*      */ 
/* 4684 */   int typePredNone = 0;
/*      */ 
/* 4689 */   int typePredChar = 1;
/*      */ 
/* 4694 */   int typePredBasic = 2;
/*      */ 
/* 4699 */   int typeSearchable = 3;
/*      */ 
/* 4879 */   short tableIndexStatistic = 0;
/*      */ 
/* 4884 */   short tableIndexClustered = 1;
/*      */ 
/* 4889 */   short tableIndexHashed = 2;
/*      */ 
/* 4894 */   short tableIndexOther = 3;
/*      */ 
/* 5581 */   short attributeNoNulls = 0;
/*      */ 
/* 5592 */   short attributeNullable = 1;
/*      */ 
/* 5604 */   short attributeNullableUnknown = 2;
/*      */ 
/* 5854 */   int sqlStateXOpen = 1;
/*      */ 
/* 5865 */   int sqlStateSQL99 = 2;
/*      */   protected static final String sqlWildcardRegex = "^%|^_|[^/]%|[^/]_";
/* 6331 */   protected static Pattern sqlWildcardPattern = null;
/*      */   protected static final String sqlEscapeRegex = "/";
/* 6333 */   protected static Pattern sqlEscapePattern = null;
/*      */ 
/* 6685 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   /** @deprecated */
/*      */   public OracleDatabaseMetaData(OracleConnection paramOracleConnection)
/*      */   {
/*   98 */     this.connection = paramOracleConnection.physicalConnectionWithin();
/*      */   }
/*      */ 
/*      */   public boolean allProceduresAreCallable()
/*      */     throws SQLException
/*      */   {
/*  121 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean allTablesAreSelectable()
/*      */     throws SQLException
/*      */   {
/*  141 */     return false;
/*      */   }
/*      */ 
/*      */   public String getURL()
/*      */     throws SQLException
/*      */   {
/*  159 */     return this.connection.getURL();
/*      */   }
/*      */ 
/*      */   public String getUserName()
/*      */     throws SQLException
/*      */   {
/*  178 */     return this.connection.getUserName();
/*      */   }
/*      */ 
/*      */   public boolean isReadOnly()
/*      */     throws SQLException
/*      */   {
/*  197 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean nullsAreSortedHigh()
/*      */     throws SQLException
/*      */   {
/*  216 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean nullsAreSortedLow()
/*      */     throws SQLException
/*      */   {
/*  235 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean nullsAreSortedAtStart()
/*      */     throws SQLException
/*      */   {
/*  254 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean nullsAreSortedAtEnd()
/*      */     throws SQLException
/*      */   {
/*  273 */     return false;
/*      */   }
/*      */ 
/*      */   public String getDatabaseProductName()
/*      */     throws SQLException
/*      */   {
/*  291 */     return "Oracle";
/*      */   }
/*      */ 
/*      */   public String getDatabaseProductVersion()
/*      */     throws SQLException
/*      */   {
/*  310 */     return this.connection.getDatabaseProductVersion();
/*      */   }
/*      */ 
/*      */   public String getDriverName()
/*      */     throws SQLException
/*      */   {
/*  329 */     return DRIVER_NAME;
/*      */   }
/*      */ 
/*      */   public String getDriverVersion()
/*      */     throws SQLException
/*      */   {
/*  348 */     return DRIVER_VERSION;
/*      */   }
/*      */ 
/*      */   public int getDriverMajorVersion()
/*      */   {
/*  366 */     return DRIVER_MAJOR_VERSION;
/*      */   }
/*      */ 
/*      */   public int getDriverMinorVersion()
/*      */   {
/*  384 */     return DRIVER_MINOR_VERSION;
/*      */   }
/*      */ 
/*      */   public boolean usesLocalFiles()
/*      */     throws SQLException
/*      */   {
/*  403 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean usesLocalFilePerTable()
/*      */     throws SQLException
/*      */   {
/*  422 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsMixedCaseIdentifiers()
/*      */     throws SQLException
/*      */   {
/*  444 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean storesUpperCaseIdentifiers()
/*      */     throws SQLException
/*      */   {
/*  464 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean storesLowerCaseIdentifiers()
/*      */     throws SQLException
/*      */   {
/*  484 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean storesMixedCaseIdentifiers()
/*      */     throws SQLException
/*      */   {
/*  504 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsMixedCaseQuotedIdentifiers()
/*      */     throws SQLException
/*      */   {
/*  526 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean storesUpperCaseQuotedIdentifiers()
/*      */     throws SQLException
/*      */   {
/*  546 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean storesLowerCaseQuotedIdentifiers()
/*      */     throws SQLException
/*      */   {
/*  566 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean storesMixedCaseQuotedIdentifiers()
/*      */     throws SQLException
/*      */   {
/*  586 */     return true;
/*      */   }
/*      */ 
/*      */   public String getIdentifierQuoteString()
/*      */     throws SQLException
/*      */   {
/*  608 */     return "\"";
/*      */   }
/*      */ 
/*      */   public String getSQLKeywords()
/*      */     throws SQLException
/*      */   {
/*  628 */     return "ACCESS, ADD, ALTER, AUDIT, CLUSTER, COLUMN, COMMENT, COMPRESS, CONNECT, DATE, DROP, EXCLUSIVE, FILE, IDENTIFIED, IMMEDIATE, INCREMENT, INDEX, INITIAL, INTERSECT, LEVEL, LOCK, LONG, MAXEXTENTS, MINUS, MODE, NOAUDIT, NOCOMPRESS, NOWAIT, NUMBER, OFFLINE, ONLINE, PCTFREE, PRIOR, all_PL_SQL_reserved_ words";
/*      */   }
/*      */ 
/*      */   public String getNumericFunctions()
/*      */     throws SQLException
/*      */   {
/*  672 */     return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
/*      */   }
/*      */ 
/*      */   public String getStringFunctions()
/*      */     throws SQLException
/*      */   {
/*  715 */     return "ASCII,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,LCASE,LENGTH,LTRIM,OCTET_LENGTH,REPLACE,RTRIM,SOUNDEX,SUBSTRING,UCASE";
/*      */   }
/*      */ 
/*      */   public String getSystemFunctions()
/*      */     throws SQLException
/*      */   {
/*  744 */     return "USER";
/*      */   }
/*      */ 
/*      */   public String getTimeDateFunctions()
/*      */     throws SQLException
/*      */   {
/*  781 */     return "CURRENT_DATE,CURRENT_TIMESTAMP,CURDATE,EXTRACT,HOUR,MINUTE,MONTH,SECOND,YEAR";
/*      */   }
/*      */ 
/*      */   public String getSearchStringEscape()
/*      */     throws SQLException
/*      */   {
/*  805 */     return "/";
/*      */   }
/*      */ 
/*      */   public String getExtraNameCharacters()
/*      */     throws SQLException
/*      */   {
/*  825 */     return "$#";
/*      */   }
/*      */ 
/*      */   public boolean supportsAlterTableWithAddColumn()
/*      */     throws SQLException
/*      */   {
/*  847 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsAlterTableWithDropColumn()
/*      */     throws SQLException
/*      */   {
/*  866 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsColumnAliasing()
/*      */     throws SQLException
/*      */   {
/*  891 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean nullPlusNonNullIsNull()
/*      */     throws SQLException
/*      */   {
/*  912 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsConvert()
/*      */     throws SQLException
/*      */   {
/*  931 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsConvert(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  953 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsTableCorrelationNames()
/*      */     throws SQLException
/*      */   {
/*  974 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsDifferentTableCorrelationNames()
/*      */     throws SQLException
/*      */   {
/*  994 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsExpressionsInOrderBy()
/*      */     throws SQLException
/*      */   {
/* 1013 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsOrderByUnrelated()
/*      */     throws SQLException
/*      */   {
/* 1032 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsGroupBy()
/*      */     throws SQLException
/*      */   {
/* 1051 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsGroupByUnrelated()
/*      */     throws SQLException
/*      */   {
/* 1070 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsGroupByBeyondSelect()
/*      */     throws SQLException
/*      */   {
/* 1090 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsLikeEscapeClause()
/*      */     throws SQLException
/*      */   {
/* 1111 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsMultipleResultSets()
/*      */     throws SQLException
/*      */   {
/* 1130 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsMultipleTransactions()
/*      */     throws SQLException
/*      */   {
/* 1150 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsNonNullableColumns()
/*      */     throws SQLException
/*      */   {
/* 1171 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsMinimumSQLGrammar()
/*      */     throws SQLException
/*      */   {
/* 1192 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsCoreSQLGrammar()
/*      */     throws SQLException
/*      */   {
/* 1211 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsExtendedSQLGrammar()
/*      */     throws SQLException
/*      */   {
/* 1230 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsANSI92EntryLevelSQL()
/*      */     throws SQLException
/*      */   {
/* 1251 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsANSI92IntermediateSQL()
/*      */     throws SQLException
/*      */   {
/* 1270 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsANSI92FullSQL()
/*      */     throws SQLException
/*      */   {
/* 1289 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsIntegrityEnhancementFacility()
/*      */     throws SQLException
/*      */   {
/* 1308 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsOuterJoins()
/*      */     throws SQLException
/*      */   {
/* 1327 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsFullOuterJoins()
/*      */     throws SQLException
/*      */   {
/* 1346 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsLimitedOuterJoins()
/*      */     throws SQLException
/*      */   {
/* 1366 */     return true;
/*      */   }
/*      */ 
/*      */   public String getSchemaTerm()
/*      */     throws SQLException
/*      */   {
/* 1385 */     return "schema";
/*      */   }
/*      */ 
/*      */   public String getProcedureTerm()
/*      */     throws SQLException
/*      */   {
/* 1404 */     return "procedure";
/*      */   }
/*      */ 
/*      */   public String getCatalogTerm()
/*      */     throws SQLException
/*      */   {
/* 1423 */     return "";
/*      */   }
/*      */ 
/*      */   public boolean isCatalogAtStart()
/*      */     throws SQLException
/*      */   {
/* 1443 */     return false;
/*      */   }
/*      */ 
/*      */   public String getCatalogSeparator()
/*      */     throws SQLException
/*      */   {
/* 1462 */     return "";
/*      */   }
/*      */ 
/*      */   public boolean supportsSchemasInDataManipulation()
/*      */     throws SQLException
/*      */   {
/* 1481 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsSchemasInProcedureCalls()
/*      */     throws SQLException
/*      */   {
/* 1500 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsSchemasInTableDefinitions()
/*      */     throws SQLException
/*      */   {
/* 1519 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsSchemasInIndexDefinitions()
/*      */     throws SQLException
/*      */   {
/* 1538 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsSchemasInPrivilegeDefinitions()
/*      */     throws SQLException
/*      */   {
/* 1557 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsCatalogsInDataManipulation()
/*      */     throws SQLException
/*      */   {
/* 1576 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsCatalogsInProcedureCalls()
/*      */     throws SQLException
/*      */   {
/* 1595 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsCatalogsInTableDefinitions()
/*      */     throws SQLException
/*      */   {
/* 1614 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsCatalogsInIndexDefinitions()
/*      */     throws SQLException
/*      */   {
/* 1633 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsCatalogsInPrivilegeDefinitions()
/*      */     throws SQLException
/*      */   {
/* 1652 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsPositionedDelete()
/*      */     throws SQLException
/*      */   {
/* 1680 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsPositionedUpdate()
/*      */     throws SQLException
/*      */   {
/* 1707 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsSelectForUpdate()
/*      */     throws SQLException
/*      */   {
/* 1726 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsStoredProcedures()
/*      */     throws SQLException
/*      */   {
/* 1746 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsSubqueriesInComparisons()
/*      */     throws SQLException
/*      */   {
/* 1767 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsSubqueriesInExists()
/*      */     throws SQLException
/*      */   {
/* 1788 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsSubqueriesInIns()
/*      */     throws SQLException
/*      */   {
/* 1809 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsSubqueriesInQuantifieds()
/*      */     throws SQLException
/*      */   {
/* 1830 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsCorrelatedSubqueries()
/*      */     throws SQLException
/*      */   {
/* 1851 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsUnion()
/*      */     throws SQLException
/*      */   {
/* 1870 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsUnionAll()
/*      */     throws SQLException
/*      */   {
/* 1889 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsOpenCursorsAcrossCommit()
/*      */     throws SQLException
/*      */   {
/* 1909 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsOpenCursorsAcrossRollback()
/*      */     throws SQLException
/*      */   {
/* 1929 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsOpenStatementsAcrossCommit()
/*      */     throws SQLException
/*      */   {
/* 1949 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsOpenStatementsAcrossRollback()
/*      */     throws SQLException
/*      */   {
/* 1969 */     return false;
/*      */   }
/*      */ 
/*      */   public int getMaxBinaryLiteralLength()
/*      */     throws SQLException
/*      */   {
/* 1996 */     return 1000;
/*      */   }
/*      */ 
/*      */   public int getMaxCharLiteralLength()
/*      */     throws SQLException
/*      */   {
/* 2015 */     return 2000;
/*      */   }
/*      */ 
/*      */   public int getMaxColumnNameLength()
/*      */     throws SQLException
/*      */   {
/* 2034 */     return 30;
/*      */   }
/*      */ 
/*      */   public int getMaxColumnsInGroupBy()
/*      */     throws SQLException
/*      */   {
/* 2053 */     return 0;
/*      */   }
/*      */ 
/*      */   public int getMaxColumnsInIndex()
/*      */     throws SQLException
/*      */   {
/* 2072 */     return 32;
/*      */   }
/*      */ 
/*      */   public int getMaxColumnsInOrderBy()
/*      */     throws SQLException
/*      */   {
/* 2091 */     return 0;
/*      */   }
/*      */ 
/*      */   public int getMaxColumnsInSelect()
/*      */     throws SQLException
/*      */   {
/* 2110 */     return 0;
/*      */   }
/*      */ 
/*      */   public int getMaxColumnsInTable()
/*      */     throws SQLException
/*      */   {
/* 2129 */     return 1000;
/*      */   }
/*      */ 
/*      */   public int getMaxConnections()
/*      */     throws SQLException
/*      */   {
/* 2148 */     return 0;
/*      */   }
/*      */ 
/*      */   public int getMaxCursorNameLength()
/*      */     throws SQLException
/*      */   {
/* 2167 */     return 0;
/*      */   }
/*      */ 
/*      */   public int getMaxIndexLength()
/*      */     throws SQLException
/*      */   {
/* 2186 */     return 0;
/*      */   }
/*      */ 
/*      */   public int getMaxSchemaNameLength()
/*      */     throws SQLException
/*      */   {
/* 2205 */     return 30;
/*      */   }
/*      */ 
/*      */   public int getMaxProcedureNameLength()
/*      */     throws SQLException
/*      */   {
/* 2224 */     return 30;
/*      */   }
/*      */ 
/*      */   public int getMaxCatalogNameLength()
/*      */     throws SQLException
/*      */   {
/* 2243 */     return 0;
/*      */   }
/*      */ 
/*      */   public int getMaxRowSize()
/*      */     throws SQLException
/*      */   {
/* 2262 */     return 0;
/*      */   }
/*      */ 
/*      */   public boolean doesMaxRowSizeIncludeBlobs()
/*      */     throws SQLException
/*      */   {
/* 2282 */     return true;
/*      */   }
/*      */ 
/*      */   public int getMaxStatementLength()
/*      */     throws SQLException
/*      */   {
/* 2301 */     return 65535;
/*      */   }
/*      */ 
/*      */   public int getMaxStatements()
/*      */     throws SQLException
/*      */   {
/* 2321 */     return 0;
/*      */   }
/*      */ 
/*      */   public int getMaxTableNameLength()
/*      */     throws SQLException
/*      */   {
/* 2340 */     return 30;
/*      */   }
/*      */ 
/*      */   public int getMaxTablesInSelect()
/*      */     throws SQLException
/*      */   {
/* 2359 */     return 0;
/*      */   }
/*      */ 
/*      */   public int getMaxUserNameLength()
/*      */     throws SQLException
/*      */   {
/* 2378 */     return 30;
/*      */   }
/*      */ 
/*      */   public int getDefaultTransactionIsolation()
/*      */     throws SQLException
/*      */   {
/* 2401 */     return 2;
/*      */   }
/*      */ 
/*      */   public boolean supportsTransactions()
/*      */     throws SQLException
/*      */   {
/* 2421 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsTransactionIsolationLevel(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2443 */     return (paramInt == 2) || (paramInt == 8);
/*      */   }
/*      */ 
/*      */   public boolean supportsDataDefinitionAndDataManipulationTransactions()
/*      */     throws SQLException
/*      */   {
/* 2465 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsDataManipulationTransactionsOnly()
/*      */     throws SQLException
/*      */   {
/* 2485 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean dataDefinitionCausesTransactionCommit()
/*      */     throws SQLException
/*      */   {
/* 2505 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean dataDefinitionIgnoredInTransactions()
/*      */     throws SQLException
/*      */   {
/* 2524 */     return false;
/*      */   }
/*      */ 
/*      */   public synchronized ResultSet getProcedures(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 2588 */     String str1 = "SELECT\n  -- Standalone procedures and functions\n  NULL AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Standalone procedure or function' AS remarks,\n  DECODE(object_type, 'PROCEDURE', 1,\n                      'FUNCTION', 2,\n                      0) AS procedure_type\n,  NULL AS specific_name\nFROM all_objects\nWHERE (object_type = 'PROCEDURE' OR object_type = 'FUNCTION')\n  AND owner LIKE :1 ESCAPE '/'\n  AND object_name LIKE :2 ESCAPE '/'\n";
/*      */ 
/* 2606 */     String str2 = "SELECT\n  -- Packaged procedures with no arguments\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged procedure' AS remarks,\n  1 AS procedure_type\n,  NULL AS specific_name\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND data_type IS NULL\n  AND ";
/*      */ 
/* 2621 */     String str3 = "SELECT\n  -- Packaged procedures with arguments\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged procedure' AS remarks,\n  1 AS procedure_type\n,  NULL AS specific_name\nFROM all_arguments\nWHERE argument_name IS NOT NULL\n  AND position = 1\n  AND position = sequence\n  AND ";
/*      */ 
/* 2636 */     String str4 = "SELECT\n  -- Packaged functions\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged function' AS remarks,\n  2 AS procedure_type\n,  NULL AS specific_name\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND in_out = 'OUT'\n  AND   data_level = 0\n  AND ";
/*      */ 
/* 2652 */     String str5 = "package_name LIKE :3 ESCAPE '/'\n  AND owner LIKE :4 ESCAPE '/'\n  AND object_name LIKE :5 ESCAPE '/'\n";
/*      */ 
/* 2655 */     String str6 = "package_name IS NOT NULL\n  AND owner LIKE :6 ESCAPE '/'\n  AND object_name LIKE :7 ESCAPE '/'\n";
/*      */ 
/* 2660 */     String str7 = "ORDER BY procedure_schem, procedure_name\n";
/*      */ 
/* 2662 */     PreparedStatement localPreparedStatement = null;
/* 2663 */     String str8 = null;
/*      */ 
/* 2666 */     String str9 = paramString2;
/*      */ 
/* 2668 */     if (paramString2 == null)
/* 2669 */       str9 = "%";
/* 2670 */     else if (paramString2.equals("")) {
/* 2671 */       str9 = getUserName().toUpperCase();
/*      */     }
/* 2673 */     String str10 = paramString3;
/*      */ 
/* 2675 */     if (paramString3 == null) {
/* 2676 */       str10 = "%";
/* 2677 */     } else if (paramString3.equals(""))
/*      */     {
/* 2679 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74);
/* 2680 */       ((SQLException)localObject).fillInStackTrace();
/* 2681 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 2684 */     if (paramString1 == null)
/*      */     {
/* 2689 */       str8 = new StringBuilder().append(str1).append("UNION ALL ").append(str2).append(str6).append("UNION ALL ").append(str3).append(str6).append("UNION ALL ").append(str4).append(str6).append(str7).toString();
/*      */ 
/* 2695 */       localPreparedStatement = this.connection.prepareStatement(str8);
/*      */ 
/* 2697 */       localPreparedStatement.setString(1, str9);
/* 2698 */       localPreparedStatement.setString(2, str10);
/* 2699 */       localPreparedStatement.setString(3, str9);
/* 2700 */       localPreparedStatement.setString(4, str10);
/* 2701 */       localPreparedStatement.setString(5, str9);
/* 2702 */       localPreparedStatement.setString(6, str10);
/* 2703 */       localPreparedStatement.setString(7, str9);
/* 2704 */       localPreparedStatement.setString(8, str10);
/*      */     }
/* 2706 */     else if (paramString1.equals(""))
/*      */     {
/* 2711 */       str8 = str1;
/*      */ 
/* 2713 */       localPreparedStatement = this.connection.prepareStatement(str8);
/*      */ 
/* 2715 */       localPreparedStatement.setString(1, str9);
/* 2716 */       localPreparedStatement.setString(2, str10);
/*      */     }
/*      */     else
/*      */     {
/* 2722 */       str8 = new StringBuilder().append(str2).append(str5).append("UNION ALL ").append(str3).append(str5).append("UNION ALL ").append(str4).append(str5).append(str7).toString();
/*      */ 
/* 2727 */       localPreparedStatement = this.connection.prepareStatement(str8);
/*      */ 
/* 2729 */       localPreparedStatement.setString(1, paramString1);
/* 2730 */       localPreparedStatement.setString(2, str9);
/* 2731 */       localPreparedStatement.setString(3, str10);
/* 2732 */       localPreparedStatement.setString(4, paramString1);
/* 2733 */       localPreparedStatement.setString(5, str9);
/* 2734 */       localPreparedStatement.setString(6, str10);
/* 2735 */       localPreparedStatement.setString(7, paramString1);
/* 2736 */       localPreparedStatement.setString(8, str9);
/* 2737 */       localPreparedStatement.setString(9, str10);
/*      */     }
/*      */ 
/* 2741 */     Object localObject = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 2744 */     ((OracleResultSet)localObject).closeStatementOnClose();
/*      */ 
/* 2746 */     return localObject;
/*      */   }
/*      */ 
/*      */   public synchronized ResultSet getProcedureColumns(String paramString1, String paramString2, String paramString3, String paramString4)
/*      */     throws SQLException
/*      */   {
/* 2858 */     boolean bool = this.connection.getIncludeSynonyms();
/*      */ 
/* 2860 */     if (("".equals(paramString1)) && ((paramString2 == null) || (!hasSqlWildcard(paramString2))) && (paramString3 != null) && (!hasSqlWildcard(paramString3)))
/*      */     {
/* 2865 */       return getUnpackagedProcedureColumnsNoWildcards(paramString2 != null ? stripSqlEscapes(paramString2) : null, paramString3 != null ? stripSqlEscapes(paramString3) : null, paramString4);
/*      */     }
/*      */ 
/* 2868 */     if ((paramString1 != null) && (paramString1.length() != 0) && (!hasSqlWildcard(paramString1)) && ((paramString2 == null) || (!hasSqlWildcard(paramString2))))
/*      */     {
/* 2872 */       return getPackagedProcedureColumnsNoWildcards(paramString1 != null ? stripSqlEscapes(paramString1) : null, paramString2 != null ? stripSqlEscapes(paramString2) : null, paramString3, paramString4);
/*      */     }
/*      */ 
/* 2879 */     return getProcedureColumnsWithWildcards(paramString1, paramString2, paramString3, paramString4, bool);
/*      */   }
/*      */ 
/*      */   ResultSet getUnpackagedProcedureColumnsNoWildcards(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 2891 */     if ("".equals(paramString3))
/*      */     {
/* 2893 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74);
/* 2894 */       ((SQLException)localObject1).fillInStackTrace();
/* 2895 */       throw ((Throwable)localObject1);
/*      */     }
/* 2897 */     Object localObject1 = getUnpackagedProcedureColumnsNoWildcardsPlsql();
/* 2898 */     CallableStatement localCallableStatement = null;
/* 2899 */     ResultSet localResultSet = null;
/*      */     try
/*      */     {
/* 2902 */       localCallableStatement = this.connection.prepareCall((String)localObject1);
/* 2903 */       localCallableStatement.setString(1, paramString1);
/* 2904 */       localCallableStatement.setString(2, paramString2);
/* 2905 */       localCallableStatement.setString(3, paramString3 == null ? "%" : paramString3);
/* 2906 */       localCallableStatement.registerOutParameter(4, -10);
/* 2907 */       localCallableStatement.registerOutParameter(5, 2);
/* 2908 */       localCallableStatement.execute();
/* 2909 */       int i = localCallableStatement.getInt(5);
/* 2910 */       if (i == 0)
/*      */       {
/* 2912 */         localResultSet = ((OracleCallableStatement)localCallableStatement).getCursor(4);
/* 2913 */         ((OracleResultSet)localResultSet).closeStatementOnClose();
/*      */       }
/*      */       else
/*      */       {
/* 2918 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 258);
/* 2919 */         localSQLException.fillInStackTrace();
/* 2920 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/* 2925 */       if ((localResultSet == null) && (localCallableStatement != null)) localCallableStatement.close();
/*      */     }
/* 2927 */     return localResultSet;
/*      */   }
/*      */ 
/*      */   ResultSet getPackagedProcedureColumnsNoWildcards(String paramString1, String paramString2, String paramString3, String paramString4)
/*      */     throws SQLException
/*      */   {
/* 2936 */     if ("".equals(paramString4))
/*      */     {
/* 2938 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74);
/* 2939 */       ((SQLException)localObject1).fillInStackTrace();
/* 2940 */       throw ((Throwable)localObject1);
/*      */     }
/* 2942 */     Object localObject1 = getPackagedProcedureColumnsNoWildcardsPlsql();
/* 2943 */     CallableStatement localCallableStatement = null;
/* 2944 */     ResultSet localResultSet = null;
/*      */     try
/*      */     {
/* 2947 */       localCallableStatement = this.connection.prepareCall((String)localObject1);
/* 2948 */       localCallableStatement.setString(1, paramString1);
/* 2949 */       localCallableStatement.setString(2, paramString2);
/* 2950 */       localCallableStatement.setString(3, paramString3);
/* 2951 */       localCallableStatement.setString(4, paramString4 == null ? "%" : paramString4);
/* 2952 */       localCallableStatement.registerOutParameter(5, -10);
/* 2953 */       localCallableStatement.registerOutParameter(6, 2);
/* 2954 */       localCallableStatement.execute();
/* 2955 */       int i = localCallableStatement.getInt(6);
/* 2956 */       if (i == 0)
/*      */       {
/* 2958 */         localResultSet = ((OracleCallableStatement)localCallableStatement).getCursor(5);
/* 2959 */         ((OracleResultSet)localResultSet).closeStatementOnClose();
/*      */       }
/*      */       else
/*      */       {
/* 2964 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 258);
/* 2965 */         localSQLException.fillInStackTrace();
/* 2966 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/* 2971 */       if ((localResultSet == null) && (localCallableStatement != null)) localCallableStatement.close();
/*      */     }
/* 2973 */     return localResultSet;
/*      */   }
/*      */ 
/*      */   ResultSet getProcedureColumnsWithWildcards(String paramString1, String paramString2, String paramString3, String paramString4, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2998 */     String str1 = new StringBuilder().append("SELECT package_name AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       argument_name AS column_name,\n       DECODE(position, 0, 5,\n                        DECODE(in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n       DECODE (data_type, 'CHAR', 1,\n                          'VARCHAR2', 12,\n                          'NUMBER', 3,\n                          'LONG', -1,\n                          'DATE', ").append(this.connection.getMapDateToTimestamp() ? "93,\n" : "91,\n").append("                          'RAW', -3,\n").append("                          'LONG RAW', -4,\n").append("                          'TIMESTAMP', 93, \n").append("                          'TIMESTAMP WITH TIME ZONE', -101, \n").append("               'TIMESTAMP WITH LOCAL TIME ZONE', -102, \n").append("               'INTERVAL YEAR TO MONTH', -103, \n").append("               'INTERVAL DAY TO SECOND', -104, \n").append("               'BINARY_FLOAT', 100, 'BINAvRY_DOUBLE', 101,").append("               1111) AS data_type,\n").append("       DECODE(data_type, 'OBJECT', type_owner || '.' || type_name, ").append("              data_type) AS type_name,\n").append("       DECODE (data_precision, NULL, data_length,\n").append("                               data_precision) AS precision,\n").append("       data_length AS length,\n").append("       data_scale AS scale,\n").append("       10 AS radix,\n").append("       1 AS nullable,\n").append("       NULL AS remarks,\n").append("       default_value AS column_def,\n").append("       NULL as sql_data_type,\n").append("       NULL AS sql_datetime_sub,\n").append("       DECODE(data_type,\n").append("                         'CHAR', 32767,\n").append("                         'VARCHAR2', 32767,\n").append("                         'LONG', 32767,\n").append("                         'RAW', 32767,\n").append("                         'LONG RAW', 32767,\n").append("                         NULL) AS char_octet_length,\n").append("       (sequence - 1) AS ordinal_position,\n").append("       'YES' AS is_nullable,\n").append("       NULL AS specific_name,\n").append("       sequence,\n").append("       overload,\n").append("       default_value\n").append(" FROM all_arguments\n").append("WHERE owner LIKE :1 ESCAPE '/'\n").append("  AND object_name LIKE :2 ESCAPE '/' AND data_level = 0\n").toString();
/*      */ 
/* 3052 */     String str2 = "  AND package_name LIKE :3 ESCAPE '/'\n";
/* 3053 */     String str3 = "  AND package_name IS NULL\n";
/*      */ 
/* 3055 */     String str4 = "  AND argument_name LIKE :4 ESCAPE '/'\n";
/* 3056 */     String str5 = "  AND (argument_name LIKE :5 ESCAPE '/'\n       OR (argument_name IS NULL\n           AND data_type IS NOT NULL))\n";
/*      */ 
/* 3062 */     String str6 = "ORDER BY procedure_schem, procedure_name, overload, sequence\n";
/*      */ 
/* 3065 */     String str7 = null;
/* 3066 */     PreparedStatement localPreparedStatement = null;
/* 3067 */     String str8 = null;
/*      */ 
/* 3070 */     String str9 = paramString2;
/*      */ 
/* 3072 */     if (paramString2 == null)
/* 3073 */       str9 = "%";
/* 3074 */     else if (paramString2.equals("")) {
/* 3075 */       str9 = getUserName().toUpperCase();
/*      */     }
/* 3077 */     String str10 = paramString3;
/*      */ 
/* 3079 */     if (paramString3 == null) {
/* 3080 */       str10 = "%";
/* 3081 */     } else if (paramString3.equals(""))
/*      */     {
/* 3083 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74);
/* 3084 */       ((SQLException)localObject1).fillInStackTrace();
/* 3085 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/* 3088 */     Object localObject1 = paramString4;
/*      */ 
/* 3090 */     if ((paramString4 == null) || (paramString4.equals("%")))
/*      */     {
/* 3092 */       localObject1 = "%";
/* 3093 */       str8 = str5;
/*      */     } else {
/* 3095 */       if (paramString4.equals(""))
/*      */       {
/* 3097 */         localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74);
/* 3098 */         ((SQLException)localObject2).fillInStackTrace();
/* 3099 */         throw ((Throwable)localObject2);
/*      */       }
/*      */ 
/* 3102 */       str8 = str4;
/*      */     }
/* 3104 */     if (paramString1 == null)
/*      */     {
/* 3109 */       str7 = new StringBuilder().append(str1).append(str8).append(str6).toString();
/*      */ 
/* 3111 */       localPreparedStatement = this.connection.prepareStatement(str7);
/*      */ 
/* 3113 */       localPreparedStatement.setString(1, str9);
/* 3114 */       localPreparedStatement.setString(2, str10);
/* 3115 */       localPreparedStatement.setString(3, (String)localObject1);
/*      */     }
/* 3117 */     else if (paramString1.equals(""))
/*      */     {
/* 3122 */       str7 = new StringBuilder().append(str1).append(str3).append(str8).append(str6).toString();
/*      */ 
/* 3124 */       localPreparedStatement = this.connection.prepareStatement(str7);
/*      */ 
/* 3126 */       localPreparedStatement.setString(1, str9);
/* 3127 */       localPreparedStatement.setString(2, str10);
/* 3128 */       localPreparedStatement.setString(3, (String)localObject1);
/*      */     }
/*      */     else
/*      */     {
/* 3134 */       str7 = new StringBuilder().append(str1).append(str2).append(str8).append(str6).toString();
/*      */ 
/* 3136 */       localPreparedStatement = this.connection.prepareStatement(str7);
/*      */ 
/* 3138 */       localPreparedStatement.setString(1, str9);
/* 3139 */       localPreparedStatement.setString(2, str10);
/* 3140 */       localPreparedStatement.setString(3, paramString1);
/* 3141 */       localPreparedStatement.setString(4, (String)localObject1);
/*      */     }
/*      */ 
/* 3145 */     Object localObject2 = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 3148 */     ((OracleResultSet)localObject2).closeStatementOnClose();
/*      */ 
/* 3150 */     return localObject2;
/*      */   }
/*      */ 
/*      */   public ResultSet getFunctionColumns(String paramString1, String paramString2, String paramString3, String paramString4)
/*      */     throws SQLException
/*      */   {
/* 3259 */     String str1 = new StringBuilder().append("SELECT package_name AS function_cat,\n       arg.owner AS function_schem,\n       arg.object_name AS function_name,\n       arg.argument_name AS column_name,\n       DECODE(arg.position, 0, 5,\n                        DECODE(arg.in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n       DECODE (arg.data_type, 'CHAR', 1,\n                          'VARCHAR2', 12,\n                          'NUMBER', 3,\n                          'LONG', -1,\n                          'DATE', ").append(this.connection.getMapDateToTimestamp() ? "93,\n" : "91,\n").append("                          'RAW', -3,\n").append("                          'LONG RAW', -4,\n").append("                          'TIMESTAMP', 93, \n").append("                          'TIMESTAMP WITH TIME ZONE', -101, \n").append("               'TIMESTAMP WITH LOCAL TIME ZONE', -102, \n").append("               'INTERVAL YEAR TO MONTH', -103, \n").append("               'INTERVAL DAY TO SECOND', -104, \n").append("               'BINARY_FLOAT', 100, 'BINAvRY_DOUBLE', 101,").append("               1111) AS data_type,\n").append("       DECODE(arg.data_type, 'OBJECT', arg.type_owner || '.' || arg.type_name, ").append("              arg.data_type) AS type_name,\n").append("       DECODE (arg.data_precision, NULL, arg.data_length,\n").append("                               arg.data_precision) AS precision,\n").append("       arg.data_length AS length,\n").append("       arg.data_scale AS scale,\n").append("       10 AS radix,\n").append("       1 AS nullable,\n").append("       NULL AS remarks,\n").append("       arg.default_value AS column_def,\n").append("       NULL as sql_data_type,\n").append("       NULL AS sql_datetime_sub,\n").append("       DECODE(arg.data_type,\n").append("                         'CHAR', 32767,\n").append("                         'VARCHAR2', 32767,\n").append("                         'LONG', 32767,\n").append("                         'RAW', 32767,\n").append("                         'LONG RAW', 32767,\n").append("                         NULL) AS char_octet_length,\n").append("       (arg.sequence - 1) AS ordinal_position,\n").append("       'YES' AS is_nullable,\n").append("       NULL AS specific_name,\n").append("       arg.sequence,\n").append("       arg.overload,\n").append("       arg.default_value\n").append(" FROM all_arguments arg, all_procedures proc\n").append(" WHERE arg.owner LIKE :1 ESCAPE '/'\n").append("  AND arg.object_name LIKE :2 ESCAPE '/'\n").toString();
/*      */ 
/* 3314 */     int i = this.connection.getVersionNumber();
/*      */ 
/* 3316 */     String str2 = i >= 10200 ? "  AND proc.object_id = arg.object_id\n  AND proc.object_type = 'FUNCTION'\n" : "  AND proc.owner = arg.owner\n  AND proc.object_name = arg.object_name\n";
/*      */ 
/* 3324 */     String str3 = "  AND arg.package_name LIKE :3 ESCAPE '/'\n";
/*      */ 
/* 3326 */     String str4 = "  AND arg.package_name IS NULL\n";
/*      */ 
/* 3328 */     String str5 = "  AND arg.argument_name LIKE :4 ESCAPE '/'\n";
/*      */ 
/* 3330 */     String str6 = "  AND (arg.argument_name LIKE :5 ESCAPE '/'\n     OR (arg.argument_name IS NULL\n         AND arg.data_type IS NOT NULL))\n";
/*      */ 
/* 3337 */     String str7 = "ORDER BY function_schem, function_name, overload, sequence\n";
/*      */ 
/* 3340 */     String str8 = null;
/* 3341 */     PreparedStatement localPreparedStatement = null;
/* 3342 */     String str9 = null;
/*      */ 
/* 3345 */     String str10 = paramString2;
/*      */ 
/* 3347 */     if (paramString2 == null)
/* 3348 */       str10 = "%";
/* 3349 */     else if (paramString2.equals("")) {
/* 3350 */       str10 = getUserName().toUpperCase();
/*      */     }
/* 3352 */     String str11 = paramString3;
/*      */ 
/* 3354 */     if (paramString3 == null) {
/* 3355 */       str11 = "%";
/* 3356 */     } else if (paramString3.equals(""))
/*      */     {
/* 3358 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74);
/* 3359 */       ((SQLException)localObject1).fillInStackTrace();
/* 3360 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/* 3363 */     Object localObject1 = paramString4;
/*      */ 
/* 3365 */     if ((paramString4 == null) || (paramString4.equals("%")))
/*      */     {
/* 3367 */       localObject1 = "%";
/* 3368 */       str9 = str6;
/*      */     } else {
/* 3370 */       if (paramString4.equals(""))
/*      */       {
/* 3372 */         localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74);
/* 3373 */         ((SQLException)localObject2).fillInStackTrace();
/* 3374 */         throw ((Throwable)localObject2);
/*      */       }
/*      */ 
/* 3377 */       str9 = str5;
/*      */     }
/* 3379 */     if (paramString1 == null)
/*      */     {
/* 3384 */       str8 = new StringBuilder().append(str1).append(str2).append(str9).append(str7).toString();
/*      */ 
/* 3386 */       localPreparedStatement = this.connection.prepareStatement(str8);
/*      */ 
/* 3388 */       localPreparedStatement.setString(1, str10);
/* 3389 */       localPreparedStatement.setString(2, str11);
/* 3390 */       localPreparedStatement.setString(3, (String)localObject1);
/*      */     }
/* 3392 */     else if (paramString1.equals(""))
/*      */     {
/* 3397 */       str8 = new StringBuilder().append(str1).append(str2).append(str4).append(str9).append(str7).toString();
/*      */ 
/* 3400 */       localPreparedStatement = this.connection.prepareStatement(str8);
/*      */ 
/* 3402 */       localPreparedStatement.setString(1, str10);
/* 3403 */       localPreparedStatement.setString(2, str11);
/* 3404 */       localPreparedStatement.setString(3, (String)localObject1);
/*      */     }
/*      */     else
/*      */     {
/* 3410 */       str8 = new StringBuilder().append(str1).append(str2).append(str3).append(str9).append(str7).toString();
/*      */ 
/* 3413 */       localPreparedStatement = this.connection.prepareStatement(str8);
/*      */ 
/* 3415 */       localPreparedStatement.setString(1, str10);
/* 3416 */       localPreparedStatement.setString(2, str11);
/* 3417 */       localPreparedStatement.setString(3, paramString1);
/* 3418 */       localPreparedStatement.setString(4, (String)localObject1);
/*      */     }
/*      */ 
/* 3422 */     Object localObject2 = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 3425 */     ((OracleResultSet)localObject2).closeStatementOnClose();
/*      */ 
/* 3427 */     return localObject2;
/*      */   }
/*      */ 
/*      */   public synchronized ResultSet getTables(String paramString1, String paramString2, String paramString3, String[] paramArrayOfString)
/*      */     throws SQLException
/*      */   {
/* 3525 */     String str1 = "SELECT NULL AS table_cat,\n       o.owner AS table_schem,\n       o.object_name AS table_name,\n       o.object_type AS table_type,\n";
/*      */ 
/* 3530 */     String str2 = "       c.comments AS remarks\n";
/* 3531 */     String str3 = "       NULL AS remarks\n";
/*      */ 
/* 3533 */     String str4 = "  FROM all_objects o, all_tab_comments c\n";
/* 3534 */     String str5 = "  FROM all_objects o\n";
/*      */ 
/* 3536 */     String str6 = "  WHERE o.owner LIKE :1 ESCAPE '/'\n    AND o.object_name LIKE :2 ESCAPE '/'\n";
/*      */ 
/* 3539 */     String str7 = "    AND o.owner = c.owner (+)\n    AND o.object_name = c.table_name (+)\n";
/*      */ 
/* 3542 */     int i = 0;
/*      */ 
/* 3544 */     String str8 = "";
/* 3545 */     String str9 = "";
/*      */ 
/* 3548 */     if (paramArrayOfString != null)
/*      */     {
/* 3556 */       str8 = "    AND o.object_type IN ('xxx'";
/* 3557 */       str9 = "    AND o.object_type IN ('xxx'";
/*      */ 
/* 3559 */       for (int j = 0; j < paramArrayOfString.length; j++)
/*      */       {
/* 3561 */         if (paramArrayOfString[j].equals("SYNONYM"))
/*      */         {
/* 3565 */           str8 = new StringBuilder().append(str8).append(", '").append(paramArrayOfString[j]).append("'").toString();
/* 3566 */           i = 1;
/*      */         }
/*      */         else
/*      */         {
/* 3572 */           str8 = new StringBuilder().append(str8).append(", '").append(paramArrayOfString[j]).append("'").toString();
/* 3573 */           str9 = new StringBuilder().append(str9).append(", '").append(paramArrayOfString[j]).append("'").toString();
/*      */         }
/*      */       }
/*      */ 
/* 3577 */       str8 = new StringBuilder().append(str8).append(")\n").toString();
/* 3578 */       str9 = new StringBuilder().append(str9).append(")\n").toString();
/*      */     }
/*      */     else
/*      */     {
/* 3582 */       i = 1;
/* 3583 */       str8 = "    AND o.object_type IN ('TABLE', 'SYNONYM', 'VIEW')\n";
/* 3584 */       str9 = "    AND o.object_type IN ('TABLE', 'VIEW')\n";
/*      */     }
/*      */ 
/* 3587 */     String str10 = "  ORDER BY table_type, table_schem, table_name\n";
/*      */ 
/* 3589 */     String str11 = "SELECT NULL AS table_cat,\n       s.owner AS table_schem,\n       s.synonym_name AS table_name,\n       'SYNONYM' AS table_table_type,\n";
/*      */ 
/* 3594 */     String str12 = "       c.comments AS remarks\n";
/* 3595 */     String str13 = "       NULL AS remarks\n";
/*      */ 
/* 3597 */     String str14 = "  FROM all_synonyms s, all_objects o, all_tab_comments c\n";
/*      */ 
/* 3599 */     String str15 = "  FROM all_synonyms s, all_objects o\n";
/*      */ 
/* 3601 */     String str16 = "  WHERE s.owner LIKE :3 ESCAPE '/'\n    AND s.synonym_name LIKE :4 ESCAPE '/'\n    AND s.table_owner = o.owner\n    AND s.table_name = o.object_name\n    AND o.object_type IN ('TABLE', 'VIEW')\n";
/*      */ 
/* 3608 */     String str17 = "";
/*      */ 
/* 3610 */     str17 = new StringBuilder().append(str17).append(str1).toString();
/*      */ 
/* 3612 */     if (this.connection.getRemarksReporting())
/* 3613 */       str17 = new StringBuilder().append(str17).append(str2).append(str4).toString();
/*      */     else {
/* 3615 */       str17 = new StringBuilder().append(str17).append(str3).append(str5).toString();
/*      */     }
/* 3617 */     str17 = new StringBuilder().append(str17).append(str6).toString();
/*      */ 
/* 3619 */     if (this.connection.getRestrictGetTables())
/* 3620 */       str17 = new StringBuilder().append(str17).append(str9).toString();
/*      */     else {
/* 3622 */       str17 = new StringBuilder().append(str17).append(str8).toString();
/*      */     }
/* 3624 */     if (this.connection.getRemarksReporting()) {
/* 3625 */       str17 = new StringBuilder().append(str17).append(str7).toString();
/*      */     }
/* 3627 */     if ((i != 0) && (this.connection.getRestrictGetTables()))
/*      */     {
/* 3631 */       str17 = new StringBuilder().append(str17).append("UNION\n").append(str11).toString();
/*      */ 
/* 3633 */       if (this.connection.getRemarksReporting())
/* 3634 */         str17 = new StringBuilder().append(str17).append(str12).append(str14).toString();
/*      */       else {
/* 3636 */         str17 = new StringBuilder().append(str17).append(str13).append(str15).toString();
/*      */       }
/* 3638 */       str17 = new StringBuilder().append(str17).append(str16).toString();
/*      */ 
/* 3640 */       if (this.connection.getRemarksReporting()) {
/* 3641 */         str17 = new StringBuilder().append(str17).append(str7).toString();
/*      */       }
/*      */     }
/* 3644 */     str17 = new StringBuilder().append(str17).append(str10).toString();
/*      */ 
/* 3647 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement(str17);
/*      */ 
/* 3649 */     localPreparedStatement.setString(1, paramString2 == null ? "%" : paramString2);
/* 3650 */     localPreparedStatement.setString(2, paramString3 == null ? "%" : paramString3);
/*      */ 
/* 3652 */     if ((i != 0) && (this.connection.getRestrictGetTables()))
/*      */     {
/* 3654 */       localPreparedStatement.setString(3, paramString2 == null ? "%" : paramString2);
/* 3655 */       localPreparedStatement.setString(4, paramString3 == null ? "%" : paramString3);
/*      */     }
/*      */ 
/* 3658 */     OracleResultSet localOracleResultSet = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 3661 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 3663 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   public ResultSet getSchemas()
/*      */     throws SQLException
/*      */   {
/* 3690 */     Statement localStatement = this.connection.createStatement();
/* 3691 */     String str = "SELECT username AS table_schem,null as table_catalog  FROM all_users ORDER BY table_schem";
/*      */ 
/* 3695 */     OracleResultSet localOracleResultSet = (OracleResultSet)localStatement.executeQuery(str);
/*      */ 
/* 3698 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 3700 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   public ResultSet getCatalogs()
/*      */     throws SQLException
/*      */   {
/* 3726 */     Statement localStatement = this.connection.createStatement();
/* 3727 */     String str = "select 'nothing' as table_cat from dual where 1 = 2";
/* 3728 */     OracleResultSet localOracleResultSet = (OracleResultSet)localStatement.executeQuery(str);
/*      */ 
/* 3731 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 3733 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   public ResultSet getTableTypes()
/*      */     throws SQLException
/*      */   {
/* 3760 */     Statement localStatement = this.connection.createStatement();
/* 3761 */     String str = "select 'TABLE' as table_type from dual\nunion select 'VIEW' as table_type from dual\nunion select 'SYNONYM' as table_type from dual\n";
/*      */ 
/* 3765 */     OracleResultSet localOracleResultSet = (OracleResultSet)localStatement.executeQuery(str);
/*      */ 
/* 3768 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 3770 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   public ResultSet getColumns(String paramString1, String paramString2, String paramString3, String paramString4)
/*      */     throws SQLException
/*      */   {
/* 3851 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 3852 */     localSQLException.fillInStackTrace();
/* 3853 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public synchronized ResultSet getColumnPrivileges(String paramString1, String paramString2, String paramString3, String paramString4)
/*      */     throws SQLException
/*      */   {
/* 3912 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       table_schema AS table_schem,\n       table_name,\n       column_name,\n       grantor,\n       grantee,\n       privilege,\n       grantable AS is_grantable\nFROM all_col_privs\nWHERE table_schema LIKE :1 ESCAPE '/'\n  AND table_name LIKE :2 ESCAPE '/'\n  AND column_name LIKE :3 ESCAPE '/'\nORDER BY column_name, privilege\n");
/*      */ 
/* 3926 */     localPreparedStatement.setString(1, paramString2 == null ? "%" : paramString2);
/* 3927 */     localPreparedStatement.setString(2, paramString3 == null ? "%" : paramString3);
/* 3928 */     localPreparedStatement.setString(3, paramString4 == null ? "%" : paramString4);
/*      */ 
/* 3930 */     OracleResultSet localOracleResultSet = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 3933 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 3935 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   public synchronized ResultSet getTablePrivileges(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 3979 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       table_schema AS table_schem,\n       table_name,\n       grantor,\n       grantee,\n       privilege,\n       grantable AS is_grantable\nFROM all_tab_privs\nWHERE table_schema LIKE :1 ESCAPE '/'\n  AND table_name LIKE :2 ESCAPE '/'\nORDER BY table_schem, table_name, privilege\n");
/*      */ 
/* 3987 */     localPreparedStatement.setString(1, paramString2 == null ? "%" : paramString2);
/* 3988 */     localPreparedStatement.setString(2, paramString3 == null ? "%" : paramString3);
/*      */ 
/* 3990 */     OracleResultSet localOracleResultSet = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 3993 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 3995 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   public synchronized ResultSet getBestRowIdentifier(String paramString1, String paramString2, String paramString3, int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4045 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement(new StringBuilder().append("SELECT 1 AS scope, 'ROWID' AS column_name, -8 AS data_type,\n 'ROWID' AS type_name, 0 AS column_size, 0 AS buffer_length,\n       0 AS decimal_digits, 2 AS pseudo_column\nFROM DUAL\nWHERE :1 = 1\nUNION\nSELECT 2 AS scope,\n  t.column_name,\n DECODE (t.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n 'LONG', -1, 'DATE', ").append(this.connection.getMapDateToTimestamp() ? "93,\n" : "91,\n").append(" 'RAW', -3, 'LONG RAW', -4, \n").append(" 'TIMESTAMP(6)', 93, ").append(" 'TIMESTAMP(6) WITH TIME ZONE', -101, \n").append(" 'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, \n").append(" 'INTERVAL YEAR(2) TO MONTH', -103, \n").append(" 'INTERVAL DAY(2) TO SECOND(6)', -104, \n").append(" 'BINARY_FLOAT', 100, ").append(" 'BINARY_DOUBLE', 101,").append(" 1111)\n").append(" AS data_type,\n").append(" t.data_type AS type_name,\n").append(" DECODE (t.data_precision, null, t.data_length, t.data_precision)\n").append("  AS column_size,\n").append("  0 AS buffer_length,\n").append("  t.data_scale AS decimal_digits,\n").append("       1 AS pseudo_column\n").append("FROM all_tab_columns t, all_ind_columns i\n").append("WHERE :2 = 1\n").append("  AND t.table_name = :3\n").append("  AND t.owner like :4 escape '/'\n").append("  AND t.nullable != :5\n").append("  AND t.owner = i.table_owner\n").append("  AND t.table_name = i.table_name\n").append("  AND t.column_name = i.column_name\n").toString());
/*      */ 
/* 4082 */     switch (paramInt)
/*      */     {
/*      */     case 0:
/* 4086 */       localPreparedStatement.setInt(1, 0);
/* 4087 */       localPreparedStatement.setInt(2, 0);
/*      */ 
/* 4089 */       break;
/*      */     case 1:
/* 4092 */       localPreparedStatement.setInt(1, 1);
/* 4093 */       localPreparedStatement.setInt(2, 1);
/*      */ 
/* 4095 */       break;
/*      */     case 2:
/* 4098 */       localPreparedStatement.setInt(1, 0);
/* 4099 */       localPreparedStatement.setInt(2, 1);
/*      */     }
/*      */ 
/* 4104 */     localPreparedStatement.setString(3, paramString3);
/* 4105 */     localPreparedStatement.setString(4, paramString2 == null ? "%" : paramString2);
/* 4106 */     localPreparedStatement.setString(5, paramBoolean ? "X" : "Y");
/*      */ 
/* 4108 */     OracleResultSet localOracleResultSet = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 4111 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 4113 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   public synchronized ResultSet getVersionColumns(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 4186 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement(new StringBuilder().append("SELECT 0 AS scope,\n t.column_name,\n DECODE (c.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n  'LONG', -1, 'DATE',  ").append(this.connection.getMapDateToTimestamp() ? "93,\n" : "91,\n").append("  'RAW', -3, 'LONG RAW', -4, ").append("  'TIMESTAMP(6)', 93, 'TIMESTAMP(6) WITH TIME ZONE', -101, \n").append("  'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, \n").append("  'INTERVAL YEAR(2) TO MONTH', -103, \n").append("  'INTERVAL DAY(2) TO SECOND(6)', -104, \n").append("  'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101,").append("   1111)\n ").append(" AS data_type,\n").append("       c.data_type AS type_name,\n").append(" DECODE (c.data_precision, null, c.data_length, c.data_precision)\n").append("   AS column_size,\n").append("       0 as buffer_length,\n").append("   c.data_scale as decimal_digits,\n").append("   0 as pseudo_column\n").append("FROM all_trigger_cols t, all_tab_columns c\n").append("WHERE t.table_name = :1\n").append("  AND c.owner like :2 escape '/'\n").append(" AND t.table_owner = c.owner\n").append("  AND t.table_name = c.table_name\n").append(" AND t.column_name = c.column_name\n").toString());
/*      */ 
/* 4209 */     localPreparedStatement.setString(1, paramString3);
/* 4210 */     localPreparedStatement.setString(2, paramString2 == null ? "%" : paramString2);
/*      */ 
/* 4212 */     OracleResultSet localOracleResultSet = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 4215 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 4217 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   public ResultSet getPrimaryKeys(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 4267 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       c.owner AS table_schem,\n       c.table_name,\n       c.column_name,\n       c.position AS key_seq,\n       c.constraint_name AS pk_name\nFROM all_cons_columns c, all_constraints k\nWHERE k.constraint_type = 'P'\n  AND k.table_name = :1\n  AND k.owner like :2 escape '/'\n  AND k.constraint_name = c.constraint_name \n  AND k.table_name = c.table_name \n  AND k.owner = c.owner \nORDER BY column_name\n");
/*      */ 
/* 4278 */     localPreparedStatement.setString(1, paramString3);
/* 4279 */     localPreparedStatement.setString(2, paramString2 == null ? "%" : paramString2);
/*      */ 
/* 4281 */     OracleResultSet localOracleResultSet = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 4284 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 4286 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   ResultSet keys_query(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5)
/*      */     throws SQLException
/*      */   {
/* 4304 */     int i = 1;
/* 4305 */     int j = paramString2 != null ? i++ : 0;
/* 4306 */     int k = paramString4 != null ? i++ : 0;
/* 4307 */     int m = (paramString1 != null) && (paramString1.length() > 0) ? i++ : 0;
/* 4308 */     int n = (paramString3 != null) && (paramString3.length() > 0) ? i++ : 0;
/*      */ 
/* 4311 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement(new StringBuilder().append("SELECT NULL AS pktable_cat,\n       p.owner as pktable_schem,\n       p.table_name as pktable_name,\n       pc.column_name as pkcolumn_name,\n       NULL as fktable_cat,\n       f.owner as fktable_schem,\n       f.table_name as fktable_name,\n       fc.column_name as fkcolumn_name,\n       fc.position as key_seq,\n       NULL as update_rule,\n       decode (f.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 1) as delete_rule,\n       f.constraint_name as fk_name,\n       p.constraint_name as pk_name,\n       decode(f.deferrable,       'DEFERRABLE',5      ,'NOT DEFERRABLE',7      , 'DEFERRED', 6      ) deferrability \n      FROM all_cons_columns pc, all_constraints p,\n      all_cons_columns fc, all_constraints f\nWHERE 1 = 1\n").append(j != 0 ? "  AND p.table_name = :1\n" : "").append(k != 0 ? "  AND f.table_name = :2\n" : "").append(m != 0 ? "  AND p.owner = :3\n" : "").append(n != 0 ? "  AND f.owner = :4\n" : "").append("  AND f.constraint_type = 'R'\n").append("  AND p.owner = f.r_owner\n").append("  AND p.constraint_name = f.r_constraint_name\n").append("  AND p.constraint_type = 'P'\n").append("  AND pc.owner = p.owner\n").append("  AND pc.constraint_name = p.constraint_name\n").append("  AND pc.table_name = p.table_name\n").append("  AND fc.owner = f.owner\n").append("  AND fc.constraint_name = f.constraint_name\n").append("  AND fc.table_name = f.table_name\n").append("  AND fc.position = pc.position\n").append(paramString5).toString());
/*      */ 
/* 4341 */     if (j != 0)
/*      */     {
/* 4343 */       localPreparedStatement.setString(j, paramString2);
/*      */     }
/*      */ 
/* 4346 */     if (k != 0)
/*      */     {
/* 4348 */       localPreparedStatement.setString(k, paramString4);
/*      */     }
/*      */ 
/* 4351 */     if (m != 0)
/*      */     {
/* 4353 */       localPreparedStatement.setString(m, paramString1);
/*      */     }
/*      */ 
/* 4356 */     if (n != 0)
/*      */     {
/* 4358 */       localPreparedStatement.setString(n, paramString3);
/*      */     }
/*      */ 
/* 4361 */     OracleResultSet localOracleResultSet = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 4364 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 4366 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   public synchronized ResultSet getImportedKeys(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 4433 */     return keys_query(null, null, paramString2, paramString3, "ORDER BY pktable_schem, pktable_name, key_seq");
/*      */   }
/*      */ 
/*      */   public ResultSet getExportedKeys(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 4520 */     return keys_query(paramString2, paramString3, null, null, "ORDER BY fktable_schem, fktable_name, key_seq");
/*      */   }
/*      */ 
/*      */   public ResultSet getCrossReference(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6)
/*      */     throws SQLException
/*      */   {
/* 4599 */     return keys_query(paramString2, paramString3, paramString5, paramString6, "ORDER BY fktable_schem, fktable_name, key_seq");
/*      */   }
/*      */ 
/*      */   public ResultSet getTypeInfo()
/*      */     throws SQLException
/*      */   {
/* 4659 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 4660 */     localSQLException.fillInStackTrace();
/* 4661 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public synchronized ResultSet getIndexInfo(String paramString1, String paramString2, String paramString3, boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/* 4764 */     Statement localStatement = this.connection.createStatement();
/*      */ 
/* 4772 */     if (((paramString2 != null) && (paramString2.length() != 0) && (!OracleSql.isValidObjectName(paramString2))) || ((paramString3 != null) && (paramString3.length() != 0) && (!OracleSql.isValidObjectName(paramString3))))
/*      */     {
/* 4780 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 4781 */       ((SQLException)localObject).fillInStackTrace();
/* 4782 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 4787 */     if (!paramBoolean2)
/*      */     {
/* 4789 */       localObject = new StringBuilder().append("analyze table ").append(paramString2 == null ? "" : new StringBuilder().append(paramString2).append(".").toString()).append(paramString3).append(" compute statistics").toString();
/*      */ 
/* 4793 */       localStatement.executeUpdate((String)localObject);
/*      */     }
/*      */ 
/* 4796 */     if ((paramString3.startsWith("\"")) && (paramString3.endsWith("\"")) && (paramString3.length() > 2))
/*      */     {
/* 4800 */       paramString3 = paramString3.substring(1, paramString3.length() - 1);
/*      */     }
/*      */ 
/* 4804 */     Object localObject = new StringBuilder().append("select null as table_cat,\n       owner as table_schem,\n       table_name,\n       0 as NON_UNIQUE,\n       null as index_qualifier,\n       null as index_name, 0 as type,\n       0 as ordinal_position, null as column_name,\n       null as asc_or_desc,\n       num_rows as cardinality,\n       blocks as pages,\n       null as filter_condition\nfrom all_tables\nwhere table_name = '").append(paramString3).append("'\n").toString();
/*      */ 
/* 4814 */     String str1 = "";
/*      */ 
/* 4816 */     if ((paramString2 != null) && (paramString2.length() > 0))
/*      */     {
/* 4818 */       if ((paramString2.startsWith("\"")) && (paramString2.endsWith("\"")) && (paramString2.length() > 2))
/*      */       {
/* 4822 */         paramString2 = paramString2.substring(1, paramString2.length() - 1);
/*      */       }
/*      */ 
/* 4825 */       str1 = new StringBuilder().append("  and owner = '").append(paramString2).append("'\n").toString();
/*      */     }
/*      */ 
/* 4829 */     String str2 = new StringBuilder().append("select null as table_cat,\n       i.owner as table_schem,\n       i.table_name,\n       decode (i.uniqueness, 'UNIQUE', 0, 1),\n       null as index_qualifier,\n       i.index_name,\n       1 as type,\n       c.column_position as ordinal_position,\n       c.column_name,\n       null as asc_or_desc,\n       i.distinct_keys as cardinality,\n       i.leaf_blocks as pages,\n       null as filter_condition\nfrom all_indexes i, all_ind_columns c\nwhere i.table_name = '").append(paramString3).append("'\n").toString();
/*      */ 
/* 4844 */     String str3 = "";
/*      */ 
/* 4846 */     if ((paramString2 != null) && (paramString2.length() > 0)) {
/* 4847 */       str3 = new StringBuilder().append("  and i.owner = '").append(paramString2).append("'\n").toString();
/*      */     }
/* 4849 */     String str4 = "";
/*      */ 
/* 4851 */     if (paramBoolean1) {
/* 4852 */       str4 = "  and i.uniqueness = 'UNIQUE'\n";
/*      */     }
/* 4854 */     String str5 = "  and i.index_name = c.index_name\n  and i.table_owner = c.table_owner\n  and i.table_name = c.table_name\n  and i.owner = c.index_owner\n";
/*      */ 
/* 4859 */     String str6 = "order by non_unique, type, index_name, ordinal_position\n";
/*      */ 
/* 4862 */     String str7 = new StringBuilder().append((String)localObject).append(str1).append("union\n").append(str2).append(str3).append(str4).append(str5).append(str6).toString();
/*      */ 
/* 4866 */     OracleResultSet localOracleResultSet = (OracleResultSet)localStatement.executeQuery(str7);
/*      */ 
/* 4869 */     localOracleResultSet.closeStatementOnClose();
/*      */ 
/* 4871 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   SQLException fail()
/*      */   {
/* 4904 */     SQLException localSQLException = new SQLException("Not implemented yet");
/*      */ 
/* 4906 */     return localSQLException;
/*      */   }
/*      */ 
/*      */   public boolean supportsResultSetType(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4934 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsResultSetConcurrency(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 4961 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean ownUpdatesAreVisible(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4985 */     return paramInt != 1003;
/*      */   }
/*      */ 
/*      */   public boolean ownDeletesAreVisible(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5009 */     return paramInt != 1003;
/*      */   }
/*      */ 
/*      */   public boolean ownInsertsAreVisible(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5033 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean othersUpdatesAreVisible(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5057 */     if (paramInt == 1005) {
/* 5058 */       return true;
/*      */     }
/* 5060 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean othersDeletesAreVisible(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5086 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean othersInsertsAreVisible(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5112 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean updatesAreDetected(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5138 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean deletesAreDetected(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5163 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean insertsAreDetected(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5189 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsBatchUpdates()
/*      */     throws SQLException
/*      */   {
/* 5213 */     return true;
/*      */   }
/*      */ 
/*      */   public ResultSet getUDTs(String paramString1, String paramString2, String paramString3, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 5267 */     int i = 0;
/*      */ 
/* 5269 */     if ((paramString3 == null) || (paramString3.length() == 0))
/*      */     {
/* 5271 */       i = 0;
/*      */     }
/* 5275 */     else if (paramArrayOfInt == null)
/*      */     {
/* 5277 */       i = 1;
/*      */     }
/*      */     else
/*      */     {
/* 5281 */       for (int j = 0; j < paramArrayOfInt.length; j++)
/*      */       {
/* 5283 */         if (paramArrayOfInt[j] == 2002)
/*      */         {
/* 5285 */           i = 1;
/*      */ 
/* 5287 */           break;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5294 */     StringBuffer localStringBuffer = new StringBuffer();
/*      */ 
/* 5296 */     localStringBuffer.append("SELECT NULL AS TYPE_CAT, owner AS TYPE_SCHEM, type_name, NULL AS CLASS_NAME, 'STRUCT' AS DATA_TYPE, NULL AS REMARKS FROM all_types ");
/*      */ 
/* 5298 */     if (i != 0)
/*      */     {
/* 5300 */       localStringBuffer.append("WHERE typecode = 'OBJECT' AND owner LIKE :1 ESCAPE '/' AND type_name LIKE :2 ESCAPE '/'");
/*      */     }
/*      */     else
/*      */     {
/* 5304 */       localStringBuffer.append("WHERE 1 = 2");
/*      */     }
/*      */ 
/* 5308 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement(localStringBuffer.substring(0, localStringBuffer.length()));
/*      */ 
/* 5311 */     if (i != 0)
/*      */     {
/* 5316 */       localObject = new String[1];
/* 5317 */       String[] arrayOfString = new String[1];
/*      */ 
/* 5319 */       if (SQLName.parse(paramString3, (String[])localObject, arrayOfString))
/*      */       {
/* 5321 */         localPreparedStatement.setString(1, localObject[0]);
/* 5322 */         localPreparedStatement.setString(2, arrayOfString[0]);
/*      */       }
/*      */       else
/*      */       {
/* 5326 */         if (paramString2 != null)
/* 5327 */           localPreparedStatement.setString(1, paramString2);
/*      */         else {
/* 5329 */           localPreparedStatement.setNull(1, 12);
/*      */         }
/* 5331 */         localPreparedStatement.setString(2, paramString3);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5336 */     Object localObject = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 5339 */     ((OracleResultSet)localObject).closeStatementOnClose();
/*      */ 
/* 5341 */     return localObject;
/*      */   }
/*      */ 
/*      */   public Connection getConnection()
/*      */     throws SQLException
/*      */   {
/* 5361 */     return this.connection.getWrapper();
/*      */   }
/*      */ 
/*      */   public boolean supportsSavepoints()
/*      */     throws SQLException
/*      */   {
/* 5386 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsNamedParameters()
/*      */     throws SQLException
/*      */   {
/* 5409 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsMultipleOpenResults()
/*      */     throws SQLException
/*      */   {
/* 5434 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean supportsGetGeneratedKeys()
/*      */     throws SQLException
/*      */   {
/* 5457 */     return true;
/*      */   }
/*      */ 
/*      */   public ResultSet getSuperTypes(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 5513 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 5514 */     localSQLException.fillInStackTrace();
/* 5515 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public ResultSet getSuperTables(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 5565 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 5566 */     localSQLException.fillInStackTrace();
/* 5567 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public ResultSet getAttributes(String paramString1, String paramString2, String paramString3, String paramString4)
/*      */     throws SQLException
/*      */   {
/* 5689 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 5690 */     localSQLException.fillInStackTrace();
/* 5691 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public boolean supportsResultSetHoldability(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5722 */     if (paramInt == 1) {
/* 5723 */       return true;
/*      */     }
/* 5725 */     return false;
/*      */   }
/*      */ 
/*      */   public int getResultSetHoldability()
/*      */     throws SQLException
/*      */   {
/* 5753 */     return 1;
/*      */   }
/*      */ 
/*      */   public int getDatabaseMajorVersion()
/*      */     throws SQLException
/*      */   {
/* 5774 */     return this.connection.getVersionNumber() / 1000;
/*      */   }
/*      */ 
/*      */   public int getDatabaseMinorVersion()
/*      */     throws SQLException
/*      */   {
/* 5795 */     return this.connection.getVersionNumber() % 1000 / 100;
/*      */   }
/*      */ 
/*      */   public int getJDBCMajorVersion()
/*      */     throws SQLException
/*      */   {
/* 5817 */     return DRIVER_API_MAJOR_VERSION;
/*      */   }
/*      */ 
/*      */   public int getJDBCMinorVersion()
/*      */     throws SQLException
/*      */   {
/* 5840 */     return DRIVER_API_MINOR_VERSION;
/*      */   }
/*      */ 
/*      */   public int getSQLStateType()
/*      */     throws SQLException
/*      */   {
/* 5886 */     return 0;
/*      */   }
/*      */ 
/*      */   public boolean locatorsUpdateCopy()
/*      */     throws SQLException
/*      */   {
/* 5903 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean supportsStatementPooling()
/*      */     throws SQLException
/*      */   {
/* 5920 */     return true;
/*      */   }
/*      */ 
/*      */   public static String getDriverNameInfo()
/*      */     throws SQLException
/*      */   {
/* 5938 */     return DRIVER_NAME;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static String getDriverVersionInfo()
/*      */     throws SQLException
/*      */   {
/* 5952 */     return DRIVER_VERSION;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static int getDriverMajorVersionInfo()
/*      */   {
/* 5965 */     return DRIVER_MAJOR_VERSION;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static int getDriverMinorVersionInfo()
/*      */   {
/* 5978 */     return DRIVER_MINOR_VERSION;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static String getLobPrecision()
/*      */     throws SQLException
/*      */   {
/* 5991 */     return "-1";
/*      */   }
/*      */ 
/*      */   public long getLobMaxLength()
/*      */     throws SQLException
/*      */   {
/* 6011 */     return this.connection.getVersionNumber() >= 10000 ? 9223372036854775807L : LOB_MAXLENGTH_32BIT;
/*      */   }
/*      */ 
/*      */   public RowIdLifetime getRowIdLifetime()
/*      */     throws SQLException
/*      */   {
/* 6031 */     return RowIdLifetime.ROWID_VALID_FOREVER;
/*      */   }
/*      */ 
/*      */   public ResultSet getSchemas(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 6063 */     if (paramString2 == null) {
/* 6064 */       return getSchemas();
/*      */     }
/*      */ 
/* 6067 */     String str = "SELECT username AS table_schem, null as table_catalog FROM all_users WHERE username LIKE ? ORDER BY table_schem";
/*      */ 
/* 6072 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement(str);
/* 6073 */     localPreparedStatement.setString(1, paramString2);
/* 6074 */     OracleResultSet localOracleResultSet = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 6076 */     localOracleResultSet.closeStatementOnClose();
/* 6077 */     return localOracleResultSet;
/*      */   }
/*      */ 
/*      */   public boolean supportsStoredFunctionsUsingCallSyntax()
/*      */     throws SQLException
/*      */   {
/* 6098 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean autoCommitFailureClosesAllResultSets()
/*      */     throws SQLException
/*      */   {
/* 6116 */     return false;
/*      */   }
/*      */ 
/*      */   public ResultSet getClientInfoProperties()
/*      */     throws SQLException
/*      */   {
/* 6122 */     Statement localStatement = this.connection.createStatement();
/* 6123 */     return localStatement.executeQuery("select NULL NAME, -1 MAX_LEN, NULL DEFAULT_VALUE, NULL DESCRIPTION  from dual where 0 = 1");
/*      */   }
/*      */ 
/*      */   public ResultSet getFunctions(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 6149 */     String str1 = "SELECT\n  -- Standalone functions\n  NULL AS function_cat,\n  owner AS function_schem,\n  object_name AS function_name,\n  'Standalone function' AS remarks,\n  0 AS function_type,\n  NULL AS specific_name\nFROM all_objects\nWHERE object_type = 'FUNCTION'\n  AND owner LIKE :1 ESCAPE '/'\n  AND object_name LIKE :2 ESCAPE '/'\n";
/*      */ 
/* 6163 */     String str2 = "SELECT\n  -- Packaged functions\n  package_name AS function_cat,\n  owner AS function_schem,\n  object_name AS function_name,\n  'Packaged function' AS remarks,\n  decode (data_type, 'TABLE', 2, 'PL/SQL TABLE', 2, 1) AS function_type,\n  NULL AS specific_name\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND in_out = 'OUT'\n  AND data_level = 0\n";
/*      */ 
/* 6179 */     String str3 = "  AND package_name LIKE :3 ESCAPE '/'\n  AND owner LIKE :4 ESCAPE '/'\n  AND object_name LIKE :5 ESCAPE '/'\n";
/*      */ 
/* 6183 */     String str4 = "  AND package_name IS NOT NULL\n  AND owner LIKE :6 ESCAPE '/'\n  AND object_name LIKE :7 ESCAPE '/'\n";
/*      */ 
/* 6189 */     String str5 = "ORDER BY function_schem, function_name\n";
/*      */ 
/* 6191 */     PreparedStatement localPreparedStatement = null;
/* 6192 */     String str6 = null;
/*      */ 
/* 6195 */     String str7 = paramString2;
/*      */ 
/* 6197 */     if (paramString2 == null)
/* 6198 */       str7 = "%";
/* 6199 */     else if (paramString2.equals("")) {
/* 6200 */       str7 = getUserName().toUpperCase();
/*      */     }
/* 6202 */     String str8 = paramString3;
/*      */ 
/* 6204 */     if (paramString3 == null) {
/* 6205 */       str8 = "%";
/* 6206 */     } else if (paramString3.equals(""))
/*      */     {
/* 6208 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 74);
/* 6209 */       ((SQLException)localObject).fillInStackTrace();
/* 6210 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 6213 */     if (paramString1 == null)
/*      */     {
/* 6218 */       str6 = new StringBuilder().append(str1).append("UNION ALL ").append(str2).append(str4).append(str5).toString();
/*      */ 
/* 6222 */       localPreparedStatement = this.connection.prepareStatement(str6);
/*      */ 
/* 6224 */       localPreparedStatement.setString(1, str7);
/* 6225 */       localPreparedStatement.setString(2, str8);
/* 6226 */       localPreparedStatement.setString(3, str7);
/* 6227 */       localPreparedStatement.setString(4, str8);
/*      */     }
/* 6229 */     else if (paramString1.equals(""))
/*      */     {
/* 6234 */       str6 = str1;
/*      */ 
/* 6236 */       localPreparedStatement = this.connection.prepareStatement(str6);
/*      */ 
/* 6238 */       localPreparedStatement.setString(1, str7);
/* 6239 */       localPreparedStatement.setString(2, str8);
/*      */     }
/*      */     else
/*      */     {
/* 6245 */       str6 = new StringBuilder().append(str2).append(str3).append(str5).toString();
/*      */ 
/* 6247 */       localPreparedStatement = this.connection.prepareStatement(str6);
/*      */ 
/* 6249 */       localPreparedStatement.setString(1, str7);
/* 6250 */       localPreparedStatement.setString(2, str7);
/* 6251 */       localPreparedStatement.setString(3, str8);
/*      */     }
/*      */ 
/* 6255 */     Object localObject = (OracleResultSet)localPreparedStatement.executeQuery();
/*      */ 
/* 6258 */     ((OracleResultSet)localObject).closeStatementOnClose();
/*      */ 
/* 6260 */     return localObject;
/*      */   }
/*      */ 
/*      */   public boolean isWrapperFor(Class<?> paramClass)
/*      */     throws SQLException
/*      */   {
/* 6280 */     if (paramClass.isInterface()) return paramClass.isInstance(this);
/*      */ 
/* 6282 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 6283 */     localSQLException.fillInStackTrace();
/* 6284 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public <T> T unwrap(Class<T> paramClass)
/*      */     throws SQLException
/*      */   {
/* 6306 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this))) return this;
/*      */ 
/* 6308 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 6309 */     localSQLException.fillInStackTrace();
/* 6310 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 6326 */     return this.connection;
/*      */   }
/*      */ 
/*      */   protected boolean hasSqlWildcard(String paramString)
/*      */   {
/* 6338 */     if (sqlWildcardPattern == null)
/* 6339 */       sqlWildcardPattern = Pattern.compile("^%|^_|[^/]%|[^/]_");
/* 6340 */     Matcher localMatcher = sqlWildcardPattern.matcher(paramString);
/* 6341 */     return localMatcher.find();
/*      */   }
/*      */ 
/*      */   protected String stripSqlEscapes(String paramString)
/*      */   {
/* 6348 */     if (sqlEscapePattern == null)
/* 6349 */       sqlEscapePattern = Pattern.compile("/");
/* 6350 */     Matcher localMatcher = sqlEscapePattern.matcher(paramString);
/* 6351 */     StringBuffer localStringBuffer = new StringBuffer();
/* 6352 */     while (localMatcher.find())
/*      */     {
/* 6354 */       localMatcher.appendReplacement(localStringBuffer, "");
/*      */     }
/* 6356 */     localMatcher.appendTail(localStringBuffer);
/* 6357 */     return localStringBuffer.toString();
/*      */   }
/*      */ 
/*      */   String getUnpackagedProcedureColumnsNoWildcardsPlsql()
/*      */     throws SQLException
/*      */   {
/* 6363 */     String str1 = "declare\n  in_owner varchar2(32) := null;\n  in_name varchar2(32) := null;\n  my_user_name varchar2(32) := null;\n  cnt number := 0;\n  temp_owner varchar2(32) := null;\n  temp_name  varchar2(32):= null;\n  out_owner varchar2(32) := null;\n  out_name  varchar2(32):= null;\n  loc varchar2(32) := null;\n  status number := 0;\n  TYPE recursion_check_type is table of number index by varchar2(65);\n  recursion_check recursion_check_type;\n  dotted_name varchar2(65);\n  recursion_cnt number := 0;\n  xxx SYS_REFCURSOR;\nbegin\n  in_owner := ?;\n  in_name := ?;\n  select user into my_user_name from dual;\n  if( my_user_name = in_owner ) then\n    select count(*) into cnt from user_procedures where object_name = in_name;\n    if( cnt = 1 ) then\n      out_owner := in_owner;\n      out_name := in_name;\n      loc := 'USER_PROCEDURES';\n    end if;\n  else\n    select count(*) into cnt from all_arguments where owner = in_owner and object_name = in_name;\n    if( cnt = 1 ) then\n      out_owner := in_owner;\n      out_name := in_name;\n      loc := 'ALL_ARGUMENTS';\n    end if;\n  end if;\n  if loc is null then\n    temp_owner := in_owner;\n    temp_name := in_name;\n    loop\n      begin\n        dotted_name := temp_owner || '.' ||temp_name;\n        begin\n          recursion_cnt := recursion_check(dotted_name );\n          status := -1;\n          exit;\n        exception\n        when NO_DATA_FOUND then\n          recursion_check( dotted_name ) := 1;\n        end;\n        select table_owner, table_name into out_owner, out_name from all_synonyms \n          where  owner = temp_owner and synonym_name = temp_name;\n        cnt := cnt + 1;\n        temp_owner  := out_owner;\n        temp_name := out_name;\n        exception\n        when NO_DATA_FOUND then\n          exit;\n        end;\n      end loop;\n      if( not(out_owner is null) ) then\n        loc := 'ALL_SYNONYMS';\n    end if;\n  end if;\n";
/*      */ 
/* 6428 */     int i = this.connection.getVersionNumber();
/* 6429 */     String str2 = "if( status = 0 ) then \n open xxx for \n";
/*      */ 
/* 6431 */     String str3 = new StringBuilder().append("SELECT package_name AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       argument_name AS column_name,\n       DECODE(position, 0, 5,\n                        DECODE(in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n       DECODE (data_type, 'CHAR', 1,\n                          'VARCHAR2', 12,\n                          'NUMBER', 3,\n                          'LONG', -1,\n                          'DATE', ").append(this.connection.getMapDateToTimestamp() ? "93,\n" : "91,\n").append("                          'RAW', -3,\n").append("                          'LONG RAW', -4,\n").append("                          'TIMESTAMP', 93, \n").append("                          'TIMESTAMP WITH TIME ZONE', -101, \n").append("               'TIMESTAMP WITH LOCAL TIME ZONE', -102, \n").append("               'INTERVAL YEAR TO MONTH', -103, \n").append("               'INTERVAL DAY TO SECOND', -104, \n").append("               'BINARY_FLOAT', 100, 'BINAvRY_DOUBLE', 101,").append("               1111) AS data_type,\n").append("       DECODE(data_type, 'OBJECT', type_owner || '.' || type_name, ").append("              data_type) AS type_name,\n").append("       DECODE (data_precision, NULL, data_length,\n").append("                               data_precision) AS precision,\n").append("       data_length AS length,\n").append("       data_scale AS scale,\n").append("       10 AS radix,\n").append("       1 AS nullable,\n").append("       NULL AS remarks,\n").append("       default_value AS column_def,\n").append("       NULL as sql_data_type,\n").append("       NULL AS sql_datetime_sub,\n").append("       DECODE(data_type,\n").append("                         'CHAR', 32767,\n").append("                         'VARCHAR2', 32767,\n").append("                         'LONG', 32767,\n").append("                         'RAW', 32767,\n").append("                         'LONG RAW', 32767,\n").append("                         NULL) AS char_octet_length,\n").append("       (sequence - 1) AS ordinal_position,\n").append("       'YES' AS is_nullable,\n").append("       NULL AS specific_name,\n").append("       sequence,\n").append("       overload,\n").append("       default_value\n").toString();
/*      */ 
/* 6484 */     String str4 = "FROM all_arguments a";
/*      */ 
/* 6486 */     String str5 = "WHERE a.owner = out_owner \n  AND a.object_name = out_name\n AND a.argument_name LIKE ? ESCAPE '/'\n AND data_level = 0\n AND package_name is null\n";
/*      */ 
/* 6491 */     String str6 = "ORDER BY procedure_schem, procedure_name, overload, sequence\n";
/*      */ 
/* 6497 */     String str7 = str2;
/* 6498 */     str7 = new StringBuilder().append(str7).append(str3).toString();
/*      */ 
/* 6500 */     str7 = new StringBuilder().append(str7).append(str4).toString();
/*      */ 
/* 6502 */     str7 = new StringBuilder().append(str7).append("\n").append(str5).toString();
/*      */ 
/* 6504 */     str7 = new StringBuilder().append(str7).append("\n").append(str6).toString();
/*      */ 
/* 6506 */     String str8 = "; \n end if;\n  ? := xxx; ? := status;\n end;";
/*      */ 
/* 6508 */     String str9 = new StringBuilder().append(str1).append(str7).append(str8).toString();
/* 6509 */     return str9;
/*      */   }
/*      */ 
/*      */   String getPackagedProcedureColumnsNoWildcardsPlsql()
/*      */     throws SQLException
/*      */   {
/* 6515 */     String str1 = "declare\n  in_package_name varchar2(32) := null;\n  in_owner varchar2(32) := null;\n  in_name varchar2(32) := null;\n  my_user_name varchar2(32) := null;\n  cnt number := 0;\n  temp_package_name varchar2(32) := null;\n  temp_owner varchar2(32) := null;\n  out_package_name varchar2(32) := null;\n  out_owner varchar2(32) := null;\n  loc varchar2(32) := null;\n  status number := 0;\n  TYPE recursion_check_type is table of number index by varchar2(65);\n  recursion_check recursion_check_type;\n  dotted_name varchar2(65);\n  recursion_cnt number := 0;\n  xxx SYS_REFCURSOR;\nbegin\n  in_package_name := ?;\n  in_owner := ?;\n  in_name := ?;\n  select user into my_user_name from dual;\n  if( my_user_name = in_owner ) then\n    select count(*) into cnt from user_arguments where package_name = in_package_name;\n    if( cnt >= 1 ) then\n      out_owner := in_owner;\n      out_package_name := in_package_name;\n      loc := 'USER_ARGUMENTS';\n    end if;\n  else\n    select count(*) into cnt from all_arguments where owner = in_owner and package_name = in_package_name;\n    if( cnt >= 1 ) then\n      out_owner := in_owner;\n      out_package_name := in_package_name;\n      loc := 'ALL_ARGUMENTS';\n    end if;\n  end if;\n  if loc is null then\n  temp_owner := in_owner;\n  temp_package_name := in_package_name;\n  loop\n    begin\n      dotted_name := temp_owner || '.' ||temp_package_name;\n      begin\n        recursion_cnt := recursion_check(dotted_name );\n        status := -1;\n        exit;\n      exception\n      when NO_DATA_FOUND then\n        recursion_check( dotted_name ) := 1;\n      end;\n      select table_owner, table_name into out_owner, out_package_name from all_synonyms \n        where  owner = temp_owner and synonym_name = temp_package_name;\n      cnt := cnt + 1;\n      temp_owner  := out_owner;\n      temp_package_name := out_package_name;\n      exception\n      when NO_DATA_FOUND then\n        exit;\n      end;\n    end loop;\n    if( not(out_owner is null) ) then\n      loc := 'ALL_SYNONYMS';\n    end if;\n  end if;\n";
/*      */ 
/* 6583 */     int i = this.connection.getVersionNumber();
/* 6584 */     String str2 = "if( status = 0 ) then \n open xxx for \n";
/*      */ 
/* 6586 */     String str3 = new StringBuilder().append("SELECT package_name AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       argument_name AS column_name,\n       DECODE(position, 0, 5,\n                        DECODE(in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n       DECODE (data_type, 'CHAR', 1,\n                          'VARCHAR2', 12,\n                          'NUMBER', 3,\n                          'LONG', -1,\n                          'DATE', ").append(this.connection.getMapDateToTimestamp() ? "93,\n" : "91,\n").append("                          'RAW', -3,\n").append("                          'LONG RAW', -4,\n").append("                          'TIMESTAMP', 93, \n").append("                          'TIMESTAMP WITH TIME ZONE', -101, \n").append("               'TIMESTAMP WITH LOCAL TIME ZONE', -102, \n").append("               'INTERVAL YEAR TO MONTH', -103, \n").append("               'INTERVAL DAY TO SECOND', -104, \n").append("               'BINARY_FLOAT', 100, 'BINAvRY_DOUBLE', 101,").append("               1111) AS data_type,\n").append("       DECODE(data_type, 'OBJECT', type_owner || '.' || type_name, ").append("              data_type) AS type_name,\n").append("       DECODE (data_precision, NULL, data_length,\n").append("                               data_precision) AS precision,\n").append("       data_length AS length,\n").append("       data_scale AS scale,\n").append("       10 AS radix,\n").append("       1 AS nullable,\n").append("       NULL AS remarks,\n").append("       default_value AS column_def,\n").append("       NULL as sql_data_type,\n").append("       NULL AS sql_datetime_sub,\n").append("       DECODE(data_type,\n").append("                         'CHAR', 32767,\n").append("                         'VARCHAR2', 32767,\n").append("                         'LONG', 32767,\n").append("                         'RAW', 32767,\n").append("                         'LONG RAW', 32767,\n").append("                         NULL) AS char_octet_length,\n").append("       (sequence - 1) AS ordinal_position,\n").append("       'YES' AS is_nullable,\n").append("       NULL AS specific_name,\n").append("       sequence,\n").append("       overload,\n").append("       default_value\n").toString();
/*      */ 
/* 6639 */     String str4 = "FROM all_arguments a";
/*      */ 
/* 6641 */     String str5 = "WHERE a.owner = out_owner \n  AND a.object_name LIKE in_name ESCAPE '/' \n AND a.argument_name LIKE ? ESCAPE '/' \n AND data_level = 0\n AND package_name = out_package_name\n";
/*      */ 
/* 6646 */     String str6 = "ORDER BY procedure_schem, procedure_name, overload, sequence\n";
/*      */ 
/* 6652 */     String str7 = str2;
/* 6653 */     str7 = new StringBuilder().append(str7).append(str3).toString();
/*      */ 
/* 6655 */     str7 = new StringBuilder().append(str7).append(str4).toString();
/*      */ 
/* 6657 */     str7 = new StringBuilder().append(str7).append("\n").append(str5).toString();
/*      */ 
/* 6659 */     str7 = new StringBuilder().append(str7).append("\n").append(str6).toString();
/*      */ 
/* 6661 */     String str8 = "; \n end if;\n  ? := xxx; ? := status;\n end;";
/*      */ 
/* 6663 */     String str9 = new StringBuilder().append(str1).append(str7).append(str8).toString();
/* 6664 */     return str9;
/*      */   }
/*      */ 
/*      */   public OracleTypeMetaData getOracleTypeMetaData(String paramString)
/*      */     throws SQLException
/*      */   {
/* 6676 */     return TypeDescriptor.getTypeDescriptor(paramString, this.connection);
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.OracleDatabaseMetaData
 * JD-Core Version:    0.6.2
 */