/*     */ package oracle.core.lmx;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ 
/*     */ public class LmxRepConversion
/*     */ {
/*     */   public static void printInHex(byte paramByte)
/*     */   {
/*  26 */     System.out.print((char)nibbleToHex((byte)((paramByte & 0xF0) >> 4)));
/*  27 */     System.out.print((char)nibbleToHex((byte)(paramByte & 0xF)));
/*     */   }
/*     */ 
/*     */   public static byte nibbleToHex(byte paramByte)
/*     */   {
/*  41 */     paramByte = (byte)(paramByte & 0xF);
/*  42 */     return (byte)(paramByte < 10 ? paramByte + 48 : paramByte - 10 + 65);
/*     */   }
/*     */ 
/*     */   public static byte asciiHexToNibble(byte paramByte)
/*     */   {
/*     */     byte b;
/*  62 */     if ((paramByte >= 97) && (paramByte <= 102)) {
/*  63 */       b = (byte)(paramByte - 97 + 10);
/*     */     }
/*  65 */     else if ((paramByte >= 65) && (paramByte <= 70)) {
/*  66 */       b = (byte)(paramByte - 65 + 10);
/*     */     }
/*  68 */     else if ((paramByte >= 48) && (paramByte <= 57)) {
/*  69 */       b = (byte)(paramByte - 48);
/*     */     }
/*     */     else {
/*  72 */       b = paramByte;
/*     */     }
/*  74 */     return b;
/*     */   }
/*     */ 
/*     */   public static void bArray2nibbles(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*     */   {
/*  86 */     for (int i = 0; i < paramArrayOfByte1.length; i++)
/*     */     {
/*  88 */       paramArrayOfByte2[(i * 2)] = nibbleToHex((byte)((paramArrayOfByte1[i] & 0xF0) >> 4));
/*  89 */       paramArrayOfByte2[(i * 2 + 1)] = nibbleToHex((byte)(paramArrayOfByte1[i] & 0xF));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String bArray2String(byte[] paramArrayOfByte)
/*     */   {
/* 102 */     StringBuffer localStringBuffer = new StringBuffer(paramArrayOfByte.length * 2);
/* 103 */     for (int i = 0; i < paramArrayOfByte.length; i++)
/*     */     {
/* 105 */       localStringBuffer.append((char)nibbleToHex((byte)((paramArrayOfByte[i] & 0xF0) >> 4)));
/* 106 */       localStringBuffer.append((char)nibbleToHex((byte)(paramArrayOfByte[i] & 0xF)));
/*     */     }
/* 108 */     return localStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   public static byte[] nibbles2bArray(byte[] paramArrayOfByte)
/*     */   {
/* 122 */     byte[] arrayOfByte = new byte[paramArrayOfByte.length / 2];
/*     */ 
/* 125 */     for (int i = 0; i < arrayOfByte.length; i++)
/*     */     {
/* 127 */       arrayOfByte[i] = ((byte)(asciiHexToNibble(paramArrayOfByte[(i * 2)]) << 4));
/*     */       int tmp31_30 = i;
/*     */       byte[] tmp31_29 = arrayOfByte; tmp31_29[tmp31_30] = ((byte)(tmp31_29[tmp31_30] | asciiHexToNibble(paramArrayOfByte[(i * 2 + 1)])));
/*     */     }
/* 130 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static void printInHex(long paramLong)
/*     */   {
/* 135 */     byte[] arrayOfByte = toHex(paramLong);
/* 136 */     System.out.print(new String(arrayOfByte, 0));
/*     */   }
/*     */ 
/*     */   public static void printInHex(int paramInt)
/*     */   {
/* 141 */     byte[] arrayOfByte = toHex(paramInt);
/* 142 */     System.out.print(new String(arrayOfByte, 0));
/*     */   }
/*     */ 
/*     */   public static void printInHex(short paramShort)
/*     */   {
/* 147 */     byte[] arrayOfByte = toHex(paramShort);
/* 148 */     System.out.print(new String(arrayOfByte, 0));
/*     */   }
/*     */ 
/*     */   public static byte[] toHex(long paramLong)
/*     */   {
/* 153 */     int i = 16;
/* 154 */     byte[] arrayOfByte = new byte[i];
/*     */ 
/* 156 */     for (int j = i - 1; j >= 0; j--)
/*     */     {
/* 158 */       arrayOfByte[j] = nibbleToHex((byte)(int)(paramLong & 0xF));
/* 159 */       paramLong >>= 4;
/*     */     }
/* 161 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static byte[] toHex(int paramInt)
/*     */   {
/* 166 */     int i = 8;
/* 167 */     byte[] arrayOfByte = new byte[i];
/*     */ 
/* 169 */     for (int j = i - 1; j >= 0; j--)
/*     */     {
/* 171 */       arrayOfByte[j] = nibbleToHex((byte)(paramInt & 0xF));
/* 172 */       paramInt >>= 4;
/*     */     }
/* 174 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static byte[] toHex(short paramShort)
/*     */   {
/* 179 */     int i = 4;
/* 180 */     byte[] arrayOfByte = new byte[i];
/*     */ 
/* 182 */     for (int j = i - 1; j >= 0; j--)
/*     */     {
/* 184 */       arrayOfByte[j] = nibbleToHex((byte)(paramShort & 0xF));
/* 185 */       paramShort = (short)(paramShort >> 4);
/*     */     }
/* 187 */     return arrayOfByte;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.core.lmx.LmxRepConversion
 * JD-Core Version:    0.6.2
 */