/*     */ package oracle.core.lmx;
/*     */ 
/*     */ public class CoreException extends Exception
/*     */ {
/*     */   public static final byte UNIMPLEMENTED = 1;
/*     */   public static final byte UNDERFLOW = 2;
/*     */   public static final byte OVERFLOW = 3;
/*     */   public static final byte INVALIDORLN = 4;
/*     */   public static final byte BADFORMATORLN = 5;
/*     */   public static final byte INVALIDORLD = 6;
/*     */   public static final byte BADFORMATORLD = 7;
/*     */   public static final byte BADYEAR = 8;
/*     */   public static final byte BADDAYYEAR = 9;
/*     */   public static final byte BADJULIANDATE = 10;
/*     */   public static final byte INVALIDINPUTN = 11;
/*     */   public static final byte NLSNOTSUPPORTED = 12;
/*     */   public static final byte INVALIDINPUT = 13;
/*     */   public static final byte CONVERSIONERROR = 14;
/* 167 */   private static final String[] _errmsgs = { "Unknown Exception", "Unimplemented method called", "Underflow Exception", "Overflow Exception", "Invalid Oracle Number", "Bad Oracle Number format", "Invalid Oracle Date", "Bad Oracle Date format", "Year Not in Range", "Day of Year Not in Range", "Julian Date Not in Range", "Invalid Input Number", "NLS Not Supported", "Invalid Input", "Conversion Error" };
/*     */   private byte ecode;
/*     */ 
/*     */   public CoreException()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CoreException(String paramString)
/*     */   {
/*  32 */     super(paramString);
/*     */   }
/*     */ 
/*     */   public CoreException(byte paramByte)
/*     */   {
/*  41 */     this.ecode = paramByte;
/*     */   }
/*     */ 
/*     */   public void setErrorCode(byte paramByte)
/*     */   {
/*  51 */     this.ecode = paramByte;
/*     */   }
/*     */ 
/*     */   public byte getErrorCode()
/*     */   {
/*  61 */     return this.ecode;
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/*  71 */     if (this.ecode == 0) {
/*  72 */       return super.getMessage();
/*     */     }
/*  74 */     return getMessage(this.ecode);
/*     */   }
/*     */ 
/*     */   public static String getMessage(byte paramByte)
/*     */   {
/*  88 */     if ((paramByte < 1) || (paramByte > 14)) {
/*  89 */       return "Unknown exception";
/*     */     }
/*  91 */     return _errmsgs[paramByte];
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.core.lmx.CoreException
 * JD-Core Version:    0.6.2
 */