/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util.management;

import com.hynnet.util.management.DynamicMBeanAbstract;
import com.hynnet.util.management.DynamicMBeanAttribute;
import com.hynnet.util.management.DynamicMBeanOperation;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicMBeanAbstract2<E>
extends DynamicMBeanAbstract {
    private E m_owner;
    private Map<String, DynamicMBeanAttribute<E>> m_attributes;
    private Map<String, DynamicMBeanOperation<E>> m_operations;

    protected abstract DynamicMBeanAttribute<E>[] getAttributes();

    protected abstract DynamicMBeanOperation<E>[] getOperations();

    public DynamicMBeanAbstract2(E owner) {
        this.m_owner = owner;
        this.init();
    }

    public DynamicMBeanAbstract2(E owner, String name, String desc) {
        super(name, desc);
        this.m_owner = owner;
        this.init();
    }

    private void init() {
        DynamicMBeanOperation<E>[] operations;
        this.m_attributes = new HashMap<String, DynamicMBeanAttribute<E>>();
        this.m_operations = new HashMap<String, DynamicMBeanOperation<E>>();
        DynamicMBeanAttribute<E>[] attributes = this.getAttributes();
        if (attributes != null) {
            for (DynamicMBeanAttribute<E> att : attributes) {
                this.m_attributes.put(att.getName(), att);
            }
        }
        if ((operations = this.getOperations()) != null) {
            for (DynamicMBeanOperation<E> oper : this.getOperations()) {
                this.m_operations.put(oper.getName(), oper);
            }
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        DynamicMBeanAttribute<E> attr = this.m_attributes.get(attribute);
        return attr != null ? attr.getAttribute(this.m_owner) : null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        DynamicMBeanOperation<E> oper = this.m_operations.get(actionName);
        return oper != null ? oper.invoke(this.m_owner, params, signature) : null;
    }

    @Override
    protected MBeanOperationInfo[] getMBeanOperationInfos() {
        MBeanOperationInfo[] vals = new MBeanOperationInfo[this.m_operations.size()];
        int n = 0;
        for (DynamicMBeanOperation<E> oper : this.m_operations.values()) {
            vals[n++] = oper.getMBeanOperationInfo();
        }
        return vals;
    }

    @Override
    protected MBeanAttributeInfo[] getMBeanAttributeInfos() {
        MBeanAttributeInfo[] vals = new MBeanAttributeInfo[this.m_attributes.size()];
        int n = 0;
        for (DynamicMBeanAttribute<E> oper : this.m_attributes.values()) {
            vals[n++] = oper.getMBeanAttributeInfo();
        }
        return vals;
    }

    @Override
    protected MBeanNotificationInfo[] getMBeanNotificationInfos() {
        return null;
    }

    @Override
    protected void setAttribute(String name, Object val) {
        DynamicMBeanAttribute<E> attr = this.m_attributes.get(name);
        if (attr != null) {
            attr.setAttribute(this.m_owner, val);
        }
    }
}

